/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.client.consumer;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageDecoder;
import java.util.HashMap;
import java.util.Map;

public class PullMessageSelector {
    private String type;
    private String expression;
    private long offset = -1L;
    private int maxNums = 0;
    private long timeout = 0L;
    private boolean blockIfNotFound = false;
    private Map<String, String> properties = new HashMap<String, String>(4);

    protected PullMessageSelector(String expression) {
        this.expression = expression;
    }

    protected PullMessageSelector(String type, String expression) {
        this.type = type;
        this.expression = expression;
    }

    public static PullMessageSelector byTag(String tag) {
        return new PullMessageSelector("TAG", tag);
    }

    public static PullMessageSelector bySql(String expression) {
        return new PullMessageSelector("SQL92", expression);
    }

    public static PullMessageSelector all() {
        return new PullMessageSelector("TAG", "*");
    }

    public void putProperty(String key, String value) {
        if (key == null || value == null || key.trim() == "" || value.trim() == "") {
            throw new IllegalArgumentException("Key and Value can not be null or empty string!");
        }
        this.properties.put(key, value);
    }

    public void putAllProperties(Map<String, String> puts) {
        if (puts == null || puts.isEmpty()) {
            return;
        }
        this.properties.putAll(puts);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPropertiesStr() {
        if (this.properties == null || this.properties.isEmpty()) {
            return null;
        }
        return MessageDecoder.messageProperties2String(this.properties);
    }

    public PullMessageSelector from(long offset) {
        this.offset = offset;
        return this;
    }

    public PullMessageSelector count(int maxNums) {
        this.maxNums = maxNums;
        return this;
    }

    public PullMessageSelector timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public PullMessageSelector blockIfNotFound(boolean block) {
        this.blockIfNotFound = block;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getExpression() {
        return this.expression;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getMaxNums() {
        return this.maxNums;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isBlockIfNotFound() {
        return this.blockIfNotFound;
    }
}

