/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.stream;

import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLogger;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.logging.InternalLoggerFactory;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.remoting.common.RemotingUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public class ByteChannelOutputStream
extends OutputStream {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger("RocketmqRemoting");
    private int position;
    private final WritableByteChannel channel;

    public ByteChannelOutputStream(WritableByteChannel channel) {
        this.channel = channel;
        this.position = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(b, off, len);
        int bytes = 0;
        while (byteBuffer.hasRemaining()) {
            bytes += this.channel.write(byteBuffer);
        }
        assert (len == bytes);
        this.position += bytes;
        String remote = "wire";
        if (this.channel instanceof SocketChannel) {
            remote = RemotingUtil.socketAddress2String(((SocketChannel)this.channel).socket().getRemoteSocketAddress());
        }
        LOGGER.debug("Data written to {} in stream API: {}", (Object)remote, (Object)new String(b, off, len));
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Unsupported");
    }

    public int getPosition() {
        return this.position;
    }
}

