/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.AbstractWatchableCallback;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Request;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.concurrent.FutureCallback;

public class AsyncCompletion<Req extends Request, Res extends Response>
extends AbstractWatchableCallback<Req, Res>
implements FutureCallback<Res> {
    protected Req request;
    protected OperationLauncher launcher;
    protected TraceLogger tracer;
    protected ExecutorService callbackExecutor;
    protected RetryStrategy retry;
    protected ScheduledExecutorService retryExecutor;

    public AsyncCompletion(OperationLauncher launcher, Req request, TraceLogger tracer, ExecutorService callbackExecutor, RetryStrategy retry, ScheduledExecutorService retryExecutor) {
        Preconditions.checkNotNull(launcher, "launcher must not be null.");
        Preconditions.checkNotNull(request, "request must not be null.");
        Preconditions.checkNotNull(tracer, "tracer must not be null.");
        Preconditions.checkNotNull(callbackExecutor, "callbackExecutor must not be null.");
        Preconditions.checkNotNull(retry, "retry must not be null.");
        Preconditions.checkNotNull(retryExecutor, "retryExecutor must not be null.");
        this.launcher = launcher;
        this.request = request;
        this.tracer = tracer;
        this.callbackExecutor = callbackExecutor;
        this.retry = retry.clone();
        this.retryExecutor = retryExecutor;
    }

    public void completed(Res result) {
        try {
            ((Response)result).setTraceId(this.tracer.getTraceId());
            LogUtil.logOnCompleted(this.tracer, this.retry, ((Response)result).getRequestId());
            this.tracer.printLog();
            this.onCompleted(this.request, result);
        }
        catch (Exception ex) {
            LogUtil.LOG.error("unknown error in completed, future or user callback may not be notified", (Throwable)ex);
        }
    }

    public void failed(Exception ex) {
        try {
            Exception e;
            String requestId = null;
            if (ex instanceof TableStoreException) {
                e = ex;
                requestId = ((TableStoreException)ex).getRequestId();
                ((TableStoreException)e).setTraceId(this.tracer.getTraceId());
            } else if (ex instanceof ClientException) {
                e = ex;
                ((ClientException)e).setTraceId(this.tracer.getTraceId());
            } else {
                e = new ClientException("Unexpected error: " + ex, ex, this.tracer.getTraceId());
            }
            long nextPause = this.retry.nextPause(this.request.getOperationName(), e);
            LogUtil.logOnFailed(this.tracer, this.retry, e, requestId, nextPause > 0L);
            if (nextPause <= 0L) {
                this.tracer.printLog();
                if (e instanceof PartialResultFailedException) {
                    this.onCompleted(this.request, (Res)((PartialResultFailedException)e).getResult());
                } else {
                    this.onFailed(this.request, e);
                }
            } else {
                final AsyncCompletion self = this;
                this.retryExecutor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Request requestForRetry = (Request)AsyncCompletion.this.launcher.getRequestForRetry(e);
                            AsyncCompletion.this.launcher.fire(requestForRetry, self);
                        }
                        catch (Exception ex) {
                            AsyncCompletion.this.failed(new ClientException("Fail to retry.", ex));
                        }
                    }
                }, nextPause, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            LogUtil.LOG.error("unknown error in failed, future or user callback may not be notified", (Throwable)exception);
        }
    }

    public void cancelled() {
        this.failed(new ClientException("request cancelled"));
    }

    @Override
    public void onCompleted(Req req, Res res) {
        for (final TableStoreCallback cb : this.downstreams) {
            this.callbackExecutor.submit(new Runnable((Request)req, (Response)res){
                final /* synthetic */ Request val$req;
                final /* synthetic */ Response val$res;
                {
                    this.val$req = request;
                    this.val$res = response;
                }

                @Override
                public void run() {
                    cb.onCompleted(this.val$req, this.val$res);
                }
            });
        }
    }

    @Override
    public void onFailed(Req req, Exception ex) {
        for (final TableStoreCallback cb : this.downstreams) {
            this.callbackExecutor.submit(new Runnable((Request)req, ex){
                final /* synthetic */ Request val$req;
                final /* synthetic */ Exception val$ex;
                {
                    this.val$req = request;
                    this.val$ex = exception;
                }

                @Override
                public void run() {
                    cb.onFailed(this.val$req, this.val$ex);
                }
            });
        }
    }
}

