/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.core.AsyncCompletion;
import com.alicloud.openservices.tablestore.core.OperationLauncher;
import com.alicloud.openservices.tablestore.core.TraceLogger;
import com.alicloud.openservices.tablestore.core.utils.LogUtil;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.CapacityUnit;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ConsumedCapacity;
import com.alicloud.openservices.tablestore.model.GetRangeRequest;
import com.alicloud.openservices.tablestore.model.GetRangeResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.Response;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.Row;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

public class AsyncGetRangeCompletion
extends AsyncCompletion<GetRangeRequest, GetRangeResponse> {
    GetRangeRequest nextRequest;
    List<Row> completeRows = new ArrayList<Row>();
    PrimaryKey nextPrimaryKey;
    PrimaryKey lastRowPK;
    List<Column> lastRowColumns;
    CapacityUnit capacityUnit;
    List<String> requestIds;

    public AsyncGetRangeCompletion(OperationLauncher<GetRangeRequest, GetRangeResponse> launcher, GetRangeRequest request, TraceLogger tracer, ExecutorService callbackExecutor, RetryStrategy retry, ScheduledExecutorService retryExecutor) {
        super(launcher, request, tracer, callbackExecutor, retry, retryExecutor);
    }

    @Override
    public void completed(GetRangeResponse result) {
        result.setTraceId(this.tracer.getTraceId());
        LogUtil.logOnCompleted(this.tracer, this.retry, result.getRequestId());
        this.tracer.printLog();
        if (!result.hasNextToken() || result.getRows().size() > 1) {
            if (this.nextRequest != null) {
                this.handleResult(result);
                this.onCompleted(this.request, this.buildFinalResult());
            } else {
                if (result.getRows().size() > 1) {
                    Row lastRow = result.getRows().get(result.getRows().size() - 1);
                    if (result.hasNextToken() && lastRow.getPrimaryKey().equals(result.getNextStartPrimaryKey())) {
                        result.getRows().remove(result.getRows().size() - 1);
                        result.setNextToken(null);
                    }
                }
                this.onCompleted(this.request, result);
            }
        } else {
            this.handleResult(result);
            this.sendNextRequest(result.getNextStartPrimaryKey(), result.getNextToken());
        }
    }

    void buildNextRequest(PrimaryKey nextStartPrimaryKey, byte[] token) {
        if (this.nextRequest == null) {
            RangeRowQueryCriteria originCriteria = ((GetRangeRequest)this.request).getRangeRowQueryCriteria();
            RangeRowQueryCriteria rangeRowQueryCriteria = new RangeRowQueryCriteria(originCriteria.getTableName());
            rangeRowQueryCriteria.setDirection(originCriteria.getDirection());
            rangeRowQueryCriteria.setLimit(originCriteria.getLimit());
            rangeRowQueryCriteria.setExclusiveEndPrimaryKey(originCriteria.getExclusiveEndPrimaryKey());
            originCriteria.copyTo(rangeRowQueryCriteria);
            this.nextRequest = new GetRangeRequest(rangeRowQueryCriteria);
        }
        this.nextRequest.getRangeRowQueryCriteria().setInclusiveStartPrimaryKey(nextStartPrimaryKey);
        this.nextRequest.getRangeRowQueryCriteria().setToken(token);
    }

    void sendNextRequest(PrimaryKey nextStartPrimaryKey, byte[] token) {
        this.buildNextRequest(nextStartPrimaryKey, token);
        this.retry = this.retry.clone();
        this.launcher.fire(this.nextRequest, this);
    }

    void mergeLastRow(Row row, boolean complete) {
        Preconditions.checkArgument(this.lastRowPK != null);
        if (row != null) {
            this.lastRowColumns.addAll(Arrays.asList(row.getColumns()));
        }
        if (complete) {
            this.completeRows.add(new Row(this.lastRowPK, this.lastRowColumns));
            this.lastRowPK = null;
            this.lastRowColumns = new ArrayList<Column>();
        }
    }

    void handleResult(GetRangeResponse result) {
        if (result.getRows().size() > 0) {
            List<Row> rows = result.getRows();
            if (this.lastRowPK != null) {
                if (rows.get(0).getPrimaryKey().equals(this.lastRowPK)) {
                    this.mergeLastRow(rows.get(0), !this.lastRowPK.equals(result.getNextStartPrimaryKey()));
                    rows.remove(0);
                } else {
                    this.mergeLastRow(null, true);
                }
            }
            if (rows.size() > 0) {
                for (int i = 0; i < rows.size() - 1; ++i) {
                    this.completeRows.add(rows.get(i));
                }
                PrimaryKey resultLastRowPK = rows.get(rows.size() - 1).getPrimaryKey();
                if (result.hasNextToken() && resultLastRowPK.equals(result.getNextStartPrimaryKey())) {
                    this.lastRowPK = resultLastRowPK;
                    if (this.lastRowColumns == null) {
                        this.lastRowColumns = new ArrayList<Column>();
                    }
                    this.lastRowColumns.addAll(Arrays.asList(rows.get(rows.size() - 1).getColumns()));
                } else {
                    this.completeRows.add(rows.get(rows.size() - 1));
                }
            }
        }
        this.nextPrimaryKey = result.getNextStartPrimaryKey();
        if (this.capacityUnit == null) {
            this.capacityUnit = new CapacityUnit(0, 0);
        }
        if (this.requestIds == null) {
            this.requestIds = new ArrayList<String>();
        }
        this.capacityUnit.setReadCapacityUnit(this.capacityUnit.getReadCapacityUnit() + result.getConsumedCapacity().getCapacityUnit().getReadCapacityUnit());
        this.capacityUnit.setWriteCapacityUnit(this.capacityUnit.getWriteCapacityUnit() + result.getConsumedCapacity().getCapacityUnit().getWriteCapacityUnit());
        this.requestIds.add(result.getRequestId());
    }

    GetRangeResponse buildFinalResult() {
        GetRangeResponse getRangeResponse = new GetRangeResponse(new Response(this.requestIds.get(0)), new ConsumedCapacity(this.capacityUnit));
        getRangeResponse.setRows(this.completeRows);
        getRangeResponse.setNextStartPrimaryKey(this.nextPrimaryKey);
        return getRangeResponse;
    }
}

