/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.core.AbstractWatchableCallback;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CallbackImpledFuture<Req, Res>
extends AbstractWatchableCallback<Req, Res>
implements Future<Res> {
    private boolean completed = false;
    private Res result;
    private Exception ex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted(Req request, Res result) {
        CallbackImpledFuture callbackImpledFuture = this;
        synchronized (callbackImpledFuture) {
            if (this.completed) {
                throw new IllegalStateException("completed() must not be invoked twice.");
            }
            this.completed = true;
            this.result = result;
            this.notifyAll();
        }
        for (TableStoreCallback downstream : this.downstreams) {
            downstream.onCompleted(request, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailed(Req request, Exception ex) {
        CallbackImpledFuture callbackImpledFuture = this;
        synchronized (callbackImpledFuture) {
            if (this.completed) {
                throw new IllegalStateException("completed() must not be invoked twice.");
            }
            this.completed = true;
            this.ex = ex;
            this.notifyAll();
        }
        for (TableStoreCallback downstream : this.downstreams) {
            downstream.onFailed(request, ex);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        CallbackImpledFuture callbackImpledFuture = this;
        synchronized (callbackImpledFuture) {
            return this.completed;
        }
    }

    @Override
    public synchronized Res get() throws InterruptedException, ExecutionException {
        while (!this.completed) {
            this.wait();
        }
        return this.getResultWithoutLock();
    }

    @Override
    public Res get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(unit, "Time unit should not be null");
        long endTime = System.currentTimeMillis() + unit.toMillis(timeout);
        CallbackImpledFuture callbackImpledFuture = this;
        synchronized (callbackImpledFuture) {
            while (true) {
                if (this.completed) {
                    return this.getResultWithoutLock();
                }
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime <= 0L) {
                    throw new TimeoutException();
                }
                this.wait(waitTime);
            }
        }
    }

    private Res getResultWithoutLock() throws TableStoreException, ClientException {
        if (this.ex instanceof TableStoreException) {
            TableStoreException tmp = (TableStoreException)this.ex;
            TableStoreException newExp = new TableStoreException(tmp.getMessage(), tmp, tmp.getErrorCode(), tmp.getRequestId(), tmp.getHttpStatus());
            newExp.setTraceId(tmp.getTraceId());
            throw newExp;
        }
        if (this.ex instanceof ClientException) {
            throw new ClientException(this.ex.getMessage(), this.ex, ((ClientException)this.ex).getTraceId());
        }
        return this.result;
    }
}

