/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.auth;

import com.alicloud.openservices.tablestore.core.auth.BasicCredentials;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class InstanceProfileCredentials
extends BasicCredentials {
    private final long expirationInMilliseconds;
    private long refreshIntervalInMilliseconds = 10000L;
    private long lastFailedRefreshTime = 0L;

    public InstanceProfileCredentials(String accessKeyId, String accessKeySecret, String sessionToken, String expiration) {
        super(accessKeyId, accessKeySecret, sessionToken, 21600L);
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        parser.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            Date date = parser.parse(expiration);
            this.expirationInMilliseconds = date.getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to get valid expiration time from ECS Metadata service.");
        }
    }

    @Override
    public InstanceProfileCredentials withExpiredFactor(double expiredFactor) {
        this.expiredFactor = expiredFactor;
        return this;
    }

    @Override
    public InstanceProfileCredentials withExpiredDuration(long expiredDurationSeconds) {
        this.expiredDurationSeconds = expiredDurationSeconds;
        return this;
    }

    public InstanceProfileCredentials withRefreshIntervalInMilliseconds(long refreshIntervalInMilliseconds) {
        this.refreshIntervalInMilliseconds = refreshIntervalInMilliseconds;
        return this;
    }

    @Override
    public boolean willSoonExpire() {
        long now = System.currentTimeMillis();
        return (double)this.expiredDurationSeconds * (1.0 - this.expiredFactor) > (double)(this.expirationInMilliseconds - now) / 1000.0;
    }

    public boolean isExpired() {
        long now = System.currentTimeMillis();
        return now >= this.expirationInMilliseconds - this.refreshIntervalInMilliseconds;
    }

    public boolean shouldRefresh() {
        long now = System.currentTimeMillis();
        return now - this.lastFailedRefreshTime > this.refreshIntervalInMilliseconds;
    }

    public void setLastFailedRefreshTime() {
        this.lastFailedRefreshTime = System.currentTimeMillis();
    }
}

