/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.core.protocol.PlainBufferCell;
import com.alicloud.openservices.tablestore.core.protocol.PlainBufferRow;
import java.io.IOException;

public class PlainBufferCrc8 {
    private static final int spaceSize = 256;
    private static byte[] crc8Table = new byte[256];

    public static byte crc8(byte crc, byte in) {
        crc = crc8Table[(crc ^ in) & 0xFF];
        return crc;
    }

    public static byte crc8(byte crc, int in) {
        for (int i = 0; i < 4; ++i) {
            crc = PlainBufferCrc8.crc8(crc, (byte)(in & 0xFF));
            in >>= 8;
        }
        return crc;
    }

    public static byte crc8(byte crc, long in) {
        for (int i = 0; i < 8; ++i) {
            crc = PlainBufferCrc8.crc8(crc, (byte)(in & 0xFFL));
            in >>= 8;
        }
        return crc;
    }

    public static byte crc8(byte crc, byte[] in) {
        for (int i = 0; i < in.length; ++i) {
            crc = PlainBufferCrc8.crc8(crc, in[i]);
        }
        return crc;
    }

    public static byte getChecksum(byte crc, PlainBufferCell cell) throws IOException {
        if (cell.hasCellName()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getNameRawData());
        }
        if (cell.hasCellValue()) {
            crc = cell.isPk() ? cell.getPkCellValue().getChecksum(crc) : cell.getCellValue().getChecksum(crc);
        }
        if (cell.hasCellTimestamp()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getCellTimestamp());
        }
        if (cell.hasCellType()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getCellType());
        }
        return crc;
    }

    public static byte getChecksum(byte crc, PlainBufferRow row) throws IOException {
        for (PlainBufferCell cell : row.getPrimaryKey()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getChecksum());
        }
        for (PlainBufferCell cell : row.getCells()) {
            crc = PlainBufferCrc8.crc8(crc, cell.getChecksum());
        }
        byte del = 0;
        if (row.hasDeleteMarker()) {
            del = 1;
        }
        crc = PlainBufferCrc8.crc8(crc, del);
        return crc;
    }

    static {
        for (int i = 0; i < crc8Table.length; ++i) {
            byte x = (byte)i;
            for (int j = 8; j > 0; --j) {
                x = (byte)(x << 1 ^ ((x & 0x80) != 0 ? 7 : 0));
            }
            PlainBufferCrc8.crc8Table[i] = x;
        }
    }
}

