/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.ecosystem;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.ecosystem.ICatalogManager;
import com.alicloud.openservices.tablestore.ecosystem.TableCatalog;
import java.util.concurrent.ConcurrentHashMap;

public class CatalogManager
implements ICatalogManager {
    ConcurrentHashMap<String, TableCatalog> map;
    private SyncClient client;

    public CatalogManager(SyncClient client) {
        this.client = client;
        this.map = new ConcurrentHashMap();
    }

    @Override
    public TableCatalog getTableCatalog(String tableName) {
        TableCatalog catalog = this.map.get(tableName);
        if (catalog == null) {
            catalog = new TableCatalog(tableName);
            try {
                catalog.buildCatalog(this.client);
            }
            catch (TableStoreException e) {
                if (e.getErrorCode().equals("OTSObjectNotExist")) {
                    return null;
                }
                throw e;
            }
            this.map.putIfAbsent(tableName, catalog);
        }
        return catalog;
    }
}

