/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.iterator;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.iterator.RowIterator;
import com.alicloud.openservices.tablestore.model.search.ParallelScanRequest;
import com.alicloud.openservices.tablestore.model.search.ParallelScanResponse;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ParallelScanRowIterator
implements RowIterator {
    private SyncClientInterface client;
    private Iterator<Row> rowsIterator;
    private ParallelScanRequest parallelScanRequest;
    private ParallelScanResponse parallelScanResponse;
    private long completedBytes;

    public ParallelScanRowIterator(SyncClientInterface syncClient, ParallelScanRequest parallelScanRequest) {
        this.parallelScanRequest = parallelScanRequest;
        this.client = syncClient;
        if (null != parallelScanRequest.getScanQuery().getToken()) {
            throw new IllegalArgumentException("ScanQuery's token must be null when initializing the ParallelScanRowIterator.");
        }
        this.fetchData();
    }

    private void fetchData() {
        if (null != this.parallelScanResponse) {
            if (null == this.parallelScanResponse.getNextToken()) {
                return;
            }
            this.parallelScanRequest.getScanQuery().setToken(this.parallelScanResponse.getNextToken());
        }
        this.parallelScanResponse = this.client.parallelScan(this.parallelScanRequest);
        this.completedBytes += this.parallelScanResponse.getBodyBytes();
        this.rowsIterator = this.parallelScanResponse.getRows().iterator();
    }

    private boolean isBufferHasMoreData() {
        return this.rowsIterator.hasNext();
    }

    private Row getNextFromBuffer() {
        return this.rowsIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isBufferHasMoreData()) {
            return true;
        }
        this.fetchData();
        return this.isBufferHasMoreData();
    }

    @Override
    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.getNextFromBuffer();
    }

    @Override
    public void remove() {
        throw new ClientException("RowIterator do not support remove().");
    }

    @Override
    public long getTotalCount() {
        throw new ClientException("ParallelScanRowIterator do not support getTotalCount().");
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }
}

