/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model;

import com.alicloud.openservices.tablestore.ClientException;
import java.util.concurrent.TimeUnit;

public class TimeRange {
    private long begin = 0L;
    private long end = Long.MAX_VALUE;

    private TimeRange() {
    }

    public static TimeRange all() {
        TimeRange timeRange = new TimeRange();
        return timeRange;
    }

    public static TimeRange range(long begin, long end, TimeUnit unit) {
        if (begin >= end) {
            throw new ClientException("The begin must be smaller than end.");
        }
        TimeRange timeRange = new TimeRange();
        timeRange.begin = unit.toMicros(begin);
        timeRange.end = unit.toMicros(end);
        return timeRange;
    }

    public static TimeRange latest(long time, TimeUnit unit) {
        if (unit.toMicros(time) <= 0L) {
            throw new ClientException("The time muse be positive.");
        }
        long now = TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis());
        if (unit.toMicros(time) > now) {
            throw new ClientException("The time muse smaller than current time.");
        }
        TimeRange timeRange = new TimeRange();
        timeRange.begin = now - unit.toMicros(time);
        timeRange.end = unit.toMicros(now);
        return timeRange;
    }

    public static TimeRange before(long end, TimeUnit unit) {
        if (unit.toMicros(end) <= 0L) {
            throw new ClientException("The end muse be positive.");
        }
        TimeRange timeRange = new TimeRange();
        timeRange.end = unit.toMicros(end);
        return timeRange;
    }

    public static TimeRange after(long begin, TimeUnit unit) {
        if (unit.toMicros(begin) <= 0L) {
            throw new ClientException("The begin muse be positive.");
        }
        TimeRange timeRange = new TimeRange();
        timeRange.begin = unit.toMicros(begin);
        return timeRange;
    }

    public long getBeginTime() {
        return this.begin;
    }

    public long getEndTime() {
        return this.end;
    }
}

