/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.timestream.model.aggregator;

import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.timestream.model.aggregator.Aggregator;

public class AggregatorLongSum
implements Aggregator<Long> {
    private String name;
    private long sum = 0L;
    private long count = 0L;

    public AggregatorLongSum(String name) {
        this(name, 0L, 0L);
    }

    public AggregatorLongSum(String name, long sum, long count) {
        this.name = name;
        this.sum = sum;
        this.count = count;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void add(Long v) {
        this.sum += v.longValue();
        ++this.count;
    }

    @Override
    public ColumnValue getValue() {
        return ColumnValue.fromLong(this.sum);
    }

    @Override
    public Aggregator clone() {
        return new AggregatorLongSum(this.name, this.sum, this.count);
    }
}

