/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.writer.retry;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.PartialResultFailedException;
import com.alicloud.openservices.tablestore.TableStoreException;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public abstract class BaseWriterRetryStrategy
implements RetryStrategy {
    private final int MAX_BASE = 320;
    private Random rnd = new Random();
    private int retries = 0;
    protected long timeout = 0L;
    private int base = 10;
    private long deadline = 0L;

    public BaseWriterRetryStrategy(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
        this.deadline = System.currentTimeMillis() + this.timeout;
    }

    @Override
    public abstract RetryStrategy clone();

    @Override
    public int getRetries() {
        return this.retries;
    }

    abstract boolean retryNotMatterActions(String var1);

    private boolean shouldRetryWithOTSException(String errorCode, int httpStatus) {
        boolean serverError = httpStatus >= 500 && httpStatus <= 599;
        return this.retryNotMatterActions(errorCode) || serverError;
    }

    protected boolean shouldRetry(Exception ex) {
        if (ex instanceof TableStoreException) {
            if (ex instanceof PartialResultFailedException) {
                PartialResultFailedException prfe = (PartialResultFailedException)ex;
                for (TableStoreException otsException : prfe.getErrors()) {
                    if (this.shouldRetryWithOTSException(otsException.getErrorCode(), prfe.getHttpStatus())) continue;
                    return false;
                }
                return true;
            }
            TableStoreException otsException = (TableStoreException)ex;
            return this.shouldRetryWithOTSException(otsException.getErrorCode(), otsException.getHttpStatus());
        }
        return ex instanceof ClientException;
    }

    @Override
    public long nextPause(String action, Exception ex) {
        if (!this.shouldRetry(ex)) {
            return 0L;
        }
        if (this.base <= 0) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        int expire = (int)(this.deadline - now);
        if (expire <= 0) {
            return 0L;
        }
        long delay = 1 + this.rnd.nextInt(this.base < expire ? this.base : expire);
        ++this.retries;
        this.base *= 2;
        if (this.base > 320) {
            this.base = 320;
        }
        return delay;
    }
}

