/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.core.protocol;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.Search;
import com.alicloud.openservices.tablestore.core.protocol.SearchAggregationResultBuilder;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByFieldResult;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByFieldResultItem;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByFilterResult;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByFilterResultItem;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByGeoDistanceResult;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByGeoDistanceResultItem;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByRangeResult;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByRangeResultItem;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByResult;
import com.alicloud.openservices.tablestore.model.search.groupby.GroupByResults;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.HashMap;

class SearchGroupByResultBuilder {
    SearchGroupByResultBuilder() {
    }

    private static GroupByResult buildGroupByFieldResult(String groupByName, ByteString groupByBody) throws InvalidProtocolBufferException {
        Search.GroupByFieldResult groupByResult = Search.GroupByFieldResult.parseFrom(groupByBody);
        GroupByFieldResult result = new GroupByFieldResult();
        result.setGroupByName(groupByName);
        ArrayList<GroupByFieldResultItem> items = new ArrayList<GroupByFieldResultItem>();
        for (Search.GroupByFieldResultItem item : groupByResult.getGroupByFieldResultItemsList()) {
            items.add(SearchGroupByResultBuilder.buildGroupByFieldResultItem(item));
        }
        result.setGroupByFieldResultItems(items);
        return result;
    }

    private static GroupByFieldResultItem buildGroupByFieldResultItem(Search.GroupByFieldResultItem fieldGroupByResultItem) throws InvalidProtocolBufferException {
        GroupByFieldResultItem result = new GroupByFieldResultItem();
        result.setKey(fieldGroupByResultItem.getKey());
        result.setRowCount(fieldGroupByResultItem.getRowCount());
        if (fieldGroupByResultItem.hasSubAggsResult()) {
            result.setSubAggregationResults(SearchAggregationResultBuilder.buildAggregationResults(fieldGroupByResultItem.getSubAggsResult()));
        }
        if (fieldGroupByResultItem.hasSubGroupBysResult()) {
            result.setSubGroupByResults(SearchGroupByResultBuilder.buildGroupByResults(fieldGroupByResultItem.getSubGroupBysResult()));
        }
        return result;
    }

    private static GroupByRangeResultItem buildGroupByRangeResultItem(Search.GroupByRangeResultItem rangeGroupByResultItem) throws InvalidProtocolBufferException {
        GroupByRangeResultItem result = new GroupByRangeResultItem();
        result.setRowCount(rangeGroupByResultItem.getRowCount());
        result.setFrom(rangeGroupByResultItem.getFrom());
        result.setTo(rangeGroupByResultItem.getTo());
        if (rangeGroupByResultItem.hasSubAggsResult()) {
            result.setSubAggregationResults(SearchAggregationResultBuilder.buildAggregationResults(rangeGroupByResultItem.getSubAggsResult()));
        }
        if (rangeGroupByResultItem.hasSubGroupBysResult()) {
            result.setSubGroupByResults(SearchGroupByResultBuilder.buildGroupByResults(rangeGroupByResultItem.getSubGroupBysResult()));
        }
        return result;
    }

    private static GroupByGeoDistanceResultItem buildGroupByGeoDistanceResultItem(Search.GroupByGeoDistanceResultItem geoDistanceResultItem) throws InvalidProtocolBufferException {
        GroupByGeoDistanceResultItem result = new GroupByGeoDistanceResultItem();
        result.setRowCount(geoDistanceResultItem.getRowCount());
        result.setFrom(geoDistanceResultItem.getFrom());
        result.setTo(geoDistanceResultItem.getTo());
        if (geoDistanceResultItem.hasSubAggsResult()) {
            result.setSubAggregationResults(SearchAggregationResultBuilder.buildAggregationResults(geoDistanceResultItem.getSubAggsResult()));
        }
        if (geoDistanceResultItem.hasSubGroupBysResult()) {
            result.setSubGroupByResults(SearchGroupByResultBuilder.buildGroupByResults(geoDistanceResultItem.getSubGroupBysResult()));
        }
        return result;
    }

    private static GroupByFilterResultItem buildGroupByFilterResultItem(Search.GroupByFilterResultItem filtersGroupByResultItem) throws InvalidProtocolBufferException {
        GroupByFilterResultItem result = new GroupByFilterResultItem();
        result.setRowCount(filtersGroupByResultItem.getRowCount());
        if (filtersGroupByResultItem.hasSubAggsResult()) {
            result.setSubAggregationResults(SearchAggregationResultBuilder.buildAggregationResults(filtersGroupByResultItem.getSubAggsResult()));
        }
        if (filtersGroupByResultItem.hasSubGroupBysResult()) {
            result.setSubGroupByResults(SearchGroupByResultBuilder.buildGroupByResults(filtersGroupByResultItem.getSubGroupBysResult()));
        }
        return result;
    }

    private static GroupByFilterResult buildGroupByFilterResult(String groupByName, ByteString groupByBody) throws InvalidProtocolBufferException {
        Search.GroupByFilterResult groupByResult = Search.GroupByFilterResult.parseFrom(groupByBody);
        GroupByFilterResult result = new GroupByFilterResult();
        result.setGroupByName(groupByName);
        ArrayList<GroupByFilterResultItem> items = new ArrayList<GroupByFilterResultItem>();
        for (Search.GroupByFilterResultItem item : groupByResult.getGroupByFilterResultItemsList()) {
            items.add(SearchGroupByResultBuilder.buildGroupByFilterResultItem(item));
        }
        result.setGroupByFilterResultItems(items);
        return result;
    }

    private static GroupByRangeResult buildGroupByRangeResult(String groupByName, ByteString groupByBody) throws InvalidProtocolBufferException {
        Search.GroupByRangeResult groupByResult = Search.GroupByRangeResult.parseFrom(groupByBody);
        GroupByRangeResult result = new GroupByRangeResult();
        result.setGroupByName(groupByName);
        ArrayList<GroupByRangeResultItem> items = new ArrayList<GroupByRangeResultItem>();
        for (Search.GroupByRangeResultItem item : groupByResult.getGroupByRangeResultItemsList()) {
            items.add(SearchGroupByResultBuilder.buildGroupByRangeResultItem(item));
        }
        result.setGroupByRangeResultItems(items);
        return result;
    }

    private static GroupByGeoDistanceResult buildGroupByGeoDistanceResult(String groupByName, ByteString groupByBody) throws InvalidProtocolBufferException {
        Search.GroupByGeoDistanceResult groupByResult = Search.GroupByGeoDistanceResult.parseFrom(groupByBody);
        GroupByGeoDistanceResult result = new GroupByGeoDistanceResult();
        result.setGroupByName(groupByName);
        ArrayList<GroupByGeoDistanceResultItem> items = new ArrayList<GroupByGeoDistanceResultItem>();
        for (Search.GroupByGeoDistanceResultItem item : groupByResult.getGroupByGeoDistanceResultItemsList()) {
            items.add(SearchGroupByResultBuilder.buildGroupByGeoDistanceResultItem(item));
        }
        result.setGroupByGeoDistanceResultItems(items);
        return result;
    }

    private static GroupByResult buildGroupByResult(Search.GroupByResult groupByResult) throws InvalidProtocolBufferException {
        switch (groupByResult.getType()) {
            case GROUP_BY_FIELD: {
                return SearchGroupByResultBuilder.buildGroupByFieldResult(groupByResult.getName(), groupByResult.getGroupByResult());
            }
            case GROUP_BY_RANGE: {
                return SearchGroupByResultBuilder.buildGroupByRangeResult(groupByResult.getName(), groupByResult.getGroupByResult());
            }
            case GROUP_BY_GEO_DISTANCE: {
                return SearchGroupByResultBuilder.buildGroupByGeoDistanceResult(groupByResult.getName(), groupByResult.getGroupByResult());
            }
            case GROUP_BY_FILTER: {
                return SearchGroupByResultBuilder.buildGroupByFilterResult(groupByResult.getName(), groupByResult.getGroupByResult());
            }
        }
        throw new ClientException("unsupported GroupByType: " + (Object)((Object)groupByResult.getType()));
    }

    private static GroupByResults buildGroupByResults(Search.GroupBysResult groupBysResult) throws InvalidProtocolBufferException {
        GroupByResults groupByResults = new GroupByResults();
        HashMap<String, GroupByResult> map = new HashMap<String, GroupByResult>();
        for (Search.GroupByResult groupByResult : groupBysResult.getGroupByResultsList()) {
            map.put(groupByResult.getName(), SearchGroupByResultBuilder.buildGroupByResult(groupByResult));
        }
        groupByResults.setGroupByResultMap(map);
        return groupByResults;
    }

    static GroupByResults buildGroupByResultsFromByteString(ByteString groupBy) throws InvalidProtocolBufferException {
        Search.GroupBysResult aggregationsResult = Search.GroupBysResult.parseFrom(groupBy);
        return SearchGroupByResultBuilder.buildGroupByResults(aggregationsResult);
    }
}

