/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.filter;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.core.protocol.OTSProtocolBuilder;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.condition.CompositeColumnValueCondition;
import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.filter.FilterType;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;

public class CompositeColumnValueFilter
extends ColumnValueFilter {
    private LogicOperator type;
    private List<ColumnValueFilter> filters;

    public CompositeColumnValueFilter(LogicOperator loType) {
        Preconditions.checkNotNull(loType, "The operation type should not be null.");
        this.type = loType;
        this.filters = new ArrayList<ColumnValueFilter>();
    }

    public CompositeColumnValueFilter addFilter(ColumnValueFilter filter) {
        Preconditions.checkNotNull(filter, "The filter should not be null.");
        this.filters.add(filter);
        return this;
    }

    public void clear() {
        this.filters.clear();
    }

    public LogicOperator getOperationType() {
        return this.type;
    }

    public List<ColumnValueFilter> getSubFilters() {
        return this.filters;
    }

    public CompositeColumnValueCondition toCondition() {
        CompositeColumnValueCondition.LogicOperator logicOperator;
        switch (this.type) {
            case NOT: {
                logicOperator = CompositeColumnValueCondition.LogicOperator.NOT;
                break;
            }
            case AND: {
                logicOperator = CompositeColumnValueCondition.LogicOperator.AND;
                break;
            }
            case OR: {
                logicOperator = CompositeColumnValueCondition.LogicOperator.OR;
                break;
            }
            default: {
                throw new ClientException("Unknown logicOperator: " + this.type.name());
            }
        }
        CompositeColumnValueCondition compositeColumnValueCondition = new CompositeColumnValueCondition(logicOperator);
        for (Filter filter : this.getSubFilters()) {
            if (filter instanceof SingleColumnValueFilter) {
                compositeColumnValueCondition.addCondition(((SingleColumnValueFilter)filter).toCondition());
                continue;
            }
            if (filter instanceof CompositeColumnValueFilter) {
                compositeColumnValueCondition.addCondition(((CompositeColumnValueFilter)filter).toCondition());
                continue;
            }
            throw new ClientException("Unknown filter type: " + (Object)((Object)filter.getFilterType()));
        }
        return compositeColumnValueCondition;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.COMPOSITE_COLUMN_VALUE_FILTER;
    }

    @Override
    public ByteString serialize() {
        return OTSProtocolBuilder.buildCompositeColumnValueFilter(this);
    }

    public static enum LogicOperator {
        NOT,
        AND,
        OR;

    }
}

