/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.agg;

import com.alicloud.openservices.tablestore.model.search.agg.AggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.AggregationType;
import com.alicloud.openservices.tablestore.model.search.agg.AvgAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.CountAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.DistinctCountAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.MaxAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.MinAggregationResult;
import com.alicloud.openservices.tablestore.model.search.agg.SumAggregationResult;
import java.util.Map;

public class AggregationResults {
    private Map<String, AggregationResult> resultMap;

    public int size() {
        if (this.resultMap == null) {
            return 0;
        }
        return this.resultMap.size();
    }

    public AggregationResults setResultMap(Map<String, AggregationResult> resultMap) {
        this.resultMap = resultMap;
        return this;
    }

    public AvgAggregationResult getAsAvgAggregationResult(String aggregationName) {
        if (this.resultMap != null && !this.resultMap.containsKey(aggregationName)) {
            throw new IllegalArgumentException("AggregationResults don't contains: " + aggregationName);
        }
        assert (this.resultMap != null);
        AggregationResult result = this.resultMap.get(aggregationName);
        if (result.getAggType() == AggregationType.AGG_AVG) {
            return (AvgAggregationResult)result;
        }
        throw new IllegalArgumentException("the result with this aggregationName can't cast to AvgAggregationResult.");
    }

    public DistinctCountAggregationResult getAsDistinctCountAggregationResult(String aggregationName) {
        if (this.resultMap != null && !this.resultMap.containsKey(aggregationName)) {
            throw new IllegalArgumentException("AggregationResults don't contains: " + aggregationName);
        }
        assert (this.resultMap != null);
        AggregationResult result = this.resultMap.get(aggregationName);
        if (result.getAggType() == AggregationType.AGG_DISTINCT_COUNT) {
            return (DistinctCountAggregationResult)result;
        }
        throw new IllegalArgumentException("the result with this aggregationName can't cast to DistinctCountAggregationResult.");
    }

    public MaxAggregationResult getAsMaxAggregationResult(String aggregationName) {
        if (this.resultMap != null && !this.resultMap.containsKey(aggregationName)) {
            throw new IllegalArgumentException("AggregationResults don't contains: " + aggregationName);
        }
        assert (this.resultMap != null);
        AggregationResult result = this.resultMap.get(aggregationName);
        if (result.getAggType() == AggregationType.AGG_MAX) {
            return (MaxAggregationResult)result;
        }
        throw new IllegalArgumentException("the result with this aggregationName can't cast to MaxAggregationResult.");
    }

    public MinAggregationResult getAsMinAggregationResult(String aggregationName) {
        if (this.resultMap != null && !this.resultMap.containsKey(aggregationName)) {
            throw new IllegalArgumentException("AggregationResults don't contains: " + aggregationName);
        }
        assert (this.resultMap != null);
        AggregationResult result = this.resultMap.get(aggregationName);
        if (result.getAggType() == AggregationType.AGG_MIN) {
            return (MinAggregationResult)result;
        }
        throw new IllegalArgumentException("the result with this aggregationName can't cast to MinAggregationResult.");
    }

    public SumAggregationResult getAsSumAggregationResult(String aggregationName) {
        if (this.resultMap != null && !this.resultMap.containsKey(aggregationName)) {
            throw new IllegalArgumentException("AggregationResults don't contains: " + aggregationName);
        }
        assert (this.resultMap != null);
        AggregationResult result = this.resultMap.get(aggregationName);
        if (result.getAggType() == AggregationType.AGG_SUM) {
            return (SumAggregationResult)result;
        }
        throw new IllegalArgumentException("the result with this aggregationName can't cast to SumAggregationResult.");
    }

    public CountAggregationResult getAsCountAggregationResult(String aggregationName) {
        if (this.resultMap != null && !this.resultMap.containsKey(aggregationName)) {
            throw new IllegalArgumentException("AggregationResults don't contains: " + aggregationName);
        }
        AggregationResult result = this.resultMap.get(aggregationName);
        if (result.getAggType() == AggregationType.AGG_COUNT) {
            return (CountAggregationResult)result;
        }
        throw new IllegalArgumentException("the result with this aggregationName can't cast to CountAggregationResult.");
    }
}

