/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.model.search.query;

import com.alicloud.openservices.tablestore.core.protocol.SearchQueryBuilder;
import com.alicloud.openservices.tablestore.core.utils.ValueUtil;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.search.query.Query;
import com.alicloud.openservices.tablestore.model.search.query.QueryBuilder;
import com.alicloud.openservices.tablestore.model.search.query.QueryType;
import com.google.protobuf.ByteString;

public class TermQuery
implements Query {
    private String fieldName;
    private ColumnValue term;
    private float weight = 1.0f;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public ColumnValue getTerm() {
        return this.term;
    }

    public void setTerm(ColumnValue term) {
        this.term = term;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.QueryType_TermQuery;
    }

    @Override
    public ByteString serialize() {
        return SearchQueryBuilder.buildTermQuery(this).toByteString();
    }

    protected static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder
    implements QueryBuilder {
        private String fieldName;
        private ColumnValue term;
        private float weight = 1.0f;

        public Builder weight(float weight) {
            this.weight = weight;
            return this;
        }

        private Builder() {
        }

        public Builder field(String val) {
            this.fieldName = val;
            return this;
        }

        public Builder term(Object val) {
            this.term = ValueUtil.toColumnValue(val);
            return this;
        }

        @Override
        public TermQuery build() {
            TermQuery termQuery = new TermQuery();
            termQuery.setTerm(this.term);
            termQuery.setWeight(this.weight);
            termQuery.setFieldName(this.fieldName);
            return termQuery;
        }
    }
}

