/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.pipeline;

import com.alicloud.openservices.tablestore.tunnel.pipeline.IBackoff;

public class ProcessDataBackoff
implements IBackoff {
    private static final long STOP = -1L;
    private int currentIntervalMillis;
    private int initialIntervalMillis = 10;
    private double randomizationFactor = 0.25;
    private double multiplier = 5.0;
    private int maxIntervalMillis = 5000;
    private long startTimeMillis;
    private int maxElapsedTimeMillis = 0;

    public ProcessDataBackoff() {
        this.reset();
    }

    @Override
    public void reset() {
        this.currentIntervalMillis = this.initialIntervalMillis;
        this.startTimeMillis = System.currentTimeMillis();
    }

    @Override
    public long nextBackOffMillis() {
        if (this.maxElapsedTimeMillis != 0 && System.currentTimeMillis() - this.startTimeMillis > (long)this.maxElapsedTimeMillis) {
            return -1L;
        }
        long randomizedInterval = this.getRandomValueFromInterval(this.randomizationFactor, Math.random(), this.currentIntervalMillis);
        this.currentIntervalMillis = (double)this.currentIntervalMillis >= (double)this.maxIntervalMillis / this.multiplier ? this.maxIntervalMillis : (int)((double)this.currentIntervalMillis * this.multiplier);
        return randomizedInterval;
    }

    private long getRandomValueFromInterval(double randomizationFactor, double random, int currentIntervalMillis) {
        double delta = randomizationFactor * (double)currentIntervalMillis;
        double minInterval = (double)currentIntervalMillis - delta;
        double maxInterval = (double)currentIntervalMillis + delta;
        long randomValue = (long)(minInterval + random * (maxInterval - minInterval + 1.0));
        return randomValue;
    }
}

