/*
 * Decompiled with CFR 0.152.
 */
package com.alicloud.openservices.tablestore.tunnel.worker;

import com.alicloud.openservices.tablestore.TunnelClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.tunnel.internal.Channel;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointRequest;
import com.alicloud.openservices.tablestore.model.tunnel.internal.GetCheckpointResponse;
import com.alicloud.openservices.tablestore.tunnel.worker.Checkpointer;
import com.alicloud.openservices.tablestore.tunnel.worker.FailedChannelConnect;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelConnect;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelDialer;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessor;
import com.alicloud.openservices.tablestore.tunnel.worker.IChannelProcessorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunnelStateMachine {
    private static final Logger LOG = LoggerFactory.getLogger(TunnelStateMachine.class);
    private String tunnelId;
    private String clientId;
    private TunnelClientInterface client;
    private IChannelDialer dialer;
    private IChannelProcessorFactory processorFactory;
    private volatile ConcurrentHashMap<String, IChannelConnect> channelConnects;
    private volatile ConcurrentHashMap<String, Channel> currentChannels;

    public TunnelStateMachine(String tunnelId, String clientId, IChannelDialer dialer, IChannelProcessorFactory processorFactory, TunnelClientInterface client) {
        Preconditions.checkArgument(tunnelId != null && !tunnelId.isEmpty(), "The tunnel id should not be null or empty.");
        Preconditions.checkArgument(clientId != null && !clientId.isEmpty(), "The client id should not be null or empty.");
        Preconditions.checkNotNull(dialer, "Channel dialer cannot be null.");
        Preconditions.checkNotNull(processorFactory, "Channel process factory cannot be null.");
        Preconditions.checkNotNull(client, "Tunnel client cannot be null.");
        this.tunnelId = tunnelId;
        this.clientId = clientId;
        this.dialer = dialer;
        this.processorFactory = processorFactory;
        this.client = client;
        this.channelConnects = new ConcurrentHashMap();
        this.currentChannels = new ConcurrentHashMap();
    }

    public void updateStatus(Channel channel) {
        LOG.debug("Begin update channel status, channel: {}", (Object)channel);
        String channelId = channel.getChannelId();
        Channel currentChannel = this.currentChannels.get(channelId);
        if (currentChannel == null) {
            LOG.info("Redundant channel, channelId: {}, status: {}", (Object)channelId, (Object)channel.getStatus().name());
            return;
        }
        LOG.debug("CurrentChannel: {}, UpdateChannel: {}", (Object)currentChannel, (Object)channel);
        if (currentChannel.getVersion() >= channel.getVersion()) {
            LOG.info("Expired channel version, channelId: {}, current version: {}, old version: {}", new Object[]{channelId, currentChannel.getVersion(), channel.getVersion()});
            return;
        }
        this.currentChannels.put(channelId, channel);
        IChannelConnect channelConnect = this.channelConnects.get(channelId);
        if (channelConnect != null && channelConnect.closed()) {
            this.channelConnects.remove(channelId);
        }
    }

    public List<IChannelConnect> batchGetChannelConnects() {
        return new ArrayList<IChannelConnect>(this.channelConnects.values());
    }

    public List<Channel> batchGetChannels() {
        return new ArrayList<Channel>(this.currentChannels.values());
    }

    public void batchUpdateChannels(List<Channel> batchChannels) {
        String channelId;
        LOG.info("Begin batch update channels");
        this.currentChannels = this.mergeChannels(batchChannels);
        for (Map.Entry<String, Channel> entry : this.currentChannels.entrySet()) {
            channelId = entry.getKey();
            IChannelConnect channelConnect = this.channelConnects.get(channelId);
            if (channelConnect == null) {
                try {
                    GetCheckpointResponse resp = this.client.getCheckpoint(new GetCheckpointRequest(this.tunnelId, this.clientId, channelId));
                    LOG.info("Get checkpoint response, channelId: {}, checkpoint: {}, sequenceNumber: {}", new Object[]{channelId, resp.getCheckpoint(), resp.getSequenceNumber()});
                    IChannelProcessor channelProcessor = this.processorFactory.createProcessor(this.tunnelId, this.clientId, channelId, new Checkpointer(this.client, this.tunnelId, this.clientId, channelId, resp.getSequenceNumber() + 1L));
                    channelConnect = this.dialer.channelDial(this.tunnelId, this.clientId, channelId, resp.getCheckpoint(), channelProcessor, this);
                    this.channelConnects.put(channelId, channelConnect);
                }
                catch (Exception e) {
                    LOG.warn("Failed to update channel, error detail: {}", (Object)e.toString());
                    channelConnect = new FailedChannelConnect(this);
                }
            }
            channelConnect.notifyStatus(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.channelConnects.entrySet()) {
            channelId = entry.getKey();
            Channel channel = this.currentChannels.get(channelId);
            if (channel != null) continue;
            LOG.info("Clear redundant channel connect, channelId: {}", (Object)channelId);
            IChannelConnect channelConnect = (IChannelConnect)entry.getValue();
            if (!channelConnect.closed()) {
                channelConnect.close();
            }
            this.channelConnects.remove(channelId);
        }
    }

    private ConcurrentHashMap<String, Channel> mergeChannels(List<Channel> batchChannels) {
        ConcurrentHashMap<String, Channel> updatedChannels = new ConcurrentHashMap<String, Channel>(batchChannels.size());
        for (Channel channel : batchChannels) {
            String channelId = channel.getChannelId();
            Channel oldChannel = this.currentChannels.get(channelId);
            if (oldChannel != null) {
                if (channel.getVersion() >= oldChannel.getVersion()) {
                    updatedChannels.put(channelId, channel);
                    continue;
                }
                updatedChannels.put(channelId, oldChannel);
                continue;
            }
            updatedChannels.put(channelId, channel);
        }
        return updatedChannels;
    }

    public void close() {
        LOG.info("Begin close tunnel state machine.");
        for (IChannelConnect connect : this.channelConnects.values()) {
            connect.close();
        }
        LOG.info("Tunnel state machine is closed");
    }
}

