/*
 * Copyright 2010-2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.cognitoidentity.model.transform;

import java.util.Map;
import java.util.Map.Entry;

import com.amazonaws.services.cognitoidentity.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * Update Identity Pool Result JSON Unmarshaller
 */
public class UpdateIdentityPoolResultJsonUnmarshaller implements Unmarshaller<UpdateIdentityPoolResult, JsonUnmarshallerContext> {

    public UpdateIdentityPoolResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        UpdateIdentityPoolResult updateIdentityPoolResult = new UpdateIdentityPoolResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null) token = context.nextToken();
        if (token == VALUE_NULL) return null;

        while (true) {
            if (token == null) break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("IdentityPoolId", targetDepth)) {
                    context.nextToken();
                    updateIdentityPoolResult.setIdentityPoolId(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("IdentityPoolName", targetDepth)) {
                    context.nextToken();
                    updateIdentityPoolResult.setIdentityPoolName(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AllowUnauthenticatedIdentities", targetDepth)) {
                    context.nextToken();
                    updateIdentityPoolResult.setAllowUnauthenticatedIdentities(BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SupportedLoginProviders", targetDepth)) {
                    context.nextToken();
                    updateIdentityPoolResult.setSupportedLoginProviders(new MapUnmarshaller<String,String>(StringJsonUnmarshaller.getInstance(), StringJsonUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("DeveloperProviderName", targetDepth)) {
                    context.nextToken();
                    updateIdentityPoolResult.setDeveloperProviderName(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("OpenIdConnectProviderARNs", targetDepth)) {
                    context.nextToken();
                    updateIdentityPoolResult.setOpenIdConnectProviderARNs(new ListUnmarshaller<String>(StringJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth) break;
                }
            }

            token = context.nextToken();
        }
        
        return updateIdentityPoolResult;
    }

    private static UpdateIdentityPoolResultJsonUnmarshaller instance;
    public static UpdateIdentityPoolResultJsonUnmarshaller getInstance() {
        if (instance == null) instance = new UpdateIdentityPoolResultJsonUnmarshaller();
        return instance;
    }
}
    