/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.StreamRecord;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import java.util.Map;

public class StreamRecordJsonMarshaller {
    private static StreamRecordJsonMarshaller instance;

    public void marshall(StreamRecord streamRecord, StructuredJsonGenerator jsonGenerator) {
        if (streamRecord == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, AttributeValue> oldImageMap;
            Map<String, AttributeValue> newImageMap;
            Map<String, AttributeValue> keysMap;
            jsonGenerator.writeStartObject();
            if (streamRecord.getApproximateCreationDateTime() != null) {
                jsonGenerator.writeFieldName("ApproximateCreationDateTime").writeValue(streamRecord.getApproximateCreationDateTime());
            }
            if ((keysMap = streamRecord.getKeys()) != null) {
                jsonGenerator.writeFieldName("Keys");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> keysMapValue : keysMap.entrySet()) {
                    if (keysMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(keysMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(keysMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((newImageMap = streamRecord.getNewImage()) != null) {
                jsonGenerator.writeFieldName("NewImage");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> newImageMapValue : newImageMap.entrySet()) {
                    if (newImageMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(newImageMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(newImageMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((oldImageMap = streamRecord.getOldImage()) != null) {
                jsonGenerator.writeFieldName("OldImage");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, AttributeValue> oldImageMapValue : oldImageMap.entrySet()) {
                    if (oldImageMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(oldImageMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(oldImageMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (streamRecord.getSequenceNumber() != null) {
                jsonGenerator.writeFieldName("SequenceNumber").writeValue(streamRecord.getSequenceNumber());
            }
            if (streamRecord.getSizeBytes() != null) {
                jsonGenerator.writeFieldName("SizeBytes").writeValue(streamRecord.getSizeBytes().longValue());
            }
            if (streamRecord.getStreamViewType() != null) {
                jsonGenerator.writeFieldName("StreamViewType").writeValue(streamRecord.getStreamViewType());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StreamRecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StreamRecordJsonMarshaller();
        }
        return instance;
    }
}

