/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.util.BitUtil;
import org.jetbrains.annotations.Nullable;

public final class FileAttributes {
    public static final FileAttributes BROKEN_SYMLINK = new FileAttributes(null, 1, 0L, 0L);
    @Nullable
    public final Type type;
    @Flags
    public final byte flags;
    public final long length;
    public final long lastModified;

    public FileAttributes(boolean directory, boolean special, boolean symlink, boolean hidden, long length, long lastModified, boolean writable) {
        this(FileAttributes.type(directory, special), FileAttributes.flags(symlink, hidden, !writable), length, lastModified);
    }

    private FileAttributes(@Nullable Type type, @Flags byte flags, long length, long lastModified) {
        this.type = type;
        this.flags = flags;
        this.length = length;
        this.lastModified = lastModified;
    }

    private static Type type(boolean isDirectory, boolean isSpecial) {
        return isDirectory ? Type.DIRECTORY : (isSpecial ? Type.SPECIAL : Type.FILE);
    }

    @Flags
    private static byte flags(boolean isSymlink, boolean isHidden, boolean isReadOnly) {
        byte flags = 0;
        if (isSymlink) {
            flags = (byte)(flags | 1);
        }
        if (isHidden) {
            flags = (byte)(flags | 2);
        }
        if (isReadOnly) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public boolean isDirectory() {
        return this.type == Type.DIRECTORY;
    }

    public boolean isSymLink() {
        return BitUtil.isSet(this.flags, (byte)1);
    }

    public static @interface Flags {
    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SPECIAL;

    }
}

