/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetToolkit {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset UTF_16LE_CHARSET = Charset.forName("UTF-16LE");
    public static final Charset UTF_16BE_CHARSET = Charset.forName("UTF-16BE");
    public static final Charset UTF_32BE_CHARSET = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE_CHARSET = Charset.forName("UTF-32LE");
    public static final Charset UTF_16_CHARSET = Charset.forName("UTF-16");
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    @NonNls
    private static final Map<Charset, byte[]> CHARSET_TO_MANDATORY_BOM = new THashMap<Charset, byte[]>(2);

    @Nullable
    public static byte[] getMandatoryBom(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "getMandatoryBom"));
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, @NotNull byte[] bom) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "canHaveBom"));
        }
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "canHaveBom"));
        }
        return charset.equals(UTF8_CHARSET) && Arrays.equals(bom, UTF8_BOM) || Arrays.equals(CharsetToolkit.getMandatoryBom(charset), bom);
    }

    static {
        CHARSET_TO_MANDATORY_BOM.put(UTF_16LE_CHARSET, UTF16LE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_16BE_CHARSET, UTF16BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32BE_CHARSET, UTF32BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32LE_CHARSET, UTF32LE_BOM);
    }
}

