/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.annotation.resolver.mask;

import com.anji.plus.gaea.annotation.GaeaMask;
import com.anji.plus.gaea.annotation.resolver.mask.MaskEnum;
import com.anji.plus.gaea.bean.ResponseBean;
import com.anji.plus.gaea.utils.GaeaMaskUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MaskResolveUtil {
    private static final Logger log = LoggerFactory.getLogger(MaskResolveUtil.class);

    public static void resolve(Object obj, Field[] fieldArr) throws IllegalAccessException {
        if (null == obj) {
            return;
        }
        Object data = obj;
        Class<?> clazz = obj.getClass();
        if (obj.getClass().equals(ResponseBean.class)) {
            data = ((ResponseBean)obj).getData();
            clazz = data.getClass();
        }
        if (null == clazz) {
            return;
        }
        Field[] fields = null;
        fields = fieldArr == null ? MaskResolveUtil.getFields(clazz) : fieldArr;
        if (null == fields || fields.length == 0) {
            return;
        }
        for (Field field : fields) {
            MaskEnum type;
            String result;
            String value;
            GaeaMask gaeaMask;
            Object value2;
            if (null == field) continue;
            field.setAccessible(true);
            Class<?> t = field.getType();
            if (t.isArray()) {
                value2 = field.get(data);
                if (Objects.isNull(value2)) continue;
                int len = Array.getLength(value2);
                for (int i = 0; i < len; ++i) {
                    Object arrayObject = Array.get(value2, i);
                    if (Objects.isNull(arrayObject)) continue;
                    if (i == 0) {
                        fields = MaskResolveUtil.getFields(arrayObject.getClass());
                    }
                    MaskResolveUtil.resolve(arrayObject, fields);
                }
            } else if (Collection.class.isAssignableFrom(t)) {
                value2 = field.get(data);
                Collection c = (Collection)value2;
                if (CollectionUtils.isEmpty((Collection)c)) continue;
                Iterator it = c.iterator();
                boolean init = false;
                while (it.hasNext()) {
                    Object collectionObj = it.next();
                    if (!init) {
                        fields = MaskResolveUtil.getFields(collectionObj.getClass());
                        init = true;
                    }
                    MaskResolveUtil.resolve(collectionObj, fields);
                }
            } else if (Map.class.isAssignableFrom(t)) {
                value2 = field.get(data);
                if (Objects.isNull(value2)) continue;
                Map m = (Map)value2;
                Set set = m.entrySet();
                Iterator init = set.iterator();
                while (init.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = init.next();
                    Object mapVal = entry.getValue();
                    MaskResolveUtil.resolve(mapVal, null);
                }
            }
            if (!field.getType().equals(String.class) || Objects.isNull(gaeaMask = field.getAnnotation(GaeaMask.class)) || StringUtils.isEmpty((CharSequence)(value = (String)field.get(data))) || Objects.equals(result = GaeaMaskUtils.getMaskValue(value, type = gaeaMask.type(), gaeaMask), value)) continue;
            field.set(data, result);
        }
    }

    public static Field[] getFields(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Object[] fields = clazz.getDeclaredFields();
        while (null != clazz.getSuperclass() && !Object.class.equals(clazz.getSuperclass())) {
            fields = (Field[])ArrayUtils.addAll((Object[])fields, (Object[])clazz.getSuperclass().getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        return fields;
    }
}

