/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.cache;

import com.anji.plus.gaea.annotation.HashKey;
import com.anji.plus.gaea.annotation.HashValue;
import com.anji.plus.gaea.bean.HashKeyValue;
import com.anji.plus.gaea.cache.CacheHelper;
import com.anji.plus.gaea.constant.BaseOperationEnum;
import com.anji.plus.gaea.utils.ApplicationContextUtils;
import com.anji.plus.gaea.utils.GaeaUtils;
import com.anji.plus.gaea.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public interface GaeaCacheService {
    default public String formatKey(String key, String[] replaceArray, Object entity) {
        return GaeaUtils.formatKey(key, replaceArray, entity);
    }

    default public <T> void refreshCacheFields(T entity, BaseOperationEnum opr) {
        Field[] declaredFields = ReflectionUtils.getAllFieldsArr(entity);
        HashMap<String, HashKeyValue> cacheMap = new HashMap<String, HashKeyValue>();
        for (Field field : declaredFields) {
            HashKeyValue hashKeyValue;
            String key;
            Object value;
            field.setAccessible(true);
            if (field.isAnnotationPresent(HashKey.class)) {
                try {
                    value = field.get(entity);
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                if (value == null) continue;
                HashKey hashKey = field.getAnnotation(HashKey.class);
                key = hashKey.key();
                if (cacheMap.containsKey(key)) {
                    hashKeyValue = (HashKeyValue)cacheMap.get(key);
                    hashKeyValue.setKey(String.valueOf(value));
                    hashKeyValue.setHashKey(hashKey);
                } else {
                    hashKeyValue = new HashKeyValue();
                    hashKeyValue.setKey(String.valueOf(value));
                    hashKeyValue.setHashKey(hashKey);
                    cacheMap.put(key, hashKeyValue);
                }
            }
            if (!field.isAnnotationPresent(HashValue.class)) continue;
            try {
                value = field.get(entity);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null) continue;
            HashValue hashValue = field.getAnnotation(HashValue.class);
            key = hashValue.key();
            if (cacheMap.containsKey(key)) {
                hashKeyValue = (HashKeyValue)cacheMap.get(key);
                hashKeyValue.setValue(String.valueOf(value));
                continue;
            }
            hashKeyValue = new HashKeyValue();
            hashKeyValue.setValue(String.valueOf(value));
            cacheMap.put(key, hashKeyValue);
        }
        CacheHelper cacheHelper = ApplicationContextUtils.getBean(CacheHelper.class);
        if (BaseOperationEnum.DELETE == opr || BaseOperationEnum.DELETE_BATCH == opr) {
            cacheMap.entrySet().stream().filter(entry -> ((HashKeyValue)entry.getValue()).nonNull()).forEach(entry -> {
                String k = this.formatKey((String)entry.getKey(), ((HashKeyValue)entry.getValue()).getHashKey().replace(), entity);
                cacheHelper.hashDel(k, ((HashKeyValue)entry.getValue()).getKey());
            });
        }
        if (BaseOperationEnum.INSERT == opr || BaseOperationEnum.UPDATE == opr) {
            cacheMap.entrySet().stream().filter(entry -> ((HashKeyValue)entry.getValue()).nonNull()).forEach(entry -> {
                String k = this.formatKey((String)entry.getKey(), ((HashKeyValue)entry.getValue()).getHashKey().replace(), entity);
                cacheHelper.hashSet(k, ((HashKeyValue)entry.getValue()).getKey(), ((HashKeyValue)entry.getValue()).getValue());
            });
        }
        if (BaseOperationEnum.DELETE_INSERT == opr) {
            cacheMap.entrySet().stream().filter(entry -> ((HashKeyValue)entry.getValue()).nonNull()).forEach(entry -> {
                String k = this.formatKey((String)entry.getKey(), ((HashKeyValue)entry.getValue()).getHashKey().replace(), entity);
                cacheHelper.hashDel(k, ((HashKeyValue)entry.getValue()).getKey());
                cacheHelper.hashSet(k, ((HashKeyValue)entry.getValue()).getKey(), ((HashKeyValue)entry.getValue()).getValue());
            });
        }
        if (BaseOperationEnum.MERGE == opr) {
            cacheMap.entrySet().stream().forEach(entry -> {
                String k = this.formatKey((String)entry.getKey(), ((HashKeyValue)entry.getValue()).getHashKey().replace(), entity);
                cacheHelper.hashSet(k, ((HashKeyValue)entry.getValue()).getKey(), ((HashKeyValue)entry.getValue()).getValue());
            });
        }
    }

    default public <T> void refreshCacheFieldsBatch(List<T> entities, BaseOperationEnum opr) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        T entity = entities.get(0);
        Field[] declaredFields = ReflectionUtils.getAllFieldsArr(entity);
        CacheHelper cacheHelper = ApplicationContextUtils.getBean(CacheHelper.class);
        HashMap cacheMap = new HashMap();
        for (T t : entities) {
            Set list;
            String key;
            Object value;
            String namePrefix = "";
            String k = "";
            for (Field field : declaredFields) {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(HashKey.class)) continue;
                try {
                    value = field.get(t);
                }
                catch (IllegalAccessException ex) {
                    continue;
                }
                if (value == null) continue;
                HashKey hashKey = field.getAnnotation(HashKey.class);
                key = hashKey.key();
                namePrefix = this.formatKey(key, hashKey.replace(), t);
                k = value + "";
                if (cacheMap.containsKey(key)) {
                    list = (Set)cacheMap.get(key);
                    HashKeyValue r = new HashKeyValue();
                    r.setKey(String.valueOf(value));
                    r.setHashKey(hashKey);
                    r.setName(namePrefix);
                    list.add(r);
                    continue;
                }
                HashKeyValue kv = new HashKeyValue();
                kv.setKey(String.valueOf(value));
                kv.setHashKey(hashKey);
                kv.setName(namePrefix);
                HashSet<HashKeyValue> list2 = new HashSet<HashKeyValue>();
                list2.add(kv);
                cacheMap.put(key, list2);
            }
            for (Field field : declaredFields) {
                HashValue hashValue;
                field.setAccessible(true);
                if (!field.isAnnotationPresent(HashValue.class)) continue;
                try {
                    value = field.get(t);
                }
                catch (IllegalAccessException e) {
                    continue;
                }
                if (value == null || !cacheMap.containsKey(key = (hashValue = field.getAnnotation(HashValue.class)).key())) continue;
                list = (Set)cacheMap.get(key);
                String k1 = k;
                String ns = namePrefix;
                list.stream().filter(f -> f.getKey().equals(k1) && f.getName().equals(ns)).findFirst().get().setValue(String.valueOf(value));
            }
        }
        if (BaseOperationEnum.DELETE == opr || BaseOperationEnum.DELETE_BATCH == opr) {
            cacheMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).forEach(entry -> {
                Map<String, List<HashKeyValue>> map = ((Set)entry.getValue()).stream().collect(Collectors.groupingBy(t -> t.getName()));
                map.entrySet().forEach(kv -> cacheHelper.hashBatchDel((String)kv.getKey(), ((List)kv.getValue()).stream().map(HashKeyValue::getKey).collect(Collectors.toSet())));
            });
        }
        if (BaseOperationEnum.INSERT == opr || BaseOperationEnum.UPDATE == opr) {
            cacheMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).forEach(entry -> {
                Map<String, List<HashKeyValue>> map = ((Set)entry.getValue()).stream().collect(Collectors.groupingBy(t -> t.getName()));
                map.entrySet().forEach(kv -> cacheHelper.hashSet((String)kv.getKey(), ((List)kv.getValue()).stream().collect(Collectors.toMap(HashKeyValue::getKey, HashKeyValue::getValue, (v1, v2) -> v2))));
            });
        }
        if (BaseOperationEnum.DELETE_INSERT == opr) {
            cacheMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).forEach(entry -> {
                Map<String, List<HashKeyValue>> map = ((Set)entry.getValue()).stream().collect(Collectors.groupingBy(t -> t.getName()));
                map.entrySet().forEach(kv -> {
                    cacheHelper.hashBatchDel((String)kv.getKey(), ((List)kv.getValue()).stream().map(HashKeyValue::getKey).collect(Collectors.toSet()));
                    cacheHelper.hashSet((String)kv.getKey(), ((List)kv.getValue()).stream().collect(Collectors.toMap(t -> t.getKey(), t -> t.getValue(), (v1, v2) -> v2)));
                });
            });
        }
        if (BaseOperationEnum.MERGE == opr) {
            cacheMap.entrySet().stream().forEach(entry -> {
                Map<String, List<HashKeyValue>> map = ((Set)entry.getValue()).stream().collect(Collectors.groupingBy(t -> t.getName()));
                map.entrySet().forEach(kv -> cacheHelper.hashSet((String)kv.getKey(), ((List)kv.getValue()).stream().filter(e -> !StringUtils.isEmpty((Object)e.getKey())).collect(Collectors.toMap(t -> t.getKey(), t -> Optional.ofNullable(t.getValue()).orElse(""), (v1, v2) -> v2))));
            });
        }
    }
}

