/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.init;

import com.anji.plus.gaea.annotation.Permission;
import com.anji.plus.gaea.annotation.Permissions;
import com.anji.plus.gaea.constant.Enabled;
import com.anji.plus.gaea.controller.GaeaBootController;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PathPatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

public class InitRequestUrlMappings {
    private static final Logger log = LoggerFactory.getLogger(InitRequestUrlMappings.class);
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Value(value="${uri.mapping.packages-ignored:}")
    private String packageIgnored;

    public List<RequestInfo> getRequestInfos(Integer scanAnnotation) {
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        ArrayList<RequestInfo> list = new ArrayList<RequestInfo>();
        handlerMethods.entrySet().stream().forEach(entry -> {
            ArrayList<Permission> annotations = new ArrayList<Permission>();
            HandlerMethod value = (HandlerMethod)entry.getValue();
            if (value.getBeanType() == GaeaBootController.class) {
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.packageIgnored) && StringUtils.startsWithAny((CharSequence)value.getBeanType().getName(), (CharSequence[])this.packageIgnored.split(","))) {
                log.warn("ignored-pack:{}", (Object)value.getBeanType().getName());
                return;
            }
            if (Enabled.YES.getValue().equals(scanAnnotation)) {
                Permission[] permissions;
                Method method = value.getMethod();
                Class beanType = value.getBeanType();
                if (!beanType.isAnnotationPresent(Permission.class) || !method.isAnnotationPresent(Permission.class) && !method.isAnnotationPresent(Permissions.class)) return;
                Permission type = beanType.getAnnotation(Permission.class);
                for (Permission mtd : permissions = (Permission[])method.getAnnotationsByType(Permission.class)) {
                    PatternsRequestCondition c;
                    RequestInfo requestInfo = new RequestInfo();
                    requestInfo.setEnabled(mtd.enabled() && type.enabled());
                    requestInfo.setDependsOn(mtd.dependsOn());
                    if (StringUtils.isNotBlank((CharSequence)mtd.superCode())) {
                        requestInfo.setMenuCode(mtd.superCode());
                        requestInfo.setAuthCode(mtd.superCode() + ":" + mtd.code());
                    } else if (StringUtils.isNotBlank((CharSequence)type.superCode())) {
                        requestInfo.setMenuCode(type.superCode());
                        if (StringUtils.isEmpty((CharSequence)mtd.superCode())) {
                            requestInfo.setAuthCode(type.code() + ":" + mtd.code());
                        } else {
                            requestInfo.setAuthCode(mtd.superCode() + ":" + mtd.code());
                        }
                    } else {
                        requestInfo.setMenuCode(type.code());
                        requestInfo.setAuthCode(type.code() + ":" + mtd.code());
                    }
                    requestInfo.setAuthName(mtd.name());
                    requestInfo.setMenuName(type.name());
                    annotations.add(mtd);
                    requestInfo.setBeanName(value.getBean().toString());
                    requestInfo.setApplicationName(this.applicationName);
                    RequestMappingInfo m = (RequestMappingInfo)entry.getKey();
                    Optional requestMethodOptional = m.getMethodsCondition().getMethods().stream().findFirst();
                    if (!requestMethodOptional.isPresent()) {
                        return;
                    }
                    RequestMethod requestMethod = (RequestMethod)requestMethodOptional.get();
                    String path = "";
                    PathPatternsRequestCondition cond = m.getPathPatternsCondition();
                    if (!Objects.isNull(cond)) {
                        Optional pathOptional = cond.getPatterns().stream().findFirst();
                        if (!pathOptional.isPresent()) {
                            return;
                        }
                        path = ((PathPattern)pathOptional.get()).getPatternString();
                    }
                    if (!Objects.isNull(c = m.getPatternsCondition())) {
                        Optional pathOptional = c.getPatterns().stream().findFirst();
                        if (!pathOptional.isPresent()) {
                            return;
                        }
                        path = (String)pathOptional.get();
                    }
                    if (path.contains("{")) {
                        path = path.replaceAll("\\{\\w+\\}", "*");
                    }
                    requestInfo.setPath(requestMethod + "#" + path);
                    list.add(requestInfo);
                }
                return;
            } else {
                PatternsRequestCondition c;
                RequestInfo requestInfo = new RequestInfo();
                requestInfo.setAuthCode(value.getBean() + "#" + value.getMethod().getName());
                requestInfo.setBeanName(value.getBean().toString());
                requestInfo.setApplicationName(this.applicationName);
                requestInfo.setEnabled(true);
                RequestMappingInfo m = (RequestMappingInfo)entry.getKey();
                Optional rm = m.getMethodsCondition().getMethods().stream().findFirst();
                if (!rm.isPresent()) {
                    return;
                }
                RequestMethod requestMethod = (RequestMethod)rm.get();
                String path = "";
                PathPatternsRequestCondition cond = m.getPathPatternsCondition();
                if (!Objects.isNull(cond)) {
                    Optional pathOptional = cond.getPatterns().stream().findFirst();
                    if (!pathOptional.isPresent()) {
                        return;
                    }
                    path = ((PathPattern)pathOptional.get()).getPatternString();
                }
                if (!Objects.isNull(c = m.getPatternsCondition())) {
                    Optional pathOptional = c.getPatterns().stream().findFirst();
                    if (!pathOptional.isPresent()) {
                        return;
                    }
                    path = (String)pathOptional.get();
                }
                if (path.contains("{")) {
                    path = path.replaceAll("\\{\\w+\\}", "**");
                }
                requestInfo.setPath(requestMethod + "#" + path);
                list.add(requestInfo);
            }
        });
        return list;
    }

    public static class RequestInfo {
        private String applicationName;
        private String beanName;
        private String menuCode;
        private String menuName;
        private String authCode;
        private String authName;
        private String path;
        private boolean enabled;
        private String dependsOn;

        public String getDependsOn() {
            return this.dependsOn;
        }

        public void setDependsOn(String dependsOn) {
            this.dependsOn = dependsOn;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getAuthCode() {
            return this.authCode;
        }

        public void setAuthCode(String authCode) {
            this.authCode = authCode;
        }

        public String getAuthName() {
            return this.authName;
        }

        public void setAuthName(String authName) {
            this.authName = authName;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public void setBeanName(String beanName) {
            this.beanName = beanName;
        }

        public String getMenuCode() {
            return this.menuCode;
        }

        public void setMenuCode(String menuCode) {
            this.menuCode = menuCode;
        }

        public String getMenuName() {
            return this.menuName;
        }

        public void setMenuName(String menuName) {
            this.menuName = menuName;
        }
    }
}

