/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.introspector;

import com.anji.plus.gaea.holder.UserContentHolder;
import com.anji.plus.gaea.utils.GaeaDateUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class DateSerializer
extends JsonSerializer<Date> {
    private final String pattern;
    private String timezone;

    public DateSerializer(String pattern, String timezone) {
        this.pattern = pattern;
        this.timezone = timezone;
    }

    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        String time;
        if (null == date) {
            return;
        }
        if ("yyyy-MM".equals(this.pattern) || "yyyy-MM-dd".equals(this.pattern)) {
            time = GaeaDateUtils.DateToString(date, this.pattern);
        } else {
            TimeZone timeZone = StringUtils.isNotBlank((CharSequence)UserContentHolder.getTimeZone()) ? TimeZone.getTimeZone(UserContentHolder.getTimeZone()) : TimeZone.getDefault();
            time = GaeaDateUtils.javaTimeToSourceTime(date, this.pattern, timeZone);
        }
        jsonGenerator.writeString(time);
    }
}

