/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import com.anji.plus.gaea.holder.UserContentHolder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GaeaDateUtils {
    private static Logger logger = LoggerFactory.getLogger(GaeaDateUtils.class);
    public static final String timePattern = "yyyy-MM-dd HH:mm:ss";
    private static final String yearPattern = "^2[0-9]{3}$";
    private static final String monthPattern = "^2[0-9]{3}-(0?[1-9]|1[0-2])$";
    private static final String janPattern = "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])";
    private static final String febPattern = "0?2-(0?[1-9]|[12][0-9])";
    private static final String aprPattern = "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)";
    private static final String dayPattern = String.format("^2[0-9]{3}-(%s|%s|%s)$", "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])", "0?2-(0?[1-9]|[12][0-9])", "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)");
    private static final String hourFormat = String.format("^2[0-9]{3}-(%s|%s|%s) ([01][0-9]|2[0-3]):00:00$", "0?2-(0?[1-9]|[12][0-9])", "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])", "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)");
    private static final String timeFormat = String.format("^2[0-9]{3}-(%s|%s|%s) ([01][0-9]|2[0-3])(:[0-5][0-9]){2}$", "0?2-(0?[1-9]|[12][0-9])", "(0?[13578]|1[02])-(0?[1-9]|[12][0-9]|3[01])", "(0?[469]|11)-(0?[1-9]|[12][0-9]|30)");

    public static String toString(Date date, String pattern) {
        LocalDateTime localDateTime = GaeaDateUtils.toLocalDateTime(date);
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(LocalDate localDate, String pattern) {
        return localDate.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static LocalDate fromString(String dateString, String pattern) {
        return LocalDate.parse(dateString, DateTimeFormatter.ofPattern(pattern));
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String formatFromSecond(long seconds) {
        long resultSeconds;
        long minus;
        long hours;
        StringBuilder builder = new StringBuilder();
        long hourSeconds = 3600L;
        long daySeconds = hourSeconds * 24L;
        long days = seconds / daySeconds;
        if (days > 0L) {
            builder.append(days).append("${day}");
        }
        if ((hours = seconds % daySeconds / hourSeconds) > 0L) {
            builder.append(hours).append("${hour}");
        }
        if ((minus = seconds % daySeconds % hourSeconds / 60L) > 0L) {
            builder.append(minus).append("${minute}");
        }
        if ((resultSeconds = seconds % daySeconds % hourSeconds % 60L) > 0L) {
            builder.append(resultSeconds).append("${second}");
        }
        return builder.toString();
    }

    public static Date sourceTimeZoneToTargetTimeZone(String sourceTime, String format, TimeZone sourceTimeZone, TimeZone targetTimeZone) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setTimeZone(sourceTimeZone);
        Date utcDate = null;
        try {
            utcDate = sdf.parse(sourceTime);
        }
        catch (ParseException e) {
            logger.error("ERROR:", (Throwable)e);
        }
        sdf.setTimeZone(targetTimeZone);
        Date locatlDate = null;
        String localTime = sdf.format(utcDate.getTime());
        try {
            locatlDate = sdf.parse(localTime);
        }
        catch (ParseException e) {
            logger.error("ERROR:", (Throwable)e);
        }
        return locatlDate;
    }

    public static String sourceTimeZoneToTargetTimeZone(String sourceTime) {
        if (sourceTime.matches(timeFormat)) {
            TimeZone timeZone = StringUtils.isNotBlank((CharSequence)UserContentHolder.getTimeZone()) ? TimeZone.getTimeZone(UserContentHolder.getTimeZone()) : TimeZone.getDefault();
            SimpleDateFormat sdf = new SimpleDateFormat(timePattern);
            sdf.setTimeZone(timeZone);
            Date utcDate = null;
            try {
                utcDate = sdf.parse(sourceTime);
            }
            catch (ParseException e) {
                logger.error("ERROR:", (Throwable)e);
            }
            sdf.setTimeZone(TimeZone.getDefault());
            return sdf.format(utcDate.getTime());
        }
        return sourceTime;
    }

    public static String javaTimeToSourceTime(Date date, String pattern, TimeZone timezone) {
        String output = "";
        if (null != date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            simpleDateFormat.setTimeZone(timezone);
            output = simpleDateFormat.format(date);
        }
        return output;
    }

    public static Date StringToDate(String time, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        try {
            return simpleDateFormat.parse(time);
        }
        catch (ParseException e) {
            logger.error("ERROR:", (Throwable)e);
            return null;
        }
    }

    public static String DateToString(Date time, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(time);
    }

    public static Date timeMillisToDate(String timeMillis) {
        Long aLong = Long.valueOf(timeMillis);
        return new Date(aLong);
    }

    public static boolean checkTimeFormat(String time) {
        return time.matches(timeFormat);
    }
}

