/*
 * Decompiled with CFR 0.152.
 */
package com.anji.plus.gaea.utils;

import com.alibaba.fastjson.JSONObject;
import com.anji.plus.gaea.bean.KeyValue;
import com.anji.plus.gaea.utils.ReflectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.DigestUtils;

public abstract class GaeaUtils {
    private static String SLAT = "354816d26912441ab280f08831c38453";
    public static final AntPathMatcher antPathMatcher = new AntPathMatcher();
    public static Pattern pattern = Pattern.compile("\\$\\{(\\w+)}");

    public static boolean matchPath(List<String> list, String path) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        if (!list.contains(path)) {
            Optional<String> any = list.stream().filter(s -> antPathMatcher.match(s, path)).findAny();
            return any.isPresent();
        }
        return true;
    }

    public static String camelToUnderline(String source) {
        return StringUtils.camelToUnderline((String)source);
    }

    public static String underlineToCamel(String source) {
        return StringUtils.underlineToCamel((String)source);
    }

    public static String getPassKey(long id) {
        String tokenTmp = DigestUtils.md5DigestAsHex((byte[])(SLAT + "_" + id).getBytes(Charset.forName("UTF-8")));
        return tokenTmp;
    }

    public static String UUID() {
        return UUID.randomUUID().toString().replaceAll("\\-", "");
    }

    public static String formatDate(Date date) {
        return GaeaUtils.formatDate(date, "yyyy-MM-dd");
    }

    public static String formatDate(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String toJSONString(Object object) {
        return JSONObject.toJSONString((Object)object);
    }

    public static List<KeyValue> formatKeyValue(Map<? extends Object, String> map) {
        return map.entrySet().stream().map(entry -> new KeyValue(entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    }

    public static Map<String, String> formatterKeyValueMap(List<KeyValue> keyValues) {
        return keyValues.stream().filter(keyValue -> keyValue.getId() != null && keyValue.getText() != null).collect(Collectors.toMap(keyValue -> String.valueOf(keyValue.getId()), KeyValue::getText, (v1, v2) -> v2));
    }

    public static String replaceFormatString(String source, Map<String, Object> map) {
        Matcher matcher = pattern.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String variable = matcher.group(1);
            Object value = map.get(variable);
            if (value == null) continue;
            matcher.appendReplacement(sb, String.valueOf(value));
        }
        return sb.toString();
    }

    public static String replaceFormatString(String source, Object param) {
        if (param instanceof String) {
            return GaeaUtils.replaceFormatString(source, param + "", "");
        }
        if (param instanceof Integer || param instanceof Long) {
            return GaeaUtils.replaceFormatString(source, param + "", "");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)param));
        return GaeaUtils.replaceFormatString(source, (Map<String, Object>)jsonObject);
    }

    public static String replaceFormatString(String source, String ... args) {
        if (args == null || args.length == 0) {
            return GaeaUtils.replaceFormatString(source, new HashMap<String, Object>());
        }
        Matcher matcher = pattern.matcher(source);
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (matcher.find()) {
            String variable = matcher.group(1);
            String value = null;
            if (index <= args.length - 1) {
                value = args[index];
            }
            if (value != null) {
                matcher.appendReplacement(sb, value);
            }
            ++index;
        }
        return sb.toString();
    }

    public static String formatKey(String key, String[] replaceArray, Object entity) {
        if (key.contains("${")) {
            HashMap<String, Object> keyPatternMap = new HashMap<String, Object>(2);
            for (String fieldName : replaceArray) {
                try {
                    Field declaredField = ReflectionUtils.getField(entity, fieldName);
                    declaredField.setAccessible(true);
                    Object fieldValue = declaredField.get(entity);
                    keyPatternMap.put(fieldName, fieldValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((key = GaeaUtils.replaceFormatString(key, keyPatternMap)).contains("${")) {
                return null;
            }
        }
        return key;
    }
}

