/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.base.exception.ParametersException;
import com.apstar.resource.busi.InstanceIpService;
import com.apstar.resource.busi.bo.InstanceIpBO;
import com.apstar.resource.busi.bo.InstanceIpReqBO;
import com.apstar.resource.busi.bo.InstanceIpRspBO;
import com.apstar.resource.busi.bo.InstancedIpBO;
import com.apstar.resource.dao.IpInstanceDao;
import com.apstar.resource.po.IpInstancePO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="instanceIpService")
public class InstanceIpServiceImpl
implements InstanceIpService {
    private static final Logger logger = LoggerFactory.getLogger(InstanceIpServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private IpInstanceDao ipInstanceDao;

    public InstanceIpRspBO instanceIp(InstanceIpReqBO instanceIpReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2\uff1a" + instanceIpReqBO.toString());
        }
        if (StringUtils.isEmpty((Object)instanceIpReqBO.getInstanceIps()) || instanceIpReqBO.getInstanceIps().size() == 0) {
            throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[instanceIps]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InstanceIpRspBO instanceIpRspBO = new InstanceIpRspBO();
        ArrayList<InstancedIpBO> instancedIpBOList = new ArrayList<InstancedIpBO>();
        for (InstanceIpBO instanceIpBO : instanceIpReqBO.getInstanceIps()) {
            if (StringUtils.isEmpty((Object)instanceIpBO.getIpId())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[ipId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)instanceIpBO.getSubnetMaskId())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[subnetMaskId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)instanceIpBO.getSubnetMask())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[subnetMask]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)instanceIpBO.getResStartIp())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[resStartIp]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)instanceIpBO.getResEndIp())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[resEndIp]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)instanceIpBO.getResIpType())) {
                throw new ParametersException("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u5165\u53c2[resIpType]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                IpInstancePO ipInstancePO = new IpInstancePO();
                ipInstancePO.setIpId(instanceIpBO.getIpId());
                ipInstancePO.setVlanId(instanceIpBO.getVlanId());
                ipInstancePO.setVlanCode(instanceIpBO.getVlanCode());
                ipInstancePO.setSubnetMaskId(instanceIpBO.getSubnetMaskId());
                ipInstancePO.setSubnetMask(instanceIpBO.getSubnetMask());
                ipInstancePO.setResStartIp(instanceIpBO.getResStartIp());
                ipInstancePO.setResEndIp(instanceIpBO.getResEndIp());
                ipInstancePO.setStaticStartIp(instanceIpBO.getStaticStartIp());
                ipInstancePO.setStaticEndIp(instanceIpBO.getStaticEndIp());
                ipInstancePO.setDynamicStartIp(instanceIpBO.getDynamicStartIp());
                ipInstancePO.setDynamicEndIp(instanceIpBO.getDynamicEndIp());
                ipInstancePO.setResIpType(instanceIpBO.getResIpType());
                ipInstancePO.setCreateTime(new Date());
                ipInstancePO.setResIpStatus(0);
                this.ipInstanceDao.insertSelective(ipInstancePO);
                InstancedIpBO instancedIpBO = new InstancedIpBO();
                instancedIpBO.setIpInstanceId(ipInstancePO.getIpInstanceId());
                instancedIpBO.setResIpType(instanceIpBO.getResIpType());
                instancedIpBOList.add(instancedIpBO);
            }
            catch (Exception e) {
                logger.error("\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u51fa\u9519", (Throwable)e);
                throw new BusinessException("10003", "\u5b9e\u4f8b\u5316IP\u8d44\u6e90\u670d\u52a1\u51fa\u9519");
            }
        }
        instanceIpRspBO.setInstancedIps(instancedIpBOList);
        return instanceIpRspBO;
    }
}

