/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.resource.busi.IpInstanceInfoService;
import com.apstar.resource.busi.bo.IpInstanceInfoBO;
import com.apstar.resource.busi.bo.IpInstanceInfoReqBO;
import com.apstar.resource.busi.bo.IpInstanceInfoRspBO;
import com.apstar.resource.dao.IpInstanceDao;
import com.apstar.resource.po.IpInstancePO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="ipInstanceInfoService")
public class IpInstanceInfoServiceImpl
implements IpInstanceInfoService {
    private static final Logger logger = LoggerFactory.getLogger(IpInstanceInfoServiceImpl.class);
    private static final Boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    IpInstanceDao IpInstanceDao;

    public IpInstanceInfoRspBO ipInstanceInfo(IpInstanceInfoReqBO ipInstanceInfoReqBO) {
        if (isDebugEnabled.booleanValue()) {
            logger.debug("\u67e5\u8be2vlan\u5217\u8868\u670d\u52a1\u5165\u53c2{}" + ipInstanceInfoReqBO.toString());
        }
        if (ipInstanceInfoReqBO.getIpInstanceIds().size() == 0 || StringUtils.isEmpty((Object)ipInstanceInfoReqBO.getIpInstanceIds())) {
            throw new BusinessException("7777", "IP\u8d44\u6e90\u5b9e\u4f8b\u8be6\u60c5\u67e5\u8be2\u670d\u52a1\u5165\u53c2[ipInstanceIds]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<IpInstancePO> list = this.IpInstanceDao.selectByIpInstanceIdsCheck(ipInstanceInfoReqBO.getIpInstanceIds());
        if (list.size() < ipInstanceInfoReqBO.getIpInstanceIds().size()) {
            throw new BusinessException("7777", "\u6709\u4e0d\u5b58\u5728\u7684IP\u8d44\u6e90\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u67e5\u8be2");
        }
        try {
            List<IpInstancePO> IpInstancePOs = this.IpInstanceDao.selectByIpInstanceIds(ipInstanceInfoReqBO.getIpInstanceIds());
            ArrayList<IpInstanceInfoBO> ipInstanceInfoBOs = new ArrayList<IpInstanceInfoBO>();
            for (IpInstancePO po : IpInstancePOs) {
                IpInstanceInfoBO ipInstanceInfoBO = new IpInstanceInfoBO();
                ipInstanceInfoBO.setIpInstanceId(po.getIpInstanceId().longValue());
                ipInstanceInfoBO.setSubnetMask(po.getSubnetMask());
                ipInstanceInfoBO.setVlanCode(po.getVlanCode());
                ipInstanceInfoBO.setResIpType(po.getResIpType());
                ipInstanceInfoBO.setResSartIp(po.getResStartIp());
                ipInstanceInfoBO.setResEndIp(po.getResEndIp());
                ipInstanceInfoBO.setStaticStartIp(po.getStaticStartIp());
                ipInstanceInfoBO.setStaticEndIp(po.getStaticEndIp());
                ipInstanceInfoBO.setDynamicStartIp(po.getDynamicStartIp());
                ipInstanceInfoBO.setDynamicEndIp(po.getDynamicEndIp());
                ipInstanceInfoBOs.add(ipInstanceInfoBO);
            }
            IpInstanceInfoRspBO ipInstanceInfoRspBO = new IpInstanceInfoRspBO();
            ipInstanceInfoRspBO.setIpInstanceInfos(ipInstanceInfoBOs);
            return ipInstanceInfoRspBO;
        }
        catch (Exception e) {
            throw new BusinessException("10003", "IP\u8d44\u6e90\u5b9e\u4f8b\u8be6\u60c5\u67e5\u8be2\u670d\u52a1\u51fa\u9519");
        }
    }
}

