/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.bo.rsp.RspPageBO;
import com.apstar.feature.orm.mybatis.Page;
import com.apstar.resource.busi.QryDevicePackagesService;
import com.apstar.resource.busi.bo.QryDevicePackagesReqBO;
import com.apstar.resource.busi.bo.QryDevicePackagesRspBO;
import com.apstar.resource.dao.DevicePackageDao;
import com.apstar.resource.po.DevicePackagePO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="qryDevicePackagesService")
public class QryDevicePackagesServiceImpl
implements QryDevicePackagesService {
    private static final Logger logger = LoggerFactory.getLogger(QryDevicePackagesServiceImpl.class);
    private static final Boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    DevicePackageDao DevicePackageDao;

    public RspPageBO<QryDevicePackagesRspBO> qryDevicePackages(QryDevicePackagesReqBO qryDevicePackagesReqBO) {
        if (isDebugEnabled.booleanValue()) {
            logger.debug("\u8bbe\u5907\u5305\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5165\u53c2{}" + qryDevicePackagesReqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        try {
            if (StringUtils.isEmpty((Object)qryDevicePackagesReqBO.getDevicePkgCodes()) || qryDevicePackagesReqBO.getDevicePkgCodes().size() == 0) {
                qryDevicePackagesReqBO.setDevicePkgCodes(null);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("devicePkgName", qryDevicePackagesReqBO.getDevicePkgName());
            params.put("list", qryDevicePackagesReqBO.getDevicePkgCodes());
            Page page = new Page(qryDevicePackagesReqBO.getPageNo(), qryDevicePackagesReqBO.getPageSize());
            List<DevicePackagePO> list = this.DevicePackageDao.selectByDevicePkgName(params, (Page<QryDevicePackagesRspBO>)page);
            ArrayList<QryDevicePackagesRspBO> rows = new ArrayList<QryDevicePackagesRspBO>();
            for (DevicePackagePO devicePackagePO : list) {
                QryDevicePackagesRspBO qryDevicePackagesRspBO = new QryDevicePackagesRspBO();
                qryDevicePackagesRspBO.setDevicePackageId(devicePackagePO.getDevicePackageId());
                qryDevicePackagesRspBO.setDevicePkgChinName(devicePackagePO.getDevicePkgChinName());
                qryDevicePackagesRspBO.setDevicePkgEngName(devicePackagePO.getDevicePkgEngName());
                qryDevicePackagesRspBO.setDevicePkgDesc(devicePackagePO.getDevicePkgDesc());
                qryDevicePackagesRspBO.setDevicePkgRes(devicePackagePO.getDevicePkgRes());
                qryDevicePackagesRspBO.setSalePrice(devicePackagePO.getSalePrice());
                rows.add(qryDevicePackagesRspBO);
            }
            rspPageBO.setRows(rows);
            rspPageBO.setPageNo(page.getPageNo());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setRecordsTotal(page.getTotalCount());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u8bbe\u5907\u5305\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("10003", "\u8bbe\u5907\u5305\u5217\u8868\u67e5\u8be2\u670d\u52a1\u5931\u8d25");
        }
    }
}

