/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.bo.rsp.RspPageBO;
import com.apstar.feature.orm.mybatis.Page;
import com.apstar.resource.busi.QryDeviceResService;
import com.apstar.resource.busi.bo.QryDeviceResReqBO;
import com.apstar.resource.busi.bo.QryDeviceResRspBO;
import com.apstar.resource.dao.DevicePackageDao;
import com.apstar.resource.dao.ResMessDao;
import com.apstar.resource.po.DevicePackagePO;
import com.apstar.resource.po.ResMessPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qryDeviceResService")
public class QryDeviceResServiceImpl
implements QryDeviceResService {
    private static final Logger logger = LoggerFactory.getLogger(QryDeviceResServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private DevicePackageDao devicePackageDao;
    @Autowired
    private ResMessDao resMessDao;

    public RspPageBO<QryDeviceResRspBO> qryDeviceRes(QryDeviceResReqBO qryDeviceResReqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8bbe\u5907\u8d44\u6e90\u5217\u8868\u4fe1\u606f\u670d\u52a1\u5165\u53c2{}" + qryDeviceResReqBO.toString());
        }
        try {
            List<DevicePackagePO> devicePackageList;
            RspPageBO rsp = new RspPageBO();
            ArrayList<String> deviceCodeList = new ArrayList<String>();
            if (null != qryDeviceResReqBO.getDevicePackageIds() && qryDeviceResReqBO.getDevicePackageIds().size() > 0 && null != (devicePackageList = this.devicePackageDao.selectByIds(qryDeviceResReqBO.getDevicePackageIds())) && devicePackageList.size() > 0) {
                for (DevicePackagePO devicePackagePO : devicePackageList) {
                    String[] strings = devicePackagePO.getDevicePkgRes().split(",");
                    for (int i = 0; strings != null && i < strings.length; ++i) {
                        deviceCodeList.add(strings[i]);
                    }
                }
            }
            Page page = new Page(qryDeviceResReqBO.getPageNo(), qryDeviceResReqBO.getPageSize());
            List<ResMessPO> resMessList = this.resMessDao.selectList(deviceCodeList, qryDeviceResReqBO, (Page<QryDeviceResRspBO>)page);
            ArrayList<QryDeviceResRspBO> result = new ArrayList<QryDeviceResRspBO>();
            if (null != resMessList && resMessList.size() > 0) {
                for (ResMessPO resMessPO : resMessList) {
                    QryDeviceResRspBO qryDeviceResRspBO = new QryDeviceResRspBO();
                    qryDeviceResRspBO.setResCode(resMessPO.getResCode());
                    qryDeviceResRspBO.setResName(resMessPO.getResName());
                    qryDeviceResRspBO.setResType(resMessPO.getResType());
                    qryDeviceResRspBO.setResDesc(resMessPO.getResDesc());
                    qryDeviceResRspBO.setResPrice(resMessPO.getResPrice());
                    qryDeviceResRspBO.setResMode(resMessPO.getResMode());
                    qryDeviceResRspBO.setFactory(resMessPO.getFactory());
                    result.add(qryDeviceResRspBO);
                }
            }
            rsp.setRows(result);
            rsp.setPageNo(qryDeviceResReqBO.getPageNo());
            rsp.setRecordsTotal(page.getTotalCount());
            rsp.setTotal(page.getTotalPages());
            return rsp;
        }
        catch (Exception e) {
            throw new BusinessException("10003", "\u8bbe\u5907\u8d44\u6e90\u5217\u8868\u4fe1\u606f\u670d\u52a1\u5931\u8d25");
        }
    }
}

