/*
 * Decompiled with CFR 0.152.
 */
package com.apstar.resource.busi.impl;

import com.apstar.base.exception.BusinessException;
import com.apstar.bo.rsp.RspPageBO;
import com.apstar.feature.orm.mybatis.Page;
import com.apstar.resource.busi.QryVlanListService;
import com.apstar.resource.busi.bo.QryVlanListReqBO;
import com.apstar.resource.busi.bo.QryVlanListRspBO;
import com.apstar.resource.dao.VlanDao;
import com.apstar.resource.po.VlanPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="qryVlanListService")
public class QryVlanListServiceImpl
implements QryVlanListService {
    private static final Logger logger = LoggerFactory.getLogger(QryVlanListServiceImpl.class);
    private static final Boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    VlanDao VlanDao;

    public RspPageBO<QryVlanListRspBO> qryVlanList(QryVlanListReqBO qryVlanListReqBO) {
        if (isDebugEnabled.booleanValue()) {
            logger.debug("\u67e5\u8be2vlan\u5217\u8868\u670d\u52a1\u5165\u53c2{}" + qryVlanListReqBO.toString());
        }
        RspPageBO rspPageBO = new RspPageBO();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("vlanCode", qryVlanListReqBO.getVlanCode());
            Page page = new Page(qryVlanListReqBO.getPageNo(), qryVlanListReqBO.getPageSize());
            List<VlanPO> list = this.VlanDao.selectByVlanCode(params, (Page<QryVlanListRspBO>)page);
            ArrayList<QryVlanListRspBO> rows = new ArrayList<QryVlanListRspBO>();
            for (VlanPO vlanPO : list) {
                QryVlanListRspBO qryVlanListRspBO = new QryVlanListRspBO();
                qryVlanListRspBO.setVlanId(vlanPO.getVlanId());
                qryVlanListRspBO.setVlanCode(vlanPO.getVlanCode());
                qryVlanListRspBO.setIpRange(vlanPO.getIpSegment());
                qryVlanListRspBO.setValnStatus(vlanPO.getValnStatus());
                rows.add(qryVlanListRspBO);
            }
            rspPageBO.setRows(rows);
            rspPageBO.setRecordsTotal(page.getTotalCount());
            rspPageBO.setTotal(page.getTotalPages());
            rspPageBO.setPageNo(page.getPageNo());
            return rspPageBO;
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2vlan\u5217\u8868\u670d\u52a1\u5931\u8d25", (Throwable)e);
            throw new BusinessException("10003", "\u67e5\u8be2vlan\u5217\u8868\u670d\u52a1\u5931\u8d25");
        }
    }
}

