/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.sms.task;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class LoadCountriesTask
extends AsyncTask<String, Void, Map<String, String>> {
    public static final String TAG = LoadCountriesTask.class.getName();
    public static final String COUNTRIES_JSON_FILE = "countries.json";
    private final Context context;

    public LoadCountriesTask(Context context) {
        this.context = context;
    }

    protected Map<String, String> doInBackground(String ... params) {
        Map<String, String> codes;
        try {
            TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
            codes = (Map)new ObjectMapper().readValue(this.context.getAssets().open(params[0]), (TypeReference)typeRef);
            Log.d((String)TAG, (String)("Loaded " + codes.size() + " countries"));
        }
        catch (IOException e) {
            codes = new HashMap<String, String>();
            Log.e((String)TAG, (String)"Failed to load countries JSON file", (Throwable)e);
        }
        return codes;
    }

    public Context getContext() {
        return this.context;
    }
}

