/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.sms.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.auth0.lock.sms.R;
import com.auth0.lock.validation.ValidationEnabled;

public class PhoneField
extends LinearLayout
implements ValidationEnabled {
    private int iconResource;
    private int errorIconResource;
    private int errorColorResource;
    private ColorStateList colorResource;
    private ColorStateList hintColorResource;
    private int codeColorResource;
    private ImageView iconView;
    private Button codeButton;
    private EditText phoneEditText;

    public PhoneField(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 16842884);
    }

    public PhoneField(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.setOrientation(0);
        this.setGravity(16);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.view_phone_fied, (ViewGroup)this, true);
        this.iconView = (ImageView)this.getChildAt(0);
        this.codeButton = (Button)this.getChildAt(1);
        this.phoneEditText = (EditText)this.getChildAt(2);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PhoneField, defStyleAttr, 0);
        try {
            this.iconResource = a.getResourceId(R.styleable.PhoneField_normalPhoneIconDrawable, -1);
            this.errorIconResource = a.getResourceId(R.styleable.PhoneField_errorPhoneIconDrawable, -1);
            this.errorColorResource = a.getResourceId(R.styleable.PhoneField_errorPhoneColor, R.color.credential_field_error);
            this.colorResource = this.phoneEditText.getTextColors();
            this.hintColorResource = this.phoneEditText.getHintTextColors();
            this.codeColorResource = this.codeButton.getTextColors().getDefaultColor();
            this.iconView.setImageResource(this.iconResource);
        }
        finally {
            a.recycle();
        }
    }

    public void markAsInvalid(boolean invalid) {
        if (invalid) {
            this.phoneEditText.setTextColor(this.getResources().getColor(this.errorColorResource));
            this.phoneEditText.setHintTextColor(this.getResources().getColor(this.errorColorResource));
            this.iconView.setImageResource(this.errorIconResource);
            this.codeButton.setTextColor(this.getResources().getColor(this.errorColorResource));
        } else {
            Editable text = this.phoneEditText.getText();
            this.phoneEditText.setText(null);
            this.phoneEditText.setTextColor(this.colorResource);
            this.phoneEditText.setHintTextColor(this.hintColorResource);
            this.phoneEditText.setText((CharSequence)text);
            this.phoneEditText.setSelection(text.length());
            this.iconView.setImageResource(this.iconResource);
            this.codeButton.setTextColor(this.codeColorResource);
        }
    }

    public Editable getText() {
        return this.phoneEditText.getText();
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.codeButton.setOnClickListener(listener);
    }

    public String getCompletePhoneNumber() {
        String number = this.codeButton.getText().toString() + this.phoneEditText.getText().toString();
        return number.replace(" ", "");
    }

    public String getPhoneNumber() {
        return this.phoneEditText.getText().toString();
    }

    public String getDialCode() {
        return this.codeButton.getText().toString();
    }

    public void setDialCode(String dialCode) {
        this.codeButton.setText((CharSequence)dialCode);
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneEditText.setText((CharSequence)phoneNumber);
    }
}

