/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.sms;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.View;
import com.auth0.core.Token;
import com.auth0.core.UserProfile;
import com.auth0.lock.Lock;
import com.auth0.lock.LockProvider;
import com.auth0.lock.error.ErrorDialogBuilder;
import com.auth0.lock.event.AlertDialogEvent;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.event.AuthenticationEvent;
import com.auth0.lock.event.NavigationEvent;
import com.auth0.lock.sms.CountryCodeActivity;
import com.auth0.lock.sms.R;
import com.auth0.lock.sms.event.CountryCodeSelectedEvent;
import com.auth0.lock.sms.event.SelectCountryCodeEvent;
import com.auth0.lock.sms.event.SmsPasscodeSentEvent;
import com.auth0.lock.sms.fragment.RequestCodeFragment;
import com.auth0.lock.sms.fragment.SmsLoginFragment;
import com.squareup.otto.Subscribe;

public class LockSMSActivity
extends FragmentActivity {
    public static final String REQUEST_SMS_CODE_JWT = "REQUEST_SMS_CODE_JWT";
    private static final String TAG = LockSMSActivity.class.getName();
    private static final int REQUEST_CODE = 0;
    Lock lock;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_lock_sms);
        this.lock = this.getLock();
        if (savedInstanceState == null) {
            RequestCodeFragment fragment = new RequestCodeFragment();
            Bundle arguments = new Bundle();
            arguments.putString("REQUEST_CODE_JWT_ARGUMENT", this.getIntent().getStringExtra(REQUEST_SMS_CODE_JWT));
            fragment.setArguments(arguments);
            this.getSupportFragmentManager().beginTransaction().add(R.id.container, (Fragment)fragment).commit();
        }
        if (this.lock.isFullScreen()) {
            this.fullscreenMode();
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (this.lock.isFullScreen()) {
            this.fullscreenMode();
        }
    }

    protected void onStart() {
        super.onStart();
        this.lock.getBus().register((Object)this);
    }

    protected void onStop() {
        super.onStop();
        this.lock.getBus().unregister((Object)this);
    }

    @Subscribe
    public void onSelectCountryCodeEvent(SelectCountryCodeEvent event) {
        Intent intent = new Intent((Context)this, CountryCodeActivity.class);
        this.startActivityForResult(intent, 0);
    }

    @Subscribe
    public void onPasscodeSentEvent(SmsPasscodeSentEvent event) {
        SmsLoginFragment fragment = new SmsLoginFragment();
        Bundle arguments = new Bundle();
        arguments.putString("PHONE_NUMBER_ARGUMENT", event.getPhoneNumber());
        fragment.setArguments(arguments);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.container, (Fragment)fragment).addToBackStack(SmsLoginFragment.class.getName()).commit();
    }

    @Subscribe
    public void onNavigationEvent(NavigationEvent event) {
        switch (event) {
            case BACK: {
                this.getSupportFragmentManager().popBackStack();
                break;
            }
            default: {
                Log.v((String)TAG, (String)("Invalid navigation event " + event));
            }
        }
    }

    @Subscribe
    public void onAuthenticationError(AuthenticationError error) {
        Log.e((String)TAG, (String)"Failed to authenticate user", (Throwable)error.getThrowable());
        ErrorDialogBuilder.showAlertDialog((Context)this, (AlertDialogEvent)error);
    }

    @Subscribe
    public void onAuthentication(AuthenticationEvent event) {
        UserProfile profile = event.getProfile();
        Token token = event.getToken();
        Log.i((String)TAG, (String)("Authenticated user " + profile.getName()));
        Intent result = new Intent("Lock.Authentication").putExtra("profile", (Parcelable)profile).putExtra("token", (Parcelable)token);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(result);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 0 && resultCode == -1) {
            String country = data.getStringExtra("COUNTRY_CODE");
            String dialCode = data.getStringExtra("COUNTRY_DIAL_CODE");
            Log.d((String)TAG, (String)("Picked country " + country));
            this.lock.getBus().post((Object)new CountryCodeSelectedEvent(country, dialCode));
        }
    }

    private Lock getLock() {
        if (this.lock != null) {
            return this.lock;
        }
        LockProvider provider = (LockProvider)this.getApplication();
        return provider.getLock();
    }

    private void fullscreenMode() {
        if (Build.VERSION.SDK_INT >= 16) {
            View decorView = this.getWindow().getDecorView();
            int uiOptions = 1028;
            decorView.setSystemUiVisibility(uiOptions);
        } else {
            this.getWindow().setFlags(1024, 1024);
        }
    }
}

