/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.lock.sms.fragment;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.auth0.api.callback.AuthenticationCallback;
import com.auth0.core.Token;
import com.auth0.core.UserProfile;
import com.auth0.lock.error.LoginAuthenticationErrorBuilder;
import com.auth0.lock.event.AuthenticationError;
import com.auth0.lock.event.AuthenticationEvent;
import com.auth0.lock.event.NavigationEvent;
import com.auth0.lock.fragment.BaseTitledFragment;
import com.auth0.lock.sms.R;
import com.auth0.lock.sms.validation.SmsPasscodeValidator;
import com.auth0.lock.validation.Validator;
import com.auth0.lock.widget.CredentialField;

public class SmsLoginFragment
extends BaseTitledFragment {
    public static final String PHONE_NUMBER_ARGUMENT = "PHONE_NUMBER_ARGUMENT";
    private String phoneNumber;
    private LoginAuthenticationErrorBuilder errorBuilder;
    private Validator validator;
    Button accessButton;
    ProgressBar progressBar;
    CredentialField passcodeField;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            this.phoneNumber = arguments.getString(PHONE_NUMBER_ARGUMENT);
        }
        this.errorBuilder = new LoginAuthenticationErrorBuilder(R.string.sms_login_error_title, R.string.sms_login_error_message, R.string.sms_login_invalid_credentials_message);
        this.validator = new SmsPasscodeValidator(R.id.sms_login_code_field, R.string.sms_login_error_title, R.string.sms_login_invalid_passcode_message);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_sms_login, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Button noCodeButton = (Button)view.findViewById(R.id.sms_no_code_button);
        noCodeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SmsLoginFragment.this.bus.post((Object)NavigationEvent.BACK);
            }
        });
        TextView messageTextView = (TextView)view.findViewById(R.id.sms_enter_code_message);
        String messageFormat = this.getString(R.string.sms_login_message);
        messageTextView.setText((CharSequence)Html.fromHtml((String)String.format(messageFormat, this.phoneNumber)));
        this.passcodeField = (CredentialField)view.findViewById(R.id.sms_login_code_field);
        this.accessButton = (Button)view.findViewById(R.id.sms_access_button);
        this.progressBar = (ProgressBar)view.findViewById(R.id.sms_login_progress_indicator);
        this.accessButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SmsLoginFragment.this.login();
            }
        });
    }

    private void login() {
        boolean valid;
        AuthenticationError error = this.validator.validateFrom((Fragment)this);
        boolean bl = valid = error == null;
        if (valid) {
            this.performLogin();
        } else {
            this.bus.post((Object)error);
        }
    }

    private void performLogin() {
        this.accessButton.setEnabled(false);
        this.accessButton.setText((CharSequence)"");
        this.progressBar.setVisibility(0);
        String passcode = this.passcodeField.getText().toString();
        this.client.smsLogin(this.phoneNumber, passcode, this.authenticationParameters, new AuthenticationCallback(){

            public void onSuccess(UserProfile userProfile, Token token) {
                SmsLoginFragment.this.bus.post((Object)new AuthenticationEvent(userProfile, token));
                SmsLoginFragment.this.accessButton.setEnabled(true);
                SmsLoginFragment.this.accessButton.setText(R.string.sms_login_access_btn_text);
                SmsLoginFragment.this.progressBar.setVisibility(8);
            }

            public void onFailure(Throwable throwable) {
                SmsLoginFragment.this.bus.post((Object)SmsLoginFragment.this.errorBuilder.buildFrom(throwable));
                SmsLoginFragment.this.accessButton.setEnabled(true);
                SmsLoginFragment.this.accessButton.setText(R.string.sms_login_access_btn_text);
                SmsLoginFragment.this.progressBar.setVisibility(8);
            }
        });
    }

    protected int getTitleResource() {
        return R.string.sms_title_enter_passcode;
    }
}

