/*
 * Decompiled with CFR 0.152.
 */
package com.avic.common;

import com.code.epoch.common.resources.FileUtilsEx;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.krysalis.barcode4j.BarcodeDimension;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.TextAlignment;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.datamatrix.DataMatrix;
import org.krysalis.barcode4j.impl.datamatrix.SymbolShapeHint;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.java2d.Java2DCanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class BarcodeUtils {
    public static String make128Jpg(String code, String show, String path, String fileName) throws Exception {
        int dpi = 300;
        File baseFile = new File(path);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        fileName = FileUtilsEx.toWindowsFileName((String)fileName);
        File outputFile = new File(String.valueOf(path) + "/" + fileName + ".jpg");
        FileOutputStream out = null;
        try {
            try {
                out = new FileOutputStream(outputFile);
                BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, "image/jpeg", 300, 12, false, 0);
                Code128Bean barcode = new Code128Bean();
                barcode.setBarHeight(8.0);
                barcode.setModuleWidth(0.5);
                barcode.setQuietZone(0.5);
                barcode.setFontName("Arial");
                barcode.setFontSize(2.5);
                barcode.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
                barcode.generateBarcode((CanvasProvider)canvas, code);
                BufferedImage img = canvas.getBufferedImage();
                Graphics2D g2d = img.createGraphics();
                double height = canvas.getDimensions().getHeight();
                double width = canvas.getDimensions().getWidth();
                g2d.fillRect(0, UnitConv.mm2px((double)8.0, (int)300), UnitConv.mm2px((double)width, (int)300), UnitConv.mm2px((double)(height - 8.0), (int)300));
                canvas.deviceText(show, 0.5, width, 11.0, "Arial", 2.5, TextAlignment.TA_LEFT);
                canvas.finish();
            }
            catch (Exception e) {
                System.out.println(outputFile.getPath());
                outputFile.delete();
                e.printStackTrace();
                throw new IOException("");
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return outputFile.getPath();
    }

    public static BufferedImage make128Img(String code, String show) {
        int dpi = 300;
        Code128Bean barcode = new Code128Bean();
        barcode.setBarHeight(8.0);
        barcode.setModuleWidth(0.5);
        barcode.setQuietZone(0.5);
        barcode.setFontName("Arial");
        barcode.setFontSize(2.5);
        barcode.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        BarcodeDimension dim = barcode.calcDimensions(code);
        double mmWidth = dim.getWidthPlusQuiet();
        double mmHeight = dim.getHeightPlusQuiet();
        int pxWidth = UnitConv.mm2px((double)mmWidth, (int)300);
        int pxHeight = UnitConv.mm2px((double)mmHeight, (int)300);
        BufferedImage bi = new BufferedImage(pxWidth, pxHeight, 1);
        Graphics2D g2d = bi.createGraphics();
        Java2DCanvasProvider canvas = new Java2DCanvasProvider(g2d, 0);
        g2d.setBackground(Color.WHITE);
        g2d.setColor(Color.BLACK);
        g2d.clearRect(0, 0, pxWidth, pxHeight);
        g2d.scale((double)pxWidth / mmWidth, (double)pxHeight / mmHeight);
        barcode.generateBarcode((CanvasProvider)canvas, code);
        int height = (int)canvas.getDimensions().getHeight() + 1;
        int width = (int)canvas.getDimensions().getWidth();
        g2d.clearRect(0, 8, width, height - 8);
        canvas.deviceText(show, 0.5, (double)width, 11.0, "Arial", 2.5, TextAlignment.TA_LEFT);
        return bi;
    }

    public static String makeMatrixJpg(String code, String path, String fileName, SymbolShapeHint shape) throws IOException {
        int dpi = 700;
        File baseFile = new File(path);
        if (!baseFile.exists()) {
            baseFile.mkdirs();
        }
        fileName = FileUtilsEx.toWindowsFileName((String)fileName);
        File outputFile = new File(String.valueOf(path) + "/" + fileName + ".jpg");
        OutputStream out = null;
        try {
            try {
                out = new FileOutputStream(outputFile);
                BitmapCanvasProvider canvas = new BitmapCanvasProvider(out, "image/jpeg", 700, 12, false, 0);
                DataMatrix dd = new DataMatrix();
                dd.getDataMatrixBean().setBarHeight(0.5);
                dd.getDataMatrixBean().setModuleWidth(0.5);
                dd.getDataMatrixBean().setQuietZone(0.5);
                dd.getDataMatrixBean().setShape(shape);
                dd.generateBarcode((CanvasProvider)canvas, code);
                canvas.finish();
            }
            catch (Exception e) {
                System.out.println(outputFile.getPath());
                outputFile.delete();
                e.printStackTrace();
                throw new IOException("");
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outputFile.getPath();
    }

    public static BufferedImage makeMatrixImg(String code, SymbolShapeHint shape) {
        int dpi = 700;
        DataMatrix dd = new DataMatrix();
        dd.getDataMatrixBean().setBarHeight(0.5);
        dd.getDataMatrixBean().setModuleWidth(0.5);
        dd.getDataMatrixBean().setQuietZone(0.5);
        dd.getDataMatrixBean().setShape(shape);
        BarcodeDimension dim = dd.calcDimensions(code);
        double mmWidth = dim.getWidthPlusQuiet();
        double mmHeight = dim.getHeightPlusQuiet();
        int pxWidth = UnitConv.mm2px((double)mmWidth, (int)700);
        int pxHeight = UnitConv.mm2px((double)mmHeight, (int)700);
        BufferedImage bi = new BufferedImage(pxWidth, pxHeight, 1);
        Graphics2D g2d = bi.createGraphics();
        Java2DCanvasProvider canvas = new Java2DCanvasProvider(g2d, 0);
        g2d.setBackground(Color.WHITE);
        g2d.setColor(Color.BLACK);
        g2d.clearRect(0, 0, pxWidth, pxHeight);
        g2d.scale((double)pxWidth / mmWidth, (double)pxHeight / mmHeight);
        dd.generateBarcode((CanvasProvider)canvas, code);
        return bi;
    }

    public static String makeMatrixSVG(String code, String path, String fileName, SymbolShapeHint shape) throws IOException {
        File outputFile;
        block6: {
            File baseFile = new File(path);
            if (!baseFile.exists()) {
                baseFile.mkdirs();
            }
            fileName = FileUtilsEx.toWindowsFileName((String)fileName);
            outputFile = new File(String.valueOf(path) + "/" + fileName + ".svg");
            FileOutputStream out = new FileOutputStream(outputFile);
            try {
                try {
                    SVGCanvasProvider svg = new SVGCanvasProvider(false, 0);
                    DataMatrix dd = new DataMatrix();
                    dd.getDataMatrixBean().setBarHeight(0.5);
                    dd.getDataMatrixBean().setModuleWidth(0.5);
                    dd.getDataMatrixBean().setQuietZone(0.5);
                    dd.getDataMatrixBean().setShape(shape);
                    dd.generateBarcode((CanvasProvider)svg, code);
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer trans = factory.newTransformer();
                    DOMSource src = new DOMSource(svg.getDOMFragment());
                    StreamResult res = new StreamResult(out);
                    trans.transform(src, res);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ((OutputStream)out).close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                ((OutputStream)out).close();
                throw throwable;
            }
            ((OutputStream)out).close();
        }
        return outputFile.getPath();
    }
}

