/*
 * Decompiled with CFR 0.152.
 */
package com.avic.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class CLabelMarker {
    private BufferedImage bi;
    private Graphics2D g2d;
    private int dpi = 200;
    private double mm2pxScale = (double)this.dpi / 26.6;

    public CLabelMarker(double canvasWidth, double canvasHeight) {
        this.bi = new BufferedImage(this.mm2px(canvasWidth), this.mm2px(canvasHeight), 1);
        this.g2d = this.bi.createGraphics();
        this.fillRect(0.0, 0.0, this.mm2px(canvasWidth), this.mm2px(canvasHeight));
        this.setColor(Color.BLACK);
    }

    public void drawString(String str, double x, double y) {
        this.g2d.drawString(str, this.mm2px(x), this.mm2px(y));
    }

    public void drawString(String str, double x1, double x2, double y, Align align) {
        if (str == null) {
            return;
        }
        FontMetrics fontM = this.g2d.getFontMetrics();
        switch (align) {
            case LEFT: {
                this.g2d.drawString(str, this.mm2px(x1), this.mm2px(y));
                break;
            }
            case RIGHT: {
                this.g2d.drawString(str, this.mm2px(x2) - fontM.stringWidth(str), this.mm2px(y));
                break;
            }
            case CENTER: {
                this.g2d.drawString(str, (this.mm2px(x1 + x2) - fontM.stringWidth(str)) / 2, this.mm2px(y));
                break;
            }
            case JUSTIFIED: {
                int totalCharWidth = 0;
                char[] cArray = str.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char s = cArray[n2];
                    totalCharWidth += fontM.charWidth(s);
                    ++n2;
                }
                double space = 0.0;
                if (str.length() != 1) {
                    space = (this.mm2px(x2 - x1) - totalCharWidth) / (str.length() - 1);
                }
                int xPx = this.mm2px(x1);
                int yPx = this.mm2px(y);
                char[] cArray2 = str.toCharArray();
                int n3 = cArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    char s = cArray2[n4];
                    this.g2d.drawString("" + s, xPx, yPx);
                    xPx = (int)((double)xPx + ((double)fontM.charWidth(s) + space));
                    ++n4;
                }
                break;
            }
        }
    }

    public void drawString(String str, double x, double y, double space) {
        int xPx = this.mm2px(x);
        int yPx = this.mm2px(y);
        int spacePx = this.mm2px(space);
        FontMetrics fontM = this.g2d.getFontMetrics();
        if (str != "" && str != null) {
            char[] cArray = str.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char s = cArray[n2];
                this.g2d.drawString("" + s, xPx, yPx);
                xPx += fontM.charWidth(s) + spacePx;
                ++n2;
            }
        }
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.g2d.drawLine(this.mm2px(x1), this.mm2px(y1), this.mm2px(x2), this.mm2px(y2));
    }

    public void drawLine(double x1, double y1, double x2, double y2, double width) {
        Stroke oldStroke = this.g2d.getStroke();
        BasicStroke newStroke = new BasicStroke(this.mm2px(width));
        this.g2d.setStroke(newStroke);
        this.g2d.drawLine(this.mm2px(x1), this.mm2px(y1), this.mm2px(x2), this.mm2px(y2));
        this.g2d.setStroke(oldStroke);
    }

    public void drawLine(double x1, double y1, double x2, double y2, String dashs) {
        Stroke oldStroke = this.g2d.getStroke();
        float[] dash = new float[]{1.0f, 0.6f};
        int i = 0;
        while (i < dash.length) {
            dash[i] = this.mm2px(dash[i]);
            ++i;
        }
        BasicStroke newStroke = new BasicStroke(1.0f, 2, 0, 10.0f, dash, 0.0f);
        this.g2d.setStroke(newStroke);
        this.g2d.drawLine(this.mm2px(x1), this.mm2px(y1), this.mm2px(x2), this.mm2px(y2));
        this.g2d.setStroke(oldStroke);
    }

    public void drawImage(Image img, double x, double y) throws IOException {
        this.g2d.drawImage(img, this.mm2px(x), this.mm2px(y), null);
    }

    public void drawImage(Image img, double x, double y, double width, double height) throws IOException {
        this.g2d.drawImage(img, this.mm2px(x), this.mm2px(y), this.mm2px(width), this.mm2px(height), null);
    }

    public void drawImageKeepRatio(Image img, double x, double y, double width, double height) throws IOException {
        double imgHeight;
        double imgWidth = img.getWidth(null);
        double ratio = imgWidth / (imgHeight = (double)img.getHeight(null));
        if (ratio > width / height) {
            height = width / ratio;
        } else {
            width = height * ratio;
        }
        this.g2d.drawImage(img, this.mm2px(x), this.mm2px(y), this.mm2px(width), this.mm2px(height), null);
    }

    public void fillRect(double x, double y, double width, double height) {
        this.g2d.fillRect(this.mm2px(x), this.mm2px(y), this.mm2px(width), this.mm2px(height));
    }

    public void setBackground(Color color) {
        this.g2d.setBackground(color);
    }

    public void setColor(Color color) {
        this.g2d.setColor(color);
    }

    public void setStroke(Stroke s) {
        this.g2d.setStroke(s);
    }

    public void setFont(String name, int style, int size) {
        this.g2d.setFont(new Font(name, style, size));
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
        this.mm2pxScale = (double)dpi / 25.4;
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    private int mm2px(double mm) {
        return (int)Math.round(this.mm2pxScale * mm);
    }

    public double px2mm(int px) {
        return (double)px / this.mm2pxScale;
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT,
        JUSTIFIED;

    }
}

