/*
 * Decompiled with CFR 0.152.
 */
package com.avic.common;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptUtils {
    public static byte[] encrypt(byte[] src, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(1, (Key)securekey, sr);
        return cipher.doFinal(src);
    }

    public static byte[] decrypt(byte[] src, byte[] key) throws Exception {
        SecureRandom sr = new SecureRandom();
        DESKeySpec dks = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(dks);
        Cipher cipher = Cipher.getInstance("DES");
        cipher.init(2, (Key)securekey, sr);
        return cipher.doFinal(src);
    }

    public static byte[] encryptAES(byte[] byteContent, byte[] password) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, new SecureRandom(password));
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, key);
        byte[] result = cipher.doFinal(byteContent);
        return result;
    }

    public static byte[] decryptAES(byte[] content, byte[] password) throws Exception {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, new SecureRandom(password));
        SecretKey secretKey = kgen.generateKey();
        byte[] enCodeFormat = secretKey.getEncoded();
        SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, key);
        byte[] result = cipher.doFinal(content);
        return result;
    }

    public static void enFile(InputStream in, String reFile, String password) throws Exception {
        byte[] t = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(reFile);
            byte[] buff = new byte[1024];
            while (in.read(buff) != -1) {
                t = CryptUtils.encrypt(buff, password.getBytes());
                out.write(t);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void enFile(String srcFile, String reFile, String password) throws Exception {
        byte[] t = null;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(srcFile);
            out = new FileOutputStream(reFile);
            byte[] buff = new byte[1024];
            while (in.read(buff) != -1) {
                t = CryptUtils.encrypt(buff, password.getBytes());
                out.write(t);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static byte[] deFile(String srcFile, String password) throws Exception {
        ByteArrayOutputStream byteWriter = new ByteArrayOutputStream();
        FileInputStream fin = null;
        try {
            byte[] debuff = new byte[1032];
            fin = new FileInputStream(srcFile);
            while (fin.read(debuff) != -1) {
                byteWriter.write(CryptUtils.decrypt(debuff, password.getBytes()));
            }
            byte[] byArray = byteWriter.toByteArray();
            return byArray;
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            if (byteWriter != null) {
                byteWriter.close();
            }
        }
    }

    public static void deFile(String srcFile, String reFile, String password) throws Exception {
        byte[] t = null;
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            byte[] debuff = new byte[1032];
            fin = new FileInputStream(srcFile);
            fout = new FileOutputStream(reFile);
            while (fin.read(debuff) != -1) {
                t = CryptUtils.decrypt(debuff, password.getBytes());
                fout.write(t);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }

    public static String decryptString(String enStr, String key) throws Exception {
        String[] s = null;
        s = enStr.split("@");
        byte[] temp = new byte[s.length];
        int k = 0;
        while (k < s.length) {
            temp[k] = (byte)Integer.parseInt(s[k].trim());
            ++k;
        }
        byte[] t = null;
        t = CryptUtils.decrypt(temp, key.getBytes());
        StringBuilder deStr = new StringBuilder();
        int k2 = 0;
        while (k2 < t.length) {
            deStr.append((char)t[k2]);
            ++k2;
        }
        return deStr.toString();
    }

    public static String encryptString(String str, String key) {
        byte[] t = null;
        try {
            t = CryptUtils.encrypt(str.getBytes(), key.getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String enString = "";
        int k = 0;
        while (k < t.length) {
            enString = String.valueOf(enString) + t[k] + "@";
            ++k;
        }
        return enString;
    }

    public static void main(String[] args) {
        String ink = CryptUtils.encryptString("70-F3-95-0B-06-F4", "ink@@301");
        System.out.println("\u55b7\u58a8\u6388\u6743\u7801\uff1a" + ink);
        String laser = CryptUtils.encryptString("70-F3-95-0B-06-F4", "laser301");
        System.out.println("\u6fc0\u5149\u6388\u6743\u7801\uff1a" + laser);
    }
}

