/*
 * Decompiled with CFR 0.152.
 */
package com.zhuozhengsoft.base64;

import com.zhuozhengsoft.base64.CharSequenceUtils;
import com.zhuozhengsoft.base64.Charsets;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringUtils {
    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence instanceof String && charSequence2 instanceof String) {
            return charSequence.equals(charSequence2);
        }
        return CharSequenceUtils.a(charSequence, false, 0, charSequence2, 0, Math.max(charSequence.length(), charSequence2.length()));
    }

    private static byte[] a(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return string.getBytes(charset);
    }

    public static byte[] getBytesIso8859_1(String string) {
        return StringUtils.a(string, Charsets.ISO_8859_1);
    }

    public static byte[] getBytesUnchecked(String string, String string2) {
        if (string == null) {
            return null;
        }
        try {
            return string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.a(string2, unsupportedEncodingException);
        }
    }

    public static byte[] getBytesUsAscii(String string) {
        return StringUtils.a(string, Charsets.US_ASCII);
    }

    public static byte[] getBytesUtf16(String string) {
        return StringUtils.a(string, Charsets.UTF_16);
    }

    public static byte[] getBytesUtf16Be(String string) {
        return StringUtils.a(string, Charsets.UTF_16BE);
    }

    public static byte[] getBytesUtf16Le(String string) {
        return StringUtils.a(string, Charsets.UTF_16LE);
    }

    public static byte[] getBytesUtf8(String string) {
        return StringUtils.a(string, Charsets.UTF_8);
    }

    private static IllegalStateException a(String string, UnsupportedEncodingException unsupportedEncodingException) {
        return new IllegalStateException(string + ": " + unsupportedEncodingException);
    }

    public static String newString(byte[] byArray, String string) {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StringUtils.a(string, unsupportedEncodingException);
        }
    }

    public static String newStringIso8859_1(byte[] byArray) {
        return new String(byArray, Charsets.ISO_8859_1);
    }

    public static String newStringUsAscii(byte[] byArray) {
        return new String(byArray, Charsets.US_ASCII);
    }

    public static String newStringUtf16(byte[] byArray) {
        return new String(byArray, Charsets.UTF_16);
    }

    public static String newStringUtf16Be(byte[] byArray) {
        return new String(byArray, Charsets.UTF_16BE);
    }

    public static String newStringUtf16Le(byte[] byArray) {
        return new String(byArray, Charsets.UTF_16LE);
    }

    public static String newStringUtf8(byte[] byArray) {
        Charset charset = Charsets.UTF_8;
        if (byArray == null) {
            return null;
        }
        return new String(byArray, charset);
    }
}

