/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.apps.resource.AppTeam;
import com.actionsoft.bpms.bo.design.model.BOModel;
import com.actionsoft.bpms.bpmn.engine.model.def.ProcessDefinition;
import com.actionsoft.bpms.cc.model.CCModel;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.mvc.model.PlatformXMetaModelHelper;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.commons.xmetadata.XCacheModel;
import com.actionsoft.bpms.dw.design.model.DWModel;
import com.actionsoft.bpms.form.design.model.FormModel;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.schedule.model.AWSScheduleModel;
import com.actionsoft.bpms.util.UtilString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AMCAPIManager {
    private static AMCAPIManager amcAPIManager;

    private AMCAPIManager() {
    }

    public static AMCAPIManager getInstance() {
        if (amcAPIManager == null) {
            amcAPIManager = new AMCAPIManager();
        }
        return amcAPIManager;
    }

    public static boolean isSuperMaster(String uid) {
        return GradeSecurityUtil.isSuperMaster(uid) || GradeSecurityUtil.isSystemMaster(uid);
    }

    public static boolean isXModelAccess(XCacheModel xModel, String uid) {
        if (AMCAPIManager.isSuperMaster(uid)) {
            return true;
        }
        if (!AMCAPIManager.isModelAppAccess(xModel.getAppId(), uid)) {
            return false;
        }
        return AMCAPIManager.isModelUserAccess(xModel, uid);
    }

    public static boolean isModelAppAccess(String appId, String uid) {
        return AMCAPIManager.isDevelopApp(appId, uid);
    }

    private static boolean isModelUserAccess(XCacheModel xModel, String uid) {
        String administrator = null;
        String createUser = null;
        if (xModel instanceof BOModel) {
            administrator = ((BOModel)xModel).getAdministrator();
            createUser = ((BOModel)xModel).getCreateUser();
        } else if (xModel instanceof FormModel) {
            administrator = ((FormModel)xModel).getAdministrator();
            createUser = ((FormModel)xModel).getCreateUser();
        } else if (xModel instanceof ProcessDefinition) {
            administrator = ((ProcessDefinition)xModel).getProcessAdministrator();
            createUser = ((ProcessDefinition)xModel).getCreateUser();
        } else {
            if (xModel instanceof AWSScheduleModel) {
                return true;
            }
            if (xModel instanceof CCModel) {
                return true;
            }
            if (xModel instanceof DWModel) {
                createUser = ((DWModel)xModel).getCreateUser();
            }
        }
        return createUser != null && createUser.equals(uid) || PlatformXMetaModelHelper.isAdministrator(administrator, uid);
    }

    public static boolean isManagementApp(String appId, String uid) {
        boolean flag = false;
        List<AppContext> appList = AMCAPIManager.getManagerApps(uid);
        for (AppContext appContext : appList) {
            if (!appContext.getId().equals(appId)) continue;
            return true;
        }
        return flag;
    }

    public static boolean isDevelopApp(String appId, String uid) {
        boolean flag = false;
        List<AppContext> appList = AMCAPIManager.getDevApps(uid);
        for (AppContext appContext : appList) {
            if (!appContext.getId().equals(appId)) continue;
            flag = true;
        }
        return flag;
    }

    public static final List<AppContext> getVisibleInstalledDevAndManagementApps(String uid) {
        ArrayList<AppContext> list = new ArrayList<AppContext>();
        List<AppContext> amcDevOfApps = AMCAPIManager.getAMCManagementOfApps(uid, "A");
        List<AppContext> amcManagementOfApps = AMCAPIManager.getAMCManagementOfApps(uid, "B");
        list.addAll(amcDevOfApps);
        list.removeAll(amcManagementOfApps);
        list.addAll(amcManagementOfApps);
        AppsAPIManager.getInstance().sortAppByName(list);
        return list;
    }

    public static final List<AppContext> getManagerApps(String uid) {
        return AMCAPIManager.getAMCManagementOfApps(uid, "B");
    }

    public static final List<AppContext> getDevApps(String uid) {
        return AMCAPIManager.getAMCManagementOfApps(uid, "A");
    }

    public static List<AppContext> getVisibleInstalledApps(String uid) {
        return AMCAPIManager.getVisibleInstalledApps(uid, true);
    }

    public static List<AppContext> getVisibleInstalledManagementApps(String uid) {
        return AMCAPIManager.getVisibleInstalledManagementApps(uid, true);
    }

    public static List<AppContext> getVisibleInstalledApps(String uid, boolean categoryVisible) {
        ArrayList<AppContext> vis = new ArrayList<AppContext>();
        List<AppContext> appList = AMCAPIManager.getDevApps(uid);
        if (appList != null) {
            for (AppContext appContext : appList) {
                if (appContext.getId().startsWith("_") || categoryVisible && !appContext.isCategoryVisible()) continue;
                vis.add(appContext);
            }
        }
        return vis;
    }

    public static List<AppContext> getVisibleInstalledManagementApps(String uid, boolean categoryVisible) {
        ArrayList<AppContext> vis = new ArrayList<AppContext>();
        List<AppContext> appList = AMCAPIManager.getManagerApps(uid);
        if (appList != null) {
            for (AppContext appContext : appList) {
                if (appContext.getId().startsWith("_") || categoryVisible && !appContext.isCategoryVisible()) continue;
                vis.add(appContext);
            }
        }
        return vis;
    }

    private static final List<AppContext> getAMCManagementOfApps(String uid, String type) {
        ArrayList<AppContext> apps = new ArrayList<AppContext>();
        HashMap<String, AppContext> tmpMapApps = new HashMap<String, AppContext>();
        ArrayList teams = new ArrayList(AppPlatformConfig.getTeams());
        boolean i = false;
        List installApps = AppsAPIManager.getInstance().getInstalledApps();
        ArrayList<String> installAppIds = new ArrayList<String>();
        for (AppContext app : installApps) {
            installAppIds.add(app.getId());
        }
        for (AppTeam devAppTeam : teams) {
            String teamApps;
            if (!AMCAPIManager.isAppTeamMember(devAppTeam, uid) || (teamApps = AMCUtil.getAppsByType(devAppTeam.getAppsPermissions(), type)).equals("")) continue;
            UtilString ut = new UtilString(teamApps);
            List<String> appls = ut.split(",");
            for (String appId : appls) {
                if (!installAppIds.contains(appId)) continue;
                AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
                tmpMapApps.put(appId, appContext);
            }
        }
        for (AppContext app : tmpMapApps.values()) {
            apps.add(app);
        }
        return apps;
    }

    private static boolean isInstall(String appId) {
        List installApps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : installApps) {
            if (!appId.equals(appContext.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnInstall(String appId) {
        List installApps = AppsAPIManager.getInstance().getUninstalledApps();
        for (AppContext appContext : installApps) {
            if (!appId.equals(appContext.getId())) continue;
            return true;
        }
        return false;
    }

    public static List<AppContext> getAppsDepend(String appId) {
        ArrayList<AppContext> apps = new ArrayList<AppContext>();
        List installApps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : installApps) {
            AppContextDepend depend = appContext.getDepend();
            if (depend == null || !appId.equals(depend.getAppId())) continue;
            apps.add(appContext);
        }
        return apps;
    }

    private static Map<String, String> getMembersOfTeam(AppTeam appTeam) {
        HashMap<String, String> mapMembers = new HashMap<String, String>();
        String members = AMCUtil.getMembers2Str(appTeam.getMembers());
        if (!members.equals("")) {
            UtilString ut = new UtilString(members);
            List<String> memberList = ut.split(",");
            for (String member : memberList) {
                mapMembers.put(member, member);
            }
        }
        return mapMembers;
    }

    public static Map<String, String> getMemebers() {
        HashMap<String, String> mapMembers = new HashMap<String, String>();
        List teams = AppPlatformConfig.getTeams();
        for (AppTeam devAppTeam : teams) {
            Map<String, String> teamMapMembers = AMCAPIManager.getMembersOfTeam(devAppTeam);
            for (String member : teamMapMembers.keySet()) {
                mapMembers.put(member, member);
            }
        }
        return mapMembers;
    }

    public static Map<String, String> getDevAppMembers(String appId) {
        HashMap<String, String> mapMembers = new HashMap<String, String>();
        List teams = AppPlatformConfig.getTeams();
        for (AppTeam devAppTeam : teams) {
            if (!devAppTeam.isValid()) continue;
            Map<String, String> m = AMCAPIManager.getPermissionsMerber(appId, devAppTeam, "A");
            mapMembers.putAll(m);
        }
        return mapMembers;
    }

    public static Map<String, String> getManagementAppMembers(String appId) {
        HashMap<String, String> mapMembers = new HashMap<String, String>();
        List teams = AppPlatformConfig.getTeams();
        for (AppTeam devAppTeam : teams) {
            if (!devAppTeam.isValid()) continue;
            Map<String, String> m = AMCAPIManager.getPermissionsMerber(appId, devAppTeam, "B");
            mapMembers.putAll(m);
        }
        return mapMembers;
    }

    private static Map<String, String> getPermissionsMerber(String appId, AppTeam appTeam, String type) {
        Map<String, String> mapMembers = new HashMap<String, String>();
        Map permissionsMap = appTeam.getAppsPermissions();
        for (String permissionAppId : permissionsMap.keySet()) {
            String permission;
            if (!permissionAppId.equals(appId) || (permission = (String)permissionsMap.get(permissionAppId)).indexOf(type) <= -1) continue;
            mapMembers = AMCAPIManager.getMembersOfTeam(appTeam);
        }
        return mapMembers;
    }

    public static boolean isAppTeamMember(AppTeam team, String uid) {
        if (team.getMembers().indexOf(uid) > -1) {
            return true;
        }
        List memberRoles = team.getRoles();
        for (String roleId : memberRoles) {
            if (!RoleCache.confirmRole((String)uid, (String)roleId)) continue;
            return true;
        }
        return false;
    }
}

