/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc;

import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationAuthWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationDevelopWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationInstallWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationManagementWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationRestoreWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationUninstallWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationUpgradeWeb;
import com.actionsoft.bpms.commons.amc.web.DashboardWeb;
import com.actionsoft.bpms.commons.amc.web.MessageCenterWeb;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.bind.annotation.Controller;
import com.actionsoft.bpms.server.bind.annotation.Mapping;

@Controller
public class AMCController {
    @Mapping(value="CONSOLE_ADMIN_AMC_HOME_PAGE")
    public String openACAction(UserContext me) {
        AMCWeb web = new AMCWeb(me);
        String htmlStr = web.getHomePage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_DASHBOARD_PAGE")
    public String getDashboardPage(UserContext me, String param) {
        DashboardWeb web = new DashboardWeb(me);
        String htmlStr = web.getDashboardPage(param);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_DASHBOARD_MESSAGECENTERMORE")
    public String getDashboardMessageCenterMore(UserContext me, int page) {
        DashboardWeb web = new DashboardWeb(me);
        String htmlStr = web.getMessageCenterHtml(page);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_DASHBOARD_MESSAGECENTER_READ")
    public String getDashboardMessageCenterMore(UserContext me, String logId, boolean isRead) {
        DashboardWeb web = new DashboardWeb(me);
        String htmlStr = web.modifyLogToRead(logId, isRead);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_DASHBOARD_APPNAMES")
    public String getInstallAppNames(UserContext me, String term) {
        DashboardWeb web = new DashboardWeb(me);
        String key = term;
        String jsonStr = web.getInstallAppNames(key);
        return jsonStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT")
    public String getApplicationManagementPage(UserContext me, String param) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        if (param.equals("undefined")) {
            param = "";
        }
        String htmlStr = web.getApplicationManagementPage(param);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_GRIDEDATA")
    public String getApplicationManagementGrid(UserContext me) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getApplicationManagementGridData();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_GRIDESORTORFILTER")
    public String getApplicationManagementGridSort(UserContext me, String opetype, String str) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getAppSortOrFilter(opetype, str);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_OPERATE")
    public String getApplicationManagementOperate(UserContext me, String appId, String opeType) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getAppOperateResult(appId, opeType);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_SET_SUSPEND")
    public String setAppSuspendVal(UserContext me, String appId, boolean suspend) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.setAppSuspendVal(appId, suspend);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_ADDPARAMPAGE")
    public String getApplicationAddParamPage(UserContext me, String appId, String paramName, String paramGroup) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.addParamPage(appId, paramName, paramGroup);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_ADDPARAM")
    public String getApplicationAddParam(UserContext me, String appId, String jsonStr) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.addParam(appId, jsonStr);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_ONERECODE")
    public String getApplicationManagementOnerecode(UserContext me, String appId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getAppManagerOneRecod(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_RESTORE_LIST")
    public String getRestoreList(UserContext me, String appId) {
        ApplicationRestoreWeb web = new ApplicationRestoreWeb(me);
        String json = web.getRestoreList(appId);
        return json;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_RESTORE")
    public String restoreApp(UserContext me, String appId, String version, String warehouse, boolean isNewerVersion, String filename) {
        ApplicationRestoreWeb web = new ApplicationRestoreWeb(me);
        String json = web.restoreApp(appId, version, warehouse, isNewerVersion, filename);
        return json;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_RESTORE_PROCESS_INFO")
    public String restoreRateInfo(UserContext me, String appId, String version, String warehouse) {
        ApplicationRestoreWeb web = new ApplicationRestoreWeb(me);
        String json = web.restoreProcessInfo(appId);
        return json;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_TAB_PAGE")
    public String getApplicationManagementTabPage(UserContext me, String appId, String tabId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getApplicationManagementTabPage(appId, tabId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_UNSAFECMD")
    public String getApplicationManagementUnSafeCmdJsonData(UserContext me, String appId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getUnSafeCmdList(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_JSON_DATA")
    public String getApplicationManagementDeployJsonData(UserContext me, String appId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getDeoloyListHtml(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_PARAMS_JSON_DATA")
    public String getApplicationManagementParamsJsonData(UserContext me, String appId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getParamesJSON(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_PARAMS_JSON_DATA_PART")
    public String getApplicationManagementParamsPartJsonData(UserContext me, String appId, String pName, String pId, String nodeName) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getPartParamesJSON(appId, pName, pId, nodeName);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_PARAMS_MODIFY")
    public String getApplicationManagementParamsModify(UserContext me, String appId, String selectParam, String paramValue, String group, String desc) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.modifyParam(appId, selectParam, paramValue, group, desc);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_PARAMS_DEL")
    public String getApplicationManagementParamsDel(UserContext me, String appId, String selectParam, String group) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.removeParam(appId, group, selectParam);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_MESSAGEMORE")
    public String getApplicationManagementMessageMore(UserContext me, String appId, int page, String mesLevel) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getAppManagerMessageByPage(appId, page, true, mesLevel);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_READMESSAGE")
    public String getApplicationManagementReadMessage(UserContext me, String appId, boolean isRead, int page) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.modifyLogToRead(appId, isRead, page);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_INSTALL")
    public String getApplicationInstallPage(UserContext me) {
        ApplicationInstallWeb web = new ApplicationInstallWeb(me);
        String htmlStr = web.getApplicationInstallPage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_INSTALL_GRID_DATA")
    public String getApplicationInstallGridData(UserContext me, String type) {
        String htmlStr = AMCUtil.getAppHtmlByType(type, me);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_INSTALL_GIVEUP")
    public String getApplicationInstallGiveUp(UserContext me, String appId) {
        ApplicationInstallWeb web = new ApplicationInstallWeb(me);
        String htmlStr = web.appGiveUp(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_INSTALL_COMPLETIONRATE_INFO")
    public String getApplicationInstallCompletionrateInfo(UserContext me, String appId, String log) {
        ApplicationInstallWeb web = new ApplicationInstallWeb(me);
        String htmlStr = web.getCompletionrateInfo(appId, log);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_INSTALL_APP")
    public String getApplicationInstallDO(UserContext me, String appId) {
        ApplicationInstallWeb web = new ApplicationInstallWeb(me);
        String htmlStr = web.installApp(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_UPGRADE")
    public String getApplicationUpgradePage(UserContext me) {
        ApplicationUpgradeWeb web = new ApplicationUpgradeWeb(me);
        String htmlStr = web.getApplicationUpgradePage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_UPGRADE_DATA")
    public String getApplicationUpgradeData(UserContext me, String type) {
        String htmlStr = AMCUtil.getAppHtmlByType(type, me);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_UPGRADE_COMPLETIONRATE_INFO")
    public String getApplicationUpgradeCompletionrateInfo(UserContext me, String appId) {
        ApplicationUpgradeWeb web = new ApplicationUpgradeWeb(me);
        String htmlStr = web.getCompletionrateInfo(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_UPGRADE_APP")
    public String getApplicationUpgradeDO(UserContext me, String appId) {
        ApplicationUpgradeWeb web = new ApplicationUpgradeWeb(me);
        String htmlStr = web.upgradeApp(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_UNINSTALL")
    public String getApplicationUninstallPage(UserContext me) {
        ApplicationUninstallWeb web = new ApplicationUninstallWeb(me);
        String htmlStr = web.getApplicationUninstallPage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_UNINSTALL_DATA")
    public String getApplicationUninstallData(UserContext me, String type) {
        String htmlStr = AMCUtil.getAppHtmlByType(type, me);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_RECOVERYAPP")
    public String getApplicationUninstallRecoveryApp(UserContext me, String appId) {
        ApplicationUninstallWeb web = new ApplicationUninstallWeb(me);
        String jsonStr = web.recoveryApp(appId);
        return jsonStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_REMOVEAPP")
    public String getApplicationUninstallRemoveApp(UserContext me, String appId) {
        ApplicationUninstallWeb web = new ApplicationUninstallWeb(me);
        String jsonStr = web.remvoeApp(appId);
        return jsonStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_GETINFO")
    public String getApplicationUninstallRemoveAppInfo(UserContext me, String appId) {
        String jsonStr = ApplicationUninstallWeb.getDelAppInfo(appId);
        return jsonStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP")
    public String getApplicationDevelopPage(UserContext me, String param) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopPage(param);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_Tree_JSON")
    public String getApplicationDevelopTreeJSON(UserContext me, String appId, String type, String pid) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getTreeJson(appId, type, pid);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_GRID_DATA")
    public String getApplicationDevelopGridData(UserContext me) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getDevTeamGrid();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_AUTH")
    public String getApplicationAuthPage(UserContext me) {
        ApplicationAuthWeb web = new ApplicationAuthWeb(me);
        String htmlStr = web.getApplicationAuthPage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_ADD_TEAM_PAGE")
    public String getApplicationDevelopAddTeamPage(UserContext me) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopAddTeamPage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_ADD_TEAM")
    public String getApplicationDevelopAddTeam(UserContext me, String jsonStr, String member) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopAddTeam(jsonStr, member);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_MANAGE_TEAM_PAGE")
    public String getApplicationDevelopManageTeamPage(UserContext me, String teamId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopManageTeamPage(teamId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_MODITY_TEAM")
    public String getApplicationDevelopManageTeamModify(UserContext me, String teamId, String jsonStr, String member, String memberRole) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopManageModifyTeam(teamId, jsonStr, member, memberRole);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_REMOVE_TEAM")
    public String getApplicationDevelopManageTeamRemove(UserContext me, String teamId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopManageRemoveTeam(teamId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_MANAGE_TEAM_MEMBERSLIST")
    public String getApplicationManagementDeploy(UserContext me, String term) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String key = term;
        String htmlStr = web.getUserList(key);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_APP_PAGE")
    public String getApplicationDevelopConfigAppPage(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopConfigAppPage(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_APP_PAGE_PARENTAPP_DATA")
    public String getParentAppData(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getParentAppData(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_NEWAPP_SAVE")
    public String getApplicationDevelopConfigNewappSave(UserContext me, String appPropertyJson, int osFolderType, String icon96name, String icon64name, String icon16name, String appMaster, String manageUser, String manageRole) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopConfigNewAppSave(appPropertyJson, osFolderType, icon96name, icon64name, icon16name, appMaster, manageUser, manageRole);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_FIND_APP")
    public String getApplicationDevelopConfigFindApp(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getAppById(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_SAVE_APP")
    public String getApplicationDevelopConfigSaveApp(UserContext me, String appId, String strJson) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.saveApplicationDevelopConfig(appId, strJson);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_GETDEPLOYTREE")
    public String getApplicationDevelopConfigGetdeployTree(UserContext me, String parentType, String tid, String formType) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getDeloyTreeByParentType(parentType, tid, formType);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_TREEHTML")
    public String getApplicationDevelopConfigTreeHtml(UserContext me, String formType) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getTreePage(formType);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_GETDEPLOYDATA")
    public String getApplicationDevelopConfigGetDeloyData(UserContext me, String appId, String deployId, String pid, String isNew) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getDeloyHtml(appId, deployId, pid, isNew);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_DEL")
    public String getApplicationDevelopConfigDel(UserContext me, String appId, String id, String tagName) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.delDeploy(appId, id, tagName);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_MAKEAPP")
    public String getApplicationDevelopConfigMakeApp(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.applicationDevelopMakeApp(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_MAKEAPPPERCENT")
    public String getApplicationDevelopConfigMakeAppPercent(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.applicationDevelopMakeAppPercent(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_MESSAGE_CENTER_PAGE")
    public String getApplicationMessageCneterPage(UserContext me) {
        MessageCenterWeb web = new MessageCenterWeb(me);
        String htmlStr = web.getMessageCenterPage();
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_MESSAGE_CENTER_GRIDDATA")
    public String getApplicationMessageCneterGridData(UserContext me, String searchKey, int page) {
        MessageCenterWeb web = new MessageCenterWeb(me);
        String htmlStr = web.getMessageCenterGrid(searchKey, page, "");
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_MESSAGE_CENTER_GRIDBYLEVEL")
    public String getApplicationMessageCneterGridLevel(UserContext me, String level, int page) {
        MessageCenterWeb web = new MessageCenterWeb(me);
        String htmlStr = web.getNotificationByLevel(level, page);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_MESSAGE_CENTER_MESSAGEMORE")
    public String getApplicationMessageCenterMore(UserContext me, String searchKey, int page, String mesLevel) {
        MessageCenterWeb web = new MessageCenterWeb(me);
        String htmlStr = web.getMessageCenterGrid(searchKey, page, mesLevel);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_DEV_APPNAMES")
    public String getInstallDevAppNames(UserContext me, String term) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String key = term;
        String jsonStr = web.getInstallAppNames(1);
        return jsonStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_DEPLOY_GRIDEDATA")
    public String getApplicationManagementDeployGrid(UserContext me, String appId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.getApplicationManagementDeployGridData(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_DEPLOY_DEL")
    public String getApplicationManagementDeployDel(UserContext me, String navId, String type) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.delNavDeploy(navId, type);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_DEPLOY")
    public String getApplicationManagementDeploy(UserContext me, String appId, String id, String deployType, String pid, String functionType) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.deployNav(appId, id, deployType, pid, functionType);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_MANAGEMENT_DEPLOY_ALL_MENU")
    public String getApplicationManagementDeployAll(UserContext me, String deployDatas, String appId) {
        ApplicationManagementWeb web = new ApplicationManagementWeb(me);
        String htmlStr = web.deployAllNav(deployDatas, appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_BYODAPP_PAGE")
    public String getApplicationDevelopConfigByodAppPage(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getApplicationDevelopConfigByodAppPage(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_BYODAPP_ADD_SECURITY_PAGE")
    public String getSecurityPage(UserContext me, String appId) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        String htmlStr = web.getSecurityPage(appId);
        return htmlStr;
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_CONFIG_BYODAPP_SECURITYGROUP_ADD")
    public String getSecurityGroupAdd(UserContext me, String id, String permissionType) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        return web.getSecurityGroupAdd(id, permissionType);
    }

    @Mapping(value="CONSOLE_ADMIN_AMC_APPLICATION_DEVELOP_DELETE_DEVELOPERCER")
    public String deleteDeveloperCer(UserContext me) {
        ApplicationDevelopWeb web = new ApplicationDevelopWeb(me);
        return web.deleteDeveloperCer();
    }
}

