/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.util;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.AppInstaller;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.apps.resource.AppContextRequire;
import com.actionsoft.apps.resource.AppContextRequireImpl;
import com.actionsoft.apps.resource.AppContextWrapper;
import com.actionsoft.apps.resource.AppDependencyHelper;
import com.actionsoft.apps.resource.AppNaming;
import com.actionsoft.apps.resource.AppTeam;
import com.actionsoft.apps.resource.AppsResource;
import com.actionsoft.apps.resource.ManifestXML;
import com.actionsoft.apps.resource.deployment.DeploymentDirectory;
import com.actionsoft.apps.resource.deployment.DeploymentFunction;
import com.actionsoft.apps.resource.deployment.DeploymentSystem;
import com.actionsoft.bpms.bpmn.modeler.util.Base64Util;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AppComparator;
import com.actionsoft.bpms.commons.amc.util.DeployUtil;
import com.actionsoft.bpms.commons.amc.web.ApplicationInstallWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationUninstallWeb;
import com.actionsoft.bpms.commons.amc.web.ApplicationUpgradeWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationFunction;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.server.DeveloperKey;
import com.actionsoft.bpms.server.DispatcherRequest;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.conf.server.AWSServerConf;
import com.actionsoft.bpms.util.AES;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UtilDate;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.emm.mam.apps.MobileAppProfile;
import com.actionsoft.emm.mam.apps.MobileAppsResource;
import com.actionsoft.emm.mam.apps.ProfileXML;
import com.actionsoft.emm.mam.cache.AppCategoryCache;
import com.actionsoft.emm.mam.dao.AppCategoryDao;
import com.actionsoft.emm.mam.model.AppCategoryModel;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.exception.ExceptionUtil;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.actionsoft.sdk.local.api.LogAPI;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class AMCUtil {
    public static final String READY = "\u5df2\u5c31\u7eea";
    public static final String STARTING = "\u542f\u52a8\u4e2d";
    public static final String ACTIVE = "\u5df2\u542f\u52a8";
    public static final String STOPPING = "\u6682\u505c\u4e2d";
    public static final String STOPPED = "\u5df2\u6682\u505c";
    public static final String FAILED = "\u5df2\u51fa\u9519";
    public static final String UNINSTALLING = "\u5378\u8f7d\u4e2d";
    public static final String UNINSTALLED = "\u5df2\u5378\u8f7d";
    public static final String OFFLINE = "\u5df2\u8131\u673a";
    public static final String AMCCOMMONIMGPATH = "../commons/img/";
    public static final String APP_SERVICE_START = "service-online.png";
    public static final String APP_SERVICE_STOP = "service-stop.png";
    public static final String APP_SERVICE_DOING = "service-doing.png";
    public static final String APP_SERVICE_OFFLINE = "service-offline.png";
    public static final String APP_DEVICE_PC = "device-pc.png";
    public static final String APP_DEVICE_MOBILE = "device-mobile.png";
    public static final String APP_DEVICE_TABLET = "device-tablet.png";
    public static final String APP_MOBILE_ANDROID = "mobile-android.png";
    public static final String APP_MOBILE_IOS = "mobile-ios.png";
    public static final String APP_MOBILE_H5 = "mobile-h5.png";
    public static final String APP_MOBILE_H5PLUS = "mobile-h5plus.png";
    public static final String APP_SERVICE_START_CSS = "app-service-start";
    public static final String APP_SERVICE_STOP_CSS = "app-service-stop";
    public static final String APP_SERVICE_DOING_CSS = "app-service-doing";
    public static final String APP_SERVICE_OFFLINE_CSS = "app-service-offline";
    public static final String APP_DEVICE_PC_CSS = "app-device-pc";
    public static final String APP_DEVICE_MOBILE_CSS = "app-device-mobile";
    public static final String APP_DEVICE_TABLET_CSS = "app-device-tablet";
    public static final String APP_MOBILE_ANDROID_CSS = "app-mobile-android";
    public static final String APP_MOBILE_IOS_CSS = "app-mobile-ios";
    public static final String APP_MOBILE_H5_CSS = "app-mobile-ios";

    public static String getAppRunTimeStatus(String status) {
        String runTimeStatus = "";
        if (status.equals("READY")) {
            runTimeStatus = READY;
        } else if (status.equals("STARTING")) {
            runTimeStatus = STARTING;
        } else if (status.equals("ACTIVE")) {
            runTimeStatus = ACTIVE;
        } else if (status.equals("STOPPING")) {
            runTimeStatus = STOPPING;
        } else if (status.equals("STOPPED")) {
            runTimeStatus = STOPPED;
        } else if (status.equals("FAILED")) {
            runTimeStatus = FAILED;
        } else if (status.equals("UNINSTALLING")) {
            runTimeStatus = UNINSTALLING;
        } else if (status.equals("UNINSTALLED")) {
            runTimeStatus = UNINSTALLED;
        } else if (status.equals("OFFLINE")) {
            runTimeStatus = OFFLINE;
        }
        return runTimeStatus;
    }

    public static String getAppRunTime(Timestamp appStartTime) {
        String timeFormat = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat format = new SimpleDateFormat(timeFormat);
        DateTime dateTime = new DateTime(UtilDate.getTimes(format.format(new Date()), timeFormat));
        PeriodFormatter periodFormatter = new PeriodFormatterBuilder().appendYears().appendSuffix(I18nRes.findValue("_bpm.platform", "\u5e74")).appendMonths().appendSuffix(I18nRes.findValue("_bpm.platform", "\u6708")).appendDays().appendSuffix(I18nRes.findValue("_bpm.platform", "\u65e5")).appendHours().appendSuffix(I18nRes.findValue("_bpm.platform", "\u65f6")).appendMinutes().appendSuffix(I18nRes.findValue("_bpm.platform", "\u5206")).appendSeconds().appendSuffix(I18nRes.findValue("_bpm.platform", "\u79d2")).toFormatter();
        DateTime startTime = new DateTime(UtilDate.getTimes(format.format(appStartTime), timeFormat));
        Period period = new Period((ReadableInstant)startTime, (ReadableInstant)dateTime);
        return periodFormatter.print((ReadablePeriod)period);
    }

    public static int getAppNotificationCount(AppContext appContext, boolean isContainInfo) {
        List notifications = appContext.getNotification();
        int total = 0;
        int error = 0;
        int waring = 0;
        if (isContainInfo) {
            total = notifications.size();
        } else if (appContext != null) {
            error = AMCUtil.getAppNotificationCount(appContext.getId(), "err");
            waring = AMCUtil.getAppNotificationCount(appContext.getId(), "warn");
            total = error + waring;
        }
        return total;
    }

    public static int getAppNotificationNoReadCount(AppContext appContext, boolean isContainInfo) {
        List notifications = appContext.getNotification();
        int total = 0;
        int error = 0;
        int waring = 0;
        if (isContainInfo) {
            total = notifications.size();
        } else if (appContext != null) {
            error = AMCUtil.getAppNotificationNoReadCount(appContext.getId(), "err");
            waring = AMCUtil.getAppNotificationNoReadCount(appContext.getId(), "warn");
            total = error + waring;
        }
        return total;
    }

    public static int getNotificationCount(String level, String uid) {
        List<AppLogMsg> list = AMCUtil.getALLAppMessageList(uid);
        int count = 0;
        for (AppLogMsg appLogBean : list) {
            if (!level.equals(appLogBean.getLevel())) continue;
            ++count;
        }
        if (level.equals("")) {
            count = list.size();
        }
        return count;
    }

    public static int getAppNotificationCount(String appId, String level) {
        int count = 0;
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app != null) {
            List notifications = app.getNotification();
            for (AppLogMsg appLogBean : notifications) {
                String l = appLogBean.getLevel();
                if (!l.equals(level)) continue;
                ++count;
            }
        }
        if (level.equals("")) {
            count = app.getNotification().size();
        }
        return count;
    }

    public static int getAppNotificationNoReadCount(String appId, String level) {
        int count = 0;
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app != null) {
            List notifications = app.getNotification();
            for (AppLogMsg appLogBean : notifications) {
                String l = appLogBean.getLevel();
                if (!l.equals(level) || appLogBean.isRead()) continue;
                ++count;
            }
        }
        return count;
    }

    public static int getAppNotificationCount(String appId, String level, boolean isRead) {
        int count = 0;
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app != null) {
            List notifications = app.getNotification();
            for (AppLogMsg appLogBean : notifications) {
                String l = appLogBean.getLevel();
                if (!l.equals(level) || appLogBean.isRead() != isRead) continue;
                ++count;
            }
        }
        return count;
    }

    public static String getAppNotificationCountHtml(AppContext appContext, String type, boolean isShowA) {
        List notifications = appContext.getNotification();
        boolean isShow = false;
        StringBuilder html = new StringBuilder();
        int error = 0;
        int waring = 0;
        for (AppLogMsg appLogBean : notifications) {
            if (appLogBean == null) continue;
            String level = appLogBean.getLevel();
            if (level.equals("err")) {
                ++error;
                continue;
            }
            if (!level.equals("warn")) continue;
            ++waring;
        }
        if (AppPlatformConfig.isAppStoreService() || !appContext.getProductId().equals("")) {
            isShow = true;
        }
        if (error > 0) {
            AMCUtil.getBubbleHtml(appContext, type, isShowA, isShow, html, error, "error");
        }
        if (waring > 0) {
            AMCUtil.getBubbleHtml(appContext, type, isShowA, isShow, html, waring, "warn");
        }
        if (error == 0 && waring == 0) {
            html.append(I18nRes.findValue("_bpm.platform", "\u6ca1\u6709\u95ee\u9898"));
        }
        return html.toString();
    }

    private static void getBubbleHtml(AppContext appContext, String type, boolean isShowA, boolean isShow, StringBuilder html, int bubbleNum, String bubbleState) {
        String css = bubbleState.equals("error") ? "error" : "warn";
        String fnArgs = bubbleState.equals("error") ? "err" : "warn";
        StringBuilder bubble = new StringBuilder();
        bubble.append("<span class='overview " + css + "'>");
        bubble.append(bubbleNum);
        bubble.append("</span>");
        if (isShowA) {
            String function = type.equals("dashboard") ? "Dashboard.skip(1,\"" + appContext.getId() + "\",\"" + appContext.getName() + "\",undefined,\"" + fnArgs + "\");return false;" : "ApplicationManagement.showDetail(\"" + appContext.getId() + "\",\"" + appContext.getName() + "\",true," + isShow + ",undefined,undefined,undefined,\"toolbarInfo\",\"" + fnArgs + "\");return false;";
            html.append("<a style='color:white' href='#' onclick='" + function + "'>" + bubble + "</a>");
        } else {
            html.append((CharSequence)bubble);
        }
    }

    public static String getAppState(AppContext appContext) {
        List notifications = appContext.getNotification();
        StringBuilder html = new StringBuilder();
        int error = 0;
        int waring = 0;
        for (AppLogMsg appLogBean : notifications) {
            String level = appLogBean.getLevel();
            if (level.equals("err")) {
                ++error;
                continue;
            }
            if (!level.equals("warn")) continue;
            ++waring;
        }
        if (error > 0) {
            html.append("<span class='overview error'>");
            html.append(error);
            html.append("</span>");
        }
        if (waring > 0) {
            html.append("<span class='overview warn'>");
            html.append(waring);
            html.append("</span>");
        }
        if (error == 0 && waring == 0) {
            html.append(I18nRes.findValue("_bpm.platform", "\u6ca1\u6709\u95ee\u9898"));
        }
        return html.toString();
    }

    public static String getOptButtonStatusByAppRumtimeStatus(AppContext appContext, boolean isRefresh, UserContext uc, boolean isRepeat) {
        StringBuilder html = new StringBuilder();
        html.append("<td>");
        html.append(AMCUtil.getInputButton(appContext, isRefresh, uc, isRepeat));
        html.append("</td>");
        return html.toString();
    }

    public static boolean checkRepeat(AppContext appContext) {
        boolean isRepeat = AMCUtil.isExistApp("install", appContext) && AMCUtil.isExistApp("uninstall", appContext);
        return isRepeat;
    }

    private static boolean isExistApp(String type, AppContext appContext) {
        boolean isExist;
        block3: {
            block2: {
                isExist = false;
                if (!type.equals("install")) break block2;
                List installApps = AppsAPIManager.getInstance().getInstalledApps();
                for (AppContext intallApp : installApps) {
                    if (!intallApp.getId().equals(appContext.getId())) continue;
                    return true;
                }
                break block3;
            }
            if (!type.equals("uninstall")) break block3;
            List unInstallApps = AppsAPIManager.getInstance().getUninstalledApps();
            for (AppContext unInstallApp : unInstallApps) {
                if (!unInstallApp.getId().equals(appContext.getId())) continue;
                return true;
            }
        }
        return isExist;
    }

    public static String getInputButton(AppContext appContext, boolean isRefresh, UserContext uc, boolean isRepeat) {
        String appId = appContext.getId();
        String img64 = AppsAPIManager.getInstance().getIcon64URL(appId, uc);
        StringBuilder html = new StringBuilder();
        if (!isRefresh) {
            html.append("<input type='button' onclick='ApplicationManagement.refreshDetial(\"" + appId + "\",true);'  class='awsui-btn awsui-btn-sm' value='" + I18nRes.findValue("_bpm.platform", "\u5237\u65b0") + "'/>");
            int appType = 0;
            if (appContext.getMobileAppProfile() != null) {
                appType = MobileAppsResource.getOsType((MobileAppProfile)appContext.getMobileAppProfile());
            }
            html.append("<input type='button' onclick='ApplicationManagement.configApp(\"" + appId + "\"," + appType + ");'  class='awsui-btn awsui-btn-sm' value='" + I18nRes.findValue("_bpm.platform", "\u914d\u7f6e") + "'/>");
        }
        if (appId.equals("_bpm.platform") || appId.equals("_bpm.portal") || appId.equals("_bpm.coe")) {
            html.append("&nbsp;");
        } else {
            if ("ACTIVE".equals(appContext.getRuntimeState())) {
                html.append("<input type='button' class='awsui-btn awsui-btn-sm awsui-btn-blue' onclick='ApplicationManagement.suspendApp(\"" + appId + "\"," + isRefresh + ",\"" + AMCUtil.getAppNewName(appContext.getName()) + "\",\"" + img64 + "\");' value='" + I18nRes.findValue("_bpm.platform", "\u6682\u505c") + "'/>");
                html.append("<input type='button' class='awsui-btn awsui-btn-sm awsui-btn-green' onclick='ApplicationManagement.restartApp(\"" + appId + "\"," + isRefresh + ",\"" + AMCUtil.getAppNewName(appContext.getName()) + "\",\"" + img64 + "\");'  value='" + I18nRes.findValue("_bpm.platform", "\u91cd\u542f") + "'>");
            } else {
                html.append("<input type='button' class='awsui-btn awsui-btn-sm awsui-btn-blue' onclick='ApplicationManagement.startApp(\"" + appId + "\"," + isRefresh + ",\"" + AMCUtil.getAppNewName(appContext.getName()) + "\",\"" + img64 + "\");'  value='" + I18nRes.findValue("_bpm.platform", "\u542f\u52a8") + "'/>");
            }
            html.append("<input type='button' class='awsui-btn awsui-btn-sm' onclick='ApplicationManagement.unInstallApp(\"" + appId + "\"," + isRefresh + ",\"" + AMCUtil.getAppNewName(appContext.getName()) + "\",\"" + img64 + "\"," + isRepeat + ");'  value='" + I18nRes.findValue("_bpm.platform", "\u5378\u8f7d") + "'/>");
        }
        if (!(isRefresh || appId.equals("_bpm.platform") || appId.equals("_bpm.portal") || appId.equals("_bpm.coe"))) {
            html.append("<br><input type='button' class='awsui-btn awsui-btn-sm' style='margin-top:10px;width:310px;' onclick='ApplicationManagement.openAppRestoreDialog(\"" + appId + "\");'  value='" + I18nRes.findValue("_bpm.platform", "\u8fd8\u539f\u5e94\u7528") + "'/>");
        }
        if (!isRefresh && MobileAppsResource.isMobileApp((AppContext)appContext)) {
            html.append("<br><input type='button' class='awsui-btn awsui-btn-sm' style='margin-top:10px;width:310px;' onclick='ApplicationManagement.goMobileAppManagement(\"" + appId + "\");'  value='" + I18nRes.findValue("_bpm.platform", "\u7ba1\u7406\u79fb\u52a8\u5e94\u7528") + "'/>");
        }
        return html.toString();
    }

    public static String getUninstallButton(AppContext appContext, boolean isRefresh, UserContext uc, boolean isRepeat) {
        String img64 = AppsAPIManager.getInstance().getIcon64URL(appContext.getId(), uc);
        StringBuilder html = new StringBuilder();
        if (!appContext.getId().equals("_bpm.platform")) {
            html.append("<input type='button' class='button small' onclick='ApplicationManagement.unInstallApp(\"" + appContext.getId() + "\"," + isRefresh + ",\"" + appContext.getName() + "\",\"" + img64 + "\"," + isRepeat + ");'  value='" + I18nRes.findValue("_bpm.platform", "\u5378\u8f7d") + "'/>");
        }
        return html.toString();
    }

    public static List<AppLogMsg> getALLAppMessageListNoInfo() {
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        ArrayList<AppLogMsg> messageList = new ArrayList<AppLogMsg>();
        for (AppContext appContext : appContexts) {
            List list = appContext.getNotification();
            for (AppLogMsg appLogBean : list) {
                if (appLogBean.getLevel().equals("info")) continue;
                messageList.add(appLogBean);
            }
        }
        return messageList;
    }

    public static AppContext getAppByLogBean(AppLogMsg logBean) {
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : appContexts) {
            List list = appContext.getNotification();
            for (AppLogMsg appLogBean : list) {
                if (!logBean.equals((Object)appLogBean)) continue;
                return appContext;
            }
        }
        return null;
    }

    public static List<AppLogMsg> getALLAppMessageList(String uid) {
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        ArrayList<AppLogMsg> messageList = new ArrayList<AppLogMsg>();
        for (AppContext appContext : appContexts) {
            if (!AMCAPIManager.isDevelopApp(appContext.getId(), uid) && !AMCAPIManager.isManagementApp(appContext.getId(), uid)) continue;
            List list = appContext.getNotification();
            for (AppLogMsg appLogBean : list) {
                messageList.add(appLogBean);
            }
        }
        return messageList;
    }

    public static List<AppLogMsg> getMessageListByApp(String appId, String levels) {
        ArrayList<AppLogMsg> messageList = new ArrayList<AppLogMsg>();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        List list = app.getNotification();
        UtilString ut = new UtilString(levels);
        List<String> v = ut.split(",");
        if (levels.equals("")) {
            return list;
        }
        for (AppLogMsg appLogBean : list) {
            int i = 0;
            while (i < v.size()) {
                String level = v.get(i);
                if (!level.equals("") && appLogBean.getLevel().equals(level)) {
                    messageList.add(appLogBean);
                }
                ++i;
            }
        }
        return messageList;
    }

    public static List<AppLogMsg> getMessageListByLevel(String levels, String uid) {
        List<AppLogMsg> messageList = new ArrayList<AppLogMsg>();
        List<AppLogMsg> list = AMCUtil.getALLAppMessageList(uid);
        for (AppLogMsg appLogBean : list) {
            if (!appLogBean.getLevel().equals(levels)) continue;
            messageList.add(appLogBean);
        }
        if (levels.equals("")) {
            messageList = list;
        }
        return messageList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static JSONObject readZipFile(String filePath) throws Exception {
        ZipEntry ze;
        JSONObject map = new JSONObject();
        File f = new File(filePath);
        if (!f.exists()) return map;
        String fileName = f.getName();
        String appId = "";
        if (fileName.indexOf(".app") > -1) {
            appId = fileName.substring(0, fileName.lastIndexOf(".app"));
        }
        map.put("appId", (Object)appId);
        if (!fileName.endsWith("app")) return map;
        ZipFile zf = new ZipFile(filePath);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
        ZipInputStream zin = new ZipInputStream(in);
        while ((ze = zin.getNextEntry()) != null) {
            if (!ze.isDirectory() && ze.getName().equals("manifest.xml")) {
                Class<AMCUtil> clazz = AMCUtil.class;
                // MONITORENTER : com.actionsoft.bpms.commons.amc.util.AMCUtil.class
                SAXReader saxreader = new SAXReader();
                Document doc = DocumentFactory.getInstance().createDocument();
                try {
                    doc = saxreader.read(zf.getInputStream(ze));
                    Element root = doc.getRootElement();
                    Iterator iter = root.elementIterator();
                    while (iter.hasNext()) {
                        Element element = (Element)iter.next();
                        if (element == null) continue;
                        if (element.getName().equals("name")) {
                            map.put("name", (Object)element.getTextTrim());
                            continue;
                        }
                        if (element.getName().equals("developer")) {
                            map.put("developer", (Object)element.getTextTrim());
                            continue;
                        }
                        if (element.getName().equals("version")) {
                            double ver = 1.0;
                            try {
                                ver = Double.parseDouble(element.getTextTrim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            map.put("version", (Object)ver);
                            continue;
                        }
                        if (element.getName().equals("buildNo")) {
                            int buildNo = 1;
                            try {
                                buildNo = Integer.parseInt(element.getTextTrim());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            map.put("buildNo", (Object)element.getTextTrim());
                            continue;
                        }
                        if (element.getName().equals("categoryVisible")) {
                            String str = element.getTextTrim();
                            if (str.equalsIgnoreCase("true")) {
                                map.put("categoryVisible", (Object)true);
                                continue;
                            }
                            map.put("categoryVisible", (Object)false);
                            continue;
                        }
                        if (element.getName().equals("releaseDate")) {
                            String date = element.getTextTrim();
                            if (date == null || date.trim().length() <= 0) continue;
                            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
                            map.put("releaseDate", (Object)sf.format(new Date(UtilDate.getTimes(date, "yyyy-MM-dd"))));
                            continue;
                        }
                        if (element.getName().equals("productId")) {
                            map.put("productId", (Object)element.getTextTrim());
                            continue;
                        }
                        if (!element.getName().equals("depend")) continue;
                        map.put("depend", (Object)element.getTextTrim());
                        String env = element.attributeValue("env");
                        map.put("env", (Object)(UtilString.isNotEmpty(env) ? env : ""));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            zin.closeEntry();
        }
        ((InputStream)in).close();
        zin.close();
        zf.close();
        return map;
    }

    public static String getAppHtmlByType(String type, UserContext uc) {
        StringBuilder html = new StringBuilder();
        if (type.equals("0")) {
            html.append(ApplicationInstallWeb.getToBeInstalledHtml(uc));
        } else if (type.equals("2")) {
            html.append(ApplicationUpgradeWeb.getToBeUpgradeHtml(uc));
        } else if (type.equals("1")) {
            html.append(ApplicationUninstallWeb.getToBeUnInstalledHtml(uc));
        }
        return html.toString();
    }

    public static AppContext getAppFromInstall(AppContext AppContext2) {
        List installApps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : installApps) {
            if (!appContext.getId().equals(AppContext2.getId())) continue;
            return appContext;
        }
        return null;
    }

    public static String getSuspendStr(String appId) {
        int info = 0;
        int err = 0;
        int warn = 0;
        int all = 0;
        StringBuilder function = new StringBuilder();
        StringBuilder function2 = new StringBuilder();
        StringBuilder function3 = new StringBuilder();
        StringBuilder function4 = new StringBuilder();
        String uid = DispatcherRequest.getUserContext().getUID();
        if (appId.equals("")) {
            info = AMCUtil.getNotificationCount("info", uid);
            err = AMCUtil.getNotificationCount("err", uid);
            warn = AMCUtil.getNotificationCount("warn", uid);
            all = AMCUtil.getNotificationCount("", uid);
        } else {
            info = AMCUtil.getAppNotificationCount(appId, "info");
            err = AMCUtil.getAppNotificationCount(appId, "err");
            warn = AMCUtil.getAppNotificationCount(appId, "warn");
            all = AMCUtil.getAppNotificationCount(appId, "");
        }
        String errStr = "";
        String warnStr = "";
        String infoStr = "";
        String flag = "";
        if (appId.equals("")) {
            function.append("ApplicationMessageCenter.getMessageByLeve('");
        } else {
            function.append("ApplicationManagement.getMessageByLeve('");
        }
        function.append(flag);
        function.append("');");
        if (err > 0) {
            flag = "err";
            if (appId.equals("")) {
                function2.append("ApplicationMessageCenter.getMessageByLeve('");
            } else {
                function2.append("ApplicationManagement.getMessageByLeve('");
            }
            function2.append(flag);
            function2.append("');");
        }
        if (warn > 0) {
            flag = "warn";
            if (appId.equals("")) {
                function3.append("ApplicationMessageCenter.getMessageByLeve('");
            } else {
                function3.append("ApplicationManagement.getMessageByLeve('");
            }
            function3.append(flag);
            function3.append("');");
        }
        if (info > 0) {
            flag = "info";
            if (appId.equals("")) {
                function4.append("ApplicationMessageCenter.getMessageByLeve('");
            } else {
                function4.append("ApplicationManagement.getMessageByLeve('");
            }
            function4.append(flag);
            function4.append("');");
        }
        String allStr = "";
        allStr = "<div style='float: left;height: 30px;padding-right: 10px;line-height:30px;'><span  class='icon all' onclick=\"" + function.toString() + " return false;\" style='cursor:pointer' > </span>&nbsp;<span onclick=\"" + function.toString() + " return false;\" style='cursor:pointer'><span id='all_msg'  >" + I18nRes.findValue("_bpm.platform", "\u5168\u90e8\u4fe1\u606f") + "(" + all + ")" + I18nRes.findValue("_bpm.platform", "\u4e2a") + "</span><div></div></span> &nbsp;&nbsp;</div>";
        if (err > 0) {
            errStr = " <div  style='float: left;height: 30px;padding-right: 10px;line-height:30px;'><span  class='icon error1' onclick=\"" + function2.toString() + "return false;\"  style='cursor:pointer' > </span>&nbsp;<span onclick=\"" + function2.toString() + " return false;\"  style='cursor:pointer'><span id='err_msg'>" + I18nRes.findValue("_bpm.platform", "\u9519\u8bef\u4fe1\u606f") + "(" + err + ")" + I18nRes.findValue("_bpm.platform", "\u4e2a") + "</span><div></div></span> &nbsp;&nbsp;</div>";
        }
        if (warn > 0) {
            warnStr = "<div  style='float: left;height: 30px;padding-right: 10px;line-height:30px;'><span  class='icon warn1' onclick=\"" + function3.toString() + " return false;\" style='cursor:pointer' > </span>&nbsp;<span onclick=\"" + function3.toString() + " return false;\" style='cursor:pointer'><span id='warn_msg'>" + I18nRes.findValue("_bpm.platform", "\u8b66\u544a\u4fe1\u606f") + "(" + warn + ")" + I18nRes.findValue("_bpm.platform", "\u4e2a") + "</span><div></div></span> &nbsp;&nbsp;</div>";
        }
        if (info > 0) {
            infoStr = "<div  style='float: left;height: 30px;padding-right: 10px;line-height:30px;'><span  class='icon info1' onclick=\"" + function4.toString() + " return false;\" style='cursor:pointer' > </span>&nbsp;<span onclick=\"" + function4.toString() + " return false;\" style='cursor:pointer' ><span id='info_msg'>" + I18nRes.findValue("_bpm.platform", "\u901a\u77e5\u4fe1\u606f") + "(" + info + ")" + I18nRes.findValue("_bpm.platform", "\u4e2a") + "</span><div></div></span> &nbsp;&nbsp;</div>";
        }
        return String.valueOf(errStr) + warnStr + infoStr + allStr;
    }

    public static String getSuspendStr() {
        return AMCUtil.getSuspendStr("");
    }

    public static String getVisitStore(String html) {
        String visitStore = "";
        if (AppPlatformConfig.isAppStoreService()) {
            visitStore = html;
        }
        return visitStore;
    }

    public static boolean getAppNameExist(String appName) {
        List installApps = AppsAPIManager.getInstance().getInstalledApps();
        List uninstaApps = AppsAPIManager.getInstance().getUninstalledApps();
        for (AppContext appContext : installApps) {
            if (!appContext.getName().equals(appName)) continue;
            return true;
        }
        for (AppContext appContext : uninstaApps) {
            if (!appContext.getName().equals(appName)) continue;
            return true;
        }
        return false;
    }

    public static List<AppContext> getReverseDependApps(String appId) {
        ArrayList<AppContext> reverseDepandList = new ArrayList<AppContext>();
        List installApps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : installApps) {
            if (appContext.getId().equals(appId) || appContext.getDepend() == null || !appContext.getDepend().getAppId().equals(appId)) continue;
            reverseDepandList.add(appContext);
        }
        return reverseDepandList;
    }

    public static List<AppContext> getAppRequires(String appId) {
        ArrayList<AppContext> list = new ArrayList<AppContext>();
        AppContext context = AppsAPIManager.getInstance().getAppContext(appId);
        List requires = context.getRequires();
        if (requires != null && !requires.isEmpty()) {
            for (AppContextRequire require : requires) {
                AppContext app = AppsResource.getAppContext((String)require.getAppId());
                if (app == null || list.contains(app)) continue;
                list.add(app);
            }
        }
        return list;
    }

    public static List<AppContext> getAppRequiresByApp(String appId) {
        ArrayList<AppContext> list = new ArrayList<AppContext>();
        List installList = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext intallApp : installList) {
            List requires2;
            if (intallApp.getId().equals(appId) || (requires2 = intallApp.getRequires()) == null || requires2.isEmpty()) continue;
            for (AppContextRequire require1 : requires2) {
                if (!require1.getAppId().equals(appId) || intallApp == null || list.contains(intallApp)) continue;
                list.add(intallApp);
            }
        }
        return list;
    }

    public static boolean isExt(List<AppContext> list, String appId) {
        for (AppContext extapp : list) {
            if (!extapp.getId().equals(appId)) continue;
            return true;
        }
        return false;
    }

    public static File[] getFileListOrderByLastModified(File[] files) {
        if (files.length > 0) {
            ArrayList<File> listFiles = new ArrayList<File>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                listFiles.add(file);
                ++n2;
            }
            Collections.sort(listFiles, new AppComparator.LastModifiedFileComparator());
            files = listFiles.toArray(new File[0]);
        }
        return files;
    }

    private static List<JSONObject> getFileList(File[] files) {
        ArrayList<JSONObject> installFileList = new ArrayList<JSONObject>();
        if (files.length > 0) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File zipFile = fileArray[n2];
                String appId = "";
                if (!zipFile.isDirectory()) {
                    File ff = new File(zipFile.getPath());
                    String fileName = ff.getName();
                    try {
                        if (fileName.endsWith(".app")) {
                            appId = fileName.substring(0, fileName.lastIndexOf(".app"));
                            JSONObject appContextJson = AMCUtil.readZipFile(zipFile.getPath());
                            boolean isNeedInstall = AppInstaller.isInstall((String)appId);
                            if (isNeedInstall) {
                                installFileList.add(appContextJson);
                            }
                        } else {
                            appId = fileName;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
        return installFileList;
    }

    private static File[] queryAppTree(JSONObject context, File[] files, boolean isFirst) {
        File[] newFiles = new File[files.length];
        ArrayList<JSONObject> sequenceList = new ArrayList<JSONObject>();
        List<JSONObject> appContextList = AMCUtil.getFileList(files);
        sequenceList.add(context);
        for (JSONObject json : sequenceList) {
            int i = 0;
            while (i < files.length) {
                String appId;
                String fileName = files[i].getName();
                if (fileName.endsWith(".app")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(".app"));
                }
                if (!(appId = UtilJson.optString(json, "id")).equals("") && appId.equals(fileName)) {
                    newFiles[i] = files[i];
                }
                ++i;
            }
        }
        return newFiles;
    }

    public static File[] queryAppTree(File[] files) {
        JSONArray systemAppArray = new JSONArray();
        JSONObject jsonPlatform = new JSONObject();
        jsonPlatform.put("id", (Object)"_bpm.platform");
        JSONObject jsonPortal = new JSONObject();
        jsonPortal.put("id", (Object)"_bpm.portal");
        JSONObject jsonCoe = new JSONObject();
        jsonCoe.put("id", (Object)"_bpm.coe");
        systemAppArray.add((Object)jsonPlatform);
        systemAppArray.add((Object)jsonPortal);
        systemAppArray.add((Object)jsonCoe);
        return AMCUtil.queryAppTree(jsonPlatform, files, true);
    }

    public static String getAppStoreName() {
        return AppPlatformConfig.getAppStoreName();
    }

    public static String getAppsByType(Map<String, String> teamApps, String type) {
        StringBuilder appsStr = new StringBuilder();
        Iterator<String> keys = teamApps.keySet().iterator();
        int count = 0;
        while (keys.hasNext()) {
            String key = keys.next();
            String permission = teamApps.get(key);
            if (permission.indexOf(type) <= -1) continue;
            if (count == 0) {
                appsStr.append(key);
            } else {
                appsStr.append(",").append(key);
            }
            ++count;
        }
        return appsStr.toString();
    }

    public static String getMembers2Str(List<String> members) {
        StringBuilder member = new StringBuilder();
        int count = 0;
        for (String m : members) {
            if (count == 0) {
                member.append(m);
            } else {
                member.append(",").append(m);
            }
            ++count;
        }
        return member.toString();
    }

    public static String getRoles2Str(List<String> roles) {
        StringBuilder role = new StringBuilder();
        int count = 0;
        for (String m : roles) {
            if (count == 0) {
                role.append(m);
            } else {
                role.append(",").append(m);
            }
            ++count;
        }
        return role.toString();
    }

    public static String getMembersAsName(List<String> members) {
        StringBuilder member = new StringBuilder();
        int count = 0;
        for (String m : members) {
            UserModel userModel = UserCache.getModel((String)m);
            if (userModel != null) {
                m = userModel.getUserName();
            }
            if (count == 0) {
                member.append(m);
            } else {
                member.append(",").append(m);
            }
            ++count;
        }
        return member.toString();
    }

    public static List<String> getMembersToList(String membersStr) {
        ArrayList<String> members = new ArrayList<String>();
        UtilString ut = new UtilString(membersStr);
        if (!UtilString.isEmpty(membersStr)) {
            List<String> memberList = ut.split(",");
            int i = 0;
            while (i < memberList.size()) {
                members.add(memberList.get(i));
                ++i;
            }
        }
        return members;
    }

    public static String getRolesAsName(List<String> roles) {
        StringBuilder role = new StringBuilder();
        int count = 0;
        for (String r : roles) {
            RoleModel roleModel = RoleCache.getModel((String)r);
            if (roleModel != null) {
                r = roleModel.getName();
            }
            if (count == 0) {
                role.append(r);
            } else {
                role.append(",").append(r);
            }
            ++count;
        }
        return role.toString();
    }

    public static List<String> getRolesToList(String rolesStr) {
        ArrayList<String> roles = new ArrayList<String>();
        if (!UtilString.isEmpty(rolesStr)) {
            UtilString ut = new UtilString(rolesStr);
            List<String> roleList = ut.split(",");
            int i = 0;
            while (i < roleList.size()) {
                roles.add(roleList.get(i));
                ++i;
            }
        }
        return roles;
    }

    public static Map<String, String> parseStr2Map(String jsonStr) {
        HashMap<String, String> map = new HashMap<String, String>();
        UtilString ut = new UtilString(jsonStr);
        List<String> permission = ut.split(",");
        for (String per : permission) {
            if (per.equals("")) continue;
            UtilString u = new UtilString(per);
            List<String> li = u.split(":");
            map.put(li.get(0), li.get(1));
        }
        return map;
    }

    public static Map<String, String> getAppsPermissions2Map(String appsPermissionsStr) {
        Map<String, String> appsPermissions = new HashMap<String, String>();
        if (appsPermissionsStr != null && !appsPermissionsStr.equals("")) {
            appsPermissions = AMCUtil.parseStr2Map(appsPermissionsStr);
        }
        return appsPermissions;
    }

    public static String getAppsPermissionsMap2Str(Map<String, String> appsPermissions) {
        Iterator<String> it = appsPermissions.keySet().iterator();
        StringBuilder permissions = new StringBuilder();
        int count = 0;
        while (it.hasNext()) {
            String appId = it.next();
            String per = appsPermissions.get(appId);
            if (count == 0) {
                permissions.append(String.valueOf(appId) + ":" + per);
            } else {
                permissions.append(",").append(String.valueOf(appId) + ":" + per);
            }
            ++count;
        }
        return permissions.toString();
    }

    public static void deployApp(AppContext appContext, boolean isShowLog) {
        String appId = appContext.getId();
        String scanXML = String.valueOf(appContext.getPath()) + "manifest.xml";
        File xmlFile = new File(scanXML);
        if (xmlFile.exists()) {
            try {
                AppsResource.updateByFile((AppContext)appContext, (File)xmlFile);
            }
            catch (AppContainerException e) {
                e.printStackTrace();
            }
        }
        List list = appContext.getDeploymentMenus();
        Date date = new Date();
        SimpleDateFormat smp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateStr = smp.format(date);
        if (list != null) {
            if (list.size() == 0) {
                if (isShowLog) {
                    AppInstaller.deployMessageMap.put(appId, "\n <font color='yellow'>" + I18nRes.findValue("_bpm.platform", "\u8b66\u544a") + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u8be5") + "App" + I18nRes.findValue("_bpm.platform", "\u6ca1\u6709\u90e8\u7f72\u4fe1\u606f") + "," + I18nRes.findValue("_bpm.platform", "\u9700\u8981\u624b\u52a8\u90e8\u7f72") + "</font>");
                }
            } else {
                for (DeploymentSystem deploymentSystem : list) {
                    if (deploymentSystem == null) {
                        AppInstaller.deployMessageMap.put(appId, "\n <font color='yellow'>" + I18nRes.findValue("_bpm.platform", "\u8b66\u544a") + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u8be5\u90e8\u7f72\u4fe1\u606f\u4e0d\u5b8c\u6574\u7f3a\u5c11\u5b50\u7cfb\u7edf\u9700\u8981\u624b\u52a8\u90e8\u7f72") + "</font>");
                        continue;
                    }
                    if (UtilString.isEmpty(deploymentSystem.getId())) {
                        AppInstaller.deployMessageMap.put(appId, "\n <font color='yellow'>" + I18nRes.findValue("_bpm.platform", "\u8b66\u544a") + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u8be5\u90e8\u7f72\u4fe1\u606f\u4e0d\u5b8c\u6574\u7f3a\u5c11\u5b50\u7cfb\u7edf\u9700\u8981\u624b\u52a8\u90e8\u7f72") + "</font>");
                        continue;
                    }
                    boolean sy = NavigationSystemCache.getModel(deploymentSystem.getId()) != null;
                    List dlist = deploymentSystem.getDeploymentDirectory();
                    if (dlist.size() == 0) {
                        if (!isShowLog) continue;
                        AppInstaller.deployMessageMap.put(appId, "\n <font color='yellow'>" + I18nRes.findValue("_bpm.platform", "\u8b66\u544a") + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u8be5\u90e8\u7f72\u4fe1\u606f\u4e0d\u5b8c\u6574\u7f3a\u5c11\u5b50\u76ee\u5f55\u9700\u8981\u624b\u52a8\u90e8\u7f72") + "</font>");
                        continue;
                    }
                    for (DeploymentDirectory deploymentDirectory : dlist) {
                        boolean de = NavigationDirectoryCache.getModel(deploymentDirectory.getId()) != null;
                        List flist = deploymentDirectory.getDeploymentFunction();
                        if (flist.size() == 0) {
                            if (!isShowLog) continue;
                            AppInstaller.deployMessageMap.put(appId, "<font color='yellow'>" + I18nRes.findValue("_bpm.platform", "\u8b66\u544a") + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u8be5\u90e8\u7f72\u4fe1\u606f\u4e0d\u5b8c\u6574\u7f3a\u5c11\u5b50\u529f\u80fd\u9700\u8981\u624b\u52a8\u90e8\u7f72") + "</font>");
                            continue;
                        }
                        for (DeploymentFunction deploymentFunction : flist) {
                            boolean fn;
                            boolean bl = fn = NavigationFunctionCache.getModel(deploymentFunction.getId()) != null;
                            if (sy && de && fn) {
                                AMCUtil.addPermissionForAdminGroup(deploymentFunction.getId(), deploymentDirectory.getId());
                                continue;
                            }
                            if (sy && de && !fn) {
                                if (deploymentSystem.getName().equals("") || deploymentDirectory.getName().equals("")) continue;
                                DeployUtil.createThreeNav(appId, deploymentSystem, deploymentDirectory, deploymentFunction, true, dateStr);
                                if (isShowLog) {
                                    AppInstaller.deployMessageMap.put(appId, String.valueOf(I18nRes.findValue("_bpm.platform", "\u4fe1\u606f")) + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u81ea\u52a8\u521b\u5efa\u7b2c\u4e09\u7ea7\u529f\u80fd\u83dc\u5355"));
                                }
                                AMCUtil.addPermissionForAdminGroup(deploymentFunction.getId(), deploymentDirectory.getId());
                                continue;
                            }
                            if (!(sy || de || fn)) {
                                if (deploymentSystem.getName().equals("") || deploymentDirectory.getName().equals("")) continue;
                                DeployUtil.createThreeNav(appId, deploymentSystem, deploymentDirectory, deploymentFunction, true, dateStr);
                                if (isShowLog) {
                                    AppInstaller.deployMessageMap.put(appId, String.valueOf(I18nRes.findValue("_bpm.platform", "\u4fe1\u606f")) + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u81ea\u52a8\u521b\u5efa\u4e09\u7ea7\u529f\u80fd\u83dc\u5355"));
                                }
                                AMCUtil.addPermissionForAdminGroup(deploymentFunction.getId(), deploymentDirectory.getId());
                                continue;
                            }
                            if (!isShowLog) continue;
                            DeployUtil.createThreeNav(appId, deploymentSystem, deploymentDirectory, deploymentFunction, true, dateStr);
                            AMCUtil.addPermissionForAdminGroup(deploymentFunction.getId(), deploymentDirectory.getId());
                            AppInstaller.deployMessageMap.put(appId, String.valueOf(I18nRes.findValue("_bpm.platform", "\u4fe1\u606f")) + ":[" + dateStr + "]" + I18nRes.findValue("_bpm.platform", "\u81ea\u52a8\u521b\u5efa\u4e09\u7ea7\u529f\u80fd\u83dc\u5355"));
                        }
                    }
                }
            }
        }
    }

    public static void addPermissionForAdminGroup(String functionId, String directoryId) {
        NavigationDirectoryModelImpl model;
        String systemId;
        PermissionListModel permissionListModel = new PermissionListModel();
        permissionListModel.setPermissionId("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31");
        permissionListModel.setResourceId(functionId);
        permissionListModel.setResourceType("FunctionObject");
        if (!PermAPIManager.getInstance().isAccessMenuPermission("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31", functionId)) {
            PermissionDaoFactory.createPermissionList().insert(permissionListModel);
        }
        String string = systemId = (model = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(directoryId)) == null ? "" : model.getSystemId();
        if (!UtilString.isEmpty(directoryId)) {
            permissionListModel = new PermissionListModel();
            permissionListModel.setPermissionId("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31");
            permissionListModel.setResourceId(directoryId);
            permissionListModel.setResourceType("FunctionObject");
            if (!PermAPIManager.getInstance().isAccessMenuPermission("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31", directoryId)) {
                PermissionDaoFactory.createPermissionList().insert(permissionListModel);
            }
        }
        if (!UtilString.isEmpty(systemId)) {
            permissionListModel = new PermissionListModel();
            permissionListModel.setPermissionId("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31");
            permissionListModel.setResourceId(systemId);
            permissionListModel.setResourceType("FunctionObject");
            if (!PermAPIManager.getInstance().isAccessMenuPermission("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31", systemId)) {
                PermissionDaoFactory.createPermissionList().insert(permissionListModel);
            }
        }
    }

    public static void copyImg2Web(AppContext newApp) {
        File[] files = new File(AMCUtil.getAppWebRealPath(newApp)).listFiles();
        if (files != null) {
            boolean isImgExist;
            boolean bl = isImgExist = AMCUtil.checkImg(files, "icon16.png") && AMCUtil.checkImg(files, "icon64.png") && AMCUtil.checkImg(files, "icon96.png");
            if (!isImgExist) {
                AMCUtil.copyAppImg2Web(newApp);
            }
        }
    }

    private static void copyAppImg2Web(AppContext newApp) {
        File sourceFile16 = new File(AMCUtil.getAppImgRealPath(newApp, "icon16.png"));
        File sourceFile64 = new File(AMCUtil.getAppImgRealPath(newApp, "icon64.png"));
        File sourceFile96 = new File(AMCUtil.getAppImgRealPath(newApp, "icon96.png"));
        File targetFile16 = new File(AMCUtil.getAppImgWebRealPath(newApp, "icon16.png"));
        File targetFile64 = new File(AMCUtil.getAppImgWebRealPath(newApp, "icon64.png"));
        File targetFile96 = new File(AMCUtil.getAppImgWebRealPath(newApp, "icon96.png"));
        try {
            if (sourceFile16.exists()) {
                UtilFile.copyFile(sourceFile16, targetFile16);
            }
            if (sourceFile64.exists()) {
                UtilFile.copyFile(sourceFile64, targetFile64);
            }
            if (sourceFile96.exists()) {
                UtilFile.copyFile(sourceFile96, targetFile96);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean checkImg(File[] files, String img) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().equals(img)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getAppImgRealPath(AppContext newApp, String img) {
        String appImg = String.valueOf(newApp.getPath()) + img;
        return appImg;
    }

    public static String getAppImgWebRealPath(AppContext newApp, String img) {
        String appImg = String.valueOf(AMCUtil.getAppWebRealPath(newApp)) + "/img/" + img;
        return appImg;
    }

    public static String getAppWebRealPath(AppContext newApp) {
        String appImg = String.valueOf(AWSPortalConf.getLocation()) + "apps/" + newApp.getId();
        return appImg;
    }

    private static String getAppIcon(String appId, boolean isCss, boolean isUninstall) {
        StringBuilder icon = new StringBuilder();
        AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
        if (appContext != null) {
            String runTimeStatus = appContext.getRuntimeState();
            if (isUninstall) {
                runTimeStatus = "UNINSTALLED";
            }
            String css = "style='height:16px;padding-left:2px;' align='absmiddle'";
            if (AppDependencyHelper.queryAppState((String)appId) == 2) {
                if (isCss) {
                    css = "class='app-service-stop'";
                }
                String runTime = AMCUtil.getAppRunTimeStatus(runTimeStatus);
                if (isUninstall) {
                    runTime = "UNINSTALLED";
                }
                icon.append("<img title='" + runTime + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_STOP + "' " + css + ">");
            } else if (runTimeStatus.equals("ACTIVE")) {
                if (isCss) {
                    css = "class='app-service-start'";
                }
                icon.append("<img title='" + I18nRes.findValue("_bpm.platform", ACTIVE) + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_START + "' " + css + ">");
            } else if (runTimeStatus.equals("STOPPING") || runTimeStatus.equals("UNINSTALLING") || runTimeStatus.equals("STARTING")) {
                if (isCss) {
                    css = "class='app-service-doing'";
                }
                icon.append("<img title='" + I18nRes.findValue("_bpm.platform", STOPPED) + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_DOING + "' " + css + ">");
            } else {
                if (isCss) {
                    css = "class='app-service-stop'";
                }
                icon.append("<img title='" + AMCUtil.getAppRunTimeStatus(runTimeStatus) + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_STOP + "' " + css + ">");
            }
            MobileAppProfile mobile = MobileAppsResource.getMobileAppProfile((String)appContext.getId());
            if (mobile == null) {
                if (isCss) {
                    css = "class='app-device-pc'";
                }
                icon.append("<img title='PC" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_DEVICE_PC + "' " + css + ">");
            } else {
                int deviceType = mobile.getDeviceType();
                int osType = MobileAppsResource.getOsType((MobileAppProfile)mobile);
                if (deviceType == 1) {
                    if (isCss) {
                        css = "class='app-device-mobile'";
                    }
                    icon.append("<img title='" + I18nRes.findValue("_bpm.platform", "\u624b\u673a\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_DEVICE_MOBILE + "' " + css + ">");
                } else if (deviceType == 2) {
                    if (isCss) {
                        css = "class='app-device-tablet'";
                    }
                    icon.append("<img title='" + I18nRes.findValue("_bpm.platform", "\u5e73\u677f\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_DEVICE_TABLET + "' " + css + ">");
                } else {
                    if (isCss) {
                        css = "class='app-device-tablet'";
                    }
                    icon.append("<img title='" + I18nRes.findValue("_bpm.platform", "\u901a\u7528\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_DEVICE_TABLET + "' " + css + ">");
                }
                if (MobileAppsResource.isNativeApp((MobileAppProfile)mobile)) {
                    if (osType == 2) {
                        if (isCss) {
                            css = "class='app-mobile-android'";
                        }
                        icon.append("<img title=' Android" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "' src='" + AMCCOMMONIMGPATH + APP_MOBILE_ANDROID + "' " + css + ">");
                    } else if (osType == 1) {
                        if (isCss) {
                            css = "class='app-mobile-ios'";
                        }
                        icon.append("<img title='IOS" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "' src='" + AMCCOMMONIMGPATH + APP_MOBILE_IOS + "' " + css + ">");
                    }
                } else if (MobileAppsResource.isH5App((MobileAppProfile)mobile)) {
                    if (isCss) {
                        css = "class='app-mobile-ios'";
                    }
                    icon.append("<img title='H5" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_MOBILE_H5 + "' " + css + ">");
                } else if (MobileAppsResource.isWeexApp((MobileAppProfile)mobile)) {
                    if (isCss) {
                        css = "class='app-mobile-ios'";
                    }
                    icon.append("<img title='H5" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_MOBILE_H5 + "' " + css + ">");
                } else if (MobileAppsResource.isH5PlusApp((MobileAppProfile)mobile)) {
                    if (isCss) {
                        css = "class='app-mobile-ios'";
                    }
                    icon.append("<img title='H5+" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "'  src='" + AMCCOMMONIMGPATH + APP_MOBILE_H5PLUS + "' " + css + ">");
                }
            }
        }
        return String.valueOf(icon.toString()) + " ";
    }

    public static String getAppOsType(AppContext appContext) {
        return AMCUtil.getAppOsType(appContext, true);
    }

    public static String getAppOsType(AppContext appContext, boolean isShowOsType) {
        StringBuilder osTypeStr = new StringBuilder();
        MobileAppProfile mobile = MobileAppsResource.getMobileAppProfile((String)appContext.getId());
        if (mobile == null) {
            return "";
        }
        osTypeStr.append("(");
        int deviceType = mobile.getDeviceType();
        int osType = MobileAppsResource.getOsType((MobileAppProfile)mobile);
        if (deviceType == 1) {
            osTypeStr.append("\u624b\u673a\u5e94\u7528-");
        } else {
            osTypeStr.append("\u5e73\u677f\u5e94\u7528-");
        }
        if (isShowOsType) {
            if (osType == 2) {
                osTypeStr.append("Android\u5e94\u7528");
            } else if (osType == 1) {
                osTypeStr.append("iOS\u5e94\u7528");
            } else {
                osTypeStr.append(I18nRes.findValue("_bpm.platform", "H5\u5e94\u7528"));
            }
        }
        osTypeStr.append(")");
        return osTypeStr.toString();
    }

    public static String getAppRuntimeOfImg(String appId) {
        StringBuilder icon = new StringBuilder();
        AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
        String runTimeStatus = appContext.getRuntimeState();
        if (runTimeStatus != null) {
            if (runTimeStatus.equals("ACTIVE")) {
                icon.append("<img title='" + I18nRes.findValue("_bpm.platform", ACTIVE) + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_START + "'> " + I18nRes.findValue("_bpm.platform", "\u8fd0\u884c\u4e2d"));
            } else if (runTimeStatus.equals("STOPPED") || runTimeStatus.equals("STOPPING") || runTimeStatus.equals("UNINSTALLED") || runTimeStatus.equals("UNINSTALLING") || runTimeStatus.equals("STARTING")) {
                icon.append("<img title='" + I18nRes.findValue("_bpm.platform", STOPPED) + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_DOING + "'> " + I18nRes.findValue("_bpm.platform", STOPPED));
            } else {
                icon.append("<img title='" + I18nRes.findValue("_bpm.platform", "\u5df2\u505c\u6b62") + "' src='" + AMCCOMMONIMGPATH + APP_SERVICE_STOP + "'> " + I18nRes.findValue("_bpm.platform", "\u5df2\u505c\u6b62"));
            }
        }
        return icon.toString();
    }

    public static List<AppContext> queryAllAppsList() {
        return AMCUtil.queryAllAppsList(true);
    }

    public static List<AppContext> queryAllAppsList(boolean isSort) {
        List<AppContext> list = new ArrayList();
        AppContext sysApp = AppsAPIManager.getInstance().getAppContext("_bpm.platform");
        List installList = AppsAPIManager.getInstance().getInstalledApps();
        list = AppsAPIManager.getInstance().queryAppsTree(sysApp);
        if (isSort) {
            AppsAPIManager.getInstance().sortAppByName(list);
        }
        List offlineList = AppDependencyHelper.queryOfflineApps();
        for (AppContext offlineApp : offlineList) {
            if (list.contains(offlineApp)) continue;
            list.add(offlineApp);
        }
        for (AppContext install : installList) {
            if (list.contains(install)) continue;
            list.add(install);
        }
        return list;
    }

    public static String getAppNewName(String appName, int length) {
        if (appName.length() > length) {
            appName = String.valueOf(appName.substring(0, length)) + "...";
        }
        return appName;
    }

    public static String getAppNewName(String appName) {
        return AMCUtil.getAppNewName(appName, 14);
    }

    public static String getListAppIcon(String appId, boolean isUnInstall) {
        return "<div>" + AMCUtil.getAppIcon(appId, true, isUnInstall) + "</div>";
    }

    public static String getListAppIcon(String appId) {
        return "<div>" + AMCUtil.getAppIcon(appId, true, false) + "</div>";
    }

    public static String getAppIconNoClass(String appId, boolean isUnInstall) {
        return AMCUtil.getAppIcon(appId, false, isUnInstall);
    }

    public static String getAppIconNoClass(String appId) {
        return AMCUtil.getAppIcon(appId, false, false);
    }

    public static String decrypt(String appId, String type, String value) {
        if (UtilString.isEmpty(value)) {
            return "";
        }
        if ("password".equals(type)) {
            try {
                value = new String(AES.decrypt((byte[])Base64.decode(value.getBytes(AES.CHARTSET)), (String)new MD5().toDigest(appId)), AES.CHARTSET);
            }
            catch (Exception e) {
                SDK.getLogAPI();
                LogAPI.getLogger(AMCUtil.class).error(appId, (Throwable)e);
            }
        }
        return value;
    }

    public static String encrypt(String appId, String type, String value) {
        if (UtilString.isEmpty(value)) {
            return "";
        }
        if ("password".equals(type)) {
            try {
                value = new String(Base64.encode(AES.encrypt((byte[])value.getBytes(AES.CHARTSET), (String)new MD5().toDigest(appId))), AES.CHARTSET);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    private static void saveMobileProfile(JSONObject appJson, File profileFile) throws Exception {
        AppCategoryModel model;
        String versionNo = "";
        String resourceType = "";
        String realAppId = "";
        String resourceURI = "";
        String trackId = "";
        String deviceType = "";
        String ssoType = "";
        boolean backupable = false;
        boolean cascadeRemove = true;
        boolean autoDistribute = false;
        int OS = appJson.getIntValue("os");
        String osType = "";
        if (OS == 2) {
            osType = "android";
        } else if (OS == 1) {
            osType = "iOS";
        }
        if (appJson.containsKey((Object)"byodVersionNo")) {
            versionNo = appJson.getString("byodVersionNo");
        } else if (appJson.containsKey((Object)"versionNo")) {
            versionNo = appJson.getString("versionNo");
        }
        if (appJson.containsKey((Object)"resourceType")) {
            resourceType = appJson.getString("resourceType");
        }
        realAppId = appJson.containsKey((Object)"realAppId") ? appJson.getString("realAppId") : appJson.getString("byodAppId");
        if (appJson.containsKey((Object)"resourceURI")) {
            resourceURI = appJson.getString("resourceURI");
        }
        if (appJson.containsKey((Object)"trackId")) {
            trackId = appJson.getString("trackId");
        }
        deviceType = appJson.containsKey((Object)"deviceType") ? appJson.getString("deviceType") : appJson.getString("supportDeviceType");
        if (appJson.containsKey((Object)"backupable")) {
            backupable = appJson.getBoolean("backupable");
        }
        if (appJson.containsKey((Object)"cascadeRemove")) {
            cascadeRemove = appJson.getBoolean("cascadeRemove");
        }
        if (appJson.containsKey((Object)"autoDistribute")) {
            autoDistribute = appJson.getBoolean("autoDistribute");
        }
        if (appJson.containsKey((Object)"ssoType")) {
            ssoType = appJson.getString("ssoType");
        }
        String category = appJson.getString("category");
        String appId = appJson.getString("byodAppId");
        if (UtilString.isEmpty(appId)) {
            appId = appJson.getString("appId");
        }
        if ((model = AppCategoryCache.getModel((String)appId)) == null) {
            model = new AppCategoryModel();
            model.setAppId(appId);
            model.setCategory(category);
            new AppCategoryDao().insert(model);
        } else if (!model.getCategory().equals(category)) {
            AppCategoryCache.removeById((String)appId);
            model.setCategory(category);
            new AppCategoryDao().update(model);
        }
        HashMap<String, String> nodeValues = new HashMap<String, String>();
        nodeValues.put("realAppId", realAppId);
        nodeValues.put("realVersion", versionNo);
        nodeValues.put("trackId", trackId);
        nodeValues.put("deviceType", deviceType);
        nodeValues.put("resourceURI", resourceURI);
        nodeValues.put("backupable", String.valueOf(backupable));
        nodeValues.put("cascadeRemove", String.valueOf(cascadeRemove));
        nodeValues.put("autoDistribute", String.valueOf(autoDistribute));
        nodeValues.put("ssoType", ssoType);
        nodeValues.put("osType", osType);
        nodeValues.put("resourceType", resourceType);
        ProfileXML.getInstance().saveKeyValue(profileFile, nodeValues);
    }

    public static ResponseObject createApp(UserContext ctx, JSONObject appJson, boolean start) {
        File targetFile;
        ResponseObject ro = ResponseObject.newOkResponse();
        String msg = I18nRes.findValue("_bpm.platform", "\u4fdd\u5b58\u6210\u529f");
        String appId = "";
        String appName = "";
        String dependstr = "";
        String versionNo = "";
        String desc = "";
        String details = "";
        String buildNo = "1";
        String categoryVisible = UtilJson.optString(appJson, "categoryVisible");
        String developerName = UtilJson.optString(appJson, "developerName");
        String developerURL = UtilJson.optString(appJson, "developerURL");
        String tablePrefix = UtilJson.optString(appJson, "tablePrefix");
        String modelAdministrator = UtilJson.optString(appJson, "modelAdministrator");
        if (Quota.isDeveloperService()) {
            developerName = DeveloperKey.getDeveloperName();
            developerURL = DeveloperKey.getDeveloperUrl();
            tablePrefix = DeveloperKey.getTablePrefix();
        }
        String resourceType = null;
        if (appJson.containsKey((Object)"resourceType")) {
            resourceType = appJson.getString("resourceType");
        }
        if (!UtilString.isEmpty(resourceType)) {
            appId = UtilJson.optString(appJson, "byodAppId");
            appName = UtilJson.optString(appJson, "byodAppName");
            dependstr = UtilJson.optString(appJson, "byod_parent_app");
            if (UtilString.isEmpty(dependstr)) {
                dependstr = "_bpm.platform-" + AppsAPIManager.getInstance().getAppContext("_bpm.platform").getVersion();
            }
            versionNo = UtilJson.optString(appJson, "byodVersionNo");
            desc = UtilJson.optString(appJson, "overview1");
            details = UtilJson.optString(appJson, "details1");
            String[] ss = versionNo.split("\\.");
            if (ss.length > 2) {
                versionNo = String.valueOf(ss[0]) + "." + ss[1];
                int i = 1;
                try {
                    i = Integer.valueOf(ss[2]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                buildNo = String.valueOf(i);
            }
        } else {
            appId = UtilJson.optString(appJson, "appId");
            appName = UtilJson.optString(appJson, "appName");
            dependstr = UtilJson.optString(appJson, "parent_app");
            versionNo = UtilJson.optString(appJson, "versionNo");
            desc = I18nRes.findValue("_bpm.platform", "\u65e0");
            details = I18nRes.findValue("_bpm.platform", "\u65e0");
        }
        if ((targetFile = new File("../apps/install/" + appId)).exists()) {
            msg = String.valueOf(I18nRes.findValue("_bpm.platform", "\u8be5")) + "App" + I18nRes.findValue("_bpm.platform", "\u5df2\u7ecf\u5b58\u5728");
            ro.warn();
            ro.msg(msg);
            return ro;
        }
        if (AMCAPIManager.isUnInstall(appId)) {
            msg = I18nRes.findValue("_bpm.platform", "\u8be5\u5df2\u5728\u5378\u8f7d\u5217\u8868\u4e2d\u8bf7\u5148\u5f7b\u5e95\u5220\u9664\u540e\u518d\u521b\u5efa");
            ro.warn();
            ro.msg(msg);
            return ro;
        }
        HashMap<String, String> xmlValues = new HashMap<String, String>();
        if (!AppNaming.appId((String)appId)) {
            msg = I18nRes.findValue("_bpm.platform", "\u5e94\u7528ID\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            ro.warn();
            ro.msg(msg);
            return ro;
        }
        boolean isOK = AppNaming.tablePrefix((String)tablePrefix);
        if (!isOK) {
            msg = I18nRes.findValue("_bpm.platform", "\u7269\u7406\u8868\u524d\u7f00\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42");
            ro.warn();
            ro.msg(msg);
            return ro;
        }
        File s = new File("conf/tpl/app-manifest.tpl");
        File r = new File("../apps/install/" + appId + "/");
        if (!r.exists()) {
            r.mkdir();
        }
        if (!UtilString.isEmpty(resourceType)) {
            File byodFolder = new File("../apps/install/" + appId + "/" + "mobile" + "/");
            byodFolder.mkdirs();
            File profileFile = new File(byodFolder, "mobile-profile.xml");
            File profileTpl = new File("conf/tpl/app-mobile-profile.tpl");
            try {
                UtilFile.copyFile(profileTpl, profileFile);
                AMCUtil.saveMobileProfile(appJson, profileFile);
            }
            catch (Exception e) {
                ro.err();
                ro.msg(ExceptionUtil.getMessage(e));
            }
        }
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        File appConfigDir = new File("../apps/install/" + appId);
        try {
            UtilFile.copyFile(s, appConfigFile);
        }
        catch (Exception e2) {
            msg = e2.getMessage();
            ro.err();
            ro.msg(ExceptionUtil.getMessage(e2));
        }
        try {
            UtilString str = new UtilString(dependstr);
            List<String> v = str.split("-");
            if (v.size() == 2) {
                String dappId = v.get(0);
                String version = v.get(1);
                AppContextDepend adepend = new AppContextDepend();
                AppContextWrapper wrapper = new AppContextWrapper(adepend);
                wrapper.setDependAppId(dappId);
                wrapper.setDependVersions(version);
                String env = AWSServerConf.getVersion();
                AppsAPIManager.getInstance().saveDepend(appConfigFile, adepend);
            }
        }
        catch (Exception e) {
            ro.err();
            ro.msg(ExceptionUtil.getMessage(e));
            System.err.println(e.getMessage());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        xmlValues.put("name", appName);
        xmlValues.put("version", versionNo);
        xmlValues.put("installDate", sdf.format(new Date()));
        xmlValues.put("categoryVisible", categoryVisible);
        xmlValues.put("developer", developerName);
        xmlValues.put("buildNo", buildNo);
        xmlValues.put("description", Base64Util.base64Decoder((String)desc));
        xmlValues.put("details", Base64Util.base64Decoder((String)details));
        xmlValues.put("modelAdministrator", modelAdministrator);
        try {
            AppsAPIManager.getInstance().saveKeyValue(appConfigFile, xmlValues);
            ro = ResponseObject.newOkResponse();
        }
        catch (Exception e) {
            ro.err();
            ro.msg(ExceptionUtil.getMessage(e));
            System.err.println(e.getMessage());
        }
        HashMap tag = new HashMap();
        HashMap<String, String> developerAttrValue = new HashMap<String, String>();
        if (!developerURL.equals("")) {
            developerAttrValue.put("url", developerURL);
        }
        if (!tablePrefix.equals("")) {
            developerAttrValue.put("tablePrefix", tablePrefix);
        }
        developerAttrValue.put("id", DeveloperKey.getDeveloperId());
        tag.put("developer", developerAttrValue);
        try {
            AppsAPIManager.getInstance().saveAttrValue(appConfigFile, tag);
        }
        catch (Exception e1) {
            ro.err();
            ro.msg(ExceptionUtil.getMessage(e1));
            System.err.println(e1.getMessage());
        }
        JSONObject appMaster = appJson.getJSONObject("appMaster");
        if (appMaster != null) {
            for (String teamId : appMaster.keySet()) {
                AppTeam team = AppPlatformConfig.getAppTeamById((String)teamId);
                Map permission = team.getAppsPermissions();
                JSONObject json = appMaster.getJSONObject(teamId);
                permission.put(appId, String.valueOf(json.getBoolean("vright") != false ? "A" : "") + (json.getBoolean("right") != false ? "B" : ""));
                team.setAppsPermissions(permission);
                AppPlatformConfig.modifyTeam((AppTeam)team);
            }
        }
        try {
            AppContext newApp = AppsResource.validateApp((File)appConfigDir);
            if (newApp != null) {
                AppContext faterApp;
                AppContext app = AppsResource.appRegister((String)"install", (String)appId);
                if (newApp.getDepend() != null && (faterApp = AppsAPIManager.getInstance().getAppContext(newApp.getDepend().getAppId())) != null) {
                    AppContextWrapper warp = new AppContextWrapper(app);
                    warp.setParentContext(faterApp);
                    warp.setModelAdministrator(modelAdministrator);
                }
                if (start) {
                    AppsAPIManager.getInstance().start(ctx, app);
                }
                ro = ResponseObject.newOkResponse();
                ro.msg(I18nRes.findValue("_bpm.platform", "\u5e94\u7528\u521b\u5efa\u6210\u529f"));
            }
        }
        catch (AppContainerException e) {
            ro.err();
            ro.msg(ExceptionUtil.getMessage(e));
            System.err.println(e.getMessage());
            return ro;
        }
        return ro;
    }

    public static ResponseObject saveApp(UserContext ctx, String appId, JSONObject elements) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = SDK.getAppAPI().getAppContext(appId);
        File appConfigFile = new File(String.valueOf(app.getPath()) + "manifest.xml");
        HashMap<String, String> xmlValues = new HashMap<String, String>();
        String resourceType = null;
        if (elements.containsKey((Object)"resourceType")) {
            resourceType = elements.getString("resourceType");
        }
        if (!UtilString.isEmpty(resourceType)) {
            File byodFolder = new File(String.valueOf(app.getPath()) + "mobile" + "/");
            byodFolder.mkdirs();
            File profileFile = new File(byodFolder, "mobile-profile.xml");
            File profileTpl = new File("conf/tpl/app-mobile-profile.tpl");
            try {
                if (!profileFile.exists()) {
                    UtilFile.copyFile(profileTpl, profileFile);
                }
                AMCUtil.saveMobileProfile(elements, profileFile);
            }
            catch (Exception e) {
                ro.err();
                ro.msg(ExceptionUtil.getMessage(e));
            }
        }
        JSONArray requireArray = new JSONArray();
        String require1 = UtilJson.optString(elements, "require");
        if (!UtilString.isEmpty(require1)) {
            requireArray = JSON.parseArray((String)require1);
        }
        String manageUser = UtilJson.optString(elements, "manageUser");
        manageUser = SDK.getORGAPI().getUserIds(manageUser).replaceAll("\"", "");
        String manageRole = UtilJson.optString(elements, "manageRole").replaceAll(",", " ");
        String modelAdministrator = String.valueOf(manageUser.trim()) + " " + manageRole.trim();
        String developerURL = UtilJson.optString(elements, "developerURL");
        String tablePrefix = UtilJson.optString(elements, "tablePrefix");
        String appName = UtilJson.optString(elements, "appName");
        String versionNo = UtilJson.optString(elements, "versionNo");
        int buildNo = elements.getIntValue("buildNo");
        boolean categoryVisible = elements.getBooleanValue("categoryVisible");
        String developerName = UtilJson.optString(elements, "developerName");
        if (Quota.isDeveloperService()) {
            developerName = DeveloperKey.getDeveloperName();
            developerURL = DeveloperKey.getDeveloperUrl();
            tablePrefix = DeveloperKey.getTablePrefix();
        }
        String details = UtilJson.optString(elements, "details1");
        String description = UtilJson.optString(elements, "overview1");
        boolean reloadable = elements.containsKey((Object)"reloadable") ? elements.getBoolean("reloadable").booleanValue() : SDK.getAppAPI().getAppContext(appId).isReloadable();
        String installListener = UtilJson.optString(elements, "installListener");
        String startListener = UtilJson.optString(elements, "startListener");
        String stopListener = UtilJson.optString(elements, "stopListener");
        String upgradeListener = UtilJson.optString(elements, "upgradeListener");
        String uninstallListener = UtilJson.optString(elements, "uninstallListener");
        String productId = UtilJson.optString(elements, "productId");
        String dependstr = UtilJson.optString(elements, "parent_app");
        String pluginListener = UtilJson.optString(elements, "pluginListener");
        boolean isOK = AppNaming.tablePrefix((String)tablePrefix);
        if (!isOK) {
            ro.warn(I18nRes.findValue("_bpm.platform", "\u7269\u7406\u8868\u524d\u7f00\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42"));
            return ro;
        }
        String dappId = "";
        String version = "1.0";
        List<AppContextRequireImpl> list = new ArrayList();
        try {
            UtilString str = new UtilString(dependstr);
            List<String> v = str.split("-");
            if (v.size() == 2) {
                List requires;
                dappId = v.get(0);
                version = v.get(1);
                if (requireArray.size() > 0) {
                    int i = 0;
                    while (i < requireArray.size()) {
                        JSONObject item = requireArray.getJSONObject(i);
                        AppContextRequireImpl require = new AppContextRequireImpl();
                        require.setAppId(item.getString("appId"));
                        require.setNotActiveHandler(item.getString("handler"));
                        list.add(require);
                        ++i;
                    }
                } else if (!elements.containsKey((Object)"require") && (requires = SDK.getAppAPI().getAppContext(appId).getRequires()) != null) {
                    list = requires;
                }
            }
        }
        catch (Exception e) {
            ro.err(ExceptionUtil.getMessage(e));
        }
        double versionN = 0.0;
        if (!UtilString.isEmpty(resourceType)) {
            String[] splits = versionNo.split("\\.");
            if (splits.length > 2) {
                versionN = Double.parseDouble(String.valueOf(splits[0]) + "." + splits[1]);
                buildNo = Integer.valueOf(versionNo.substring(versionNo.lastIndexOf(".") + 1, versionNo.length()));
            } else {
                versionN = Double.parseDouble(versionNo);
            }
        } else {
            versionN = Double.parseDouble(versionNo);
        }
        xmlValues.put("name", appName);
        xmlValues.put("version", String.valueOf(versionN));
        xmlValues.put("buildNo", String.valueOf(buildNo));
        xmlValues.put("categoryVisible", String.valueOf(categoryVisible));
        xmlValues.put("developer", developerName);
        xmlValues.put("depend", dappId);
        xmlValues.put("description", Base64Util.base64Decoder((String)description));
        xmlValues.put("details", Base64Util.base64Decoder((String)details));
        xmlValues.put("productId", productId);
        xmlValues.put("modelAdministrator", modelAdministrator);
        xmlValues.put("reloadable", String.valueOf(reloadable));
        xmlValues.put("installListener", installListener);
        xmlValues.put("startListener", startListener);
        xmlValues.put("stopListener", stopListener);
        xmlValues.put("upgradeListener", upgradeListener);
        xmlValues.put("uninstallListener", uninstallListener);
        xmlValues.put("pluginListener", pluginListener);
        HashMap tag = new HashMap();
        HashMap<String, String> attrValue = new HashMap<String, String>();
        if (!developerURL.equals("")) {
            attrValue.put("url", developerURL);
        }
        if (!tablePrefix.equals("")) {
            attrValue.put("tablePrefix", tablePrefix);
        }
        HashMap<String, String> attrValue2 = new HashMap<String, String>();
        attrValue2.put("versions", version);
        tag.put("depend", attrValue2);
        try {
            AppsAPIManager.getInstance().saveKeyValue(appConfigFile, xmlValues);
            AppsAPIManager.getInstance().saveAttrValue(appConfigFile, tag);
            AppsAPIManager.getInstance().saveRequires(appConfigFile, list);
            ro = ResponseObject.newOkResponse();
        }
        catch (Exception e) {
            ro.err(ExceptionUtil.getMessage(e));
        }
        app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app != null) {
            AppContextWrapper wrapper = AppContextWrapper.createWrapper((AppContext)app);
            wrapper.setBuildNo(buildNo);
            wrapper.setCategoryVisible(categoryVisible);
            wrapper.setName(appName);
            wrapper.setDeveloperName(developerName);
            wrapper.setDeveloperUrl(developerURL);
            wrapper.setInstallListener(installListener);
            wrapper.setDescription(Base64Util.base64Decoder((String)description));
            wrapper.setDetails(Base64Util.base64Decoder((String)details));
            wrapper.setPluginListener(pluginListener);
            wrapper.setProductId(productId);
            wrapper.setModelAdministrator(modelAdministrator);
            wrapper.setReloadable(reloadable);
            wrapper.setStartListener(startListener);
            wrapper.setStopListener(stopListener);
            wrapper.setTablePrefix(tablePrefix);
            wrapper.setPluginListener(pluginListener);
            wrapper.setUninstallListener(uninstallListener);
            wrapper.setBuildNo(buildNo);
            wrapper.setVersion(versionN);
            try {
                UtilString str = new UtilString(dependstr);
                List<String> v = str.split("-");
                if (v.size() == 2) {
                    dappId = v.get(0);
                    version = v.get(1);
                    AppContext parentContext = AppsAPIManager.getInstance().getAppContext(dappId);
                    AppContextWrapper currentWrapper = AppContextWrapper.createWrapper((AppContext)app);
                    currentWrapper.setParentContext(parentContext);
                }
                ro.ok();
            }
            catch (Exception e) {
                ro.err(ExceptionUtil.getMessage(e));
            }
            AMCUtil.saveDeployInfo(ctx, appConfigFile, elements, ro, appId);
        }
        return ro;
    }

    private static void saveDeployInfo(UserContext ctx, File appConfigFile, JSONObject elements, ResponseObject ro, String appId) {
        DeploymentFunction function;
        String functionId;
        Object model;
        DeploymentDirectory directory;
        String directoryId;
        String pid;
        String nodeId;
        JSONObject obj;
        JSONArray nodeArray = elements.getJSONArray("checkNodes");
        NavigationFunction functionDao = NavigationDaoFactory.createNavigationFunction();
        int num = 0;
        int dirSize = 0;
        int funSize = 0;
        int i = 0;
        while (i < nodeArray.size()) {
            obj = nodeArray.getJSONObject(i);
            nodeId = UtilJson.optString(obj, "id");
            pid = UtilJson.optString(obj, "pid");
            if (!("root".equals(nodeId) || "system".equals(nodeId) || nodeId == null || "".equals(nodeId) || nodeId.length() <= 2)) {
                if (pid != null && !"".equals(pid) && pid.length() > 2) {
                    pid = pid.substring(2);
                }
                if (nodeId.startsWith("d_")) {
                    directoryId = nodeId.substring(2);
                    directory = new DeploymentDirectory();
                    model = NavigationDirectoryCache.getModel(directoryId);
                    if (model != null) {
                        ++dirSize;
                    }
                }
                if (nodeId.startsWith("f_")) {
                    functionId = nodeId.substring(2);
                    function = new DeploymentFunction();
                    model = NavigationFunctionCache.getModel(functionId);
                    if (model != null) {
                        ++funSize;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < nodeArray.size()) {
            obj = nodeArray.getJSONObject(i);
            nodeId = UtilJson.optString(obj, "id");
            pid = UtilJson.optString(obj, "pid");
            if (!("root".equals(nodeId) || "system".equals(nodeId) || nodeId == null || "".equals(nodeId) || nodeId.length() <= 2)) {
                NavigationFunctionModelImpl fmodel;
                if (num == 0) {
                    try {
                        ManifestXML.getInstance().clearElement(appConfigFile, "deployment");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    List<NavigationFunctionModel> list = NavigationFunctionCache.getListOfAppId(appId);
                    for (NavigationFunctionModel model2 : list) {
                        fmodel = (NavigationFunctionModelImpl)model2;
                        fmodel.setAppId("");
                        functionDao.update(fmodel);
                    }
                }
                ++num;
                if (pid != null && !"".equals(pid) && pid.length() > 2) {
                    pid = pid.substring(2);
                }
                if (nodeId.startsWith("s_")) {
                    DeploymentSystem system = new DeploymentSystem();
                    String systemId = nodeId.substring(2);
                    model = NavigationSystemCache.getModel(systemId);
                    if (model != null) {
                        system.setId(systemId);
                        system.setName(JavascriptEscape.escape(NavigationUtil.getLangName(ctx.getLanguage(), model.getSystemName())));
                        system.setIcon16(model.getIcon16());
                        system.setIcon64(model.getIcon64());
                        system.setNotifier(model.getNotifier());
                        system.setIcon96(model.getIcon96());
                        system.setTarget(model.getLinkTarget());
                        system.setUrl(model.getLinkUrl());
                        system.setDeployType("2");
                        system.setSource(0);
                        try {
                            ManifestXML.getInstance().saveDeploymentSystem(appConfigFile, system, appId);
                        }
                        catch (Exception e) {
                            ro.err(ExceptionUtil.getMessage(e));
                        }
                    }
                }
                if (nodeId.startsWith("d_")) {
                    directoryId = nodeId.substring(2);
                    directory = new DeploymentDirectory();
                    model = NavigationDirectoryCache.getModel(directoryId);
                    if (model != null) {
                        directory.setId(directoryId);
                        directory.setName(JavascriptEscape.escape(NavigationUtil.getLangName(ctx.getLanguage(), model.getDirectoryName())));
                        directory.setIcon16(model.getIcon16());
                        directory.setIcon64(model.getIcon64());
                        directory.setNotifier(model.getNotifier());
                        directory.setIcon96(model.getIcon96());
                        directory.setTarget(model.getLinkTarget());
                        directory.setUrl(model.getLinkUrl());
                        directory.setDeployType("2");
                        directory.setSource(0);
                        directory.setOrderIndex(model.getOrderIndex());
                        try {
                            ManifestXML.getInstance().saveDeploymentDirectory(appConfigFile, directory, pid, appId, dirSize > 1);
                        }
                        catch (Exception e) {
                            ro.err(ExceptionUtil.getMessage(e));
                        }
                    }
                }
                if (nodeId.startsWith("f_")) {
                    functionId = nodeId.substring(2);
                    function = new DeploymentFunction();
                    model = NavigationFunctionCache.getModel(functionId);
                    if (model != null) {
                        function.setId(functionId);
                        function.setName(JavascriptEscape.escape(NavigationUtil.getLangName(ctx.getLanguage(), model.getFunctionName())));
                        function.setIcon16(model.getIcon16());
                        function.setIcon64(model.getIcon64());
                        function.setNotifier(model.getNotifier());
                        function.setIcon96(model.getIcon96());
                        function.setTarget(model.getLinkTarget());
                        function.setUrl(model.getLinkUrl());
                        function.setDeployType("2");
                        function.setSource(0);
                        function.setOrderIndex(model.getOrderIndex());
                        try {
                            ManifestXML.getInstance().saveDeploymentFunction(appConfigFile, function, pid, appId, funSize > 1);
                        }
                        catch (Exception e) {
                            ro.err(ExceptionUtil.getMessage(e));
                        }
                        fmodel = (NavigationFunctionModelImpl)model;
                        fmodel.setAppId(appId);
                        functionDao.update(fmodel);
                    }
                }
            }
            ++i;
        }
    }
}

