/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.util;

import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.bpms.util.UtilDate;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.joda.time.DateTime;

public class AppComparator {

    public static class AppDateComparatorASC
    implements Comparator<AppContext> {
        @Override
        public int compare(AppContext o1, AppContext o2) {
            String timeFormat = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat format = new SimpleDateFormat(timeFormat);
            DateTime o1startTime = new DateTime((Object)new Date());
            DateTime o2startTime = new DateTime((Object)new Date());
            if (o1.getStartTime() != null) {
                o1startTime = new DateTime(UtilDate.getTimes(format.format(o1.getStartTime()), timeFormat));
            }
            if (o2.getStartTime() != null) {
                o2startTime = new DateTime(UtilDate.getTimes(format.format(o2.getStartTime()), timeFormat));
            }
            return Long.valueOf(new Date().getTime() - o2startTime.getMillis()).compareTo(new Date().getTime() - o1startTime.getMillis());
        }
    }

    public static class AppDateComparatorDESC1
    implements Comparator<AppContext> {
        @Override
        public int compare(AppContext o1, AppContext o2) {
            String timeFormat = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat format = new SimpleDateFormat(timeFormat);
            DateTime o1startTime = new DateTime((Object)new Date());
            DateTime o2startTime = new DateTime((Object)new Date());
            if (o1.getStartTime() != null) {
                o1startTime = new DateTime(UtilDate.getTimes(format.format(o1.getStartTime()), timeFormat));
            }
            if (o2.getStartTime() != null) {
                o2startTime = new DateTime(UtilDate.getTimes(format.format(o2.getStartTime()), timeFormat));
            }
            return Long.valueOf(new Date().getTime() - o1startTime.getMillis()).compareTo(new Date().getTime() - o2startTime.getMillis());
        }
    }

    public static class LastModifiedFileComparator
    implements Comparator<File> {
        @Override
        public int compare(File f1, File f2) {
            File file1 = f1;
            File file2 = f2;
            long result = file2.lastModified() - file1.lastModified();
            if (result < 0L) {
                return -1;
            }
            if (result > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class LogDateComparatorASC
    implements Comparator<AppLogMsg> {
        @Override
        public int compare(AppLogMsg o1, AppLogMsg o2) {
            return Long.valueOf(o1.getTime()).compareTo(o2.getTime());
        }
    }

    public static class MessageDateComparatorDESC
    implements Comparator<AppLogMsg> {
        @Override
        public int compare(AppLogMsg o1, AppLogMsg o2) {
            return Long.valueOf(o2.getTime()).compareTo(o1.getTime());
        }
    }
}

