/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.util;

import com.actionsoft.apps.lifecycle.AppInstaller;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppsResource;
import com.actionsoft.apps.resource.ManifestXML;
import com.actionsoft.apps.resource.deployment.DeploymentDirectory;
import com.actionsoft.apps.resource.deployment.DeploymentFunction;
import com.actionsoft.apps.resource.deployment.DeploymentSystem;
import com.actionsoft.apps.resource.deployment.NavTpl;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationFunctionModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationSystemModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.i18n.I18nRes;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class DeployUtil {
    public static String createNavSystem(NavTpl nav, String appId) {
        NavigationSystemModelImpl systemModel = new NavigationSystemModelImpl();
        systemModel.setAppId(appId);
        systemModel.setId(nav.getId());
        systemModel.setSystemName(JavascriptEscape.unescape(nav.getName()));
        systemModel.setIcon16(nav.getIcon16(appId));
        systemModel.setIcon64(nav.getIcon64(appId));
        systemModel.setNotifier(nav.getNotifier());
        systemModel.setIcon96(nav.getIcon96(appId));
        systemModel.setLinkUrl(nav.getUrl());
        systemModel.setLinkTarget(nav.getTarget());
        int r = NavigationDaoFactory.createNavigationSystem().insert(systemModel);
        if (r > -1) {
            return systemModel.getId();
        }
        return "";
    }

    public static String createNavDirectory(NavTpl nav, String appId, String systemId) {
        int r;
        NavigationDirectoryModelImpl directoryModel = new NavigationDirectoryModelImpl();
        directoryModel.setAppId(appId);
        directoryModel.setId(nav.getId());
        directoryModel.setDirectoryName(JavascriptEscape.unescape(nav.getName()));
        directoryModel.setIcon16(nav.getIcon16(appId));
        directoryModel.setIcon64(nav.getIcon64(appId));
        directoryModel.setNotifier(nav.getNotifier());
        directoryModel.setIcon96(nav.getIcon96(appId));
        directoryModel.setLinkUrl(nav.getUrl());
        directoryModel.setLinkTarget(nav.getTarget());
        directoryModel.setSystemId(systemId);
        if (nav.getOrderIndex() > 0) {
            directoryModel.setOrderIndex(nav.getOrderIndex());
        }
        if ((r = NavigationDaoFactory.createNavigationDirectory().insert(directoryModel)) > -1) {
            return directoryModel.getId();
        }
        return "";
    }

    public static boolean createNavFucntion(DeploymentFunction deploymentFunction, String appId, String directoryId) {
        Serializable model;
        NavigationDirectoryModel dmodel;
        NavigationFunctionModelImpl functionModel = new NavigationFunctionModelImpl();
        boolean dirIsExt = true;
        boolean systemExt = true;
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        DeploymentSystem deploymentSystem = DeployUtil.getSystemFromDir(appConfigFile, directoryId);
        DeploymentDirectory deploymentDirectory = DeployUtil.getDeploymentFromDirId(directoryId, appConfigFile);
        systemExt = DeployUtil.isExtSystemFromDir(deploymentSystem);
        dirIsExt = DeployUtil.isExtDeploymentFromDirId(deploymentDirectory);
        if (!dirIsExt && (dmodel = NavigationDirectoryCache.getModel(directoryId)) != null) {
            systemExt = true;
            dirIsExt = true;
        }
        if (systemExt && dirIsExt) {
            model = NavigationFunctionCache.getModel(deploymentFunction.getId());
            if (model == null) {
                int r;
                functionModel.setAppId(appId);
                functionModel.setDirectoryId(directoryId);
                functionModel.setId(deploymentFunction.getId());
                functionModel.setFunctionName(JavascriptEscape.unescape(deploymentFunction.getName()));
                functionModel.setIcon16(deploymentFunction.getIcon16(appId));
                functionModel.setIcon64(deploymentFunction.getIcon64(appId));
                functionModel.setNotifier(deploymentFunction.getNotifier());
                functionModel.setIcon96(deploymentFunction.getIcon96(appId));
                functionModel.setLinkUrl(deploymentFunction.getUrl());
                functionModel.setLinkTarget(deploymentFunction.getTarget());
                if (deploymentFunction.getOrderIndex() > 0) {
                    functionModel.setOrderIndex(deploymentFunction.getOrderIndex());
                }
                return (r = NavigationDaoFactory.createNavigationFunction().insert(functionModel)) > -1;
            }
            return true;
        }
        if (systemExt && !dirIsExt) {
            NavigationFunctionModel funModel;
            model = NavigationDirectoryCache.getModel(directoryId);
            if (model == null) {
                NavigationDirectoryModelImpl navDireModel = new NavigationDirectoryModelImpl();
                navDireModel.setAppId(appId);
                navDireModel.setSystemId(deploymentSystem.getId());
                navDireModel.setId(directoryId);
                navDireModel.setDirectoryName(JavascriptEscape.unescape(deploymentDirectory.getName()));
                navDireModel.setIcon16(deploymentDirectory.getIcon16(appId));
                navDireModel.setIcon64(deploymentDirectory.getIcon64(appId));
                navDireModel.setNotifier(deploymentDirectory.getNotifier());
                navDireModel.setIcon96(deploymentDirectory.getIcon96(appId));
                navDireModel.setLinkUrl(deploymentDirectory.getUrl());
                navDireModel.setLinkTarget(deploymentDirectory.getTarget());
                if (deploymentDirectory.getOrderIndex() > 0) {
                    navDireModel.setOrderIndex(deploymentDirectory.getOrderIndex());
                }
                int n = NavigationDaoFactory.createNavigationDirectory().insert(navDireModel);
            }
            if ((funModel = NavigationFunctionCache.getModel(deploymentFunction.getId())) == null) {
                int rr;
                functionModel.setAppId(appId);
                functionModel.setDirectoryId(directoryId);
                functionModel.setId(deploymentFunction.getId());
                functionModel.setFunctionName(JavascriptEscape.unescape(deploymentFunction.getName()));
                functionModel.setIcon16(deploymentFunction.getIcon16(appId));
                functionModel.setIcon64(deploymentFunction.getIcon64(appId));
                functionModel.setNotifier(deploymentFunction.getNotifier());
                functionModel.setIcon96(deploymentFunction.getIcon96(appId));
                functionModel.setLinkUrl(deploymentFunction.getUrl());
                functionModel.setLinkTarget(deploymentFunction.getTarget());
                if (deploymentFunction.getOrderIndex() > 0) {
                    functionModel.setOrderIndex(deploymentFunction.getOrderIndex());
                }
                return (rr = NavigationDaoFactory.createNavigationFunction().insert(functionModel)) > -1;
            }
            return true;
        }
        return DeployUtil.createThreeNav(appId, deploymentSystem, deploymentDirectory, deploymentFunction, false, "");
    }

    public static String removeAppFunctionDeployInfo(String appId, NavigationFunctionModel functionModel) {
        StringBuffer error = new StringBuffer();
        if (functionModel != null && functionModel.getAppId().equals(appId)) {
            int r = 0;
            try {
                r = NavigationDaoFactory.createNavigationFunction().delete(functionModel.getId());
                if (r > 0) {
                    error.append("1");
                } else {
                    error.append("-1");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error.append("-1");
            }
        }
        return error.toString();
    }

    public static String removeAppDirectoryDeployInfo(String appId, NavigationDirectoryModel directoryModel) {
        StringBuffer error = new StringBuffer();
        if (directoryModel != null) {
            List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(directoryModel.getId());
            if (directoryModel.getAppId().equals(appId) && functions.size() == 0) {
                try {
                    int r = NavigationDaoFactory.createNavigationDirectory().delete(directoryModel.getId());
                    if (r > 0) {
                        error.append("1");
                    } else {
                        error.append("-1");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error.append("-1");
                }
            }
        }
        return error.toString();
    }

    public static String removeAppSystemDeployInfo(String appId, NavigationSystemModel systemModel) {
        StringBuffer error = new StringBuffer();
        if (systemModel != null) {
            List<NavigationDirectoryModel> directorys = NavigationDirectoryCache.getListOfSystem(systemModel.getId());
            if (systemModel.getAppId().equals(appId) && directorys.size() == 0) {
                int r = 0;
                try {
                    r = NavigationDaoFactory.createNavigationSystem().delete(systemModel.getId());
                    if (r > 0) {
                        error.append("1");
                    } else {
                        error.append("-1");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error.append("-1");
                }
            }
        }
        return error.toString();
    }

    public static String modifyAppSystemActivity(String appId, NavigationSystemModel systemModel, boolean isActivity) {
        StringBuffer error = new StringBuffer();
        if (systemModel != null) {
            List<NavigationDirectoryModel> directorys = NavigationDirectoryCache.getListOfSystem(systemModel.getId());
            if (systemModel.getAppId().equals(appId) && directorys.size() == 0) {
                int r = 0;
                try {
                    NavigationSystemModelImpl sysImpl = (NavigationSystemModelImpl)systemModel;
                    if (sysImpl != null) {
                        sysImpl.setActivity(isActivity);
                        r = NavigationDaoFactory.createNavigationSystem().update(sysImpl);
                    }
                    if (r > 0) {
                        error.append("1");
                    } else {
                        error.append("-1");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error.append("-1");
                }
            }
        }
        return error.toString();
    }

    public static String modifyAppFunctionActivity(String appId, NavigationFunctionModel functionModel, boolean isActivity) {
        StringBuffer error = new StringBuffer();
        if (functionModel != null && functionModel.getAppId().equals(appId)) {
            int r = 0;
            try {
                NavigationFunctionModelImpl functionModelImpl = (NavigationFunctionModelImpl)functionModel;
                if (functionModelImpl != null) {
                    functionModelImpl.setActivity(isActivity);
                    r = NavigationDaoFactory.createNavigationFunction().update(functionModelImpl);
                }
                if (r > 0) {
                    error.append("1");
                } else {
                    error.append("-1");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error.append("-1");
            }
        }
        return error.toString();
    }

    public static String modifyAppDirectoryActivity(String appId, NavigationDirectoryModel directoryModel, boolean isActivity) {
        StringBuffer error = new StringBuffer();
        if (directoryModel != null) {
            List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(directoryModel.getId());
            if (directoryModel.getAppId().equals(appId) && functions.size() == 0) {
                int r = 0;
                try {
                    NavigationDirectoryModelImpl navigationDirectoryModelImpl = (NavigationDirectoryModelImpl)directoryModel;
                    if (navigationDirectoryModelImpl != null) {
                        navigationDirectoryModelImpl.setActivity(isActivity);
                        r = NavigationDaoFactory.createNavigationDirectory().update(navigationDirectoryModelImpl);
                    }
                    if (r > 0) {
                        error.append("1");
                    } else {
                        error.append("-1");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    error.append("-1");
                }
            }
        }
        return error.toString();
    }

    public static boolean createThreeNav(String appId, DeploymentSystem deploymentSystem, DeploymentDirectory deploymentDirectory, DeploymentFunction deploymentFunction, boolean isShowlog, String mes) {
        if (deploymentSystem != null) {
            String id = deploymentSystem.getId();
            NavigationSystemModel sysModel = NavigationSystemCache.getModel(id);
            if (sysModel == null) {
                id = DeployUtil.createNavSystem((NavTpl)deploymentSystem, appId);
            }
            if (!id.equals("")) {
                String did = deploymentDirectory.getId();
                NavigationDirectoryModel dirModel = NavigationDirectoryCache.getModel(did);
                if (dirModel == null) {
                    did = DeployUtil.createNavDirectory((NavTpl)deploymentDirectory, appId, id);
                }
                if (!did.equals("")) {
                    if (isShowlog) {
                        AppInstaller.deployMessageMap.put(appId, "\u4fe1\u606f:[" + mes + "]\u81ea\u52a8\u521b\u5efa\u4e09\u7ea7\u5bfc\u822a\u83dc\u5355");
                    }
                    String fid = deploymentFunction.getId();
                    NavigationFunctionModel fmodel = NavigationFunctionCache.getModel(fid);
                    boolean iscreat = true;
                    if (fmodel == null) {
                        iscreat = DeployUtil.createNavFucntion(deploymentFunction, appId, did);
                    }
                    return iscreat;
                }
            }
        }
        return false;
    }

    private static DeploymentDirectory getDeploymentFromDirId(String directoryId, File appConfigFile) {
        DeploymentDirectory directory = DeployUtil.getDeploymentDirectoryById(appConfigFile, directoryId);
        return directory;
    }

    private static boolean isExtDeploymentFromDirId(DeploymentDirectory directory) {
        String isHas;
        return directory != null && !(isHas = DeployUtil.getDirectoryNameIsHas(directory)).equals("");
    }

    public static String getSystemNameIsHas(DeploymentSystem deploymentSystem) {
        String id = "";
        Iterator ns = NavigationSystemCache.getCache().iterator();
        while (ns.hasNext()) {
            NavigationSystemModel navigationSystemModel = (NavigationSystemModel)ns.next();
            if (!navigationSystemModel.getId().equals(deploymentSystem.getId())) continue;
            return navigationSystemModel.getId();
        }
        return id;
    }

    public static String getDirectoryNameIsHas(DeploymentDirectory deploymentDirectory) {
        String id = "";
        Iterator nd = NavigationDirectoryCache.getCache().iterator();
        while (nd.hasNext()) {
            NavigationDirectoryModel navigationDirectoryModel = (NavigationDirectoryModel)nd.next();
            if (!deploymentDirectory.getId().equals(navigationDirectoryModel.getId())) continue;
            return navigationDirectoryModel.getId();
        }
        return id;
    }

    public static String getFunctionNameIsHas(DeploymentFunction deploymentFunction) {
        Iterator nf = NavigationFunctionCache.getCache().iterator();
        while (nf.hasNext()) {
            NavigationFunctionModel navigationFunctionModel = (NavigationFunctionModel)nf.next();
            String name = NavigationUtil.getLangName(I18nRes.getUserLanguage(), navigationFunctionModel.getFunctionName());
            if (deploymentFunction.getName().equals("") || !name.equals(deploymentFunction.getName()) || !deploymentFunction.getUrl().equals(navigationFunctionModel.getLinkUrl())) continue;
            return navigationFunctionModel.getId();
        }
        return "";
    }

    public static NavigationSystemModel getSystemModelByDeploymentSystem(DeploymentSystem deploymentSystem) {
        Iterator ns = NavigationSystemCache.getCache().iterator();
        while (ns.hasNext()) {
            NavigationSystemModel navigationSystemModel = (NavigationSystemModel)ns.next();
            if (!deploymentSystem.getUrl().equals(navigationSystemModel.getLinkUrl()) || !deploymentSystem.getId().equals(navigationSystemModel.getId())) continue;
            return navigationSystemModel;
        }
        return null;
    }

    public static NavigationDirectoryModel getDirectoryModelByDeploymentDirectory(DeploymentDirectory deploymentDirectory) {
        Iterator nd = NavigationDirectoryCache.getCache().iterator();
        while (nd.hasNext()) {
            NavigationDirectoryModel navigationDirectoryModel = (NavigationDirectoryModel)nd.next();
            String name = NavigationUtil.getLangName(I18nRes.getUserLanguage(), navigationDirectoryModel.getDirectoryName());
            if (!name.equals(JavascriptEscape.unescape(deploymentDirectory.getName())) || !deploymentDirectory.getUrl().equals(navigationDirectoryModel.getLinkUrl())) continue;
            return navigationDirectoryModel;
        }
        return null;
    }

    public static NavigationFunctionModel getFunctionByDeploymentFunction(DeploymentFunction deploymentFunction) {
        Iterator nf = NavigationFunctionCache.getCache().iterator();
        while (nf.hasNext()) {
            NavigationFunctionModel navigationFunctionModel = (NavigationFunctionModel)nf.next();
            if (!navigationFunctionModel.getId().equals(deploymentFunction.getId())) continue;
            return navigationFunctionModel;
        }
        return null;
    }

    public static DeploymentSystem getSystemFromDir(File appConfigFile, String directoryId) {
        List<DeploymentSystem> systems = DeployUtil.getDeploymentSystems(appConfigFile);
        for (DeploymentSystem deploymentSystem : systems) {
            List<DeploymentDirectory> dirs = DeployUtil.getDeploymentDirectorys(appConfigFile, deploymentSystem.getId());
            for (DeploymentDirectory deploymentDirectory : dirs) {
                if (!directoryId.equals(deploymentDirectory.getId())) continue;
                return deploymentSystem;
            }
        }
        return null;
    }

    public static boolean isExtSystemFromDir(DeploymentSystem deploymentSystem) {
        String isHash;
        return deploymentSystem != null && !(isHash = DeployUtil.getSystemNameIsHas(deploymentSystem)).equals("");
    }

    public static List<DeploymentSystem> getDeploymentSystems(File appConfigFile) {
        return ManifestXML.getInstance().getDeploymentSystems(appConfigFile);
    }

    public static List<DeploymentFunction> getDeploymentFunctions(File appConfigFile) {
        return ManifestXML.getInstance().getDeploymentFunctions(appConfigFile);
    }

    public static DeploymentSystem getDeploymentSystemById(File appConfigFile, String id) {
        return ManifestXML.getInstance().getDeploymentSystemById(appConfigFile, id);
    }

    public static DeploymentDirectory getDeploymentDirectoryById(File appConfigFile, String id) {
        return ManifestXML.getInstance().getDeploymentDirectoryById(appConfigFile, id);
    }

    public static DeploymentFunction getDeploymentFunctionById(File appConfigFile, String id) {
        return ManifestXML.getInstance().getDeploymentFunctionsById(appConfigFile, id);
    }

    public static List<DeploymentDirectory> getDeploymentDirectorys(File appConfigFile, String systemId) {
        return ManifestXML.getInstance().getDeploymentDirectorys(appConfigFile, systemId);
    }

    public static List<DeploymentDirectory> getDeploymentDirectorys(File appConfigFile) {
        return ManifestXML.getInstance().getDeploymentDirectorys(appConfigFile);
    }

    public DeploymentDirectory getDeploymentDirectorysById(File appConfigFile, String id, String systemId) {
        return ManifestXML.getInstance().getDeploymentDirectorysById(appConfigFile, id, systemId);
    }

    public static List<DeploymentFunction> getDeploymentFunctions(File appConfigFile, String deploymentDirectoryId) {
        return ManifestXML.getInstance().getDeploymentFunctions(appConfigFile, deploymentDirectoryId);
    }

    public DeploymentFunction getDeploymentFunctionById(File appConfigFile, String id, String deploymentDirectoryId) {
        return ManifestXML.getInstance().getDeploymentFunctionById(appConfigFile, id, deploymentDirectoryId);
    }

    public static void deleteAppPortalAndSystemResource(AppContext app) throws AppContainerException {
        String scanXML = String.valueOf(app.getPath()) + "manifest.xml";
        File xmlFile = new File(scanXML);
        if (xmlFile.exists()) {
            AppsResource.updateByFile((AppContext)app, (File)xmlFile);
        }
        List systems = app.getDeploymentMenus();
        String appId = app.getId();
        if (systems != null && systems.size() > 0) {
            for (DeploymentSystem deploymentSystem : systems) {
                NavigationSystemModel systemModel;
                List dirs = deploymentSystem.getDeploymentDirectory();
                for (DeploymentDirectory deploymentDirectory : dirs) {
                    NavigationDirectoryModel directoryModel;
                    List functions = deploymentDirectory.getDeploymentFunction();
                    for (DeploymentFunction deploymentFunction : functions) {
                        NavigationFunctionModel functionModel;
                        if (deploymentFunction == null || (functionModel = NavigationFunctionCache.getModel(deploymentFunction.getId())) == null) continue;
                        String mes = DeployUtil.removeAppFunctionDeployInfo(appId, functionModel);
                        if (mes.equals("-1")) {
                            AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]\u5220\u9664\u5931\u8d25"));
                            continue;
                        }
                        AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]\u5220\u9664\u6210\u529f"));
                    }
                    if (deploymentDirectory == null || (directoryModel = NavigationDirectoryCache.getModel(deploymentDirectory.getId())) == null) continue;
                    String mes = DeployUtil.removeAppDirectoryDeployInfo(appId, directoryModel);
                    if (mes.equals("-1")) {
                        AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), directoryModel.getDirectoryName()) + "]\u5220\u9664\u5931\u8d25"));
                        continue;
                    }
                    AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), directoryModel.getDirectoryName()) + "]\u5220\u9664\u6210\u529f"));
                }
                if (deploymentSystem == null || (systemModel = NavigationSystemCache.getModel(deploymentSystem.getId())) == null) continue;
                String mes = DeployUtil.removeAppSystemDeployInfo(appId, systemModel);
                if (mes.equals("-1")) {
                    AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), systemModel.getSystemName()) + "]\u5220\u9664\u5931\u8d25"));
                    continue;
                }
                AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), systemModel.getSystemName()) + "]\u5220\u9664\u6210\u529f"));
            }
        }
        File appConfigFile = new File(String.valueOf(app.getPath()) + "manifest.xml");
        List<DeploymentFunction> functions = DeployUtil.getDeploymentFunctions(appConfigFile);
        for (DeploymentFunction deploymentFunction : functions) {
            NavigationFunctionModel functionModel = NavigationFunctionCache.getModel(deploymentFunction.getId());
            if (functionModel == null) continue;
            String mes = DeployUtil.removeAppFunctionDeployInfo(appId, functionModel);
            if (mes.equals("-1")) {
                AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]\u5220\u9664\u5931\u8d25"));
                continue;
            }
            AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]\u5220\u9664\u6210\u529f"));
        }
    }

    public static void modifyAppPortalAndSystemResource(AppContext app, boolean isActivity) throws Exception, AppContainerException {
        String activity = isActivity ? "\u542f\u7528" : "\u505c\u7528";
        String scanXML = String.valueOf(app.getPath()) + "manifest.xml";
        File xmlFile = new File(scanXML);
        if (xmlFile.exists()) {
            AppsResource.updateByFile((AppContext)app, (File)xmlFile);
        }
        List systems = app.getDeploymentMenus();
        String appId = app.getId();
        if (systems != null && systems.size() > 0) {
            for (DeploymentSystem deploymentSystem : systems) {
                NavigationSystemModel systemModel;
                List dirs = deploymentSystem.getDeploymentDirectory();
                for (DeploymentDirectory deploymentDirectory : dirs) {
                    NavigationDirectoryModel directoryModel;
                    List functions = deploymentDirectory.getDeploymentFunction();
                    for (DeploymentFunction deploymentFunction : functions) {
                        NavigationFunctionModel functionModel;
                        if (deploymentFunction == null || UtilString.isEmpty(deploymentFunction.getId()) || (functionModel = NavigationFunctionCache.getModel(deploymentFunction.getId())) == null) continue;
                        String mes = DeployUtil.modifyAppFunctionActivity(appId, functionModel, isActivity);
                        if (mes.equals("-1")) {
                            AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]" + activity + "\u5931\u8d25"));
                            continue;
                        }
                        AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]" + activity + "\u6210\u529f"));
                    }
                    if (deploymentDirectory == null || UtilString.isEmpty(deploymentDirectory.getId()) || (directoryModel = NavigationDirectoryCache.getModel(deploymentDirectory.getId())) == null) continue;
                    String mes = DeployUtil.modifyAppDirectoryActivity(appId, directoryModel, isActivity);
                    if (mes.equals("-1")) {
                        AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), directoryModel.getDirectoryName()) + "]" + activity + "\u5931\u8d25"));
                        continue;
                    }
                    AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), directoryModel.getDirectoryName()) + "]" + activity + "\u6210\u529f"));
                }
                if (deploymentSystem == null || UtilString.isEmpty(deploymentSystem.getId()) || (systemModel = NavigationSystemCache.getModel(deploymentSystem.getId())) == null) continue;
                String mes = DeployUtil.modifyAppSystemActivity(appId, systemModel, isActivity);
                if (mes.equals("-1")) {
                    AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), systemModel.getSystemName()) + "]" + activity + "\u5931\u8d25"));
                    continue;
                }
                AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), systemModel.getSystemName()) + "]" + activity + "\u6210\u529f"));
            }
        }
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        List<DeploymentFunction> functions = DeployUtil.getDeploymentFunctions(appConfigFile);
        for (DeploymentFunction deploymentFunction : functions) {
            NavigationFunctionModel functionModel = NavigationFunctionCache.getModel(deploymentFunction.getId());
            if (functionModel == null) continue;
            String mes = DeployUtil.modifyAppFunctionActivity(appId, functionModel, isActivity);
            if (mes.equals("-1")) {
                AppsLogger.warn((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]" + activity + "\u5931\u8d25"));
                continue;
            }
            AppsLogger.info((AppContext)app, (String)("\u5bfc\u822a\u83dc\u5355[" + NavigationUtil.getLangName(I18nRes.getUserLanguage(), functionModel.getFunctionName()) + "]" + activity + "\u6210\u529f"));
        }
    }
}

