/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.AppDist;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextRequire;
import com.actionsoft.apps.resource.AppContextRequireImpl;
import com.actionsoft.apps.resource.AppTeam;
import com.actionsoft.apps.resource.ManifestXML;
import com.actionsoft.apps.resource.deployment.DeploymentDirectory;
import com.actionsoft.apps.resource.deployment.DeploymentFunction;
import com.actionsoft.apps.resource.deployment.DeploymentSystem;
import com.actionsoft.apps.resource.deployment.NavTpl;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.util.DeployUtil;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.cache.FastFiles;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.ac.AccessControlAPI;
import com.actionsoft.bpms.commons.security.ac.model.NavACCM;
import com.actionsoft.bpms.commons.security.basic.cache.PermissionCache;
import com.actionsoft.bpms.commons.security.basic.model.PermissionModel;
import com.actionsoft.bpms.commons.security.high.HighSecurity;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.org.cache.RoleCache;
import com.actionsoft.bpms.org.cache.UserCache;
import com.actionsoft.bpms.org.model.RoleModel;
import com.actionsoft.bpms.org.model.UserModel;
import com.actionsoft.bpms.org.util.SecurityUtil;
import com.actionsoft.bpms.server.DeveloperKey;
import com.actionsoft.bpms.server.Quota;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.conf.portal.AWSPortalConf;
import com.actionsoft.bpms.server.fs.DCContext;
import com.actionsoft.bpms.server.fs.dc.DCProfileManager;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.emm.mam.apps.MobileAppProfile;
import com.actionsoft.emm.mam.apps.MobileAppsResource;
import com.actionsoft.emm.mam.apps.NativeAppProfile;
import com.actionsoft.emm.mam.cache.AppCategoryCache;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.i18n.I18nMetadataUtil;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ApplicationDevelopWeb
extends AMCWeb {
    public ApplicationDevelopWeb(UserContext me) {
        super(me);
    }

    public String getApplicationDevelopPage(String param) {
        JSONObject paramJO = JSONArray.parseObject((String)param);
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        String showDeveloperCertify = SDK.getAppAPI().getProperty("_bpm.platform", "showDeveloperCertify");
        String showValidDate = SDK.getAppAPI().getProperty("_bpm.platform", "showValidDate");
        String showParentApp = SDK.getAppAPI().getProperty("_bpm.platform", "showParentApp");
        String showApplicationIcon = SDK.getAppAPI().getProperty("_bpm.platform", "showApplicationIcon");
        String showInitVersionNum = SDK.getAppAPI().getProperty("_bpm.platform", "showInitVersionNum");
        int navIndex = paramJO.getIntValue("navIndex");
        String developNewApp = this.getDevelopNewAppHtml();
        String appPrefix = DeveloperKey.getAppPrefix();
        String developerName = DeveloperKey.getDeveloperName();
        String developerURL = DeveloperKey.getDeveloperUrl();
        String tablePrefix = DeveloperKey.getTablePrefix();
        String developerpath = "../apps/developer.csr";
        boolean isExistCer = false;
        String developer = "";
        String expirationDate = "";
        File developerCer = new File(developerpath);
        if (developerCer.exists()) {
            isExistCer = true;
            developer = DeveloperKey.getDeveloperName();
            expirationDate = DeveloperKey.getExpirationDate();
        } else {
            developer = I18nRes.findValue("_bpm.platform", "\u9ed8\u8ba4");
            expirationDate = I18nRes.findValue("_bpm.platform", "\u9ed8\u8ba4");
        }
        if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
            macroLibraries.put("developTeam", this.getDevelopTeamHtml());
        } else {
            macroLibraries.put("developTeam", "");
        }
        if (Quota.isDeveloperService()) {
            macroLibraries.put("developNewApp", developNewApp);
        } else if (Quota.isPRD() && !Quota.isPaasCloud()) {
            macroLibraries.put("developNewApp", "");
        } else {
            macroLibraries.put("developNewApp", "");
        }
        AppTeam t = AppPlatformConfig.getAppTeamById((String)AppPlatformConfig.awsteam);
        if (t == null) {
            t = new AppTeam();
            t.setId(AppPlatformConfig.awsteam);
            t.setName("AWS Team1");
            t.setDesc("AWS" + I18nRes.findValue("_bpm.platform", "\u9ed8\u8ba4\u7ec4"));
            t.setValid(true);
            t.setMembers(AMCUtil.getMembersToList("admin"));
            t.setAppsPermissions(this.getAppsPermissions());
            AppPlatformConfig.addTeam((AppTeam)t);
        }
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("param", param);
        if (navIndex == 1) {
            String addBtn = "";
            if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
                addBtn = "<button type='button' class='awsui-btn awsui-btn-blue' onclick='AppDevelop.showAddTeamDialog();'>" + I18nRes.findValue("_bpm.platform", "\u65b0\u5efa\u5f00\u53d1\u5c0f\u7ec4") + " </button>";
            }
            macroLibraries.put("addBtn", addBtn);
            macroLibraries.put("list", HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.developteam.htm", macroLibraries));
        } else if (navIndex == 2) {
            StringBuilder option = new StringBuilder();
            List apps = AppsAPIManager.getInstance().getInstalledApps();
            AppsAPIManager.getInstance().sortAppByName(apps);
            JSONArray jsonArray = new JSONArray();
            JSONArray byodJsonArray = new JSONArray();
            JSONObject empty = new JSONObject();
            empty.put("id", (Object)"");
            empty.put("text", (Object)"");
            empty.put("imgs", (Object)"");
            jsonArray.add((Object)empty);
            byodJsonArray.add((Object)empty);
            for (AppContext appContext : apps) {
                String imgs;
                JSONObject json;
                if (!appContext.getId().equals("_bpm.platform") && !appContext.getId().equals("_bpm.portal")) {
                    json = new JSONObject();
                    imgs = AMCUtil.getAppIconNoClass(appContext.getId());
                    json.put("id", (Object)(String.valueOf(appContext.getId()) + "-" + appContext.getVersion()));
                    json.put("label", (Object)I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName()));
                    json.put("value", (Object)(String.valueOf(appContext.getId()) + "-" + appContext.getVersion()));
                    json.put("imgs", (Object)imgs);
                    json.put("text", (Object)(String.valueOf(I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName())) + "\uff08" + appContext.getId() + "\uff09"));
                    byodJsonArray.add((Object)json);
                }
                json = new JSONObject();
                imgs = AMCUtil.getAppIconNoClass(appContext.getId());
                json.put("id", (Object)(String.valueOf(appContext.getId()) + "-" + appContext.getVersion()));
                json.put("label", (Object)I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName()));
                json.put("value", (Object)(String.valueOf(appContext.getId()) + "-" + appContext.getVersion()));
                json.put("imgs", (Object)imgs);
                json.put("text", (Object)(String.valueOf(I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName())) + "\uff08" + appContext.getId() + "\uff09"));
                jsonArray.add((Object)json);
            }
            macroLibraries.put("appPrefix", appPrefix);
            macroLibraries.put("showDeveloperCertify", showDeveloperCertify);
            macroLibraries.put("showValidDate", showValidDate);
            macroLibraries.put("showParentApp", showParentApp);
            macroLibraries.put("showApplicationIcon", showApplicationIcon);
            macroLibraries.put("showInitVersionNum", showInitVersionNum);
            macroLibraries.put("option", jsonArray.toString());
            macroLibraries.put("data", jsonArray.toString());
            macroLibraries.put("byoddata", byodJsonArray.toString());
            macroLibraries.put("developerName", I18nRes.findValue("_bpm.platform", developerName));
            macroLibraries.put("developerURL", developerURL);
            macroLibraries.put("tablePrefix", tablePrefix);
            boolean flag = SDK.getPermAPI().havingNavMenuPermission(super.getContext().getUID(), "obj_adb6dc511f7642bda0e71cc803ecf45b");
            macroLibraries.put("disableCss", flag ? "" : "disable");
            macroLibraries.put("disableAttr", flag ? "" : "disabled");
            macroLibraries.put("isExistCer", isExistCer);
            macroLibraries.put("developer", I18nRes.findValue("_bpm.platform", developer));
            macroLibraries.put("expirationDate", expirationDate);
            List teams = AppPlatformConfig.getAppTeamsByMember((String)super.getContext().getUID());
            StringBuilder b = new StringBuilder();
            b.append("<table id='appMasterTable' width='600px' heigth='100%' cellspacing='0' cellpadding='0'>");
            b.append("<colgroup><col style='width: 40%;'></col><col style='width: 60%;text-align: right;'></col></colgroup>");
            String label1 = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5f00\u53d1\u6743\u9650"));
            String label2 = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u7ef4\u62a4\u6743\u9650"));
            int i = 0;
            while (i < teams.size()) {
                AppTeam team = (AppTeam)teams.get(i);
                String teamName = team.getName();
                String teamId = team.getId();
                String vright = "vright_" + (i + 1);
                String right = "right_" + (i + 1);
                b.append("<tr id='" + teamId + "' ><td>").append(teamName).append("</td></td><td>");
                b.append("<input class='awsui-checkbox vright' checked='checked' value='" + vright + "' type='checkbox'>");
                b.append("<label class='awsui-checkbox-label' for='" + vright + "'>" + (String)label1 + "</label>&nbsp;&nbsp;&nbsp;");
                b.append("<input class='awsui-checkbox right' checked='checked' value='" + right + "' type='checkbox'>");
                b.append("<label class='awsui-checkbox-label' for='" + right + "'>" + label2 + "</label>");
                b.append("</td></tr>");
                ++i;
            }
            b.append("</table>");
            macroLibraries.put("appMaster", b.toString());
            macroLibraries.put("roleSource", this.getRoleSource());
            AppContext portal = AppsAPIManager.getInstance().getAppContext("_bpm.portal");
            macroLibraries.put("defaultDependApp", String.valueOf(portal.getId()) + "-" + portal.getVersion());
            macroLibraries.put("isBYODService", Quota.isBYODService());
            List categoryList = AppCategoryCache.getAllCategories();
            JSONObject categories = new JSONObject();
            categories.put("width", (Object)"100%");
            categories.put("placeholder", (Object)I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9\u6216\u8f93\u5165\u4e00\u4e2a\u5206\u7c7b")));
            categories.put("allowClear", (Object)true);
            categories.put("tags", (Object)true);
            JSONArray categoryArray = new JSONArray();
            for (String category : categoryList) {
                JSONObject json = new JSONObject();
                json.put("id", (Object)category);
                json.put("text", (Object)category);
                categoryArray.add((Object)json);
            }
            categories.put("data", (Object)categoryArray);
            macroLibraries.put("categories", categories.toString());
            macroLibraries.put("onlyAdmin", "admin".equals(this.getContext().getUID()) ? "" : "display:none;");
            macroLibraries.put("mobileUrl", AWSPortalConf.getMobileUrl());
            macroLibraries.put("list", HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.app.create.htm", macroLibraries));
        } else if (navIndex == 3) {
            macroLibraries.put("list", HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.configapp.htm", macroLibraries));
        } else if (navIndex == 4) {
            macroLibraries.put("list", HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.distributeapp.htm", macroLibraries));
        }
        macroLibraries.put("navIndex", navIndex);
        macroLibraries.put("sid", super.getContext().getSessionId());
        List list = AppPlatformConfig.getAppTeamsByMember((String)this.getContext().getUID());
        String temastr = "";
        String user = "";
        AppTeam team = null;
        if (list.size() > 0) {
            team = (AppTeam)list.get(0);
            temastr = team.getName();
            UserModel u = UserCache.getModel((String)this.getContext().getUID());
            user = u == null ? this.getContext().getUID() : u.getUserName();
        }
        macroLibraries.put("selectData", this.getInstallAppNames(navIndex));
        macroLibraries.put("isExistCer", isExistCer);
        macroLibraries.put("developer", developer);
        macroLibraries.put("team", temastr);
        macroLibraries.put("user", user);
        List categoryList = AppCategoryCache.getAllCategories();
        JSONObject categories = new JSONObject();
        categories.put("width", (Object)"100%");
        categories.put("placeholder", (Object)I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9\u6216\u8f93\u5165\u4e00\u4e2a\u5206\u7c7b")));
        categories.put("allowClear", (Object)true);
        categories.put("tags", (Object)true);
        JSONArray categoryArray = new JSONArray();
        for (String category : categoryList) {
            JSONObject json = new JSONObject();
            json.put("id", (Object)category);
            json.put("text", (Object)category);
            categoryArray.add((Object)json);
        }
        categories.put("data", (Object)categoryArray);
        macroLibraries.put("categories", categories.toString());
        JSONArray jsonArray = new JSONArray();
        List allapps = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appC : allapps) {
            JSONObject json = new JSONObject();
            String imgs = AMCUtil.getAppIconNoClass(appC.getId());
            json.put("id", (Object)(String.valueOf(appC.getId()) + "-" + appC.getVersion()));
            json.put("label", (Object)I18nMetadataUtil.findValue(appC.getId(), "APP_NAME_", appC.getId(), this.getContext().getLanguage(), appC.getName()));
            json.put("value", (Object)(String.valueOf(appC.getId()) + "-" + appC.getVersion()));
            json.put("imgs", (Object)imgs);
            jsonArray.add((Object)json);
        }
        macroLibraries.put("byodComboxData", jsonArray.toString());
        String editDialog = HtmlPageTemplate.getTemplateContent("_bpm.platform", "console.admin.byod.mam.app.edit.dialog.htm");
        macroLibraries.put("editAppDialog", editDialog);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.htm", macroLibraries);
    }

    private String getDevelopNewAppHtml() {
        StringBuilder developNewApp = new StringBuilder();
        developNewApp.append("<div class='nav' navIndex='2'>");
        developNewApp.append("<div style='position:absolute;height:50px;line-height:50px;'>");
        developNewApp.append(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u521b\u5efa\u5e94\u7528")));
        developNewApp.append("</div>");
        developNewApp.append("</div>");
        return developNewApp.toString();
    }

    private String getDevelopTeamHtml() {
        StringBuilder developNewApp = new StringBuilder();
        developNewApp.append("<div class='nav' navIndex='1'>");
        developNewApp.append("<div style='position:absolute;height:50px;line-height:50px;'>");
        developNewApp.append(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5f00\u53d1\u5c0f\u7ec4")));
        developNewApp.append("</div>");
        developNewApp.append("</div>");
        return developNewApp.toString();
    }

    public String getDevTeamGrid() {
        StringBuilder html = new StringBuilder();
        List list = AppPlatformConfig.getTeams();
        for (AppTeam appTeam : list) {
            if (HighSecurity.isON() && appTeam.getId().equals(AppPlatformConfig.awsteam)) continue;
            String className = "";
            if (!appTeam.isValid()) {
                className = "invalid";
            }
            html.append("<tr>");
            html.append("<td  class='list normal ").append(className).append("' style='font-size:14px;white-space: normal; width:30%;'>");
            String teamName = appTeam.getName();
            if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
                teamName = "<a style='cursor:pointer;' onclick='AppDevelop.showManageTeamDialog(\"" + appTeam.getId() + "\"," + appTeam.getId().equals(AppPlatformConfig.awsteam) + ",\"" + appTeam.getName() + "\");return false;' >" + appTeam.getName() + "</a>";
            }
            html.append(teamName);
            html.append("</td>");
            html.append("<td style='width:20%;line-height: 22px;white-space: normal;' class='list normal ").append(className).append("'>");
            html.append(AMCUtil.getMembersAsName(appTeam.getMembers()));
            html.append("</td>");
            html.append("<td style='width:20%;line-height: 22px;white-space: normal;' class='list normal ").append(className).append("'>");
            html.append(AMCUtil.getRolesAsName(appTeam.getRoles()));
            html.append("</td>");
            html.append("<td style='width:15%;' class='list normal ").append(className).append("'>");
            html.append(I18nRes.findValue("_bpm.platform", appTeam.isValid() ? I18nRes.findValue("_bpm.platform", "\u6709\u6548") : I18nRes.findValue("_bpm.platform", "\u6682\u505c")));
            html.append("</td>");
            html.append("<td style='width:15%;'>");
            if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
                html.append("<input type='button' class='awsui-btn awsui-btn-sm awsui-btn-blue' onclick='AppDevelop.showManageTeamDialog(\"" + appTeam.getId() + "\"," + appTeam.getId().equals(AppPlatformConfig.awsteam) + ",\"" + appTeam.getName() + "\")' value='" + I18nRes.findValue("_bpm.platform", "\u7ba1\u7406") + "'/>");
                if (!(appTeam.getId().equals(AppPlatformConfig.awsteam) || HighSecurity.isON() && appTeam.getId().equals(String.valueOf(AppPlatformConfig.awsteam) + "Security"))) {
                    html.append("<input type='button' class='awsui-btn awsui-btn-sm awsui-btn-danger' onclick='AppDevelop.removeTeam(\"" + appTeam.getId() + "\")' value='" + I18nRes.findValue("_bpm.platform", "\u5220\u9664") + "'/>");
                }
            }
            html.append("</td>");
            html.append("</tr>");
        }
        return html.toString();
    }

    public String getApplicationDevelopAddTeamPage() {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        StringBuilder html = new StringBuilder();
        String name = "";
        String desc = "";
        String id = "";
        boolean isValid = true;
        List<AppContext> list = this.getApps();
        HashMap<String, String> permissions = new HashMap<String, String>();
        html.append(this.getAppList(list, permissions));
        macroLibraries.put("name", name);
        macroLibraries.put("desc", desc);
        macroLibraries.put("users", "");
        macroLibraries.put("roles", "");
        macroLibraries.put("roleSource", this.getRoleSource());
        macroLibraries.put("isValid", "<input type='checkbox' id='isValid' name='isValid' " + (isValid ? "checked" : "") + " class='awsui-checkbox'/>");
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("html", html.toString());
        macroLibraries.put("id", id);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.addteam.htm", macroLibraries);
    }

    private List<AppContext> getApps() {
        List<Object> installApps = new ArrayList();
        try {
            installApps = AMCUtil.queryAllAppsList();
        }
        catch (AppContainerException e) {
            e.printStackTrace();
        }
        ArrayList<AppContext> list = new ArrayList<AppContext>();
        for (AppContext appContext : installApps) {
            list.add(appContext);
        }
        return list;
    }

    private Map<String, String> getAppsPermissions() {
        HashMap<String, String> appsPermissions = new HashMap<String, String>();
        List<AppContext> list = this.getApps();
        int i = 0;
        while (i < list.size()) {
            AppContext app = list.get(i);
            appsPermissions.put(app.getId(), "AB");
            ++i;
        }
        return appsPermissions;
    }

    public String getApplicationDevelopAddTeam(String jsonstr, String memeber) {
        String members = SDK.getORGAPI().getUserIds(memeber).replaceAll(" ", ",");
        if (jsonstr.equals("")) {
            jsonstr = "{}";
        }
        JSONObject json = JSONArray.parseObject((String)jsonstr);
        String teamName = UtilJson.optString(json, "teamname");
        String teamDesc = UtilJson.optString(json, "teamdesc");
        String memberRole = UtilJson.optString(json, "memberRole");
        boolean isvalid = json.getBooleanValue("isValid");
        String appsPermissions = UtilJson.optString(json, "permissions");
        AppTeam team = new AppTeam();
        team.setName(teamName);
        team.setDesc(teamDesc);
        team.setMembers(AMCUtil.getMembersToList(members));
        team.setRoles(AMCUtil.getRolesToList(memberRole));
        team.setValid(isvalid);
        team.setAppsPermissions(AMCUtil.getAppsPermissions2Map(appsPermissions));
        boolean f = AppPlatformConfig.addTeam((AppTeam)team);
        return String.valueOf(f);
    }

    public String getAppList(List<AppContext> apps, Map<String, String> permissions) {
        StringBuilder html = new StringBuilder();
        html.append("<table width=100% heigth=100%  cellspacing=0 cellpadding=0 id='innerTable'>");
        String label1 = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5f00\u53d1\u6743\u9650"));
        String label2 = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u7ef4\u62a4\u6743\u9650"));
        int i = 0;
        while (i < apps.size()) {
            String permission;
            String appId;
            String isCheck = "";
            String visCheck = "";
            AppContext app = apps.get(i);
            Iterator<String> permissionApps = permissions.keySet().iterator();
            Iterator<String> permissionApps2 = permissions.keySet().iterator();
            while (permissionApps.hasNext()) {
                appId = permissionApps.next();
                permission = permissions.get(appId);
                if (!app.getId().equals(appId) || permission.indexOf("B") <= -1) continue;
                isCheck = "checked";
            }
            while (permissionApps2.hasNext()) {
                appId = permissionApps2.next();
                permission = permissions.get(appId);
                if (!app.getId().equals(appId) || permission.indexOf("A") <= -1) continue;
                visCheck = "checked";
            }
            String img = AMCUtil.getListAppIcon(app.getId());
            html.append("<tr id='" + app.getId() + "' >");
            html.append("<td width='7%'>");
            html.append(i + 1);
            html.append("</td>");
            html.append("<td class='list name' width='63%' appName='" + app.getName() + "'>");
            html.append(String.valueOf(img) + AMCUtil.getAppNewName(app.getName(), 30));
            html.append("</td>");
            html.append("<td  width='30%' id='" + app.getId().replace(".", "-") + "_td'>");
            html.append("<input name='vright' id='vright_" + (i + 1) + "' class='awsui-checkbox' type='checkbox' " + visCheck + " value='" + app.getId() + "'><label class='awsui-checkbox-label' for='vright_" + (i + 1) + "'>" + label1 + " </label>");
            html.append("<input name='right' id='right_" + (i + 1) + "'  class='awsui-checkbox' type='checkbox' " + isCheck + " value='" + app.getId() + "'><label class='awsui-checkbox-label' for='right_" + (i + 1) + "'>" + label2 + "</label>");
            html.append("</td>");
            html.append("</tr>");
            ++i;
        }
        html.append("</table>");
        return html.toString();
    }

    public String getApplicationDevelopManageTeamPage(String teamId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        StringBuilder html = new StringBuilder();
        AppTeam team = AppPlatformConfig.getAppTeamById((String)teamId);
        String id = "";
        String name = "";
        String desc = "";
        String members = "";
        String roles = "";
        boolean isValid = false;
        Map<String, String> permissions = new HashMap<String, String>();
        if (team != null) {
            id = team.getId();
            name = team.getName();
            desc = team.getDesc();
            members = AMCUtil.getMembers2Str(team.getMembers());
            roles = AMCUtil.getRoles2Str(team.getRoles());
            isValid = team.isValid();
            permissions = team.getAppsPermissions();
        }
        List<AppContext> list = this.getApps();
        html.append(this.getAppList(list, permissions));
        macroLibraries.put("sid", super.getContext().getSessionId());
        JSONArray array = this.getMember(members);
        macroLibraries.put("id", id);
        macroLibraries.put("name", name);
        macroLibraries.put("desc", desc);
        macroLibraries.put("members", members);
        macroLibraries.put("initData", array);
        macroLibraries.put("users", this.getUserNames(members));
        macroLibraries.put("roles", roles);
        macroLibraries.put("roleSource", this.getRoleSource());
        String checkbox = "";
        checkbox = teamId.equals(AppPlatformConfig.awsteam) ? "<input type='checkbox' id='isValid' disabled='disabled' readonly='readonly' name='isValid' checked='" + (isValid ? "checked" : "") + "' class='awsui-checkbox'/>" : "<input type='checkbox' id='isValid' name='isValid' " + (isValid ? "checked" : "") + " class='awsui-checkbox'/>";
        macroLibraries.put("isValid", checkbox);
        macroLibraries.put("html", html.toString());
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.addteam.htm", macroLibraries);
    }

    private String getUserNames(String members) {
        String users = "";
        if (!members.equals("")) {
            UtilString us = new UtilString(members);
            List<String> membersList = us.split(",");
            int i = 0;
            while (i < membersList.size()) {
                String m = membersList.get(i);
                UserModel user = UserCache.getModel((String)m);
                if (user != null) {
                    users = String.valueOf(users) + user.getUserNameAlias() + " ";
                }
                ++i;
            }
        }
        return users.trim();
    }

    private String getRoleSource() {
        JSONArray arr = new JSONArray();
        for (RoleModel model : RoleCache.getCache()) {
            if (!SecurityUtil.hasRoleAssignSec((UserContext)this.getContext(), (String)model.getCategoryName())) continue;
            JSONObject json = new JSONObject();
            json.put("id", (Object)model.getId());
            json.put("text", (Object)model.toName());
            arr.add((Object)json);
        }
        return arr.toString();
    }

    private JSONArray getMember(String members) {
        JSONArray array = new JSONArray();
        if (!members.equals("")) {
            UtilString us = new UtilString(members);
            List<String> membersList = us.split(",");
            for (String uid : membersList) {
                JSONObject json = new JSONObject();
                UserModel userModel = UserCache.getModel((String)uid);
                String label = "";
                String value = "";
                if (userModel != null) {
                    value = userModel.getUID();
                    label = userModel.getUserName();
                    if (!userModel.isClosed()) {
                        json.put("label", (Object)label);
                        json.put("value", (Object)value);
                    } else {
                        json.put("label", (Object)label);
                        json.put("value", (Object)value);
                        json.put("notfind", (Object)true);
                    }
                } else {
                    json.put("label", (Object)uid);
                    json.put("value", (Object)uid);
                    json.put("notfind", (Object)true);
                }
                array.add((Object)json);
            }
        }
        return array;
    }

    public String getApplicationDevelopManageModifyTeam(String teamId, String jsonstr, String member, String memberRole) {
        String members = SDK.getORGAPI().getUserIds(member).replaceAll(" ", ",");
        ResponseObject resonObject = ResponseObject.newOkResponse();
        JSONObject json = null;
        String optType = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u65b0\u5efa"));
        if (jsonstr.equals("")) {
            jsonstr = "{}";
            json = new JSONObject();
        }
        json = JSONArray.parseObject((String)jsonstr);
        String teamName = UtilJson.optString(json, "teamname");
        String teamDesc = UtilJson.optString(json, "teamdesc");
        boolean isvalid = json.getBooleanValue("isValid");
        String apps = UtilJson.optString(json, "apps");
        String vapps = UtilJson.optString(json, "vapps");
        String appsPermissions = UtilJson.optString(json, "appsPermissions");
        AppTeam team = null;
        if (teamId.equals("")) {
            boolean isExt = AppPlatformConfig.isExtAppTeam((String)teamName);
            if (isExt) {
                resonObject.warn();
                resonObject.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u8be5\u5c0f\u7ec4\u5df2\u5b58\u5728")));
                return resonObject.toString();
            }
            team = new AppTeam();
        } else {
            team = AppPlatformConfig.getAppTeamById((String)teamId);
            optType = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u4fee\u6539"));
        }
        String notExistMember = this.getNotExistMember(members);
        if (!notExistMember.equals("")) {
            resonObject.warn();
            resonObject.msg(String.valueOf(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5c0f\u7ec4\u6210\u5458"))) + "[" + notExistMember + "]" + I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u4e0d\u5b58\u5728\u6216\u8be5\u7528\u6237\u5df2\u88ab\u6ce8\u9500")));
            return resonObject.toString();
        }
        team.setName(teamName);
        team.setDesc(teamDesc);
        team.setMembers(AMCUtil.getMembersToList(members));
        team.setRoles(AMCUtil.getRolesToList(memberRole));
        team.setValid(isvalid);
        team.setAppsPermissions(AMCUtil.getAppsPermissions2Map(appsPermissions));
        boolean f = true;
        f = teamId.equals("") ? AppPlatformConfig.addTeam((AppTeam)team) : AppPlatformConfig.modifyTeam((AppTeam)team);
        String msg = String.valueOf(optType) + I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u6210\u529f"));
        if (!f) {
            resonObject = ResponseObject.newWarnResponse();
            msg = String.valueOf(optType) + I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5931\u8d25"));
        }
        resonObject.msg(msg);
        return resonObject.toString();
    }

    private String getAppsPermissions(JSONObject json) {
        StringBuilder appsPermissions = new StringBuilder();
        String apps = UtilJson.optString(json, "apps");
        String vapps = UtilJson.optString(json, "vapps");
        return appsPermissions.toString();
    }

    private String getNotExistMember(String members) {
        StringBuilder notExistMember = new StringBuilder();
        int count = 0;
        if (!members.equals("")) {
            UtilString membersStr = new UtilString(members);
            List<String> membersList = membersStr.split(",");
            for (String member : membersList) {
                boolean check = this.checkMember(member);
                if (check) continue;
                if (count == 0) {
                    notExistMember.append(member);
                } else {
                    notExistMember.append(",").append(member);
                }
                ++count;
            }
        }
        return notExistMember.toString();
    }

    private boolean checkMember(String member) {
        List users = UserCache.getActiveList();
        int i = 0;
        while (i < users.size()) {
            UserModel userModel = (UserModel)users.get(i);
            if (member.equals(userModel.getUID())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getApplicationDevelopManageRemoveTeam(String teamId) {
        boolean f = AppPlatformConfig.removeTeam((String)teamId);
        String msg = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
        ResponseObject resonObject = ResponseObject.newOkResponse();
        if (!f) {
            resonObject.warn();
            msg = I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
        }
        resonObject.msg(msg);
        return resonObject.toString();
    }

    public String getApplicationDevelopConfigAppPage(String appId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        String appName = "";
        StringBuilder parentApp = new StringBuilder();
        String isCheck = "";
        String developerName = "";
        String developerURL = "";
        int bulidNo = 0;
        String isReload = "";
        double versonNO = 1.0;
        String tablePrefix = "";
        String overview = "";
        String details = "";
        String productId = "";
        String installListener = "";
        String pluginListener = "";
        String startListener = "";
        String stopListener = "";
        String upgradeListener = "";
        String uninstallListener = "";
        String checkBoxHtml = "<input type='checkbox' name='categoryVisible'  class='awsui-checkbox' id='categoryVisible' <#ischeck> /><label class='awsui-checkbox-label'style='white-space: nowrap;' for='categoryVisible'>" + I18nRes.findValue("_bpm.platform", "\u63d0\u4f9b\u4e1a\u52a1\u5efa\u6a21") + "</label>";
        String modelAdmin = "";
        List requireList = new ArrayList();
        if (app != null) {
            appName = I18nMetadataUtil.findValue(appId, "APP_NAME_", appId, this.getContext().getLanguage(), app.getName());
            versonNO = app.getVersion();
            List apps = AppsAPIManager.getInstance().getInstalledApps();
            AppsAPIManager.getInstance().sortAppByName(apps);
            isCheck = app.isCategoryVisible() ? "checked" : "";
            checkBoxHtml = checkBoxHtml.replace("<#ischeck>", isCheck);
            if (app.getId().startsWith("_")) {
                checkBoxHtml = "";
            }
            isReload = app.isReloadable() ? "checked" : "";
            developerName = app.getDeveloperName();
            developerURL = app.getDeveloperUrl();
            tablePrefix = app.getTablePrefix();
            bulidNo = app.getBuildNo();
            tablePrefix = app.getTablePrefix();
            overview = app.getDescription();
            details = app.getDetails();
            productId = app.getProductId();
            installListener = app.getInstallListener();
            pluginListener = app.getPluginListener();
            startListener = app.getStartListener();
            stopListener = app.getStopListener();
            upgradeListener = app.getUpgradeListener();
            uninstallListener = app.getUninstallListener();
            modelAdmin = app.getModelAdministrator();
            requireList = app.getRequires();
        }
        AppsAPIManager api = AppsAPIManager.getInstance();
        String appIcon = api.getIcon64URL(appId, this.getContext());
        macroLibraries.put("appIcon", appIcon);
        macroLibraries.put("icon64url", appIcon);
        macroLibraries.put("iconurl", api.getIcon96URL(appId, this.getContext()));
        macroLibraries.put("icon16url", api.getIcon16URL(appId, this.getContext()));
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("appName", appName);
        macroLibraries.put("appId", appId);
        macroLibraries.put("parentApp", parentApp);
        macroLibraries.put("versonNO", versonNO);
        macroLibraries.put("checkBoxHtml", checkBoxHtml);
        macroLibraries.put("developerURL", developerURL);
        macroLibraries.put("developerName", developerName);
        macroLibraries.put("bulidNo", bulidNo);
        macroLibraries.put("isReload", isReload);
        macroLibraries.put("tablePrefix", tablePrefix);
        macroLibraries.put("productId", productId);
        macroLibraries.put("overview", Html.encodeForHTMLAttribute(overview));
        macroLibraries.put("details", details);
        macroLibraries.put("installListener", installListener);
        macroLibraries.put("pluginListener", pluginListener);
        macroLibraries.put("startListener", startListener);
        macroLibraries.put("stopListener", stopListener);
        macroLibraries.put("upgradeListener", upgradeListener);
        macroLibraries.put("uninstallListener", uninstallListener);
        int appType = 0;
        if (app.getMobileAppProfile() != null) {
            appType = MobileAppsResource.getOsType((MobileAppProfile)app.getMobileAppProfile());
        }
        macroLibraries.put("appType", appType);
        String users = "";
        String roles = "";
        if (modelAdmin == null) {
            modelAdmin = "";
        }
        String[] temp = modelAdmin.split(" ");
        int i = 0;
        while (i < temp.length) {
            String id = temp[i];
            if (RoleCache.getModel((String)id) != null) {
                roles = String.valueOf(roles) + " " + id;
            } else if (SDK.getORGAPI().getUserNames(id).length() > 0) {
                users = String.valueOf(users) + " " + id;
            }
            ++i;
        }
        macroLibraries.put("manageUser", this.getUserNames(users.trim().replaceAll(" ", ",")));
        macroLibraries.put("manageRole", roles.trim().replaceAll(" ", ","));
        macroLibraries.put("roleSource", this.getRoleSource());
        JSONArray requireArray = new JSONArray();
        if (UtilString.isEmpty(requireList)) {
            requireList = new ArrayList();
        }
        for (AppContextRequire r : requireList) {
            AppContextRequireImpl require = (AppContextRequireImpl)r;
            JSONObject json = new JSONObject();
            json.put("appId", (Object)require.getAppId());
            json.put("handler", (Object)require.getNotActiveHandler());
            requireArray.add((Object)json);
        }
        macroLibraries.put("require", requireArray.toString());
        JSONArray appArray = new JSONArray();
        JSONObject empty = new JSONObject();
        empty.put("id", (Object)"");
        empty.put("text", (Object)"");
        empty.put("imgs", (Object)"");
        appArray.add((Object)empty);
        List apps = AppsAPIManager.getInstance().getInstalledApps();
        AppsAPIManager.getInstance().sortAppByName(apps);
        String parentId = this.getSelectParentAppId(apps, app);
        for (AppContext appContext : apps) {
            String id = appContext.getId();
            if (id.equals(appId) || parentId.startsWith(id)) continue;
            JSONObject json = new JSONObject();
            String imgs = AMCUtil.getAppIconNoClass(id);
            json.put("id", (Object)id);
            json.put("text", (Object)I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName()));
            json.put("imgs", (Object)imgs);
            appArray.add((Object)json);
        }
        String showApplicationIcon = SDK.getAppAPI().getProperty("_bpm.platform", "showApplicationIcon");
        String showInitVersionNum = SDK.getAppAPI().getProperty("_bpm.platform", "showInitVersionNum");
        macroLibraries.put("showApplicationIcon", showApplicationIcon);
        macroLibraries.put("showInitVersionNum", showInitVersionNum);
        macroLibraries.put("requireAppSource", appArray.toString());
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.configapp.dialog.htm", macroLibraries);
    }

    public String getParentAppData(String appId) {
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        JSONArray jsonArray = new JSONArray();
        String selectVal = "";
        if (app != null) {
            List apps = AppsAPIManager.getInstance().getInstalledApps();
            AppsAPIManager.getInstance().sortAppByName(apps);
            selectVal = this.getSelectParentAppId(apps, app);
            for (AppContext appContext : apps) {
                JSONObject json = new JSONObject();
                String imgs = AMCUtil.getAppIconNoClass(appContext.getId());
                json.put("id", (Object)(String.valueOf(appContext.getId()) + "-" + appContext.getVersion()));
                json.put("text", (Object)(String.valueOf(I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName())) + "\uff08" + appContext.getId() + "\uff09"));
                json.put("value", (Object)(String.valueOf(appContext.getId()) + "-" + appContext.getVersion()));
                json.put("imgs", (Object)imgs);
                jsonArray.add((Object)json);
            }
        }
        ResponseObject ro = ResponseObject.newOkResponse();
        ro.put("selectVal", selectVal);
        ro.put("comboxData", jsonArray);
        return ro.toString();
    }

    private String getSelectParentAppId(List<AppContext> apps, AppContext currentApp) {
        String selectVal = "";
        for (AppContext appContext : apps) {
            boolean selected;
            if (appContext.getId().equals(currentApp.getId())) continue;
            AppContext parentContextApp = currentApp.getParentContext();
            String parentAppId = "";
            if (parentContextApp != null) {
                parentAppId = parentContextApp.getId();
            }
            if (!(selected = appContext.getId().equals(parentAppId))) continue;
            selectVal = String.valueOf(parentAppId) + "-" + appContext.getVersion();
        }
        return selectVal;
    }

    private String getSelectParentAppIdNoPlartFormAndPortal(List<AppContext> apps, AppContext currentApp) {
        String selectVal = "";
        for (AppContext appContext : apps) {
            boolean selected;
            if (appContext.getId().equals(currentApp.getId())) continue;
            AppContext parentContextApp = currentApp.getParentContext();
            String parentAppId = "";
            if (parentContextApp != null) {
                parentAppId = parentContextApp.getId();
            }
            if (!(selected = appContext.getId().equals(parentAppId))) continue;
            selectVal = String.valueOf(parentAppId) + "-" + appContext.getVersion();
        }
        return selectVal;
    }

    public String getApplicationDevelopConfigNewAppSave(String appPropertyJson, int osFolderType, String icon96name, String icon64name, String icon16name, String appMaster, String manageUser, String manageRole) {
        JSONObject json = JSONArray.parseObject((String)appPropertyJson);
        json.put("appMaster", (Object)appMaster);
        manageUser = SDK.getORGAPI().getUserIds(manageUser).replaceAll("\"", "");
        manageRole = manageRole.replaceAll(",", " ");
        String modelAdministrator = String.valueOf(manageUser.trim()) + " " + manageRole.trim();
        json.put("modelAdministrator", (Object)modelAdministrator);
        ResponseObject ro = AMCUtil.createApp(this.getContext(), json, true);
        if (ro.isOk()) {
            String appId = "";
            appId = osFolderType == 1 || osFolderType == 2 ? UtilJson.optString(json, "byodAppId") : UtilJson.optString(json, "appId");
            this.moveIcon(appId, osFolderType, icon96name, icon64name, icon16name);
        }
        return ro.toString();
    }

    public void moveIcon(String appId, int osFolderType, String icon96name, String icon64name, String icon16name) {
        String sourcefilepath96 = "";
        String sourcefilepath64 = "";
        String sourcefilepath16 = "";
        String filevalue = "";
        filevalue = 1 == osFolderType ? "_iosicon" : (2 == osFolderType ? "_androidicon" : "_webicon");
        DCContext sourceIcon96 = new DCContext(this.getContext(), DCProfileManager.getDCProfile("_bpm.platform", "tmp"), "_bpm.platform", "appicon", filevalue, icon96name);
        DCContext sourceIcon64 = new DCContext(this.getContext(), DCProfileManager.getDCProfile("_bpm.platform", "tmp"), "_bpm.platform", "appicon", filevalue, icon64name);
        DCContext sourceIcon16 = new DCContext(this.getContext(), DCProfileManager.getDCProfile("_bpm.platform", "tmp"), "_bpm.platform", "appicon", filevalue, icon16name);
        sourceIcon96.setFileName(icon96name);
        sourceIcon64.setFileName(icon64name);
        sourceIcon16.setFileName(icon16name);
        sourcefilepath96 = sourceIcon96.getFilePath();
        sourcefilepath64 = sourceIcon64.getFilePath();
        sourcefilepath16 = sourceIcon16.getFilePath();
        File sourceFile96 = new File(sourcefilepath96);
        File sourceFile64 = new File(sourcefilepath64);
        File sourceFile16 = new File(sourcefilepath16);
        String targetFilePath = "../apps/install/" + appId + "/";
        File targetFile96 = new File(targetFilePath, "icon96.png");
        File targetFile64 = new File(targetFilePath, "icon64.png");
        File targetFile16 = new File(targetFilePath, "icon16.png");
        try {
            if (!icon96name.equals("") && icon96name != null && sourceFile96.exists()) {
                UtilFile.moveFile(sourceFile96, targetFile96);
                FastFiles.removeFile(String.valueOf(targetFilePath) + "icon96.png");
            }
            if (!icon64name.equals("") && icon64name != null && sourceFile64.exists()) {
                UtilFile.moveFile(sourceFile64, targetFile64);
                FastFiles.removeFile(String.valueOf(targetFilePath) + "icon64.png");
            }
            if (!icon16name.equals("") && icon16name != null && sourceFile16.exists()) {
                UtilFile.moveFile(sourceFile16, targetFile16);
                FastFiles.removeFile(String.valueOf(targetFilePath) + "icon16.png");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveApplicationDevelopConfig(String appId, String json) {
        json = JavascriptEscape.unescape(json);
        json = json.replaceAll("\n", "<br>");
        JSONObject info = new JSONObject();
        if (json.equals("")) {
            json = "{}";
        }
        JSONObject elements = JSONArray.parseObject((String)json);
        ResponseObject ro = AMCUtil.saveApp(this.getContext(), appId, elements);
        int osFolderType = elements.getIntValue("osFolderType");
        String icon96name = UtilJson.optString(elements, "icon96name");
        String icon64name = UtilJson.optString(elements, "icon64name");
        String icon16name = UtilJson.optString(elements, "icon16name");
        if (ro.isOk()) {
            this.moveIcon(appId, osFolderType, icon96name, icon64name, icon16name);
        }
        return ro.toString();
    }

    public String applicationDevelopMakeAppPercent(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        int percent = 0;
        percent = AppDist.percentMap.get(appId) != null ? (Integer)AppDist.percentMap.get(appId) : 0;
        JSONObject json = new JSONObject();
        json.put("percent", (Object)percent);
        ro.setData(json);
        return ro.toDataString();
    }

    public String applicationDevelopMakeApp(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject json = new JSONObject();
        AppContext constext = AppsAPIManager.getInstance().getAppContext(appId);
        try {
            String destPath = AppDist.makeApp((AppContext)constext);
            String appDestPath = this.getAppUrl(appId, destPath);
            json.put("status", (Object)"ok");
            json.put("appURL", (Object)appDestPath);
            ro.ok();
        }
        catch (AppContainerException e) {
            json.put("status", (Object)"fail");
            json.put("info", (Object)e.getMessage());
            ro.err(e.getMessage());
            e.printStackTrace();
        }
        ro.setData(json);
        return ro.toString();
    }

    private String getAppUrl(String appId, String sourceFilePath) {
        DCContext dc = new DCContext(this.getContext(), DCProfileManager.getDCProfile("_bpm.platform", "!appresource"), appId, "distFile", appId, String.valueOf(appId) + ".app");
        String downloadLink = dc.getDownloadURL();
        return downloadLink;
    }

    public String getTreeJson(String appId, String type, String pid) {
        JSONArray jsonArray = new JSONArray();
        if (UtilString.isEmpty(appId)) {
            return jsonArray.toString();
        }
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        List deploymentList = null;
        List systemList = null;
        deploymentList = ManifestXML.getInstance().getDeploymentDirectorys(appConfigFile);
        systemList = ManifestXML.getInstance().getDeploymentSystems(appConfigFile);
        String nav = String.valueOf(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u90e8\u7f72"))) + ">>" + I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u529f\u80fd\u83dc\u5355"));
        if (type.equals("root")) {
            JSONObject root = new JSONObject();
            Iterator<NavigationSystemModel> ns = NavigationSystemCache.getCache().iteratorSorted(NavigationSystemCache.SORT_ORDERINDEX);
            while (ns.hasNext()) {
                NavigationSystemModel navigationSystemModel = ns.next();
                String navigationSystemModelAppId = navigationSystemModel.getAppId();
                boolean isManager = AMCAPIManager.isManagementApp(navigationSystemModelAppId, this.getContext().getUID());
                List<NavigationDirectoryModel> dirs = NavigationDirectoryCache.getListOfSystem(navigationSystemModel.getId());
                boolean isHas = this.isHasOtherAppOfDirectory(dirs, navigationSystemModelAppId);
                if (isHas) {
                    isManager = true;
                }
                if (navigationSystemModelAppId.equals("") || isManager && !navigationSystemModelAppId.equals("")) {
                    if ("obj_ed721d4f4b5e468caa6fb5e0438c9918".equals(navigationSystemModel.getId()) || !this.hasSystemRight(navigationSystemModel.getId())) continue;
                    JSONObject attributes = new JSONObject();
                    attributes.put("isActivity", (Object)navigationSystemModel.isActivity());
                    attributes.put("orderIndex", (Object)navigationSystemModel.getOrderIndex());
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("id", (Object)("s_" + navigationSystemModel.getId()));
                    jsonObject.put("name", (Object)navigationSystemModel.getNameI18N());
                    if ("obj_007801f265cbfd38310eb1acdd53dc02".equals(navigationSystemModel.getId())) {
                        jsonObject.put("allowDrag", (Object)false);
                    } else {
                        jsonObject.put("allowDrag", (Object)true);
                    }
                    jsonObject.put("open", (Object)false);
                    jsonObject.put("iconCls", (Object)"nav-system");
                    jsonObject.put("disabled", (Object)(!navigationSystemModel.isActivity() ? 1 : 0));
                    jsonObject.put("attributes", (Object)attributes);
                    if (systemList != null) {
                        for (DeploymentSystem system : systemList) {
                            if (!navigationSystemModel.getId().equals(system.getId())) continue;
                            jsonObject.put("checked", (Object)true);
                            break;
                        }
                    }
                    jsonArray.add((Object)jsonObject);
                }
                List<NavigationDirectoryModel> nd = NavigationDirectoryCache.getListOfSystem(navigationSystemModel.getId());
                int d = 0;
                while (d < nd.size()) {
                    NavigationDirectoryModel navigationDirectoryModel = nd.get(d);
                    String dappId = navigationDirectoryModel.getAppId();
                    boolean disManager = AMCAPIManager.isManagementApp(dappId, this.getContext().getUID());
                    List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
                    boolean disHas = this.isHasOtherAppOfFunction(functions, dappId);
                    if (disHas) {
                        disManager = true;
                    }
                    if (dappId.equals("") || disManager && !dappId.equals("")) {
                        JSONObject attributes = new JSONObject();
                        attributes.put("isActivity", (Object)(navigationSystemModel.isActivity() && navigationDirectoryModel.isActivity() ? 1 : 0));
                        attributes.put("orderIndex", (Object)navigationDirectoryModel.getOrderIndex());
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)("d_" + navigationDirectoryModel.getId()));
                        jsonObject.put("pid", (Object)("s_" + navigationSystemModel.getId()));
                        jsonObject.put("name", (Object)navigationDirectoryModel.getNameI18N());
                        jsonObject.put("allowDrag", (Object)true);
                        jsonObject.put("open", (Object)false);
                        jsonObject.put("iconCls", (Object)"nav-directory");
                        jsonObject.put("disabled", (Object)(!navigationSystemModel.isActivity() || !navigationDirectoryModel.isActivity() ? 1 : 0));
                        jsonObject.put("attributes", (Object)attributes);
                        if (deploymentList != null) {
                            for (DeploymentDirectory deployment : deploymentList) {
                                if (!navigationDirectoryModel.getId().equals(deployment.getId())) continue;
                                jsonObject.put("checked", (Object)true);
                                break;
                            }
                        }
                        jsonArray.add((Object)jsonObject);
                    }
                    List<NavigationFunctionModel> nf = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
                    int i = 0;
                    while (i < nf.size()) {
                        NavigationFunctionModel navigationFunctionModel = nf.get(i);
                        String fappId = navigationFunctionModel.getAppId();
                        boolean isManagerFunction = AMCAPIManager.isManagementApp(fappId, this.getContext().getUID());
                        if (fappId.equals("") || isManagerFunction && !fappId.equals("")) {
                            Boolean bool = !"".equals(navigationFunctionModel.getAppId()) && !appId.equals(navigationFunctionModel.getAppId());
                            String name = navigationFunctionModel.getNameI18N();
                            if (bool.booleanValue()) {
                                name = String.valueOf(name) + "(" + navigationFunctionModel.getAppId() + ")";
                            }
                            JSONObject attributes = new JSONObject();
                            attributes.put("isActivity", (Object)(navigationSystemModel.isActivity() && navigationDirectoryModel.isActivity() && navigationFunctionModel.isActivity() ? 1 : 0));
                            attributes.put("orderIndex", (Object)navigationFunctionModel.getOrderIndex());
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("id", (Object)("f_" + navigationFunctionModel.getId()));
                            jsonObject.put("pid", (Object)("d_" + navigationDirectoryModel.getId()));
                            jsonObject.put("name", (Object)name);
                            jsonObject.put("allowDrag", (Object)true);
                            jsonObject.put("iconCls", (Object)"nav-function");
                            jsonObject.put("disabled", (Object)(!navigationSystemModel.isActivity() || !navigationDirectoryModel.isActivity() || !navigationFunctionModel.isActivity() || bool != false ? 1 : 0));
                            jsonObject.put("attributes", (Object)attributes);
                            jsonObject.put("leaf", (Object)true);
                            jsonObject.put("checked", (Object)appId.equals(fappId));
                            jsonArray.add((Object)jsonObject);
                        }
                        ++i;
                    }
                    ++d;
                }
            }
        }
        return jsonArray.toString();
    }

    public boolean isHasOtherAppOfDirectory(List<NavigationDirectoryModel> dirs, String appId) {
        boolean isHas = false;
        for (NavigationDirectoryModel navigationDirectoryModel : dirs) {
            if (!navigationDirectoryModel.getAppId().trim().equals(appId)) {
                isHas = true;
                break;
            }
            List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(navigationDirectoryModel.getId());
            isHas = this.isHasOtherAppOfFunction(functions, appId);
            if (!isHas) continue;
            isHas = true;
            break;
        }
        if (dirs.size() == 0) {
            isHas = true;
        }
        return isHas;
    }

    public boolean isHasOtherAppOfFunction(List<NavigationFunctionModel> functions, String appId) {
        boolean isHas = false;
        for (NavigationFunctionModel navigationFunctionModel : functions) {
            if (navigationFunctionModel.getAppId().equals(appId)) continue;
            isHas = true;
            break;
        }
        if (functions.size() == 0) {
            isHas = true;
        }
        return isHas;
    }

    public String getDeloyHtml(String appId, String id, String pid, String isNew) {
        if (!id.equals("") && isNew.equals("1")) {
            return this.createDeploy(id, true, appId, pid);
        }
        StringBuilder html = new StringBuilder();
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        if (id.indexOf("deploymentSystem") > -1) {
            UtilString ut = new UtilString(id);
            ArrayList v = (ArrayList)ut.split("\\-");
            String mpid = (String)v.get(0);
            DeploymentSystem system = ManifestXML.getInstance().getDeploymentSystemById(appConfigFile, mpid);
            html.append(this.getDeployment((NavTpl)system, false, appId, id, pid));
        } else if (id.indexOf("deploymentDirectorys") > -1) {
            if (pid.indexOf("deploymentSystem") > -1) {
                UtilString ut = new UtilString(pid);
                ArrayList v = (ArrayList)ut.split("\\-");
                String mpid = (String)v.get(0);
                UtilString ut2 = new UtilString(id);
                ArrayList v2 = (ArrayList)ut2.split("\\-");
                String myId = (String)v2.get(0);
                DeploymentDirectory deploymentDirectory = ManifestXML.getInstance().getDeploymentDirectorysById(appConfigFile, myId, mpid);
                html.append(this.getDeployment((NavTpl)deploymentDirectory, false, appId, id, pid));
            }
        } else if (id.indexOf("deploymentFunctions") > -1) {
            if (pid.indexOf("deploymentDirectorys") > -1) {
                UtilString ut = new UtilString(pid);
                ArrayList v = (ArrayList)ut.split("\\-");
                UtilString ut1 = new UtilString(id);
                ArrayList v2 = (ArrayList)ut1.split("\\-");
                String deploymentDirectoryId = (String)v.get(0);
                String myId = (String)v2.get(0);
                DeploymentFunction deploymentFunction = ManifestXML.getInstance().getDeploymentFunctionById(appConfigFile, myId, deploymentDirectoryId);
                html.append(this.getDeployment((NavTpl)deploymentFunction, false, appId, id, pid));
            } else if (pid.indexOf("system") > -1) {
                UtilString ut1 = new UtilString(id);
                ArrayList v2 = (ArrayList)ut1.split("\\-");
                String myId = (String)v2.get(0);
                DeploymentFunction deploymentFunction = ManifestXML.getInstance().getDeploymentFunctionById(appConfigFile, myId);
                html.append(this.getDeployment((NavTpl)deploymentFunction, false, appId, id, pid));
            }
        }
        return html.toString();
    }

    public String getDeloyTreeByParentType(String parentType, String tid, String formType) {
        StringBuilder tree = new StringBuilder();
        if (!parentType.equals("")) {
            String pid = "";
            if (parentType.indexOf("-") > -1) {
                pid = parentType.split("-")[0];
            }
            if (parentType.indexOf("system") > -1) {
                tree.append(this.getDeployJSON(tid, "1", pid, formType));
            } else if (parentType.indexOf("deploymentSystem") > -1) {
                tree.append(this.getDeployJSON(tid, "2", pid, formType));
            } else if (parentType.indexOf("deploymentDirectorys") > -1) {
                tree.append(this.getDeployJSON(tid, "3", pid, formType));
            }
        }
        return tree.toString();
    }

    public String getDeployJSON(String tid, String rank, String pid, String formType) {
        JSONArray jsonArray;
        block11: {
            block12: {
                block10: {
                    jsonArray = new JSONArray();
                    if (tid == null || !tid.equals("root")) break block10;
                    JSONObject root = new JSONObject();
                    root.put("id", (Object)"root");
                    root.put("name", (Object)I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u83dc\u5355\u7ed3\u6784")));
                    root.put("open", (Object)true);
                    root.put("iconCls", (Object)"tree_root");
                    jsonArray.add((Object)root);
                    Iterator ns = NavigationSystemCache.getCache().iterator();
                    while (ns.hasNext()) {
                        JSONObject node = new JSONObject();
                        NavigationSystemModel navigationSystemModel = (NavigationSystemModel)ns.next();
                        String appId = navigationSystemModel.getAppId();
                        if (appId.equals("")) {
                            appId = "_bpm.platform";
                        }
                        if (!AMCAPIManager.isManagementApp(appId, this.getContext().getUID()) || navigationSystemModel.getId().equals("obj_ed721d4f4b5e468caa6fb5e0438c9918") || !this.hasSystemRight(navigationSystemModel.getId()) || formType.equals("") && !pid.equals("") && !navigationSystemModel.getId().equals(pid)) continue;
                        node.put("id", (Object)("s_" + navigationSystemModel.getId()));
                        node.put("pid", (Object)"root");
                        if (rank != "1") {
                            node.put("open", (Object)false);
                        }
                        node.put("disabled", (Object)(!navigationSystemModel.isActivity() ? 1 : 0));
                        JSONObject attr = new JSONObject();
                        attr.put("isActivity", (Object)navigationSystemModel.isActivity());
                        attr.put("orderIndex", (Object)navigationSystemModel.getOrderIndex());
                        node.put("attributes", (Object)attr);
                        node.put("iconCls", (Object)"nav-system");
                        node.put("name", (Object)NavigationUtil.getLangName(this.getContext().getLanguage(), navigationSystemModel.getSystemName()));
                        JSONObject data = new JSONObject();
                        data.put("uuid", (Object)navigationSystemModel.getId());
                        data.put("icon16", (Object)navigationSystemModel.getIcon16());
                        data.put("icon64", (Object)navigationSystemModel.getIcon64());
                        data.put("icon96", (Object)navigationSystemModel.getIcon96());
                        data.put("url", (Object)navigationSystemModel.getLinkUrl());
                        data.put("target", (Object)navigationSystemModel.getLinkTarget());
                        data.put("appId", (Object)(navigationSystemModel.getAppId().equals("") ? "_bpm.platform" : navigationSystemModel.getAppId()));
                        node.put("data", (Object)data);
                        jsonArray.add((Object)node);
                    }
                    break block11;
                }
                if (!tid.startsWith("s_")) break block12;
                List<NavigationDirectoryModel> nd = NavigationDirectoryCache.getListOfSystem(tid.substring(2));
                NavigationSystemModel navigationSystemModel = NavigationSystemCache.getModel(tid.substring(2));
                int d = 0;
                while (d < nd.size()) {
                    NavigationDirectoryModel navigationDirectoryModel = nd.get(d);
                    String appId = navigationDirectoryModel.getAppId();
                    if (appId.equals("")) {
                        appId = "_bpm.platform";
                    }
                    if (AMCAPIManager.isManagementApp(appId, this.getContext().getUID())) {
                        JSONObject node = new JSONObject();
                        JSONObject attr = new JSONObject();
                        node.put("id", (Object)("d_" + navigationDirectoryModel.getId()));
                        node.put("name", (Object)NavigationUtil.getLangName(this.getContext().getLanguage(), navigationDirectoryModel.getDirectoryName()));
                        node.put("pid", (Object)tid);
                        if (rank != "2") {
                            node.put("open", (Object)false);
                        }
                        node.put("disabled", (Object)(!navigationSystemModel.isActivity() || !navigationDirectoryModel.isActivity() ? 1 : 0));
                        attr.put("isActivity", (Object)(navigationSystemModel.isActivity() && navigationDirectoryModel.isActivity() ? 1 : 0));
                        attr.put("orderIndex", (Object)navigationDirectoryModel.getOrderIndex());
                        node.put("attributes", (Object)attr);
                        node.put("iconCls", (Object)"nav-directory");
                        JSONObject data = new JSONObject();
                        data.put("uuid", (Object)navigationDirectoryModel.getId());
                        data.put("icon16", (Object)navigationDirectoryModel.getIcon16());
                        data.put("icon64", (Object)navigationDirectoryModel.getIcon64());
                        data.put("icon96", (Object)navigationDirectoryModel.getIcon96());
                        data.put("url", (Object)navigationDirectoryModel.getLinkUrl());
                        data.put("target", (Object)navigationDirectoryModel.getLinkTarget());
                        data.put("appId", (Object)(navigationDirectoryModel.getAppId().equals("") ? "_bpm.platform" : navigationDirectoryModel.getAppId()));
                        node.put("data", (Object)data);
                        jsonArray.add((Object)node);
                    }
                    ++d;
                }
                break block11;
            }
            if (!tid.startsWith("d_")) break block11;
            List<NavigationFunctionModel> nf = NavigationFunctionCache.getListOfDirectory(tid.substring(2));
            NavigationDirectoryModel navigationDirectoryModel = NavigationDirectoryCache.getModel(tid.substring(2));
            NavigationSystemModel navigationSystemModel = NavigationSystemCache.getModel(navigationDirectoryModel.getSystemId());
            int i = 0;
            while (i < nf.size()) {
                NavigationFunctionModel navigationFunctionModel = nf.get(i);
                String appId = navigationFunctionModel.getAppId();
                if (appId.equals("")) {
                    appId = "_bpm.platform";
                }
                if (AMCAPIManager.isManagementApp(appId, this.getContext().getUID())) {
                    JSONObject attr = new JSONObject();
                    JSONObject node = new JSONObject();
                    node.put("id", (Object)("f_" + navigationFunctionModel.getId()));
                    node.put("name", (Object)NavigationUtil.getLangName(this.getContext().getLanguage(), navigationFunctionModel.getFunctionName()));
                    node.put("pid", (Object)tid);
                    node.put("disabled", (Object)(!navigationSystemModel.isActivity() || !navigationDirectoryModel.isActivity() || !navigationFunctionModel.isActivity() ? 1 : 0));
                    attr.put("isActivity", (Object)(navigationSystemModel.isActivity() && navigationDirectoryModel.isActivity() && navigationFunctionModel.isActivity() ? 1 : 0));
                    attr.put("orderIndex", (Object)navigationFunctionModel.getOrderIndex());
                    node.put("attributes", (Object)attr);
                    node.put("iconCls", (Object)"nav-function");
                    JSONObject data = new JSONObject();
                    data.put("uuid", (Object)navigationFunctionModel.getId());
                    data.put("icon16", (Object)navigationFunctionModel.getIcon16());
                    data.put("icon64", (Object)navigationFunctionModel.getIcon64());
                    data.put("icon96", (Object)navigationFunctionModel.getIcon96());
                    data.put("url", (Object)navigationFunctionModel.getLinkUrl());
                    data.put("target", (Object)navigationFunctionModel.getLinkTarget());
                    data.put("appId", (Object)(navigationFunctionModel.getAppId().equals("") ? "_bpm.platform" : navigationFunctionModel.getAppId()));
                    node.put("data", (Object)data);
                    jsonArray.add((Object)node);
                }
                ++i;
            }
        }
        return jsonArray.toString();
    }

    private boolean hasSystemRight(String sysId) {
        return GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || AccessControlAPI.getInstance().havingPermission(this.getContext(), NavACCM.resourceType, sysId, NavACCM.MANAGER.getType());
    }

    public String getDeployment(NavTpl na, boolean isShow, String appId, String deployId, String pid) {
        boolean isRead = this.getNavIsRead(na, appId);
        String disabled = "";
        if (isRead) {
            disabled = "disabled='" + (isRead ? "disabled" : "") + "'";
        }
        StringBuilder html = new StringBuilder();
        String name = "";
        String rootPath = "../apps/" + appId + "/img/";
        String root64Path = "../apps/" + appId + "/img/";
        String root96Path = "../apps/" + appId + "/img/";
        String img16 = "";
        String img64 = "";
        String img96 = "";
        String target = "";
        String url = "";
        String id = "";
        String idDisplay = "none";
        String display = "none";
        String nameAndUrlDisplay = "none";
        String isShowDeployType = "1";
        String notifier = "";
        if (na != null) {
            id = na.getId();
            name = na.getName();
            img16 = na.getIcon16(appId);
            if (!img16.equals("")) {
                rootPath = img16.substring(0, img16.lastIndexOf("/") + 1);
            }
            if (img16.indexOf("/") > -1) {
                img16 = img16.substring(img16.lastIndexOf("/") + 1, img16.length());
            }
            if (!(img64 = na.getIcon64(appId)).equals("")) {
                root64Path = img64.substring(0, img64.lastIndexOf("/") + 1);
            }
            if (img64.indexOf("/") > -1) {
                img64 = img64.substring(img64.lastIndexOf("/") + 1, img64.length());
            }
            if (!(img96 = na.getIcon96(appId)).equals("")) {
                root96Path = img96.substring(0, img96.lastIndexOf("/") + 1);
            }
            if (img96.indexOf("/") > -1) {
                img96 = img96.substring(img96.lastIndexOf("/") + 1, img96.length());
            }
            notifier = na.getNotifier();
            target = na.getTarget();
            url = na.getUrl();
            isShowDeployType = na.getDeployType();
        }
        if (!deployId.equals("system")) {
            isShowDeployType = "2";
        }
        if (isShowDeployType.equals("1")) {
            nameAndUrlDisplay = "";
        }
        if (isShowDeployType.equals("2")) {
            display = "";
            nameAndUrlDisplay = "";
        }
        if (img16.equals("")) {
            img16 = "icon16.png";
        }
        if (img64.equals("")) {
            img64 = "icon64.png";
        }
        if (img96.equals("")) {
            img96 = "icon96.png";
        }
        if (isShow) {
            String dis = "none";
            if (deployId.equals("system")) {
                dis = "";
            }
            html.append("<tr nowrap='nowrap' style='display:" + dis + "'>");
            html.append("<td class='awsui-ux-title'  width=15%>" + I18nRes.findValue("_bpm.platform", "\u7c7b\u578b") + "</td><td>");
            html.append("<select class='awsui-select hasCustomSelect' id='deployUrlType' name='deployUrlType' onchange='AppDevelopConfigApp.changeDeployType(\"" + appId + "\");'>");
            if (isShowDeployType.equals("0")) {
                html.append("<!--<option value=0 selected>\u65e0\u9700\u90e8\u7f72</option>-->");
                html.append("<option value=1>" + I18nRes.findValue("_bpm.platform", "\u5355\u4e00\u7684\u529f\u80fd\u83dc\u5355") + "</option>");
                html.append("<option value=2>" + I18nRes.findValue("_bpm.platform", "\u7ec4\u5408\u7684\u529f\u80fd\u83dc\u5355") + "</option>");
            } else if (isShowDeployType.equals("1")) {
                html.append("<!--<option value=0 selected>\u65e0\u9700\u90e8\u7f72</option>-->");
                html.append("<option value=1 selected>" + I18nRes.findValue("_bpm.platform", "\u5355\u4e00\u7684\u529f\u80fd\u83dc\u5355") + "</option>");
                html.append("<option value=2>" + I18nRes.findValue("_bpm.platform", "\u7ec4\u5408\u7684\u529f\u80fd\u83dc\u5355") + "</option>");
            } else if (isShowDeployType.equals("2")) {
                html.append("<!--<option value=0 selected>\u65e0\u9700\u90e8\u7f72</option>-->");
                html.append("<option value=1>" + I18nRes.findValue("_bpm.platform", "\u5355\u4e00\u7684\u529f\u80fd\u83dc\u5355") + "</option>");
                html.append("<option value=2 selected>" + I18nRes.findValue("_bpm.platform", "\u7ec4\u5408\u7684\u529f\u80fd\u83dc\u5355") + "</option>");
            }
            html.append("</select>");
            html.append("</tr>");
            html.append("<tr nowrap='nowrap' id='idGenerationTr' style='display:" + display + ";'>");
            html.append("<td class='awsui-ux-title' >" + I18nRes.findValue("_bpm.platform", "\u6765\u6e90") + "</td><td>");
            html.append("<select  id='idGeneration' class='awsui-select' name='idGeneration' onchange='changeOpt();'>");
            html.append("<option value=0>" + I18nRes.findValue("_bpm.platform", "\u81ea\u5b9a\u4e49") + "</option>");
            String tmpId = "";
            int source = 0;
            File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
            if (deployId.indexOf("deploymentSystem") > -1) {
                tmpId = deployId.substring(0, deployId.indexOf("deploymentSystem") - 1);
                DeploymentSystem nav = DeployUtil.getDeploymentSystemById(appConfigFile, tmpId);
                source = nav.getSource();
            }
            if (source == 1 || deployId.equals("system")) {
                html.append("<option value=1>" + I18nRes.findValue("_bpm.platform", "\u4ece\u672c\u5730\u5f15\u7528") + "</option>");
            }
            html.append("</select>");
            html.append("</tr>");
        }
        html.append("<tr nowrap='nowrap' id='deployIdtr' style='display:" + idDisplay + ";'>");
        html.append("<td  class='awsui-ux-title' >ID</td><td nowrap='nowrap'>");
        html.append("<input class='awsui-textbox'   type='text' id='deployId' name='deployId'   disabled='disabled'    value='" + id + "'/>&nbsp;&nbsp;");
        html.append("</td>");
        html.append("</tr>");
        html.append("<tr  nowrap='nowrap' id='deployNameTr' >");
        html.append("<td for='deployName'  class='awsui-ux-title'>" + I18nRes.findValue("_bpm.platform", "\u540d\u79f0") + "</td><td nowrap='nowrap'>");
        html.append("<span class='required'><input type='text' style='width: 353px;'  id='deployName' " + disabled + " name='deployName' class='awsui-textbox' value='" + JavascriptEscape.unescape(name) + "'/></span>&nbsp;&nbsp;<span  id='searchBtn' onclick='AppDevelopConfigApp.serachDeployUUId();return false;' style='display:none;vertical-align: bottom;padding: 4px 5px;'><button style='padding:4px 12px;' type='button' class='awsui-btn'>" + I18nRes.findValue("_bpm.platform", "\u67e5\u8be2") + "</button></span>");
        html.append("</tr>");
        html.append("<tr nowrap='nowrap' id='smailPicTr' > ");
        html.append("<td   class='awsui-ux-title' nowrap='nowrap'>" + I18nRes.findValue("_bpm.platform", "\u5c0f\u56fe\u6807") + "(16x16)</td><td nowrap='nowrap'>");
        html.append("<span id='smailPicSpan'  style='width:43%'>" + rootPath + "</span><input type='text' style='width:20%' " + disabled + "   onkeyup='AppDevelopConfigApp.lookUp(\"smailPic\");return false;'   value='" + img16 + "' name='smailPic'   id='smailPic' class='awsui-textbox' /><img id='img_smailPic' width='16'    height='16' src='" + rootPath + img16 + "'>");
        html.append("</td>");
        html.append("</tr>");
        html.append("<tr nowrap='nowrap' id='bigPicTr'  >");
        html.append("<td  class='awsui-ux-title' nowrap='nowrap'>" + I18nRes.findValue("_bpm.platform", "\u4e2d\u56fe\u6807") + "(64x64)</td><td nowrap='nowrap'>");
        html.append("<span id='bigPicSpan' style='width:100%'>" + root64Path + "</span>");
        html.append("<input class='awsui-textbox'  " + disabled + "     style='width:20%'   onkeyup='AppDevelopConfigApp.lookUp(\"bigPic\");return false;' type='text' value='" + img64 + "' name='bigPic'   id='bigPic'  />");
        html.append("<img width='16' id='img_bigPic' style='vertical-align: bottom;' height='16'   src='" + root64Path + img64 + "'>");
        html.append("</td>");
        html.append("</tr>");
        html.append("<tr nowrap='nowrap' id='tbigPicTr'  >");
        html.append("<td  class='awsui-ux-title' nowrap='nowrap'>" + I18nRes.findValue("_bpm.platform", "\u5927\u56fe\u6807") + "(96x96)</td><td nowrap='nowrap'>");
        html.append("<span id='tbigPicSpan' style='width:100%'>" + root96Path + "</span>");
        html.append("<input class='awsui-textbox' " + disabled + "    style='width:20%'   onkeyup='AppDevelopConfigApp.lookUp(\"tbigPic\");return false;' type='text' value='" + img96 + "' name='tbigPic'   id='tbigPic'  />");
        html.append("<img width='16' id='img_tbigPic' style='vertical-align: bottom;' height='16'  src='" + root96Path + img96 + "'>");
        html.append("</td>");
        html.append("</tr>");
        html.append("<tr nowrap='nowrap' id='targetTr' >");
        html.append("<td  for='target' class='awsui-ux-title' >" + I18nRes.findValue("_bpm.platform", "\u76ee\u6807") + "</td><td>");
        StringBuilder select = new StringBuilder();
        select.append("<select class='awsui-select'   name='target' style='height:25px;'   id='target'   " + disabled + " >");
        if (target.equals("mainFrame")) {
            select.append("<option value='mainFrame' selected=selected >mainFrame</option>");
        } else {
            select.append("<option value='mainFrame'>mainFrame</option>");
        }
        if (target.equals("_blank")) {
            select.append("<option value='_blank' selected=selected >_blank</option>");
        } else {
            select.append("<option value='_blank' >_blank</option>");
        }
        select.append("</select>");
        html.append((CharSequence)select);
        html.append("</td>");
        html.append("<tr nowrap='nowrap' id='urlTr' >");
        html.append("<td for='url' class='awsui-ux-title' >URL</td><td td nowrap='nowrap'>");
        String requiredStart = "<span  class='required'>";
        String requiredEnd = "</span>";
        if (url.equals("")) {
            url = "/";
        }
        String urlHtml = "<input class='awsui-textbox' style='width:353px' " + disabled + "   type='text' value='" + url + "' name='url'   id='url'  /> <a href='#' onclick='parent.AppDevelop.lookUpURL(\"url\");return false;'>" + I18nRes.findValue("_bpm.platform", "\u9884\u89c8") + "</a>";
        urlHtml = String.valueOf(requiredStart) + urlHtml + requiredEnd;
        html.append(urlHtml);
        html.append("</td>");
        html.append("</tr>");
        html.append("<tr nowrap='nowrap' id='notifierTr' >");
        html.append("<td class='awsui-ux-title' >" + I18nRes.findValue("_bpm.platform", "\u4fe1\u606f\u63a8\u9001\u63a5\u53e3") + "</td><td td nowrap='nowrap'>");
        html.append("<input class='awsui-textbox'  style='width:353px' " + disabled + "   type='text' value='" + notifier + "' name='notifier'   id='notifier'  /> ");
        html.append("</td>");
        html.append("</tr>");
        html.append("<input type='hidden' id='menuId' name='meneId' value='" + id + "' />");
        html.append("<input type='hidden' id='itemId' name='itemId' value='" + deployId + "' />");
        html.append("<input type='hidden' id='pid' name='pid' value='" + pid + "' />");
        if (!isShow) {
            html.append("<input type='hidden' id='deployUrlType' name='deployUrlType' value='" + isShowDeployType + "' />");
        }
        return html.toString();
    }

    public boolean getNavIsRead(NavTpl nav, String appId) {
        NavigationFunctionModel functionModel;
        NavigationDirectoryModel directoryModel;
        NavigationSystemModel systemModel;
        boolean isRead = false;
        if (nav instanceof DeploymentSystem ? (systemModel = NavigationSystemCache.getModel(nav.getId())) != null && !systemModel.getAppId().equals(appId) : (nav instanceof DeploymentDirectory ? (directoryModel = NavigationDirectoryCache.getModel(nav.getId())) != null && !directoryModel.getAppId().equals(appId) : nav instanceof DeploymentFunction && (functionModel = NavigationFunctionCache.getModel(nav.getId())) != null && !functionModel.getAppId().equals(appId))) {
            return true;
        }
        return isRead;
    }

    public String createDeploy(String id, boolean isshow, String appId, String pid) {
        return this.getDeployment(null, isshow, appId, id, pid);
    }

    public String getTreePage(String formType) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", this.getContext().getSessionId());
        macroLibraries.put("formType", formType);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.tree.htm", macroLibraries);
    }

    public String delDeploy(String appId, String id, String tagName) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject info = new JSONObject();
        UtilString ut = new UtilString(id);
        ArrayList v = (ArrayList)ut.split("-");
        String nid = (String)v.get(0);
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        if (tagName.equals("system")) {
            NavigationSystemModel systemModel = NavigationSystemCache.getModel(nid);
            StringBuffer error = new StringBuffer();
            if (systemModel != null) {
                List<NavigationDirectoryModel> list = NavigationDirectoryCache.getListOfSystem(systemModel.getId());
                for (NavigationDirectoryModel dirmodel : list) {
                    if (dirmodel != null) {
                        List<NavigationFunctionModel> functions = NavigationFunctionCache.getListOfDirectory(dirmodel.getId());
                        for (NavigationFunctionModel function : functions) {
                            error.append(DeployUtil.removeAppFunctionDeployInfo(appId, function));
                        }
                        error.append(DeployUtil.removeAppDirectoryDeployInfo(appId, dirmodel));
                    }
                    error.append(DeployUtil.removeAppSystemDeployInfo(appId, systemModel));
                    if (error.indexOf("-1") == -1) {
                        info.put("status", (Object)"ok");
                        ro.ok();
                        ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f")));
                        continue;
                    }
                    info.put("status", (Object)"fail");
                    ro.warn();
                    ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25")));
                }
            }
        } else if (tagName.equals("directory")) {
            NavigationDirectoryModel dirModel = NavigationDirectoryCache.getModel(nid);
            if (dirModel != null) {
                List<NavigationFunctionModel> list = NavigationFunctionCache.getListOfDirectory(dirModel.getId());
                Iterator<NavigationFunctionModel> it = list.iterator();
                StringBuffer error = new StringBuffer();
                while (it.hasNext()) {
                    NavigationFunctionModel model = it.next();
                    error.append(DeployUtil.removeAppFunctionDeployInfo(appId, model));
                }
                error.append(DeployUtil.removeAppDirectoryDeployInfo(appId, dirModel));
                if (error.indexOf("-1") == -1) {
                    info.put("status", (Object)"ok");
                    ro.ok();
                    ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f")));
                } else {
                    info.put("status", (Object)"fail");
                    ro.err();
                    ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25")));
                }
            }
        } else {
            NavigationFunctionModel functionModel = NavigationFunctionCache.getModel(nid);
            if (functionModel != null) {
                String error = DeployUtil.removeAppFunctionDeployInfo(appId, functionModel);
                if (error.indexOf("-1") == -1) {
                    info.put("status", (Object)"ok");
                    ro.ok();
                    ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f")));
                } else {
                    info.put("status", (Object)"fail");
                    ro.err();
                    ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25")));
                }
            }
        }
        try {
            ManifestXML.getInstance().removeElement(appConfigFile, nid, tagName);
            info.put("status", (Object)"ok");
            info.put("mes", (Object)I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u529f\u80fd\u83dc\u5355\u6210\u529f")));
            ro.ok();
            ro.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u5220\u9664\u529f\u80fd\u83dc\u5355\u6210\u529f")));
        }
        catch (Exception e) {
            info.put("status", (Object)"error");
            ro.err();
            ro.msg(e.getMessage());
            e.printStackTrace();
        }
        ro.setData(info);
        return ro.toString();
    }

    public String getInstallAppNames(int navIndex) {
        ResponseObject ro = ResponseObject.newOkResponse();
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        AppsAPIManager.getInstance().sortAppByName(appContexts);
        JSONArray appNames = new JSONArray();
        JSONArray appTopThree = new JSONArray();
        JSONObject empty = new JSONObject();
        empty.put("id", (Object)"");
        empty.put("text", (Object)"");
        empty.put("imgs", (Object)"");
        appNames.add((Object)empty);
        for (AppContext appContext : appContexts) {
            boolean isRight = AMCAPIManager.isDevelopApp(appContext.getId(), this.getContext().getUID());
            if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID())) {
                isRight = true;
            }
            if (!isRight) continue;
            JSONObject json = new JSONObject();
            String img = AMCUtil.getAppIconNoClass(appContext.getId());
            String id = appContext.getId();
            json.put("id", (Object)id);
            json.put("text", (Object)(String.valueOf(I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName())) + "\uff08" + appContext.getId() + "\uff09"));
            json.put("value", (Object)appContext.getId());
            json.put("name", (Object)I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName()));
            json.put("imgs", (Object)img);
            if (appContext.getMobileAppProfile() != null) {
                json.put("apptype", (Object)MobileAppsResource.getOsType((MobileAppProfile)appContext.getMobileAppProfile()));
            } else {
                json.put("apptype", (Object)0);
            }
            if ("_bpm.platform".equals(id) || "_bpm.portal".equals(id) || "_bpm.coe".equals(id)) {
                appTopThree.add((Object)json);
                continue;
            }
            appNames.add((Object)json);
        }
        if (navIndex == 4) {
            return appNames.toString();
        }
        appTopThree.addAll((Collection)appNames);
        return appTopThree.toString();
    }

    public String getAppById(String appId) {
        ResponseObject responseObject = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app == null) {
            responseObject.warn();
            responseObject.msg(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u8be5App\u4e0d\u5b58\u5728")));
        }
        return responseObject.toString();
    }

    public String getUserList(String key) {
        JSONArray userJsonArray = new JSONArray();
        List users = UserCache.getActiveList();
        int i = 0;
        while (i < users.size()) {
            UserModel userModel = (UserModel)users.get(i);
            if (userModel.getUID().toLowerCase().indexOf(key.toLowerCase()) > -1 || userModel.getUserName().toLowerCase().indexOf(key.toLowerCase()) > -1) {
                JSONObject json = new JSONObject();
                json.put("id", (Object)userModel.getUID());
                json.put("label", (Object)userModel.getUserName());
                json.put("value", (Object)userModel.getUID());
                userJsonArray.add((Object)json);
            }
            ++i;
        }
        return userJsonArray.toString();
    }

    public String getApplicationDevelopConfigByodAppPage(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext appContext = SDK.getAppAPI().getAppContext(appId);
        MobileAppProfile mobile = appContext.getMobileAppProfile();
        if (mobile != null) {
            File file;
            int osType = MobileAppsResource.getOsType((MobileAppProfile)mobile);
            String prex = appContext.getId().replace(".", "_");
            String uploadfileName = "";
            String resourcePath = appContext.getMobileAppProfile().getResourceURI();
            if (resourcePath != null && (file = new File(resourcePath)).exists()) {
                uploadfileName = file.getName();
            }
            String selectVal = "";
            boolean isShowParentApp = true;
            List apps = AppsAPIManager.getInstance().getInstalledApps();
            selectVal = this.getSelectParentAppIdNoPlartFormAndPortal(apps, appContext);
            String category = AppCategoryCache.getCategory(null, (String)mobile.getAppContext().getId());
            String apptype = "";
            if (mobile.getResourceType().equals("framework")) {
                apptype = "iOS" + I18nRes.findValue("_bpm.platform", "\u539f\u751f");
            } else if (mobile.getResourceType().equals("h5plus")) {
                apptype = "H5+";
            } else if (mobile.getResourceType().equals("h5url")) {
                apptype = "H5";
            } else if (mobile.getResourceType().equals("itunes")) {
                apptype = "iTunes" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528");
            } else if (mobile.getResourceType().equals("weex")) {
                apptype = "Weex" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528");
            } else if (mobile.getResourceType().equals("package")) {
                if (osType == 2) {
                    apptype = "Android" + I18nRes.findValue("_bpm.platform", "\u539f\u751f");
                } else if (osType == 1) {
                    apptype = "iOS" + I18nRes.findValue("_bpm.platform", "\u539f\u751f");
                }
            }
            JSONObject json = new JSONObject();
            json.put("selectVal", (Object)selectVal);
            json.put("isShowParentApp", (Object)isShowParentApp);
            json.put("iconurl", (Object)appContext.getIcon96Url(this.getContext()));
            json.put("icon64url", (Object)appContext.getIcon64Url(this.getContext()));
            json.put("icon16url", (Object)appContext.getIcon16Url(this.getContext()));
            json.put("appName", (Object)appContext.getName());
            json.put("appId", (Object)appContext.getId());
            json.put("appRealId", (Object)MobileAppsResource.getRealAppId((MobileAppProfile)mobile));
            json.put("version", (Object)MobileAppsResource.getRealVersion((MobileAppProfile)mobile));
            json.put("developerName", (Object)appContext.getDeveloperName());
            json.put("developerUrl", (Object)appContext.getDeveloperUrl());
            json.put("prex", (Object)prex);
            json.put("os", (Object)osType);
            json.put("apptype", (Object)I18nRes.findValue("_bpm.platform", apptype));
            json.put("uploadfileName", (Object)uploadfileName);
            json.put("resourceType", (Object)appContext.getMobileAppProfile().getResourceType());
            json.put("resourceURI", (Object)appContext.getMobileAppProfile().getResourceURI());
            json.put("isAutoDistribute", (Object)mobile.isAutoDistribute());
            json.put("isBackupable", (Object)(mobile instanceof NativeAppProfile ? ((NativeAppProfile)mobile).isBackupable() : false));
            json.put("isCascadeRemove", (Object)(mobile instanceof NativeAppProfile ? ((NativeAppProfile)mobile).isCascadeRemove() : false));
            json.put("trackId", (Object)(mobile instanceof NativeAppProfile ? ((NativeAppProfile)mobile).getTrackId() : ""));
            json.put("deviceType", (Object)MobileAppsResource.getDeviceType((MobileAppProfile)mobile));
            json.put("ssoType", (Object)mobile.getSSOType());
            json.put("flag", (Object)"false");
            json.put("desc", (Object)appContext.getDescription());
            json.put("details", (Object)appContext.getDetails());
            json.put("category", (Object)category);
            JSONObject xmlValues = new JSONObject();
            xmlValues.put("productId", (Object)appContext.getProductId());
            xmlValues.put("modelAdministrator", (Object)appContext.getModelAdministrator());
            xmlValues.put("reloadable", (Object)String.valueOf(appContext.isReloadable()));
            xmlValues.put("installListener", (Object)appContext.getInstallListener());
            xmlValues.put("startListener", (Object)appContext.getStartListener());
            xmlValues.put("stopListener", (Object)appContext.getStopListener());
            xmlValues.put("upgradeListener", (Object)appContext.getUpgradeListener());
            xmlValues.put("uninstallListener", (Object)appContext.getUninstallListener());
            xmlValues.put("pluginListener", (Object)appContext.getPluginListener());
            ro.put("hiddenParams", "<input type='hidden' value='" + JavascriptEscape.escape(xmlValues.toJSONString()) + "' id='" + prex + "_appproperties'/>");
            ro.put("param", json);
        } else {
            ro.err(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u672a\u627e\u5230\u79fb\u52a8\u5e94\u7528\u914d\u7f6e")));
        }
        return ro.toString();
    }

    public String getSecurityPage(String appId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("appId", appId);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.byodconfigapp.dialog.access.htm", macroLibraries);
    }

    public String getSecurityGroupAdd(String id, String permissionType) {
        String sid = "<input type=hidden name=sid value=" + super.getContext().getSessionId() + ">\n";
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder options = new StringBuilder();
        options.append("<option value=''>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9\u5206\u7c7b") + "</option>");
        Iterator map = PermissionCache.getCache().iterator();
        while (map.hasNext()) {
            PermissionModel model = (PermissionModel)map.next();
            if (list.contains(model.getCategoryName())) continue;
            list.add(model.getCategoryName());
            options.append("<option value='" + model.getCategoryName() + "'>" + model.getCategoryName() + "</option>");
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("id", id);
        macroLibraries.put("permissionType", permissionType);
        macroLibraries.put("sid", sid);
        macroLibraries.put("options", options.toString());
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.byodconfig.dialog.security.add.htm", macroLibraries);
    }

    public String deleteDeveloperCer() {
        ResponseObject result = ResponseObject.newOkResponse();
        String developerpath = "../apps/developer.csr";
        File targetFile = new File(developerpath);
        if (targetFile.exists()) {
            if (targetFile.delete()) {
                result.ok(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u5220\u9664\u6210\u529f")));
                DeveloperKey.reload();
            } else {
                result.err(I18nRes.findValue("_bpm.platform", I18nRes.findValue("_bpm.platform", "\u6587\u4ef6\u5220\u9664\u5931\u8d25")));
            }
        }
        return result.toString();
    }
}

