/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.lifecycle.AppInstaller;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.UtilFile;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileFilter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApplicationInstallWeb
extends AMCWeb {
    public ApplicationInstallWeb(UserContext me) {
        super(me);
    }

    public String getApplicationInstallPage() {
        AppsAPIManager.getInstance().getInstalledApps();
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        String doInstallHtml = ApplicationInstallWeb.getToBeInstalledHtml(this.getContext());
        String visitStore = AMCUtil.getVisitStore("<button id='right' class='awsui-btn awsui-btn-blue' onclick='AppIntall.visitAppStroe();return false;'><span class='icon icon-edit'></span><span class='title'>\u8bbf\u95ee" + AMCUtil.getAppStoreName() + "</span></button>");
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("doInstallHtml", doInstallHtml);
        macroLibraries.put("visitStore", visitStore);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appinstall.htm", macroLibraries);
    }

    public static String getToBeInstalledHtml(UserContext me) {
        StringBuilder html = new StringBuilder();
        String doInstallAppPath = AppInstaller.getUploadPath();
        File f = new File(doInstallAppPath);
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".app");
            }
        });
        File[] tmpFiles = AMCUtil.queryAppTree(files);
        files = AMCUtil.getFileListOrderByLastModified(files);
        int m = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File zipFile = fileArray[n2];
            if (!zipFile.isDirectory()) {
                html.append("<tr>");
                JSONObject appContextJson = null;
                File ff = new File(zipFile.getPath());
                String fileName = ff.getName();
                String appId = "";
                boolean isApp = true;
                if (fileName.endsWith(".app")) {
                    appId = fileName.substring(0, fileName.lastIndexOf(".app"));
                } else {
                    isApp = false;
                    appId = fileName;
                }
                if (!fileName.endsWith(".app")) {
                    html.append(ApplicationInstallWeb.getNoManifestHtml(appId));
                    ++m;
                } else {
                    try {
                        appContextJson = AMCUtil.readZipFile(zipFile.getPath());
                        boolean isNeedInstall = AppInstaller.isInstall((String)appId);
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        String appName = UtilJson.optString(appContextJson, "name");
                        String version = UtilJson.optString(appContextJson, "version");
                        int buildNo = appContextJson.getIntValue("buildNo");
                        String releaseDate = UtilJson.optString(appContextJson, "releaseDate");
                        String warnStr = "";
                        String type = "\u4ea7\u54c1";
                        String appRId = appId.replaceAll("\\.", "_");
                        if (!isNeedInstall) {
                            AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
                            appName = app.getName();
                            version = String.valueOf(app.getVersion());
                            releaseDate = sdf.format(app.getReleaseDate());
                            buildNo = app.getBuildNo();
                        } else if (AMCAPIManager.isUnInstall(appId)) {
                            warnStr = "<font color='red'>(<b>\u5f53\u524dApp\u5df2\u5728\u5378\u8f7d\u5217\u8868\u4e2d\uff0c\u8bf7\u5148\u5f7b\u5e95\u5220\u9664\u540e\u518d\u5b89\u88c5</b>)</font>";
                        }
                        boolean isEnvErr = false;
                        String platformEnv = appContextJson.getString("env");
                        String msg = "";
                        if (!AppContextDepend.isDependEnvVersion((String)platformEnv)) {
                            msg = "\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u5e73\u53f0\u7248\u672c[" + platformEnv + "]\uff0c\u8bf7\u5347\u7ea7\u5e73\u53f0";
                            isEnvErr = true;
                            isNeedInstall = false;
                        }
                        try {
                            appContextJson.getString("productId");
                        }
                        catch (Exception e) {
                            type = "\u79c1\u6709";
                        }
                        appName = AMCUtil.getAppNewName(appName);
                        html.append("<td style='width: 43%;white-space:normal;' name='titleTd'>");
                        html.append("<span>" + appName + warnStr + "</span><br><span style='font-size: 12px;'>" + appId + "</span>");
                        html.append("</td>");
                        html.append("<td style='width: 6%'>" + version + "." + buildNo + "</td>");
                        html.append("<td style='width: 10%'>" + releaseDate + "</td>");
                        html.append("<td style='width: 7%'>&nbsp;" + type + "</td>");
                        if (isEnvErr) {
                            html.append("<td style='width: 10%' name='state' title='" + msg + "'><font color='red'><b>&nbsp;\u7248\u672c\u4f9d\u8d56\u5f02\u5e38</b></font></td>");
                        } else if (isNeedInstall) {
                            html.append("<td name='state' index='" + m + "' style='width: 10%' id='" + appRId + "_state' >\u5c31\u7eea</td>");
                        } else {
                            html.append("<td name='state' style='width: 10%' ><font color='red'><b>\u672c\u5730\u5df2\u7ecf\u5b89\u88c5</b></font></td>");
                        }
                        html.append("<td style='width:24%;' name='installTd'>");
                        if (isNeedInstall) {
                            html.append("<div style='float:left;height:28px;margin-top:10px;margin-right:5px;'  id='buttons_" + appRId + "'>");
                            String style = "padding-left:65px;";
                            if (warnStr.equals("")) {
                                html.append("<input type='button' id='i_" + appRId + "' class='awsui-btn awsui-btn-sm awsui-btn-blue' name='installBtn' appId='" + appId + "' " + Html.toHtmlJSEvent("onclick", "AppIntall.install", new Object[]{appId, appRId, false}) + "  value='\u5b89\u88c5'/>");
                                style = "";
                            }
                            html.append("</div>");
                            html.append("<div style='float:left;margin-top:10px;" + style + "'>");
                            html.append("<input type='button' id='g_" + appRId + "'  class='awsui-btn awsui-btn-sm awsui-btn-green' " + Html.toHtmlJSEvent("onclick", "AppIntall.giveup", new Object[]{appId, isApp}) + "  value='\u653e\u5f03'/>");
                            html.append("</div>");
                            html.append("<div style='float:right;height:28px;'>");
                            html.append("<div>");
                            html.append("<div id='log_" + appRId + "'  style='display:none;border-left: 1px solid #999999 ;margin: 1px;height: 36px;'>");
                            html.append("<img src='../apps/_bpm.platform/img/amc/up32.png' style='cursor:pointer;width:24px;height:24px;margin: 6px 5px 6px 7px;' id='s_" + appRId + "'  " + Html.toHtmlJSEvent("onclick", "AppIntall.showLog", new Object[]{appRId}) + "   title='\u663e\u793a\u5b89\u88c5\u65e5\u5fd7'/>");
                            html.append("</div>");
                            html.append("</div>");
                        } else {
                            html.append("</div>");
                            html.append("<div style='float:left;'>");
                            html.append("<input type='button' id='g_" + appRId + "'  class='awsui-btn awsui-btn-sm' onclick='AppIntall.giveup(\"" + appId + "\"," + isApp + ")'  value='\u653e\u5f03'/>");
                            html.append("</div>");
                        }
                        html.append("</td>");
                        html.append("</tr>");
                        html.append("<tr>");
                        html.append("<td colspan='6' style='border:0px;'>");
                        html.append("<div id='expInfo_" + appRId + "' style=\" display:none;margin-bottom:1px; border-width: 0 1px 1px 1px;border-style: solid;border-bottom-left-radius: 5px;border-bottom-right-radius: 5px;  left: 20px; height:200px; overflow:auto; font-family:'Courier New'; font-size:12px; background-color:#000; background-image:none; line-height:normal;white-space:nowrap\">");
                        html.append("<span style=\"color:#0F0;\" id='infomes_" + appRId + "'>");
                        html.append("</span>");
                        html.append("</div>");
                        html.append("</td>");
                        html.append("</tr>");
                    }
                    catch (Exception e) {
                        html.append(ApplicationInstallWeb.getNoManifestHtml(appId));
                        ++m;
                    }
                    ++m;
                }
            }
            ++n2;
        }
        return html.toString();
    }

    public static String getNoManifestHtml(String appId) {
        StringBuilder noManifestHtml = new StringBuilder();
        noManifestHtml.append("<tr>");
        noManifestHtml.append("<td style='width: 43%;white-space:normal;'name='titleTd' ><span>\u4e0d\u88ab\u8bc6\u522b\u7684\u6587\u4ef6\u683c\u5f0f</span><br><span style='font-size: 12px;'>" + appId + "</span></td>");
        noManifestHtml.append("<td  style='width: 6%'>&nbsp;&nbsp;N/A</td>");
        noManifestHtml.append("<td style='width: 10%'>&nbsp;&nbsp;&nbsp;&nbsp;N/A</td>");
        noManifestHtml.append("<td style='width: 6%'>&nbsp;&nbsp;N/A</td></td>");
        noManifestHtml.append("<td style='width: 10%'>\u6587\u4ef6\u9519\u8bef</td>");
        noManifestHtml.append(" <td style='width: 24%' name='installTd'><div style='float:left;padding-left:65px;'><input type='button'   id='g_" + appId.replaceAll("\\.", "_") + "' class='awsui-btn awsui-btn-sm' onclick='AppIntall.giveup(\"" + appId + "\",\"" + appId.replaceAll("\\.", "_") + "\")'  value='\u653e\u5f03'/></div></td>");
        noManifestHtml.append("</tr>");
        return noManifestHtml.toString();
    }

    public String getCompletionrateInfo(String appId, String l) {
        String str;
        int percent = 0;
        StringBuilder log = new StringBuilder();
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject info = new JSONObject();
        percent = AppInstaller.percentMap.get(appId) != null ? (Integer)AppInstaller.percentMap.get(appId) : 0;
        if (AppInstaller.percentMap.get(appId) != null && (percent = ((Integer)AppInstaller.percentMap.get(appId)).intValue()) == 100) {
            AppInstaller.percentMap.put(appId, 0);
        }
        info.put("percent", (Object)percent);
        List logs = AppsLogger.getLogs((String)appId);
        int start = 0;
        int end = 0;
        StringBuilder errorlog = new StringBuilder();
        try {
            for (AppLogMsg appLogBean : logs) {
                String msg = appLogBean.getMsg();
                if (msg == null) continue;
                if (appLogBean.getMsg().indexOf("\u51c6\u5907\u5b89\u88c5") > -1) {
                    ++start;
                }
                if (appLogBean.getMsg().indexOf("\u5b8c\u6210\u5b89\u88c5") > -1) {
                    ++end;
                }
                log.append(this.getLogInfo(appLogBean));
            }
        }
        catch (Exception it) {
            // empty catch block
        }
        String newLog = str = log.toString();
        String deployMessage = (String)AppInstaller.deployMessageMap.get(appId);
        if (deployMessage == null) {
            deployMessage = "";
        }
        if (newLog.equals("")) {
            newLog = "\u6570\u636e\u52a0\u8f7d\u4e2d...";
        } else if (errorlog.length() == 0 || errorlog.toString().equals("<br>")) {
            newLog = String.valueOf(newLog) + "<br>" + deployMessage;
        }
        info.put("log", (Object)newLog);
        ro.setData(info);
        return ro.toDataString();
    }

    private String getLogInfo(AppLogMsg appLogBean) {
        SimpleDateFormat smp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder log = new StringBuilder();
        if (appLogBean.getLevel().equals("err")) {
            log.append("<font style='color:red'>\u9519\u8bef:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "</font><br>");
        }
        if (appLogBean.getLevel().equals("warn")) {
            log.append("<font style='color:yellow'>\u8b66\u544a:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "</font><br>");
        } else {
            log.append("\u4fe1\u606f:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "<br>");
        }
        return log.toString();
    }

    public String installApp(String mappId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        Map installApp = new HashMap();
        try {
            List<String> v = new UtilString(mappId).split(",");
            ArrayList<String> newApps = new ArrayList<String>();
            int i = 0;
            while (i < v.size()) {
                String appId = v.get(i);
                if (appId != null && appId.trim().length() > 0) {
                    newApps.add(String.valueOf(appId.trim()) + ".app");
                }
                ++i;
            }
            installApp = AppInstaller.install(newApps);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        String str = "";
        try {
            str = ((String)installApp.get(mappId)).toString();
            if (str.equals("")) {
                str = ((String)installApp.get(String.valueOf(mappId) + ".app")).toString();
            }
        }
        catch (Exception ex) {
            str = ((String)installApp.get(String.valueOf(mappId) + ".app")).toString();
        }
        JSONObject da = new JSONObject();
        da.put("info", (Object)str);
        ro.setData(da);
        return ro.toDataString();
    }

    public String appGiveUp(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        UtilFile ut = new UtilFile(String.valueOf(AppInstaller.getUploadPath()) + "/" + appId + ".app");
        if (ut.exists()) {
            ut.delete();
            UtilFile ut2 = new UtilFile(String.valueOf(AppInstaller.getUploadPath()) + "/" + appId);
            if (ut2.exists()) {
                this.deleteDirectory(String.valueOf(AppInstaller.getUploadPath()) + "/" + appId);
            }
        } else {
            ut = new UtilFile(String.valueOf(AppInstaller.getUploadPath()) + "/" + appId);
            if (ut.exists()) {
                ut.delete();
            }
        }
        return ro.toString();
    }

    public boolean deleteDirectory(String sPath) {
        File dirFile;
        if (!sPath.endsWith(File.separator)) {
            sPath = String.valueOf(sPath) + File.separator;
        }
        if (!(dirFile = new File(sPath)).exists() || !dirFile.isDirectory()) {
            dirFile.delete();
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isFile() ? !(flag = this.deleteFile(files[i].getAbsolutePath())) : !(flag = this.deleteDirectory(files[i].getAbsolutePath()))) break;
            ++i;
        }
        if (!flag) {
            return false;
        }
        return dirFile.delete();
    }

    public boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }
}

