/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.AppPlatformConfig;
import com.actionsoft.apps.lifecycle.api.AppsAPIManager;
import com.actionsoft.apps.lifecycle.event.AppEventBus;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.resource.AppContext;
import com.actionsoft.apps.resource.AppContextDepend;
import com.actionsoft.apps.resource.AppContextProperty;
import com.actionsoft.apps.resource.AppContextPropertyImpl;
import com.actionsoft.apps.resource.AppContextWrapper;
import com.actionsoft.apps.resource.AppDependencyHelper;
import com.actionsoft.apps.resource.ManifestXML;
import com.actionsoft.apps.resource.deployment.DeploymentDirectory;
import com.actionsoft.apps.resource.deployment.DeploymentFunction;
import com.actionsoft.apps.resource.deployment.DeploymentSystem;
import com.actionsoft.apps.resource.deployment.NavTpl;
import com.actionsoft.apps.resource.interop.aslp.ASLPExecuter;
import com.actionsoft.apps.resource.plugin.meta.PluginMeta;
import com.actionsoft.apps.resource.plugin.meta.PluginMetas;
import com.actionsoft.apps.resource.plugin.profile.ACPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.ASLPPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.AWSPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.AddOnsPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.AppCustomActionPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.AppExtensionProfile;
import com.actionsoft.apps.resource.plugin.profile.AtFormulaPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.CachePluginProfile;
import com.actionsoft.apps.resource.plugin.profile.CloudDCPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.DCPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.FormThemePluginProfile;
import com.actionsoft.apps.resource.plugin.profile.FormUIPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.FullSearchPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.HttpASLP;
import com.actionsoft.apps.resource.plugin.profile.HumanPerformerPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.PALExtendsPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.PALMethodPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.ProcessPublicEventPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.SkinsPluginProfile;
import com.actionsoft.apps.resource.plugin.profile.WechatPluginProfile;
import com.actionsoft.bpms.bo.design.cache.BOCache;
import com.actionsoft.bpms.bpmn.engine.cache.ProcessDefCache;
import com.actionsoft.bpms.cc.CCUtil;
import com.actionsoft.bpms.cc.cache.CCCache;
import com.actionsoft.bpms.cc.model.CCModel;
import com.actionsoft.bpms.commons.addons.AddOnsManager;
import com.actionsoft.bpms.commons.amc.AMCAPIManager;
import com.actionsoft.bpms.commons.amc.util.AMCUtil;
import com.actionsoft.bpms.commons.amc.util.AppComparator;
import com.actionsoft.bpms.commons.amc.util.DeployUtil;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.devops.DevOpsWeb;
import com.actionsoft.bpms.commons.dictionary.util.XmlUtil;
import com.actionsoft.bpms.commons.htmlframework.HtmlFormTemplate;
import com.actionsoft.bpms.commons.htmlframework.HtmlPageTemplate;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationDirectoryCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationFunctionCache;
import com.actionsoft.bpms.commons.portal.navigation.cache.NavigationSystemCache;
import com.actionsoft.bpms.commons.portal.navigation.dao.NavigationDaoFactory;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationDirectoryModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationFunctionModel;
import com.actionsoft.bpms.commons.portal.navigation.model.NavigationSystemModel;
import com.actionsoft.bpms.commons.portal.navigation.model.impl.NavigationDirectoryModelImpl;
import com.actionsoft.bpms.commons.portal.navigation.util.NavigationUtil;
import com.actionsoft.bpms.commons.security.basic.PermAPIManager;
import com.actionsoft.bpms.commons.security.basic.dao.PermissionDaoFactory;
import com.actionsoft.bpms.commons.security.basic.model.PermissionListModel;
import com.actionsoft.bpms.commons.security.mgtgrade.util.GradeSecurityUtil;
import com.actionsoft.bpms.dw.design.cache.DWCache;
import com.actionsoft.bpms.form.design.cache.FormCache;
import com.actionsoft.bpms.schedule.cache.AWSScheduleCache;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.server.apps.AppClassLoader;
import com.actionsoft.bpms.server.apps.AppCmd;
import com.actionsoft.bpms.server.apps.AppController;
import com.actionsoft.bpms.server.apps.AppLoader;
import com.actionsoft.bpms.server.apps.AppsLoader;
import com.actionsoft.bpms.server.bind.annotation.Mapping;
import com.actionsoft.bpms.util.AES;
import com.actionsoft.bpms.util.Base64;
import com.actionsoft.bpms.util.Html;
import com.actionsoft.bpms.util.JavascriptEscape;
import com.actionsoft.bpms.util.MD5;
import com.actionsoft.bpms.util.UUIDGener;
import com.actionsoft.bpms.util.UtilJson;
import com.actionsoft.bpms.util.UtilString;
import com.actionsoft.emm.mam.apps.MobileAppProfile;
import com.actionsoft.emm.mam.apps.MobileAppsResource;
import com.actionsoft.emm.mam.dao.RecommendAppDao;
import com.actionsoft.exception.AWSObjectNotFindException;
import com.actionsoft.exception.AppContainerException;
import com.actionsoft.exception.ExceptionUtil;
import com.actionsoft.i18n.I18nMetadataUtil;
import com.actionsoft.i18n.I18nRes;
import com.actionsoft.sdk.local.SDK;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ApplicationManagementWeb
extends AMCWeb {
    String rootPath = "../apps/_bpm.platform/img/amc/";
    String twoLevelRootPath = "../commons/img/";
    String ext = ".png";
    JSONObject appJson;
    JSONObject requireJson;
    JSONObject linkJson;

    public ApplicationManagementWeb(UserContext me) {
        super(me);
    }

    public static JSONObject getAppStyle(String appId) {
        JSONObject itemStyle = new JSONObject();
        AppContext appContext = AppsAPIManager.getInstance().getAppContext(appId);
        String runTimeStatus = appContext.getRuntimeState();
        if (runTimeStatus != null) {
            if (runTimeStatus.equals("ACTIVE")) {
                itemStyle.put("color", (Object)"#eeeeee");
            } else if (runTimeStatus.equals("STOPPED") || runTimeStatus.equals("STOPPING") || runTimeStatus.equals("UNINSTALLED") || runTimeStatus.equals("UNINSTALLING") || runTimeStatus.equals("STARTING")) {
                itemStyle.put("color", (Object)"red");
            } else {
                itemStyle.put("color", (Object)"yellow");
            }
        }
        return itemStyle;
    }

    public String getApplicationManagementPage(String param) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        StringBuilder appStoreLink = new StringBuilder();
        AppPlatformConfig.initConfig();
        appStoreLink.append(" <input type=\"button\" onclick='ApplicationManagement.visitMoreInfo();'  class=\"awsui-btn awsui-btn-blue\" value=\"" + I18nRes.findValue("_bpm.platform", "\u6d4f\u89c8") + AppPlatformConfig.getAppStoreName() + I18nRes.findValue("_bpm.platform", "\u7684\u66f4\u591a\u4fe1\u606f") + "\"/></a>");
        appStoreLink.append(" <!--input type=\"button\" onclick='ApplicationManagement.checkNewVersion();' class=\"awsui-btn awsui-btn-green\" value=\"" + I18nRes.findValue("_bpm.platform", "\u65b0\u7248\u672c\u68c0\u67e5") + "\"/-->");
        macroLibraries.put("sid", super.getContext().getSessionId());
        macroLibraries.put("appStoreLink", appStoreLink.toString());
        macroLibraries.put("filteroption", this.getFilterOption());
        macroLibraries.put("param", param);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.htm", macroLibraries);
    }

    public String getFilterOption() {
        StringBuilder option = new StringBuilder();
        option.append("<option value='READY'> " + I18nRes.findValue("_bpm.platform", "\u5df2\u5c31\u7eea") + "</option>");
        option.append("<option value='ACTIVE'>" + I18nRes.findValue("_bpm.platform", "\u5df2\u542f\u52a8") + "</option>");
        option.append("<option value='STOPPED'>" + I18nRes.findValue("_bpm.platform", "\u5df2\u6682\u505c") + "</option>");
        option.append("<option value='FAILED'> " + I18nRes.findValue("_bpm.platform", "\u5df2\u51fa\u9519") + "</option>");
        option.append("<option value='OFFLINE'>" + I18nRes.findValue("_bpm.platform", "\u5df2\u8131\u673a") + "</option>");
        return option.toString();
    }

    public String getApplicationManagementGridData() {
        ArrayList<AppContext> apps = new ArrayList();
        ResponseObject ro = ResponseObject.newOkResponse();
        try {
            apps = AMCUtil.queryAllAppsList();
        }
        catch (AppContainerException e) {
            ro.err();
            ro.msg(e.getMessage());
            System.err.print(e.getMessage());
        }
        JSONObject gridData = new JSONObject();
        gridData.put("html", (Object)this.getApplicationManagementList());
        gridData.put("appMes", (Object)this.getSuspendStr(apps));
        ro.setData(gridData);
        return ro.toString();
    }

    public String getApplicationManagementDeployGridData(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject gridData = new JSONObject();
        String html = this.getDeployTableListHtml(appId);
        if (html.equals("<table width='100%' heigth='100%' style=' border-bottom: solid 1px #DBD4D4;' cellspacing='0' cellpadding='0' id='innerTable1'></table>")) {
            html = "<div style='width:100%; text-align:center;'>" + I18nRes.findValue("_bpm.platform", "\u5f53\u524d\u5e94\u7528\u4e2d\u6ca1\u6709\u90e8\u7f72\u529f\u80fd\u83dc\u5355") + " </div>";
        }
        String icon = AppsAPIManager.getInstance().getIcon64URL(appId, this.getContext());
        String appName = AppsAPIManager.getInstance().getAppContext(appId).getName();
        String deployAllHtm = "<span id='deployAll' onclick=\"ApplicationManagement.deployAllMenu('" + appId + "','" + appName + "','" + icon + "');return false;\" style='color:red;font-size:12px;font-weight:400;cursor:pointer'>\uff08" + I18nRes.findValue("_bpm.platform", "\u90e8\u7f72\u5168\u90e8") + "\uff09</span>";
        gridData.put("html", (Object)html);
        gridData.put("deployAllHtm", (Object)deployAllHtm);
        ro.setData(gridData);
        return ro.toString();
    }

    private String getSuspendStr(List<AppContext> apps) {
        int suspendCount = 0;
        int sum = 0;
        for (AppContext appContext : apps) {
            if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || AMCAPIManager.isDevelopApp(appContext.getId(), this.getContext().getUID()) || AMCAPIManager.isManagementApp(appContext.getId(), this.getContext().getUID())) {
                ++sum;
            }
            if (!appContext.getRuntimeState().equals("STOPPED")) continue;
            ++suspendCount;
        }
        String supendStr = String.valueOf(I18nRes.findValue("_bpm.platform", "\u5df2\u5b89\u88c5")) + apps.size() + I18nRes.findValue("_bpm.platform", "\u4e2a");
        if (!GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) && !GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) && sum > 0) {
            supendStr = String.valueOf(supendStr) + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u53ef\u8bbf\u95ee") + sum + I18nRes.findValue("_bpm.platform", "\u4e2a");
        }
        if (suspendCount > 0) {
            supendStr = String.valueOf(supendStr) + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u5176\u4e2d\u6709") + suspendCount + I18nRes.findValue("_bpm.platform", "\u4e2a\u6682\u505c");
        }
        return supendStr;
    }

    public String getAppOperateResult(String appId, String opeType) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject result = new JSONObject();
        String error = "";
        AppsAPIManager instance = AppsAPIManager.getInstance();
        if (opeType.equals("0")) {
            error = this.appreSuspend(appId, instance);
        } else if (opeType.equals("1")) {
            error = this.appStart(appId, instance);
        } else if (opeType.equals("2")) {
            error = this.appReStart(appId, instance);
        } else if (opeType.equals("3")) {
            error = this.appreUnInstall(appId, instance);
        }
        if (UtilString.isEmpty(error)) {
            result.put("status", (Object)"ok");
            ro.ok();
        } else {
            result.put("status", (Object)"fail");
            ro.warn();
        }
        result.put("error", (Object)error);
        ro.msg(error);
        ro.setData(result);
        return ro.toString();
    }

    public String getAppManagerOneRecod(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject result = new JSONObject();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        String supendStr = this.getSuspendStr(AppsAPIManager.getInstance().getInstalledApps());
        String html = this.getSingleAppNoTrHtml(app);
        result.put("html", (Object)html);
        result.put("appMes", (Object)supendStr);
        ro.setData(result);
        return ro.toString();
    }

    private String appStart(String appId, AppsAPIManager instance) {
        String error = "";
        AppContext app = instance.getAppContext(appId);
        String state = app.getRuntimeState();
        instance.start(this.getContext(), app);
        if ("READY".equals(state)) {
            AWSScheduleCache.getInstance().scheduleInstIfNot(appId);
        }
        return error;
    }

    private String appreSuspend(String appId, AppsAPIManager instance) {
        String error = "";
        instance.stop(instance.getAppContext(appId));
        return error;
    }

    private String appReStart(String appId, AppsAPIManager instance) {
        String error = "";
        instance.restart(this.getContext(), instance.getAppContext(appId));
        return error;
    }

    private String appreUnInstall(String appId, AppsAPIManager instance) {
        String error = "";
        Map unstallMesMap = instance.uninstall(instance.getAppContext(appId));
        if (unstallMesMap.size() > 0 && (error = (String)unstallMesMap.get(appId)).equals("ok")) {
            error = "";
            new RecommendAppDao().deleteApp(appId);
        }
        return error;
    }

    public String getApplicationManagementTabPage(String appId, String tabId) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        AppClassLoader classLoader = null;
        String appClassLoaderName = "";
        String appClassStartTime = "";
        String rootPath = "../apps/install/" + appId + "/lib/";
        File applib = new File(rootPath);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder dirs = new StringBuilder();
        if (app != null) {
            if (app.getBindClassLoader() != null && app.getBindClassLoader() instanceof AppClassLoader && (classLoader = (AppClassLoader)app.getBindClassLoader()).getURLs().length > 0) {
                appClassLoaderName = classLoader.toString();
                File[] list = applib.listFiles();
                int i = 0;
                while (i < list.length) {
                    File file = list[i];
                    if (file.getName().indexOf(".jar") > -1) {
                        dirs.append(String.valueOf(rootPath) + file.getName() + "<br>");
                    }
                    ++i;
                }
                appClassStartTime = sf.format(classLoader.getStartTime());
            }
            String nullStr = I18nRes.findValue("_bpm.platform", "\u65e0");
            if ("toolbar-overview".equals(tabId)) {
                SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat sdfDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                double versionID = app.getVersion();
                int no = app.getBuildNo();
                String releaseDate = sdfDate.format(app.getReleaseDate());
                String developerName = app.getDeveloperName();
                String overview = app.getDescription();
                String details = app.getDetails();
                String appStatus = AMCUtil.getAppRunTimeStatus(app.getRuntimeState());
                String startDate = "";
                String startTime = "";
                String installDate = "";
                String installTime = "";
                String upgradeDate = nullStr;
                String upgradeTime = nullStr;
                String restoreDate = nullStr;
                String restoreTime = nullStr;
                if (app.getStartTime() != null) {
                    startDate = sdfDate.format(app.getStartTime());
                    startTime = sdfDateTime.format(app.getStartTime());
                }
                if (app.getInstallDate() != null) {
                    installDate = sdfDate.format(app.getInstallDate());
                    installTime = sdfDateTime.format(app.getInstallDate());
                }
                if (app.getUpgradeDate() != null) {
                    upgradeDate = sdfDate.format(app.getUpgradeDate());
                    upgradeTime = sdfDateTime.format(app.getUpgradeDate());
                }
                if (app.getRestoreDate() != null) {
                    restoreDate = sdfDate.format(app.getRestoreDate());
                    restoreTime = sdfDateTime.format(app.getRestoreDate());
                }
                String appIcon = AppsAPIManager.getInstance().getIcon64URL(appId, this.getContext());
                String appDepand = this.getAppDepend(app);
                String reverseDepend = this.getReverseDepend(appId);
                macroLibraries.put("appId", appId);
                if (app.getMobileAppProfile() != null) {
                    macroLibraries.put("versionID", MobileAppsResource.getRealVersion((MobileAppProfile)app.getMobileAppProfile()));
                } else {
                    macroLibraries.put("versionID", String.valueOf(versionID) + "." + no);
                }
                macroLibraries.put("releaseDate", releaseDate);
                macroLibraries.put("developerName", I18nRes.findValue("_bpm.platform", developerName));
                overview = overview.replaceAll("\n", "<br>");
                overview = overview.replaceAll("&gt;", "<");
                overview = overview.replaceAll("&lt;", ">");
                details = details.replaceAll("\n", "<br>");
                details = details.replaceAll("&lt;", "<");
                details = details.replaceAll("&gt;", ">");
                macroLibraries.put("overview", overview);
                macroLibraries.put("details", details);
                macroLibraries.put("appStatus", I18nRes.findValue("_bpm.platform", appStatus));
                macroLibraries.put("startDate", startDate);
                macroLibraries.put("startTime", startTime);
                macroLibraries.put("installDate", installDate);
                macroLibraries.put("installTime", installTime);
                macroLibraries.put("upgradeDate", upgradeDate);
                macroLibraries.put("upgradeTime", upgradeTime);
                macroLibraries.put("restoreDate", restoreDate);
                macroLibraries.put("restoreTime", restoreTime);
                macroLibraries.put("appIcon", appIcon);
                macroLibraries.put("appDepand", appDepand);
                macroLibraries.put("reverseDepend", reverseDepend);
                boolean isRepeat = AMCUtil.checkRepeat(app);
                macroLibraries.put("buttonList", AMCUtil.getInputButton(app, false, this.getContext(), isRepeat));
                int errorCount = AMCUtil.getAppNotificationCount(appId, "err", false);
                int warnCount = AMCUtil.getAppNotificationCount(appId, "warn", false);
                StringBuffer mesCountStr = new StringBuffer();
                if (errorCount > 0) {
                    String errCountStr = String.valueOf(errorCount);
                    if (errorCount > 99) {
                        errCountStr = "99+";
                    }
                    mesCountStr.append(" <span id='errormes' class='overview error'>" + errCountStr + "</span>");
                }
                if (warnCount > 0) {
                    String warnCountStr = String.valueOf(warnCount);
                    if (warnCount > 99) {
                        warnCountStr = "99+";
                    }
                    mesCountStr.append("<span id='warnmes' class='overview warn'>" + warnCountStr + "</span>");
                }
                StringBuilder input = new StringBuilder();
                String disAppStore = "";
                disAppStore = AppPlatformConfig.isAppStoreService() && !app.getProductId().equals("") ? "true" : "false";
                input.append("<input type='hidden' id='disAppStore' value='" + disAppStore + "'>");
                macroLibraries.put("disAppStore", input.toString());
                macroLibraries.put("mescount", mesCountStr.toString());
                macroLibraries.put("suspendState", app.isSuspend() ? "" : "checked='checked'");
                macroLibraries.put("devOpsInfo", new DevOpsWeb(this.getContext()).getDevOpsWebHtml(appId));
                return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.overview.htm", macroLibraries);
            }
            if ("toolbar-deploy".equals(tabId)) {
                StringBuilder isHotDeploy = new StringBuilder();
                StringBuilder isShow = new StringBuilder();
                if (app.isReloadable()) {
                    isHotDeploy.append("<input type='checkbox' disabled='disbaled' checked='checked' class='awsui-checkbox'/> ");
                } else {
                    isHotDeploy.append("<input type='checkbox' disabled='disbaled'  class='awsui-checkbox'/>");
                }
                if (app.isCategoryVisible()) {
                    isShow.append("<input type='checkbox' disabled='disbaled' checked='checked'  class='awsui-checkbox'/>");
                } else {
                    isShow.append("<input type='checkbox' disabled='disbaled'  class='awsui-checkbox'/>");
                }
                int i18nSize = I18nRes.getResourceMapByApp(appId).size();
                int boSize = BOCache.getInstance().getListByApp(appId).size();
                int formSize = FormCache.getInstance().getListByApp(appId).size();
                int processSize = ProcessDefCache.getInstance().getListByApp(appId).size();
                int dwSize = DWCache.getInstance().getListByApp(appId).size();
                int htmlFormSize = HtmlFormTemplate.getListByApp(appId).size();
                int htmlPageSize = HtmlPageTemplate.getListByApp(appId).size();
                int mobileAppSize = MobileAppsResource.getListByApp((String)appId).size();
                int xmlDictionarySize = 0;
                xmlDictionarySize = XmlUtil.getFileName((String)appId, (boolean)true).size() + XmlUtil.getFileName((String)appId, (boolean)false).size();
                int unSafetyCmd = 0;
                String unSafeCmdHtml = "";
                if (SDK.getAppAPI().isActive(app)) {
                    Map cmds = AppsLoader.getInstance().getAppLoader(appId).getCmds();
                    for (String cmd : cmds.keySet()) {
                        if (((AppCmd)cmds.get(cmd)).getMapping().session() || cmd.equals("AWSPAASCLOUD_API")) continue;
                        ++unSafetyCmd;
                    }
                    if (unSafetyCmd > 0) {
                        unSafeCmdHtml = "<div style='float: right;height: 20px;line-height: 20px;background-color: rgb(249, 210, 110);padding: 8px;border: 1px solid red;margin-top: -20px;font-size: 13px;'>";
                        unSafeCmdHtml = String.valueOf(unSafeCmdHtml) + I18nRes.findValue("_bpm.platform", "\u8be5\u5e94\u7528\u542b\u6709") + "<a href='javascript:showUNSafeCMD()'  style='font-weight: bold;'>(" + unSafetyCmd + ")</a>" + I18nRes.findValue("_bpm.platform", "\u4e2a\u4e0d\u9a8c\u8bc1\u4f1a\u8bdd\u7684") + "cmd</div>";
                    }
                }
                macroLibraries.put("unSafetyCmd", unSafeCmdHtml);
                macroLibraries.put("i18nSize", i18nSize == 0 ? "" : Integer.valueOf(i18nSize));
                macroLibraries.put("boSize", boSize == 0 ? "" : Integer.valueOf(boSize));
                macroLibraries.put("formSize", formSize == 0 ? "" : Integer.valueOf(formSize));
                macroLibraries.put("processSize", processSize == 0 ? "" : Integer.valueOf(processSize));
                macroLibraries.put("dwSize", dwSize == 0 ? "" : Integer.valueOf(dwSize));
                macroLibraries.put("htmlFormSize", htmlFormSize == 0 ? "" : Integer.valueOf(htmlFormSize));
                macroLibraries.put("htmlPageSize", htmlPageSize == 0 ? "" : Integer.valueOf(htmlPageSize));
                macroLibraries.put("mobileAppsSize", mobileAppSize == 0 ? "" : Integer.valueOf(mobileAppSize));
                macroLibraries.put("xmlDictionarySize", xmlDictionarySize == 0 ? "" : Integer.valueOf(xmlDictionarySize));
                macroLibraries.put("isHotDeploy", isHotDeploy);
                macroLibraries.put("isShow", isShow);
                macroLibraries.put("appClassLoaderName", appClassLoaderName.equals("") ? nullStr : appClassLoaderName);
                macroLibraries.put("appClassDir", dirs == null || dirs.length() == 0 ? nullStr : dirs);
                macroLibraries.put("appClassStartTime", appClassStartTime.equals("") ? nullStr : appClassStartTime);
                String s = (String)macroLibraries.get("appClassStartTime");
                s = String.valueOf(s) + "<br/><br/>" + I18nRes.findValue("_bpm.platform", "\u5b58\u5728\u56de\u6536\u5386\u53f2") + "\uff1a" + (AppsLoader.checkAppGC((String)app.getId()) ? I18nRes.findValue("_bpm.platform", "\u662f") : I18nRes.findValue("_bpm.platform", "\u5426"));
                Collection info = AppsLoader.getMonitor((String)app.getId());
                if (!UtilString.isEmpty(info)) {
                    s = String.valueOf(s) + "<br/><br/><font color='red'>" + I18nRes.findValue("_bpm.platform", "\u5c1a\u672a\u56de\u6536\u8d44\u6e90") + "\uff1a" + UtilString.join(info, ",") + "</font>";
                }
                macroLibraries.put("appClassStartTime", s);
                return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.resource.htm", macroLibraries);
            }
            if ("toolbar-param".equals(tabId)) {
                String icon = AppsAPIManager.getInstance().getIcon64URL(appId, this.getContext());
                String delParams = "<span class='awsui-btn awsui-btn-danger' id='del_btn' style='display:none;' onclick='ApplicationManagement.delParams(\"" + appId + "\",\"" + app.getName() + "\",\"" + icon + "\");return false;'>" + I18nRes.findValue("_bpm.platform", "\u5220\u9664") + "</span>";
                macroLibraries.put("delParams", delParams);
                return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.param.htm", macroLibraries);
            }
            if ("toolbar-info".equals(tabId)) {
                List notification = app.getNotification();
                int totalPage = notification.size() % 50 > 0 ? notification.size() / 50 + 1 : notification.size() / 50;
                String more = "";
                if (totalPage > 1) {
                    more = "<span id='more'><a href='#' style='margin-left: 5px;margin-top:10px;font-size: 14px' onclick='ApplicationManagement.getMoreRecodes();return false;'>" + I18nRes.findValue("_bpm.platform", "\u67e5\u770b\u66f4\u591a\u6d88\u606f\u8bb0\u5f55") + "</a></span>";
                }
                String html = AMCUtil.getSuspendStr(appId);
                macroLibraries.put("html", html);
                macroLibraries.put("more", more);
                return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.info.htm", macroLibraries);
            }
            if ("toolbar-deploy2".equals(tabId)) {
                return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.deploy.htm", macroLibraries);
            }
            if ("toolbar-ref".equals(tabId)) {
                return this.getRelationship(appId, macroLibraries, app);
            }
        }
        return "";
    }

    private String getRelationship(String appId, Map<String, Object> macroLibraries, AppContext app) {
        JSONArray relationLinkerData = new JSONArray();
        JSONArray relationNodeData = this.getRelationData(appId, relationLinkerData);
        macroLibraries.put("relationNodeData", relationNodeData);
        macroLibraries.put("relationLinkerData", relationLinkerData);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.appref.htm", macroLibraries);
    }

    public String getUnSafeCmdList(String appId) {
        Map cmds = AppsLoader.getInstance().getAppLoader(appId).getCmds();
        StringBuilder sb = new StringBuilder();
        for (String cmd : cmds.keySet()) {
            Mapping map = ((AppCmd)cmds.get(cmd)).getMapping();
            if (map.session() || cmd.equals("AWSPAASCLOUD_API")) continue;
            sb.append("<tr><td>" + cmd + "</td><td>" + (UtilString.isEmpty(map.noSessionReason()) ? "" : map.noSessionReason()) + "</td><td>" + (UtilString.isEmpty(map.noSessionEvaluate()) ? "" : map.noSessionEvaluate()) + "</td></tr>");
        }
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("tbody", sb);
        macroLibraries.put("sid", this.getSIDFlag());
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appmanagement.unsafe.htm", macroLibraries);
    }

    private JSONArray getRelationData(String appId, JSONArray linkChartData) {
        JSONArray relationNodeData = new JSONArray();
        this.appJson = new JSONObject();
        this.requireJson = new JSONObject();
        this.linkJson = new JSONObject();
        AppContext currentApp = AppsAPIManager.getInstance().getAppContext(appId);
        relationNodeData.add((Object)this.getNodeData(relationNodeData, currentApp, "self"));
        this.findDepend(appId, relationNodeData, linkChartData);
        this.findChildren(appId, relationNodeData, linkChartData);
        int size = relationNodeData.size();
        int i = 0;
        while (i < size) {
            JSONObject json = relationNodeData.getJSONObject(i);
            appId = json.getString("appId");
            this.findRequire(appId, relationNodeData, linkChartData);
            ++i;
        }
        JSONArray newData = new JSONArray();
        int i2 = 0;
        while (i2 < relationNodeData.size()) {
            JSONObject json = relationNodeData.getJSONObject(i2);
            if (json != null) {
                newData.add((Object)json);
            }
            ++i2;
        }
        relationNodeData = newData;
        return relationNodeData;
    }

    private void findDepend(String appId, JSONArray relationNodeData, JSONArray linkChartData) {
        AppContext currentApp = AppsAPIManager.getInstance().getAppContext(appId);
        AppContextDepend appDependContext = currentApp.getDepend();
        if (appDependContext == null) {
            return;
        }
        AppContext dependApp = AppsAPIManager.getInstance().getAppContext(appDependContext.getAppId());
        if (dependApp != null) {
            JSONObject item = this.getNodeData(relationNodeData, dependApp, "depend");
            relationNodeData.add((Object)item);
            this.getLink(this.appJson.getIntValue(appId), this.appJson.getIntValue(dependApp.getId()), linkChartData, "depend");
            this.findDepend(dependApp.getId(), relationNodeData, linkChartData);
        }
    }

    private void findChildren(String appId, JSONArray relationNodeData, JSONArray linkChartData) {
        List<AppContext> list = AMCUtil.getReverseDependApps(appId);
        for (AppContext app : list) {
            JSONObject item = this.getNodeData(relationNodeData, app, "children");
            relationNodeData.add((Object)item);
            this.getLink(this.appJson.getIntValue(app.getId()), this.appJson.getIntValue(appId), linkChartData, "children");
            this.findChildren(app.getId(), relationNodeData, linkChartData);
        }
    }

    private void findRequire(String appId, JSONArray relationNodeData, JSONArray linkChartData) {
        if (this.requireJson.containsKey((Object)appId)) {
            return;
        }
        this.requireJson.put(appId, (Object)"0");
        List<AppContext> appList = AMCUtil.getAppRequires(appId);
        for (AppContext app : appList) {
            JSONObject item = this.getNodeData(relationNodeData, app, "require");
            relationNodeData.add((Object)item);
            this.getLink(this.appJson.getIntValue(appId), this.appJson.getIntValue(app.getId()), linkChartData, "require");
            this.findRequire(app.getId(), relationNodeData, linkChartData);
        }
    }

    private void getLink(int source, int target, JSONArray linkChartData, String type) {
        String linkStr = String.valueOf(source) + "-" + target;
        if (this.linkJson.containsKey((Object)linkStr)) {
            return;
        }
        this.linkJson.put(linkStr, (Object)"0");
        JSONObject item = new JSONObject();
        item.put("id", (Object)String.valueOf(linkChartData.size()));
        item.put("target", (Object)String.valueOf(source));
        item.put("source", (Object)String.valueOf(target));
        JSONObject lineStyle = new JSONObject();
        lineStyle.put("color", (Object)"#aeaeae");
        if (type.equals("depend")) {
            lineStyle.put("width", (Object)5);
        } else if (type.equals("children")) {
            lineStyle.put("width", (Object)3);
        } else if (type.equals("require")) {
            lineStyle.put("type", (Object)"dashed");
        }
        item.put("lineStyle", (Object)lineStyle);
        if (!linkChartData.contains((Object)item)) {
            linkChartData.add((Object)item);
        }
    }

    private JSONObject getNodeData(JSONArray treeChartData, AppContext app, String type) {
        String appId = app.getId();
        if (this.appJson.containsKey((Object)appId)) {
            return null;
        }
        this.appJson.put(appId, (Object)treeChartData.size());
        JSONObject item = new JSONObject();
        item.put("id", (Object)String.valueOf(treeChartData.size()));
        String name = app.getName();
        MobileAppProfile mobile = app.getMobileAppProfile();
        if (mobile != null) {
            String suffix = "(";
            if (MobileAppsResource.isNativeApp((MobileAppProfile)mobile)) {
                int osType = MobileAppsResource.getOsType((MobileAppProfile)mobile);
                suffix = osType == 2 ? String.valueOf(suffix) + "Android\u5e94\u7528" : String.valueOf(suffix) + "iOS\u5e94\u7528";
            } else if (MobileAppsResource.isH5App((MobileAppProfile)mobile)) {
                suffix = String.valueOf(suffix) + "H5\u5e94\u7528";
            }
            suffix = String.valueOf(suffix) + ")";
            if (suffix.length() > 2) {
                name = String.valueOf(name) + suffix;
            }
        }
        String statusLabel = "(";
        String runTimeStatus = app.getRuntimeState();
        if (runTimeStatus != null && !runTimeStatus.equals("ACTIVE")) {
            statusLabel = runTimeStatus.equals("STOPPED") || runTimeStatus.equals("STOPPING") || runTimeStatus.equals("UNINSTALLED") || runTimeStatus.equals("UNINSTALLING") || runTimeStatus.equals("STARTING") ? String.valueOf(statusLabel) + "\u5df2\u6682\u505c" : String.valueOf(statusLabel) + "\u5df2\u505c\u6b62";
        }
        if ((statusLabel = String.valueOf(statusLabel) + ")").length() > 2) {
            name = String.valueOf(name) + statusLabel;
        }
        item.put("name", (Object)name);
        item.put("appId", (Object)appId);
        item.put("draggable", (Object)true);
        int symbolSize = 0;
        String category = "";
        if (type.equals("self")) {
            symbolSize = 50;
            category = "\u5f53\u524d\u5e94\u7528";
        } else if (type.equals("depend")) {
            symbolSize = 30;
            category = "\u4f9d\u8d56\u5e94\u7528";
        } else if (type.equals("children")) {
            symbolSize = 30;
            category = "\u88ab\u4f9d\u8d56\u5e94\u7528";
        } else if (type.equals("require")) {
            symbolSize = 30;
            category = "\u5173\u8054\u5e94\u7528";
        }
        item.put("type", (Object)type);
        item.put("category", (Object)category);
        item.put("symbolSize", (Object)symbolSize);
        return item;
    }

    private String getDeployTableListHtml(String appId) {
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        StringBuilder tables = new StringBuilder();
        tables.append(this.getDeployHtml(appId));
        List functions = ManifestXML.getInstance().getDeploymentFunctions(appConfigFile);
        for (DeploymentFunction deploymentFunction : functions) {
            if (deploymentFunction.getName().equals("")) continue;
            String path = "";
            String id = "";
            NavigationSystemModel sysmodel = NavigationSystemCache.getModel(deploymentFunction.getId());
            if (sysmodel != null) {
                path = NavigationUtil.getLangName(this.getContext().getLanguage(), sysmodel.getSystemName());
                id = sysmodel.getId();
            } else {
                NavigationDirectoryModel dirModel = NavigationDirectoryCache.getModel(deploymentFunction.getId());
                if (dirModel != null) {
                    NavigationSystemModel sysModel = NavigationSystemCache.getModel(dirModel.getSystemId());
                    path = String.valueOf(NavigationUtil.getLangName(this.getContext().getLanguage(), sysModel.getSystemName())) + "/" + NavigationUtil.getLangName(this.getContext().getLanguage(), dirModel.getDirectoryName());
                    id = dirModel.getId();
                } else {
                    NavigationFunctionModel function = DeployUtil.getFunctionByDeploymentFunction(deploymentFunction);
                    if (function != null) {
                        NavigationSystemModel sysModel1;
                        NavigationDirectoryModel dirModel1 = NavigationDirectoryCache.getModel(function.getDirectoryId());
                        if (dirModel1 != null && (sysModel1 = NavigationSystemCache.getModel(dirModel1.getSystemId())) != null) {
                            path = String.valueOf(NavigationUtil.getLangName(this.getContext().getLanguage(), sysModel1.getSystemName())) + "/" + NavigationUtil.getLangName(this.getContext().getLanguage(), dirModel1.getDirectoryName()) + "/" + function.getFunctionName();
                        }
                        if (function != null) {
                            id = function.getId();
                        }
                    }
                }
            }
            tables.append(this.getTable(this.getDeployTr((NavTpl)deploymentFunction, "no", id, path, 3, appId, "onlyThree"), "three"));
        }
        return tables.toString();
    }

    public String getDeployHtml(String appId) {
        StringBuilder deploy = new StringBuilder();
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        List systems = ManifestXML.getInstance().getDeploymentSystems(appConfigFile);
        for (DeploymentSystem deploymentSystem : systems) {
            boolean f = false;
            boolean isShowTr = true;
            StringBuilder trs = new StringBuilder();
            NavigationSystemModel systemModel = DeployUtil.getSystemModelByDeploymentSystem(deploymentSystem);
            String sid = "";
            String sname = "";
            List directorys = ManifestXML.getInstance().getDeploymentDirectorys(appConfigFile, deploymentSystem.getId());
            for (DeploymentDirectory deploymentDirectory : directorys) {
                List functions = deploymentDirectory.getDeploymentFunction();
                Iterator iterator = functions.iterator();
                if (!iterator.hasNext()) continue;
                DeploymentFunction deploymentFunction = (DeploymentFunction)iterator.next();
                isShowTr = true;
            }
            if (systemModel != null) {
                sid = systemModel.getId();
                sname = NavigationUtil.getLangName(this.getContext().getLanguage(), systemModel.getSystemName());
            }
            if (isShowTr) {
                trs.append(this.getDeployTr((NavTpl)deploymentSystem, "", sid, sname, 0, appId, ""));
            }
            for (DeploymentDirectory deploymentDirectory : directorys) {
                NavigationDirectoryModel navigationDirectoryModel = DeployUtil.getDirectoryModelByDeploymentDirectory(deploymentDirectory);
                String did = "";
                String dname = "";
                if (navigationDirectoryModel != null) {
                    did = navigationDirectoryModel == null ? deploymentDirectory.getId() : navigationDirectoryModel.getId();
                    String string = dname = navigationDirectoryModel == null ? deploymentDirectory.getName() : NavigationUtil.getLangName(this.getContext().getLanguage(), navigationDirectoryModel.getDirectoryName());
                }
                if (isShowTr) {
                    String newName = "";
                    if (!sname.equals("") && !dname.equals("")) {
                        newName = String.valueOf(NavigationUtil.getLangName(this.getContext().getLanguage(), sname)) + "/" + NavigationUtil.getLangName(this.getContext().getLanguage(), dname);
                    }
                    trs.append(this.getDeployTr((NavTpl)deploymentDirectory, deploymentSystem.getId(), did, newName, 1, appId, ""));
                }
                List functions = ManifestXML.getInstance().getDeploymentFunctions(appConfigFile, deploymentDirectory.getId());
                for (DeploymentFunction deploymentFunction : functions) {
                    f = true;
                    NavigationFunctionModel navigationFunctionModel = DeployUtil.getFunctionByDeploymentFunction(deploymentFunction);
                    String id = "";
                    String name = "";
                    if (navigationFunctionModel != null) {
                        id = navigationFunctionModel.getId();
                        name = navigationFunctionModel.getFunctionName();
                    }
                    if (!isShowTr) continue;
                    String newName = "";
                    if (!(sname.equals("") || dname.equals("") || name.equals(""))) {
                        newName = String.valueOf(NavigationUtil.getLangName(this.getContext().getLanguage(), sname)) + "/" + NavigationUtil.getLangName(this.getContext().getLanguage(), dname) + "/" + NavigationUtil.getLangName(this.getContext().getLanguage(), name);
                    }
                    trs.append(this.getDeployTr((NavTpl)deploymentFunction, deploymentDirectory.getId(), id, newName, 2, appId, ""));
                }
            }
            if (trs.toString().equals("")) continue;
            if (f) {
                deploy.append(this.getTable(trs.toString(), "all"));
                continue;
            }
            deploy.append(this.getTable(trs.toString(), ""));
        }
        return deploy.toString();
    }

    private String getDeployTr(NavTpl nav, String pid, String navId, String sysNav, int rank, String appId, String ntype) {
        navId = navId == null ? "" : navId;
        sysNav = sysNav == null ? "" : sysNav;
        String id = nav.getId();
        String name = JavascriptEscape.unescape(nav.getName());
        String img = nav.getIcon64(appId);
        String url = nav.getUrl();
        String type = "system";
        if (nav instanceof DeploymentDirectory) {
            type = "directory";
        } else if (nav instanceof DeploymentFunction) {
            type = "function";
        }
        String icon = AppsAPIManager.getInstance().getIcon64URL(appId, this.getContext());
        String appName = AppsAPIManager.getInstance().getAppContext(appId).getName();
        String security = "<a style = 'margin-right:6px' href = '' onclick = \"navSystemDeploy('" + navId + "');return false;\"><img src = '../apps/_bpm.platform/img/model/security.group.gif' awsui-qtip='" + I18nRes.findValue("_bpm.platform", "\u6388\u6743") + "'></a>";
        String deploystr = "";
        if (type.equals("function") || !url.equals("/")) {
            String tmp = "";
            if (rank == 2) {
                tmp = sysNav;
            } else if (sysNav.lastIndexOf("/") > -1) {
                tmp = sysNav.substring(sysNav.lastIndexOf("/") + 1, sysNav.length());
            }
            if ("system".equals(type)) {
                if (UtilString.isEmpty(sysNav)) {
                    deploystr = "<a href='#' onclick='ApplicationManagement.noDeployBtn(\"" + appId + "\",\"" + id + "\",\"" + pid + "\",\"" + type + "\",\"" + appName + "\",\"" + icon + "\");return false;'><font color=red>" + I18nRes.findValue("_bpm.platform", "\u672a\u90e8\u7f72\u70b9\u51fb\u90e8\u7f72") + "</font></a>";
                } else {
                    deploystr = "<font color=green>" + I18nRes.findValue("_bpm.platform", "\u5df2\u90e8\u7f72") + "</font>";
                    security = String.valueOf(security) + "&nbsp;<a href='#' onclick='ApplicationManagement.del(\"" + navId + "\",\"" + type + "\",\"" + appId + "\",\"" + appName + "\",\"" + icon + "\");return false;'>" + I18nRes.findValue("_bpm.platform", "\u5220\u9664") + "</a>";
                }
            } else if (tmp.equals("")) {
                sysNav = tmp;
                if ("no".equals(pid)) {
                    deploystr = "<a href='#' onclick='ApplicationManagement.noDeployBtn(\"" + appId + "\",\"" + id + "\",\"" + pid + "\",\"" + type + "\",\"" + appName + "\",\"" + icon + "\");return false;'><font color=red>" + I18nRes.findValue("_bpm.platform", "\u672a\u90e8\u7f72\u70b9\u51fb\u90e8\u7f72") + "</font></a>";
                } else {
                    JSONObject datas = new JSONObject();
                    datas.put("id", (Object)id);
                    datas.put("pid", (Object)pid);
                    datas.put("type", (Object)type);
                    deploystr = "<a href='#' deployData='" + datas.toString() + "' onclick='ApplicationManagement.noDeployBtn(\"" + appId + "\",\"" + id + "\",\"" + pid + "\",\"" + type + "\",\"" + appName + "\",\"" + icon + "\");return false;'><font class='deploy_menu' color=red>" + I18nRes.findValue("_bpm.platform", "\u672a\u90e8\u7f72\u70b9\u51fb\u90e8\u7f72") + "</font></a>";
                }
                security = "";
            } else {
                deploystr = "<font color=green>" + I18nRes.findValue("_bpm.platform", "\u5df2\u90e8\u7f72") + "</font>";
                security = String.valueOf(security) + "&nbsp;<a href='#' onclick='ApplicationManagement.del(\"" + navId + "\",\"" + type + "\",\"" + appId + "\",\"" + appName + "\",\"" + icon + "\");return false;'>" + I18nRes.findValue("_bpm.platform", "\u5220\u9664") + "</a>";
            }
        }
        String str = name;
        if (rank == 2 || !url.equals("/")) {
            str = "<a href='#' onclick='ApplicationManagement.lookUpURL(\"" + url + "\");return false;' title='" + I18nRes.findValue("_bpm.platform", "\u70b9\u51fb\u9884\u89c8") + "'>" + name + "</a>";
        }
        StringBuilder deploy = new StringBuilder();
        deploy.append(" <tr id='" + id + "' class='even'>");
        deploy.append("<td style='width: 50%;' class='list name'>");
        if (ntype.equals("onlyThree")) {
            rank = 0;
        }
        deploy.append("<div style='margin-left:" + 40 * rank + "px;float:left;'> " + str + "</div>");
        deploy.append("</td>");
        deploy.append(" <td style='width: 30%;'> " + (sysNav.equals("") ? I18nRes.findValue("_bpm.platform", "\u65e0") : sysNav) + "</td>");
        deploy.append("<td style='width: 10%;' >" + deploystr + "</td>");
        deploy.append("<td  style='width: 9%;' >" + security + "</td>");
        deploy.append(" </tr>");
        return deploy.toString();
    }

    public String getTable(String html, String type) {
        StringBuilder table = new StringBuilder();
        if (!html.equals("")) {
            table.append("<table width='100%' heigth='100%' style='line-height:28px;border-bottom: solid 1px #DBD4D4;' cellspacing='0' cellpadding='0' id='innerTable1'>");
            table.append(html);
            table.append("</table>");
        }
        return table.toString();
    }

    public String getDeoloyListHtml(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        JSONArray tree = new JSONArray();
        try {
            List pluginProfile = AppEventBus.getInstance().handlePluginEvent(app);
            if (pluginProfile != null) {
                this.getListenerJSON(app, tree);
                List list = PluginMetas.getList();
                for (PluginMeta pluginMeta : list) {
                    List<AWSPluginProfile> appPlugins = this.getPluginList(pluginProfile, pluginMeta.getProfile().getName());
                    if (appPlugins.size() <= 0) continue;
                    this.getDeyloy(app, pluginMeta.getName(), appPlugins, tree);
                }
            }
            this.getControllerJSON(app, tree);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        if (tree.size() == 0) {
            JSONObject root = new JSONObject();
            root.put("id", (Object)"no");
            root.put("name", (Object)I18nRes.findValue("_bpm.platform", "\u65e0"));
            root.put("open", (Object)true);
            String levelOneIcon = String.valueOf(this.rootPath) + "appplugin" + this.ext;
            root.put("icon", (Object)levelOneIcon);
            tree.add((Object)root);
        }
        ro.setData(tree);
        return ro.toString();
    }

    private void getListenerJSON(AppContext app, JSONArray tree) {
        String jt = I18nRes.findValue("_bpm.platform", "\u5e94\u7528\u76d1\u542c\u5668");
        String levelOneIcon = String.valueOf(this.rootPath) + "appplugin" + this.ext;
        String twoLevelIcon = String.valueOf(this.twoLevelRootPath) + "recycling_16" + this.ext;
        JSONObject root = new JSONObject();
        root.put("id", (Object)jt);
        root.put("name", (Object)jt);
        root.put("open", (Object)false);
        root.put("icon", (Object)levelOneIcon);
        tree.add((Object)root);
        if (!UtilString.isEmpty(app.getPluginListener())) {
            JSONObject node = new JSONObject();
            node.put("id", (Object)"1");
            node.put("name", (Object)app.getPluginListener());
            node.put("pid", (Object)jt);
            node.put("title", (Object)"pluginListener");
            node.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node);
        }
        if (!UtilString.isEmpty(app.getStartListener())) {
            JSONObject node2 = new JSONObject();
            node2.put("id", (Object)"2");
            node2.put("name", (Object)app.getStartListener());
            node2.put("pid", (Object)jt);
            node2.put("title", (Object)"startListener");
            node2.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node2);
        }
        if (!UtilString.isEmpty(app.getStopListener())) {
            JSONObject node3 = new JSONObject();
            node3.put("id", (Object)"3");
            node3.put("name", (Object)app.getStopListener());
            node3.put("pid", (Object)jt);
            node3.put("title", (Object)"stopListener");
            node3.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node3);
        }
        if (!UtilString.isEmpty(app.getUpgradeListener())) {
            JSONObject node4 = new JSONObject();
            node4.put("id", (Object)"4");
            node4.put("name", (Object)app.getUpgradeListener());
            node4.put("pid", (Object)jt);
            node4.put("title", (Object)"upgradeListener");
            node4.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node4);
        }
        if (!UtilString.isEmpty(app.getInstallListener())) {
            JSONObject node6 = new JSONObject();
            node6.put("id", (Object)"6");
            node6.put("name", (Object)app.getInstallListener());
            node6.put("pid", (Object)jt);
            node6.put("title", (Object)"installListener");
            node6.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node6);
        }
        if (!UtilString.isEmpty(app.getUninstallListener())) {
            JSONObject node5 = new JSONObject();
            node5.put("id", (Object)"5");
            node5.put("name", (Object)app.getUninstallListener());
            node5.put("pid", (Object)jt);
            node5.put("title", (Object)"uninstallListener");
            node5.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node5);
        }
    }

    private void getControllerJSON(AppContext app, JSONArray tree) {
        String jt = I18nRes.findValue("_bpm.platform", "\u8bf7\u6c42\u63a7\u5236\u5668");
        String levelOneIcon = String.valueOf(this.rootPath) + "appplugin" + this.ext;
        String twoLevelIcon = String.valueOf(this.twoLevelRootPath) + "recycling_16" + this.ext;
        JSONObject root = new JSONObject();
        root.put("id", (Object)jt);
        root.put("name", (Object)jt);
        root.put("open", (Object)false);
        root.put("icon", (Object)levelOneIcon);
        tree.add((Object)root);
        AppLoader loader = AppsLoader.getInstance().getAppLoader(app.getId());
        Map controllers = loader.getAppController();
        for (Map.Entry e : controllers.entrySet()) {
            JSONObject node = new JSONObject();
            String id = UUIDGener.getUUID();
            node.put("id", (Object)id);
            node.put("name", (Object)(String.valueOf((String)e.getKey()) + (((AppController)e.getValue()).getArchiveName() == null ? "" : "_" + ((AppController)e.getValue()).getArchiveName())));
            node.put("pid", (Object)jt);
            node.put("title", (Object)UtilString.join(((AppController)e.getValue()).getCmds().keySet(), ","));
            node.put("icon", (Object)twoLevelIcon);
            tree.add((Object)node);
        }
    }

    private void getDeyloy(AppContext app, String groupName, List<AWSPluginProfile> list, JSONArray tree) {
        String asName = "";
        JSONObject root = new JSONObject();
        asName = groupName;
        String uid = UUIDGener.getObjectId();
        StringBuilder pluginMetaListHtml = new StringBuilder();
        pluginMetaListHtml.append("<div id='group' onClick=\"$('#params_" + uid + "').toggle();\" style='font-size: 14px;cursor:pointer;' > + " + groupName + "</div>");
        pluginMetaListHtml.append("<div id='params_" + uid + "' style='display:none'>");
        pluginMetaListHtml.append("<ul>");
        String levelOneIcon = String.valueOf(this.rootPath) + "appplugin" + this.ext;
        root.put("id", (Object)uid);
        root.put("name", (Object)asName);
        root.put("open", (Object)false);
        root.put("icon", (Object)levelOneIcon);
        tree.add((Object)root);
        int count = 0;
        for (AWSPluginProfile awsPluginProfile : list) {
            String newId;
            String id;
            AtFormulaPluginProfile profile;
            String levelTwoIcon;
            JSONObject node = new JSONObject();
            String iconName = awsPluginProfile.getClass().getName();
            iconName = iconName.substring(iconName.lastIndexOf(".") + 1, iconName.length());
            if (awsPluginProfile instanceof AtFormulaPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "variable_16" + this.ext;
                profile = (AtFormulaPluginProfile)awsPluginProfile;
                id = profile.getId();
                newId = profile.getId();
                if (id.indexOf(":") > -1) {
                    newId = id.replace(":", "");
                }
                if (id.indexOf(".") > -1) {
                    newId = id.replace(".", "_");
                }
                node.put("id", (Object)newId);
                node.put("name", (Object)(String.valueOf(profile.getSyntax()) + " - " + profile.getTitle()));
                node.put("pid", (Object)uid);
                node.put("title", (Object)profile.getClazzName());
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof DCPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "db1_16" + this.ext;
                profile = (DCPluginProfile)awsPluginProfile;
                node.put("id", (Object)UUIDGener.getObjectId());
                node.put("name", (Object)(String.valueOf(profile.getRepositoryName()) + " (" + profile.getDesc() + ")"));
                node.put("pid", (Object)uid);
                node.put("title", (Object)profile.getClazzName());
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof CloudDCPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "db1_16" + this.ext;
                profile = (CloudDCPluginProfile)awsPluginProfile;
                node.put("id", (Object)UUIDGener.getObjectId());
                node.put("name", (Object)(String.valueOf(profile.getName()) + "(" + profile.getCloudId() + ")," + I18nRes.findValue("_bpm.platform", "\u5e94\u7528\u8303\u56f4") + ":" + (UtilString.isEmpty(profile.getScope()) ? String.valueOf(I18nRes.findValue("_bpm.platform", "\u5168\u90e8")) + "DC" : String.valueOf(I18nRes.findValue("_bpm.platform", "\u5e94\u7528")) + ":" + profile.getScope())));
                node.put("pid", (Object)uid);
                node.put("title", (Object)profile.getClazzName());
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof WechatPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "code_16" + this.ext;
                profile = (WechatPluginProfile)awsPluginProfile;
                node.put("id", (Object)UUIDGener.getObjectId());
                node.put("name", (Object)profile.getClazzName());
                node.put("pid", (Object)uid);
                node.put("title", (Object)profile.getClazzName());
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof FormUIPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "rename_16" + this.ext;
                profile = (FormUIPluginProfile)awsPluginProfile;
                id = profile.getId();
                newId = profile.getId();
                if (id.indexOf(":") > -1) {
                    newId = id.replace(":", "");
                }
                if (id.indexOf(".") > -1) {
                    newId = id.replace(".", "_");
                }
                node.put("id", (Object)newId);
                node.put("name", (Object)profile.getTitle());
                node.put("pid", (Object)uid);
                node.put("title", (Object)profile.getClazzName());
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof SkinsPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "pc_16" + this.ext;
                profile = (SkinsPluginProfile)awsPluginProfile;
                id = app.getId();
                if (id.indexOf(".") > -1) {
                    id = id.replace(".", "_");
                }
                node.put("id", (Object)id);
                node.put("name", (Object)app.getName());
                node.put("title", (Object)profile.getClazzName());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof PALMethodPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "labs_16" + this.ext;
                profile = (PALMethodPluginProfile)awsPluginProfile;
                id = profile.getMethodId();
                newId = profile.getMethodId();
                if (id.indexOf(":") > -1) {
                    newId = id.replace(":", "");
                }
                if (id.indexOf(".") > -1) {
                    newId = id.replace(".", "_");
                }
                node.put("id", (Object)newId);
                node.put("name", (Object)id);
                node.put("title", (Object)id);
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof PALExtendsPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "labs_16" + this.ext;
                profile = (PALExtendsPluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                String name = profile.getClass().getName();
                node.put("id", (Object)id);
                node.put("name", (Object)name);
                node.put("title", (Object)name);
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof FullSearchPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "db1_16" + this.ext;
                profile = (FullSearchPluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getRepositoryName());
                node.put("title", (Object)profile.getDesc());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof ACPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "security_user_16" + this.ext;
                profile = (ACPluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getResourceName());
                node.put("title", (Object)profile.getDesc());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof FormThemePluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "tv_16" + this.ext;
                profile = (FormThemePluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getName());
                node.put("title", (Object)profile.getClazzName());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof CachePluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "money_16" + this.ext;
                profile = (CachePluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getClazzName());
                node.put("title", (Object)profile.getName());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof ProcessPublicEventPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "recycling_16" + this.ext;
                profile = (ProcessPublicEventPluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getClazzName());
                node.put("title", (Object)profile.getDesc());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof AppCustomActionPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "recycling_16" + this.ext;
                profile = (AppCustomActionPluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getClazzName());
                node.put("title", (Object)profile.getDesc());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof HumanPerformerPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "org1_16" + this.ext;
                profile = (HumanPerformerPluginProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)("(" + profile.getGroup().getName() + ")" + profile.getTitle()));
                node.put("title", (Object)profile.getDesc());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof AppExtensionProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "jar_16" + this.ext;
                profile = (AppExtensionProfile)awsPluginProfile;
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getName());
                node.put("title", (Object)profile.getAslp());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (awsPluginProfile instanceof AddOnsPluginProfile) {
                levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "labs_16" + this.ext;
                profile = AddOnsManager.getProfile(((AddOnsPluginProfile)awsPluginProfile).getId());
                id = UUIDGener.getObjectId();
                node.put("id", (Object)id);
                node.put("name", (Object)profile.getAppContext().getName());
                node.put("title", (Object)profile.getAppContext().getDescription());
                node.put("pid", (Object)uid);
                node.put("icon", (Object)levelTwoIcon);
                tree.add((Object)node);
                continue;
            }
            if (!(awsPluginProfile instanceof ASLPPluginProfile)) continue;
            levelTwoIcon = String.valueOf(this.twoLevelRootPath) + "near_16" + this.ext;
            profile = (ASLPPluginProfile)awsPluginProfile;
            profile.setAppContext(app);
            id = UUIDGener.getObjectId();
            node.put("id", (Object)id);
            HttpASLP httpAppService = profile.getHttpService();
            String supportHttp = "";
            StringBuilder toolbarTabSelect = new StringBuilder();
            StringBuilder callSelect = new StringBuilder();
            JSONObject codes = new JSONObject();
            JSONArray metaInfoArray = new JSONArray();
            String keyValid = "";
            if (httpAppService != null && httpAppService.getAuthenticationType().equals(HttpASLP.AUTH_KEY)) {
                if (UtilString.isEmpty(httpAppService.getAuthenticationParam())) {
                    keyValid = "<img src=../commons/img/performance_warn.gif title='" + I18nRes.findValue("_bpm.platform", "\u6ce8\u518c\u65f6\u672a\u6307\u5b9a\u53d8\u91cf") + "'>";
                } else {
                    String localIpValue;
                    String localKeyValue;
                    String sysConfig = SDK.getAppAPI().getProperty(app.getId(), httpAppService.getAuthenticationParam());
                    Map<String, Object> sysConfigSet = null;
                    try {
                        sysConfigSet = UtilJson.parseJSON2Map(sysConfig);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    keyValid = sysConfigSet == null || sysConfigSet.isEmpty() ? "<img src=../commons/img/performance_warn.gif title='" + I18nRes.findValue("_bpm.platform", "\u8be5\u5e94\u7528\u672a\u521b\u5efa\u6216\u6b63\u786e\u8bbe\u7f6e") + "[" + httpAppService.getAuthenticationParam() + "]" + I18nRes.findValue("_bpm.platform", "\u53d8\u91cf") + "'>" : (UtilString.isEmpty(localKeyValue = (String)sysConfigSet.get("key")) ? "<img src=../commons/img/performance_warn.gif title='" + I18nRes.findValue("_bpm.platform", "\u8be5\u5e94\u7528\u53d8\u91cf") + "[" + httpAppService.getAuthenticationParam() + "]" + I18nRes.findValue("_bpm.platform", "\u503c\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5json\u4e32") + "(" + I18nRes.findValue("_bpm.platform", "\u683c\u5f0f") + "\uff1a {\"key\":\"\",\"ip\":\"\"})" + I18nRes.findValue("_bpm.platform", "\u6216\u672a\u6307\u5b9akey\u503c") + "'>" : (UtilString.isEmpty(localIpValue = (String)sysConfigSet.get("ip")) ? "<img src=../commons/img/performance_warn.gif title='" + I18nRes.findValue("_bpm.platform", "\u8be5\u5e94\u7528\u53d8\u91cf") + "[" + httpAppService.getAuthenticationParam() + "]" + I18nRes.findValue("_bpm.platform", "\u503c\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5json\u4e32") + "(" + I18nRes.findValue("_bpm.platform", "\u683c\u5f0f") + "\uff1a {\"key\":\"\",\"ip\":\"\"})" + I18nRes.findValue("_bpm.platform", "\u6216\u672a\u6307\u5b9aip\u503c") + "'>" : ""));
                }
            }
            toolbarTabSelect.append(this.getHtml(count, httpAppService == null));
            if (httpAppService != null) {
                callSelect.append("<input id=\"httpcall_" + count + "\" value=\"" + httpAppService.getAuthenticationType() + "\" type=\"hidden\">");
                supportHttp = "&nbsp;<span style='background-color:green;font-size:8px;cursor:default;color:#ffffff'>&nbsp;<b>HTTP</b>&nbsp;</span>&nbsp;<span style='background-color:red;cursor:default;font-size:8px;color:#ffffff'>&nbsp;<b>" + httpAppService.getAuthenticationType() + "</b>&nbsp;</span>&nbsp;" + keyValid;
            }
            try {
                List metas = ASLPExecuter.createService().getParameterMetas(profile.getAslp());
                if (metas != null && !metas.isEmpty()) {
                    for (Map meta : metas) {
                        JSONObject metaJson = new JSONObject();
                        metaJson.put("name", meta.get("name"));
                        metaJson.put("required", meta.get("required"));
                        String desc = (String)meta.get("desc");
                        Boolean allowEmpty = (Boolean)meta.get("allowEmpty");
                        Integer maxLen = (Integer)meta.get("maxLen");
                        Integer minLen = (Integer)meta.get("minLen");
                        if (desc == null) {
                            desc = "";
                        }
                        desc = desc.trim();
                        if (allowEmpty != null) {
                            desc = String.valueOf(desc) + (allowEmpty == false ? "\uff0c" + I18nRes.findValue("_bpm.platform", "\u4e0d\u5141\u8bb8\u7a7a\u503c") : "");
                        }
                        if (minLen != null) {
                            desc = String.valueOf(desc) + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u4e0d\u5141\u8bb8\u5c11\u4e8e\u4e2a") + minLen + I18nRes.findValue("_bpm.platform", "\u5b57\u7b26");
                        }
                        if (maxLen != null) {
                            desc = String.valueOf(desc) + "\uff0c" + I18nRes.findValue("_bpm.platform", "\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e2a") + maxLen + I18nRes.findValue("_bpm.platform", "\u5b57\u7b26");
                        }
                        metaJson.put("desc", (Object)desc);
                        metaInfoArray.add((Object)metaJson);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            callSelect.append("<input id=\"java_call_" + count + "\" value=\"java_call\" type=\"hidden\">");
            callSelect.append("<input id=\"java_asynCall_" + count + "\" value=\"java_asynCall\" type=\"hidden\">");
            callSelect.append("<input id=\"ios_call_" + count + "\" value=\"ios_call\" type=\"hidden\">");
            callSelect.append("<input id=\"android_call_" + count + "\" value=\"android_call\" type=\"hidden\">");
            codes.put("java_call", (Object)this.getASLPExampleCode(app.getId(), "java_call", httpAppService == null ? "" : httpAppService.getAuthenticationType(), (ASLPPluginProfile)profile, metaInfoArray));
            codes.put("java_asynCall", (Object)this.getASLPExampleCode(app.getId(), "java_asynCall", httpAppService == null ? "" : httpAppService.getAuthenticationType(), (ASLPPluginProfile)profile, metaInfoArray));
            if (httpAppService != null) {
                codes.put(httpAppService.getAuthenticationType(), (Object)this.getASLPExampleCode(app.getId(), httpAppService.getAuthenticationType(), httpAppService.getAuthenticationType(), (ASLPPluginProfile)profile, metaInfoArray));
                codes.put("ios_call", (Object)this.getASLPExampleCode(app.getId(), "ios_call", httpAppService.getAuthenticationType(), (ASLPPluginProfile)profile, metaInfoArray));
                codes.put("android_call", (Object)this.getASLPExampleCode(app.getId(), "android_call", httpAppService.getAuthenticationType(), (ASLPPluginProfile)profile, metaInfoArray));
            }
            StringBuilder metaLable = new StringBuilder();
            if (metaInfoArray.toString().length() > 0) {
                metaLable.append("<script>var toolbarTabSelect_" + count + "='" + toolbarTabSelect.toString() + "'; var codes_" + count + "=" + codes.toString() + ";  var calloption_" + count + "='" + callSelect + "' ; var meta_" + count + "=" + metaInfoArray.toString() + "; var aslp_" + count + "='" + profile.getAslp() + "'; var aslpName_" + count + "='" + profile.getDesc() + "'; </script>");
                metaLable.append("&nbsp;<a href='' onclick=\"openMetaDialog(toolbarTabSelect_" + count + "," + count + ",meta_" + count + ",aslp_" + count + ",aslpName_" + count + ",calloption_" + count + ",codes_" + count + ");return false;\"><span style='background-color:blue;font-size:8px;color:#ffffff'>&nbsp;<b>Meta</b>&nbsp;</span></a>");
            }
            ++count;
            node.put("name", (Object)(String.valueOf(profile.getAslp()) + metaLable.toString() + supportHttp));
            node.put("title", (Object)profile.getDesc());
            node.put("pid", (Object)uid);
            node.put("icon", (Object)levelTwoIcon);
            tree.add((Object)node);
        }
    }

    private String getHtml(int count, boolean isOnlyJava) {
        StringBuilder toolbarTabSelect = new StringBuilder();
        String display = isOnlyJava ? "display:none;" : "";
        toolbarTabSelect.append("<div id=\"toolbar-tab2_" + count + "\" class=\"toolbar-tab-box\">");
        toolbarTabSelect.append("\t<ul class=\"toolbar-tabs\">");
        toolbarTabSelect.append("\t\t<li name=\"toolbartab\" style=\"width: 80px;\" toolbarid=\"interface_tab_" + count + "\" id=\"interfaceTab_" + count + "\" class=\"tab-normal\">");
        toolbarTabSelect.append("\t\t\t<span>");
        toolbarTabSelect.append("\t\t\t\t<img style=\"width: 16px;height: 16px;padding:2px 5px 8px 0px;\" src=\"../apps/_bpm.platform/img/amc/tags.png\"/>");
        toolbarTabSelect.append("\t\t\t</span>");
        toolbarTabSelect.append("\t\t" + I18nRes.findValue("_bpm.platform", "\u63a5\u53e3\u8bf4\u660e"));
        toolbarTabSelect.append("\t\t</li>");
        toolbarTabSelect.append("\t\t<li name=\"toolbartab\" style=\"width: 130px;\" toolbarid=\"synchronous_tab_" + count + "\" id=\"synchronousTab_" + count + "\" class=\"tab-normal\">");
        toolbarTabSelect.append("\t\t\t<span>");
        toolbarTabSelect.append("\t\t\t\t<img style=\"width: 16px;height: 16px;padding:2px 5px 8px 0px;\" src=\"../apps/_bpm.platform/img/amc/java1.png\"/>");
        toolbarTabSelect.append("\t\t\t</span>");
        toolbarTabSelect.append("\t\t" + I18nRes.findValue("_bpm.platform", "\u672c\u5730java\u540c\u6b65\u8c03\u7528"));
        toolbarTabSelect.append("\t\t</li>");
        toolbarTabSelect.append("\t\t<li name=\"toolbartab\" style=\"width: 130px;\" toolbarid=\"nonsynchronous_tab_" + count + "\" id=\"nonsynchronousTab_" + count + "\" class=\"tab-normal\">");
        toolbarTabSelect.append("\t\t\t<span>");
        toolbarTabSelect.append("\t\t\t\t<img style=\"width: 16px;height: 16px;padding:2px 5px 8px 0px;\" src=\"../apps/_bpm.platform/img/amc/java1.png\"/>");
        toolbarTabSelect.append("\t\t\t</span>");
        toolbarTabSelect.append("\t\t" + I18nRes.findValue("_bpm.platform", "\u672c\u5730java\u5f02\u6b65\u8c03\u7528"));
        toolbarTabSelect.append("\t\t</li>");
        toolbarTabSelect.append("\t\t<li name=\"toolbartab\" style=\"width: 85px;" + display + "\" toolbarid=\"http_tab_" + count + "\" id=\"httpTab_" + count + "\" class=\"tab-normal\">");
        toolbarTabSelect.append("\t\t\t<span>");
        toolbarTabSelect.append("\t\t\t\t<img style=\"width: 16px;height: 16px;padding:2px 5px 8px 0px;\" src=\"../apps/_bpm.platform/img/amc/link.png\"/>");
        toolbarTabSelect.append("\t\t\t</span>");
        toolbarTabSelect.append("\t\tHTTP" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528"));
        toolbarTabSelect.append("\t\t</li>");
        toolbarTabSelect.append("\t\t<li name=\"toolbartab\" style=\"width: 75px;" + display + "\" toolbarid=\"iosapp_tab_" + count + "\" id=\"iosappTab_" + count + "\" class=\"tab-normal\">");
        toolbarTabSelect.append("\t\t\t<span>");
        toolbarTabSelect.append("\t\t\t\t<img style=\"width: 16px;height: 16px;padding:2px 5px 8px 0px;\" src=\"../commons/img/mobile-ios.png\"/>");
        toolbarTabSelect.append("\t\t\t</span>");
        toolbarTabSelect.append("\t\tiOS" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528"));
        toolbarTabSelect.append("\t\t</li>");
        toolbarTabSelect.append("\t\t<li name=\"toolbartab\" style=\"width: 105px;" + display + "\" toolbarid=\"androidapp_tab_" + count + "\" id=\"androidappTab_" + count + "\" class=\"tab-normal\">");
        toolbarTabSelect.append("\t\t\t<span>");
        toolbarTabSelect.append("\t\t\t\t<img style=\"width: 16px;height: 16px;padding:2px 5px 8px 0px;\" src=\"../commons/img/mobile-android.png\"/>");
        toolbarTabSelect.append("\t\t\t</span>");
        toolbarTabSelect.append("\t\tAndroid" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528"));
        toolbarTabSelect.append("\t\t</li>");
        toolbarTabSelect.append("\t</ul>");
        toolbarTabSelect.append("</div>");
        toolbarTabSelect.append("<div id=\"toolbar-area3_" + count + "\" style=\"float:left;background-color: rgb(255, 255, 255); overflow: auto; border-top: 1px solid rgb(195, 195, 195); height: 440px; background-position: initial initial; background-repeat: initial initial;\">");
        toolbarTabSelect.append("\t\t<div id=\"interface_tab_" + count + "\" class=\"toolbar-items-container\" style=\"overflow: auto; display: block;height: 100%;\">");
        toolbarTabSelect.append(" \t      <table class=\"awsui-ux\" id=\"metaParams_" + count + "\" style=\"line-height: 30px;padding:0px 20px;\">");
        toolbarTabSelect.append("\t\t  </table>");
        toolbarTabSelect.append("\t\t</div>");
        toolbarTabSelect.append("\t\t<div id=\"synchronous_tab_" + count + "\" class=\"toolbar-items-container\" style=\"display: none; overflow: hidden;height: 100%;\">");
        toolbarTabSelect.append(" \t      <table class=\"awsui-ux\" style=\"padding-top: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        toolbarTabSelect.append("           <tr>");
        toolbarTabSelect.append("\t\t\t\t<td id=\"aslpTypeTd_" + count + "\"></td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t\t<tr>");
        toolbarTabSelect.append("\t\t\t\t<td>");
        toolbarTabSelect.append("\t\t\t\t\t<textarea id=\"code_" + count + "\" name=\"code\" style=\"height:20px;\"></textarea>");
        toolbarTabSelect.append("\t\t\t\t </td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t  </table>");
        toolbarTabSelect.append("\t\t</div>");
        toolbarTabSelect.append("\t\t<div id=\"nonsynchronous_tab_" + count + "\" class=\"toolbar-items-container\" style=\"display: none; overflow: hidden;height: 100%;\">");
        toolbarTabSelect.append(" \t      <table class=\"awsui-ux\" style=\"padding-top: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        toolbarTabSelect.append("           <tr>");
        toolbarTabSelect.append("\t\t\t\t<td id=\"nonsynchronousaslpTypeTd_" + count + "\"></td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t\t<tr>");
        toolbarTabSelect.append("\t\t\t\t<td>");
        toolbarTabSelect.append("\t\t\t\t\t<textarea id=\"nonsynchronouscode_" + count + "\" name=\"code\" style=\"height:20px;\"></textarea>");
        toolbarTabSelect.append("\t\t\t\t </td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t  </table>");
        toolbarTabSelect.append("\t\t</div>");
        toolbarTabSelect.append("\t\t<div id=\"http_tab_" + count + "\" class=\"toolbar-items-container\" style=\"width: 99%; display: none; overflow: hidden;height: 100%;\">");
        toolbarTabSelect.append(" \t      <table class=\"awsui-ux\" style=\"padding-top: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        toolbarTabSelect.append("           <tr>");
        toolbarTabSelect.append("\t\t\t\t<td id=\"httpaslpTypeTd_" + count + "\"></td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t\t<tr>");
        toolbarTabSelect.append("\t\t\t\t<td>");
        toolbarTabSelect.append("\t\t\t\t\t<textarea id=\"httpcode_" + count + "\" name=\"code\" style=\"height:20px;\"></textarea>");
        toolbarTabSelect.append("\t\t\t\t </td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t  </table>");
        toolbarTabSelect.append("\t\t</div>");
        toolbarTabSelect.append("\t\t<div id=\"iosapp_tab_" + count + "\" class=\"toolbar-items-container\" style=\"display: none; overflow: hidden;height: 100%;\">");
        toolbarTabSelect.append(" \t      <table class=\"awsui-ux\" style=\"padding-top: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        toolbarTabSelect.append("           <tr>");
        toolbarTabSelect.append("\t\t\t\t<td id=\"iosaslpTypeTd_" + count + "\"></td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t\t<tr>");
        toolbarTabSelect.append("\t\t\t\t<td>");
        toolbarTabSelect.append("\t\t\t\t\t<textarea id=\"ioscode_" + count + "\" name=\"code\" style=\"height:20px;\"></textarea>");
        toolbarTabSelect.append("\t\t\t\t </td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t  </table>");
        toolbarTabSelect.append("\t\t</div>");
        toolbarTabSelect.append("\t\t<div id=\"androidapp_tab_" + count + "\" class=\"toolbar-items-container\" style=\"display: none; overflow: hidden;height: 100%;\">");
        toolbarTabSelect.append(" \t      <table class=\"awsui-ux\" style=\"padding-top: 0px;\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        toolbarTabSelect.append("           <tr>");
        toolbarTabSelect.append("\t\t\t\t<td id=\"androidaslpTypeTd_" + count + "\"></td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t\t<tr>");
        toolbarTabSelect.append("\t\t\t\t<td>");
        toolbarTabSelect.append("\t\t\t\t\t<textarea id=\"androidcode_" + count + "\" name=\"code\" style=\"height:20px;\"></textarea>");
        toolbarTabSelect.append("\t\t\t\t </td>");
        toolbarTabSelect.append("\t\t\t</tr>");
        toolbarTabSelect.append("\t\t  </table>");
        toolbarTabSelect.append("\t\t</div>");
        toolbarTabSelect.append("</div>");
        return toolbarTabSelect.toString();
    }

    private String getParams(String alsp) {
        JSONObject params = new JSONObject();
        try {
            List metas = ASLPExecuter.createService().getParameterMetas(alsp);
            if (metas != null && !metas.isEmpty()) {
                for (Map meta : metas) {
                    params.put((String)meta.get("name"), (Object)1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params.toString();
    }

    private String getASLPExampleCode(String appId, String alspType, String auth, ASLPPluginProfile aslp, JSONArray metaInfoArray) {
        StringBuilder aslpCode = new StringBuilder();
        if (alspType.equals(HttpASLP.AUTH_AWS_SID) || alspType.equals(HttpASLP.AUTH_KEY) || alspType.equals(HttpASLP.AUTH_RSA)) {
            aslpCode.append(this.ASLPhttp(appId, alspType, aslp, metaInfoArray));
        } else if (alspType.equals("java_call")) {
            aslpCode.append(this.ASLPJava(appId, aslp, metaInfoArray));
        } else if (alspType.equals("java_asynCall")) {
            aslpCode.append(this.ASLPJavaAsyn(appId, aslp, metaInfoArray));
        } else if (alspType.equals("ios_call")) {
            aslpCode.append(this.ASLPIOS(appId, auth, aslp, metaInfoArray));
        } else if (alspType.equals("android_call")) {
            aslpCode.append(this.ASLPAndroid(appId, auth, aslp, metaInfoArray));
        }
        return aslpCode.toString();
    }

    public String ASLPhttp(String appId, String alspType, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        StringBuffer code = new StringBuffer();
        String params = this.getParams(aslp);
        code.append("public boolean execute(){\n");
        code.append("  String serverUrl = \"http://localhost:8088/portal\";\n");
        code.append("  String sourceAppId = \"" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528\u65b9\u5e94\u7528") + "ID\";\n");
        code.append("  String auth=" + alspType + ";\n");
        code.append("  JSONObject params = new JSONObject();\n");
        code.append("  try {\n");
        JSONObject json = JSONObject.parseObject((String)params);
        for (String key : json.keySet()) {
            String metaDesc = this.getParamDesc(metaInfoArray, key);
            code.append("//" + metaDesc + " \n");
            code.append("    params.put(\"" + key + "\", " + key + ");\n");
        }
        code.append("  } catch (JSONException e) {\n");
        code.append("    e.printStackTrace();\n");
        code.append("  }\n");
        code.append("  String requestUrl = serverUrl+\"/r/jd?cmd=API_CALL_ASLP&sourceAppId=\"+sourceAppId+\"&aslp=aslp://" + appId + "/" + aslpProfile.getServiceName() + "&params=\"+params.toString()+\"&authentication=\"+auth;" + "\n");
        code.append("  URL url = new URL(requestUrl);\n");
        code.append("}\n");
        return code.toString();
    }

    public String ASLPAndroid(String appId, String auth, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("public boolean execute(){\n");
        code.append("  String serverUrl = \"\"; \n");
        code.append("  String sourceAppId = context.getPackageName();\n");
        code.append("  String aslp =\"" + aslp + "\";\n");
        code.append("  String auth = " + auth + ";\n");
        code.append("  JSONObject params = new JSONObject();\n");
        code.append("  try {\n");
        JSONObject json = JSONObject.parseObject((String)params);
        for (String key : json.keySet()) {
            String metaDesc = this.getParamDesc(metaInfoArray, key);
            code.append("//" + metaDesc + " \n");
            code.append("    params.put(\"" + key + "\", " + key + ");\n");
        }
        code.append("  } catch (JSONException e) {\n");
        code.append("    e.printStackTrace();\n");
        code.append("  }\n");
        code.append("  AslpUtil.requestAslp(serverUrl,sourceAppId, aslp,params.toString(), auth,new AslpCallBack() {\n");
        code.append("@Override\n");
        code.append(" public void onSuccess(String arg0) {\n");
        code.append("  //" + I18nRes.findValue("_bpm.platform", "\u8bf7\u6c42\u6210\u529f") + "\n");
        code.append(" }\n");
        code.append("  @Override\n");
        code.append("  public void onStart() {\n");
        code.append("     //" + I18nRes.findValue("_bpm.platform", "\u5f00\u59cb\u8bf7\u6c42") + "\n");
        code.append("   }\n");
        code.append("  @Override\n");
        code.append("  public void onFailer(int code, String arg0) {\n");
        code.append("    //" + I18nRes.findValue("_bpm.platform", "\u8bf7\u6c42\u5931\u8d25") + "\n");
        code.append(" }\n");
        code.append(" @Override\n");
        code.append(" public void onError(AslpError arg0) {\n");
        code.append("     //" + I18nRes.findValue("_bpm.platform", "\u8bf7\u6c42\u51fa\u9519") + "\n");
        code.append("   }\n");
        code.append("  });\n");
        code.append("}");
        return code.toString();
    }

    public String ASLPIOS(String appId, String auth, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("-\uff08void\uff09execute{\n");
        code.append("NSMutableDictionary *paramDic = [[NSMutableDictionary alloc] init]; \n");
        JSONObject json = JSONObject.parseObject((String)params);
        for (String key : json.keySet()) {
            String metaDesc = this.getParamDesc(metaInfoArray, key);
            code.append("//" + metaDesc + " \n");
            code.append("[paramDic setObject:" + key + "forKey:@\"" + key + "\"];\n");
        }
        code.append("NSString *server = [self defaultServer]; \n");
        code.append("NSString *sourceAppId = APPID;\n");
        code.append("NSString *aslp = @\"" + aslp + "\";\n");
        code.append("NSString *auth =" + auth + ";\n");
        code.append("NSString *jsonParams = [NSString jsonStringWithDictionary:paramDic];\n");
        code.append("NSLog(@\"jsonParams = %@\",jsonParams);\n");
        code.append("[ASLP aslpRequestWithServer:server SourceAppId:sourceAppId aslpName:aslp JsonParams:jsonParams Authentication:auth NetWorkDelegate:delegate tag:0];\n");
        code.append("}\n");
        return code.toString();
    }

    public String httpKey(String appId, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String desc = aslpProfile.getDesc();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("public boolean execute(Map<String, Object> params) {\n");
        code.append("params = new HashMap<String, Object>();\n");
        code.append(" //" + I18nRes.findValue("_bpm.platform", "\u6210\u529f\u8fd0\u884c\u9700\u5728\u8be5\u589e\u52a0\u53c2\u6570\u5176\u503c\u8bbe\u7f6e\u4e3a") + "2014\n");
        code.append(" String authentication = \"2014\";\n");
        code.append("//" + I18nRes.findValue("_bpm.platform", "\u6839\u636eURL\u83b7\u53d6httpData") + " \n");
        code.append(" Map<String, Object> httpData = UtilJson.getMapByUrl(\n \"http://localhost:8088/portal/r/jd?cmd=API_CALL_ASLP&sourceAppId=" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "ID \n&aslp=" + aslp + "?params=" + params + " \n&authentication=\"+authentication);\n");
        code.append("}");
        return code.toString();
    }

    public String httpSessionId(String appId, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String desc = aslpProfile.getDesc();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("public boolean execute(Map<String, Object> params) {\n");
        code.append("//" + I18nRes.findValue("_bpm.platform", "\u5b9a\u4e49\u53c2\u6570\u5217\u8868") + " \n");
        code.append("Map params = new HashMap<String, Object>();\n");
        code.append("//" + I18nRes.findValue("_bpm.platform", "\u5f53\u524d\u7528\u6237\u8bbf\u95ee\u4f1a\u8bdd") + " \n");
        code.append("String authentication = appAPI.getUserContext().getSessionId();\n");
        code.append("//" + I18nRes.findValue("_bpm.platform", "\u6839\u636eURL\u83b7\u53d6httpData") + " \n");
        code.append("Map<String, Object> httpData = UtilJson.getMapByUrl(\"http://IP:8088/portal/r/jd?cmd=API_CALL_ASLP&sourceAppId=" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "ID \n &aslp=" + aslp + "?params=" + params + " \n &authentication=\"+authentication);\n");
        code.append("}");
        return code.toString();
    }

    public String httpRsa(String appId, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String desc = aslpProfile.getDesc();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("public boolean execute(Map<String, Object> params) {\n");
        code.append(" //" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528") + "AppId \n");
        code.append("String invokeAppId = \"" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "ID\";\n");
        code.append("// " + I18nRes.findValue("_bpm.platform", "\u53c2\u6570\u5b9a\u4e49\u5217\u8868") + "  \n");
        code.append(" Map params = new HashMap<String, Object>();\n");
        code.append(" //" + I18nRes.findValue("_bpm.platform", "\u83b7\u53d6App\u5bf9\u8c61") + " \n");
        code.append("AppContext sourceApp = SDK.getAppAPI().getAppContext(invokeAppId);\n");
        code.append("String authentication = new String(Base64.encodeURL(RSA.encrypt(\n sourceApp.getPath() + \"" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "ID\", \"RSA-KEY\".getBytes())));\n");
        code.append("Map<String, Object> httpData = UtilJson.getMapByUrl(  \n \"http://IP:8088/portal/r/jd?cmd=API_CALL_ASLP&sourceAppId=" + I18nRes.findValue("_bpm.platform", "\u5e94\u7528") + "ID \n & aslp=aslp?params=" + I18nRes.findValue("_bpm.platform", "\u53c2\u6570\u5217\u8868") + " \n &authentication=\"+authentication);\n");
        code.append("}");
        return code.toString();
    }

    public String ASLPJava(String appId, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String desc = aslpProfile.getDesc();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("public boolean execute() {\n");
        code.append("// " + I18nRes.findValue("_bpm.platform", "\u8c03\u7528") + "App \n");
        code.append("  String sourceAppId = \"" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528\u65b9\u5e94\u7528") + "ID\";\n");
        code.append("// aslp" + I18nRes.findValue("_bpm.platform", "\u670d\u52a1\u5730\u5740") + " \n");
        code.append("String aslp = \"" + aslp + "\";\n");
        code.append("// " + I18nRes.findValue("_bpm.platform", "\u53c2\u6570\u5b9a\u4e49\u5217\u8868") + "  \n");
        code.append("Map params = new HashMap<String, Object>();\n");
        JSONObject json = JSONObject.parseObject((String)params);
        for (String key : json.keySet()) {
            String metaDesc = this.getParamDesc(metaInfoArray, key);
            code.append("//" + metaDesc + " \n");
            code.append("params.put(\"" + key + "\", " + key + ");\n");
        }
        code.append("AppAPI appAPI =  SDK.getAppAPI(); \n");
        code.append("//" + desc + " \n");
        code.append("ResponseObject ro = appAPI.callASLP(appAPI.getAppContext(sourceAppId), aslp, params);\n");
        code.append("}");
        return code.toString();
    }

    public String getParamDesc(JSONArray metaInfoArray, String key) {
        String desc = "";
        boolean required = false;
        int i = 0;
        while (i < metaInfoArray.size()) {
            JSONObject json = metaInfoArray.getJSONObject(i);
            if (json.get((Object)"name").equals(key)) {
                required = json.getBoolean("required");
                if (required) {
                    desc = String.valueOf(json.getString("desc")) + "," + I18nRes.findValue("_bpm.platform", "\u5fc5\u586b");
                    break;
                }
                desc = String.valueOf(json.getString("desc")) + "," + I18nRes.findValue("_bpm.platform", "\u975e\u5fc5\u586b");
                break;
            }
            ++i;
        }
        return desc;
    }

    public String ASLPJavaAsyn(String appId, ASLPPluginProfile aslpProfile, JSONArray metaInfoArray) {
        String aslp = aslpProfile.getAslp();
        String desc = aslpProfile.getDesc();
        String params = this.getParams(aslp);
        StringBuffer code = new StringBuffer();
        code.append("public boolean execute() {\n");
        code.append("// " + I18nRes.findValue("_bpm.platform", "\u6a21\u62df\u8c03\u7528\u65b9") + "\n");
        code.append("  String sourceAppId = \"" + I18nRes.findValue("_bpm.platform", "\u8c03\u7528\u65b9\u5e94\u7528") + "ID\";\n");
        code.append("// " + I18nRes.findValue("_bpm.platform", "\u670d\u52a1\u5730\u5740") + "\n");
        code.append("String aslp = \"" + aslp + "\";\n");
        code.append("// " + I18nRes.findValue("_bpm.platform", "\u53c2\u6570\u5b9a\u4e49\u5217\u8868") + "  \n");
        code.append("Map params = new HashMap<String, Object>();\n");
        JSONObject json = JSONObject.parseObject((String)params);
        for (String key : json.keySet()) {
            String metaDesc = this.getParamDesc(metaInfoArray, key);
            code.append("//" + metaDesc + " \n");
            code.append("params.put(\"" + key + "\", " + key + ");\n");
        }
        code.append("AppAPI appAPI =  SDK.getAppAPI(); \n");
        code.append("//" + desc + " \n");
        code.append("appAPI.asynCallASLP(appAPI.getAppContext(sourceAppId), aslp, params);\n");
        code.append("}");
        return code.toString();
    }

    private List<AWSPluginProfile> getPluginList(List<AWSPluginProfile> pluginProfile, String profileClazz) {
        ArrayList<AWSPluginProfile> list = new ArrayList<AWSPluginProfile>();
        for (AWSPluginProfile awsPluginProfile : pluginProfile) {
            if (!profileClazz.equals(awsPluginProfile.getClass().getName())) continue;
            list.add(awsPluginProfile);
        }
        return list;
    }

    public String getPartParamesJSON(String appId, String pName, String pId, String nodeName) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String nodeIcon = String.valueOf(this.twoLevelRootPath) + "geometry_16" + this.ext;
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        Map propertys = app.getProperty();
        ArrayList<AppContextProperty> appContextPropertyList = new ArrayList<AppContextProperty>();
        JSONArray tree = new JSONArray();
        String id = "";
        for (AppContextProperty appContextProperty : propertys.values()) {
            if (!appContextProperty.getGroup().equals(pName)) continue;
            appContextPropertyList.add(appContextProperty);
        }
        for (AppContextProperty appContextProperty : appContextPropertyList) {
            if (appContextProperty.isSystem()) continue;
            String uuid = UUIDGener.getObjectId();
            JSONObject jsonPro = new JSONObject();
            JSONObject node = new JSONObject();
            jsonPro.put("action", (Object)appContextProperty.getAction());
            jsonPro.put("group", (Object)appContextProperty.getGroup());
            jsonPro.put("name", (Object)appContextProperty.getName());
            jsonPro.put("title", (Object)appContextProperty.getTitle());
            jsonPro.put("type", (Object)appContextProperty.getType());
            jsonPro.put("value", (Object)appContextProperty.getValue());
            jsonPro.put("issystem", (Object)appContextProperty.isSystem());
            jsonPro.put("htmlValue", (Object)this.getHtmlEditor(appContextProperty, appId));
            jsonPro.put("htmlDesc", (Object)this.getHtmlDesc(appContextProperty, appId));
            String nodeId = "node_" + uuid;
            node.put("id", (Object)nodeId);
            String name = String.valueOf(appContextProperty.getTitle()) + (appContextProperty.isSystem() ? "(" + I18nRes.findValue("_bpm.platform", "\u7cfb\u7edf\u53c2\u6570") + ")" : "");
            node.put("name", (Object)name);
            node.put("pid", (Object)pId);
            node.put("pName", (Object)pName);
            node.put("pro", (Object)jsonPro);
            node.put("isHasSystem", (Object)appContextProperty.isSystem());
            node.put("group", (Object)pName);
            node.put("icon", (Object)nodeIcon);
            tree.add((Object)node);
            if (!name.equals(nodeName)) continue;
            id = nodeId;
        }
        JSONObject idJson = new JSONObject();
        idJson.put("id", (Object)id);
        JSONObject data = new JSONObject();
        data.put("id", (Object)id);
        data.put("data", (Object)tree);
        ro.setData(data);
        ro.msg(id);
        return ro.toDataString();
    }

    public String getParamesJSON(String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        String nodeIcon = String.valueOf(this.twoLevelRootPath) + "geometry_16" + this.ext;
        String groupIcon = String.valueOf(this.twoLevelRootPath) + "folder_16" + this.ext;
        String rootIcon = String.valueOf(this.twoLevelRootPath) + "settings_16" + this.ext;
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app == null) {
            throw new AWSObjectNotFindException(String.valueOf(I18nRes.findValue("_bpm.platform", "\u5e94\u7528\u4e0d\u5b58\u5728")) + "\uff0cAppId:" + appId);
        }
        LinkedHashMap<String, String> groups = new LinkedHashMap<String, String>();
        Map propertys = app.getProperty();
        ArrayList<AppContextProperty> appContextPropertyList = new ArrayList<AppContextProperty>();
        for (AppContextProperty appProperty : propertys.values()) {
            String groupName = appProperty.getGroup();
            groups.put(groupName, groupName);
            appContextPropertyList.add(appProperty);
        }
        Iterator itGroups = groups.values().iterator();
        JSONArray tree = new JSONArray();
        JSONObject root = new JSONObject();
        root.put("id", (Object)"root");
        root.put("name", (Object)I18nRes.findValue("_bpm.platform", "\u53c2\u6570\u5217\u8868"));
        root.put("open", (Object)true);
        root.put("icon", (Object)rootIcon);
        tree.add((Object)root);
        int i = 0;
        int n = 0;
        while (itGroups.hasNext()) {
            ++i;
            String groupName = (String)itGroups.next();
            boolean isHasSystem = false;
            if (this.getGroupIsHidden(groupName, appContextPropertyList)) continue;
            for (AppContextProperty appContextProperty : appContextPropertyList) {
                if (!appContextProperty.getGroup().equals(groupName) || appContextProperty.getAction().equals("hidden") || !appContextProperty.isSystem()) continue;
                isHasSystem = true;
            }
            JSONObject group = new JSONObject();
            String groupId = "group_" + i;
            UUIDGener.getObjectId();
            group.put("id", (Object)groupId);
            group.put("name", (Object)I18nRes.findValue("_bpm.platform", groupName));
            if (i <= 1) {
                group.put("open", (Object)true);
            } else {
                group.put("open", (Object)false);
            }
            group.put("pid", (Object)"root");
            group.put("isHasSystem", (Object)isHasSystem);
            group.put("icon", (Object)groupIcon);
            group.put("isGroup", (Object)true);
            tree.add((Object)group);
            int count = 0;
            for (AppContextProperty appContextProperty : appContextPropertyList) {
                if (!appContextProperty.getGroup().equals(groupName) || appContextProperty.getAction().equals("hidden") || appContextProperty.isSystem()) continue;
                ++count;
                ++n;
                JSONObject jsonPro = new JSONObject();
                JSONObject node = new JSONObject();
                jsonPro.put("action", (Object)appContextProperty.getAction());
                jsonPro.put("group", (Object)appContextProperty.getGroup());
                jsonPro.put("name", (Object)I18nRes.findValue("_bpm.platform", appContextProperty.getName()));
                jsonPro.put("title", (Object)appContextProperty.getTitle());
                jsonPro.put("type", (Object)appContextProperty.getType());
                jsonPro.put("value", (Object)appContextProperty.getValue());
                jsonPro.put("issystem", (Object)appContextProperty.isSystem());
                jsonPro.put("htmlValue", (Object)this.getHtmlEditor(appContextProperty, appId));
                jsonPro.put("htmlDesc", (Object)this.getHtmlDesc(appContextProperty, appId));
                String nodeId = "node_" + n;
                node.put("id", (Object)nodeId);
                node.put("name", (Object)(String.valueOf(I18nRes.findValue("_bpm.platform", appContextProperty.getTitle())) + (appContextProperty.isSystem() ? "(" + I18nRes.findValue("_bpm.platform", "\u7cfb\u7edf\u53c2\u6570") + ")" : "")));
                node.put("pid", (Object)groupId);
                node.put("pName", (Object)I18nRes.findValue("_bpm.platform", groupName));
                node.put("pro", (Object)jsonPro);
                node.put("isHasSystem", (Object)appContextProperty.isSystem());
                node.put("group", (Object)I18nRes.findValue("_bpm.platform", groupName));
                node.put("isGroup", (Object)false);
                node.put("icon", (Object)nodeIcon);
                tree.add((Object)node);
            }
        }
        ro.setData(tree);
        return ro.toString();
    }

    private String getHtmlEditor(AppContextProperty appContextProperty, String appId) {
        StringBuilder htmlEditor = new StringBuilder();
        String disabled = "";
        String readOnly = "";
        if (appContextProperty != null) {
            if (appContextProperty.getAction().equals("disabled")) {
                disabled = "disabled";
                readOnly = "readOnly";
            }
            htmlEditor.append("<div class='prameUIDiv'>");
            if (appContextProperty.getType().equals("input")) {
                htmlEditor.append("<input  " + readOnly + " id='htmlEditor' class='paramUIInput'  value='" + appContextProperty.getValue() + "'  class=\"txt\"   />");
                htmlEditor.append("<a href=\"#\" onclick=\"popDialog('" + readOnly + "')\" class='paramUIZoom'><img  src=\"../commons/img/popup.png\"  awsui-qtip=\"" + I18nRes.findValue("_bpm.platform", "\u70b9\u51fb\u653e\u5927\u8f93\u5165\u7a97\u53e3") + "\"  /></a>");
            } else if (appContextProperty.getType().equals("textarea")) {
                htmlEditor.append("<textarea " + readOnly + " class='paramUITextarea' id=\"htmlEditor\"  >" + Html.encodeForHTML(appContextProperty.getValue()) + "</textarea>");
                htmlEditor.append("<a href=\"#\" onclick=\"popDialog('" + readOnly + "')\" class='paramUIZoom'><img  src=\"../commons/img/popup.png\" awsui-qtip=\"" + I18nRes.findValue("_bpm.platform", "\u70b9\u51fb\u653e\u5927\u8f93\u5165\u7a97\u53e3") + "\" /></a>");
            } else if (appContextProperty.getType().equals("cc.mail")) {
                htmlEditor.append("");
            } else if (appContextProperty.getType().equals("select")) {
                htmlEditor.append(this.getCCDataBase(appContextProperty.getValue(), disabled));
            } else if (appContextProperty.getType().equals("combox")) {
                htmlEditor.append(this.getCombox(appContextProperty.getValue(), appContextProperty.getRef(), disabled));
            } else if (appContextProperty.getType().equals("password")) {
                String value = appContextProperty.getValue();
                try {
                    value = new String(AES.decrypt((byte[])Base64.decode(value.getBytes(Charset.forName("UTF-8"))), (String)new MD5().toDigest(appId)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                htmlEditor.append("<input  " + readOnly + " type=\"password\"  id='htmlEditor' class='paramUIInput' value='" + value + "'   class=\"txt\"   />");
            } else if (appContextProperty.getType().equals("address")) {
                htmlEditor.append("<input  " + readOnly + " id='htmlEditor' class='paramUIInput'  value='" + appContextProperty.getValue() + "'  class=\"txt\"   />");
                htmlEditor.append("<script>").append("$(document).ready(function(){ $('#htmlEditor').address(); });").append("</script>");
            }
            htmlEditor.append("</div>");
        }
        return htmlEditor.toString();
    }

    private String getCCDataBase(String databaseName, String dis) {
        String sel = "";
        StringBuilder sBuilder = new StringBuilder("<select " + dis + " class='paramUISelect' id='htmlEditor' >");
        sBuilder.append("<option value=''>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9") + "...</option>");
        Map h = CCCache.getInstance().getListByType("jdbc");
        int i = 0;
        while (i < h.size()) {
            CCModel cp = (CCModel)h.get(i);
            if (databaseName.equals(cp.getId())) {
                sel = "selected";
            }
            sBuilder.append("<option " + sel + " value='" + cp.getId() + "' >" + CCUtil.getName((CCModel)cp) + "</option>");
            sel = "";
            ++i;
        }
        sBuilder.append("</select>");
        sBuilder.append("<a style=\"margin-left: 10px;\" href=\"\" onclick=\"editCCJDBC();return false;\">");
        sBuilder.append("<img src=\"../apps/_bpm.platform/img/model/comments.gif\" awsui-qtip=\"" + I18nRes.findValue("_bpm.platform", "\u7f16\u8f91") + "\"></a>");
        return sBuilder.toString();
    }

    private String getCombox(String value, String refVal, String dis) {
        StringBuilder sBuilder = new StringBuilder("<select " + dis + " class='paramUISelect' id='htmlEditor' >");
        String[] refValArr = refVal != null && refVal.length() > 0 ? refVal.split("\\|") : null;
        String sel = "";
        String tempHtm = "";
        String tempVal = "";
        if (refValArr != null) {
            int i = 0;
            while (i < refValArr.length) {
                String tempStr = refValArr[i];
                if (tempStr.replace("\\:", "%").indexOf(":") > -1) {
                    tempStr = refValArr[i].replace("\\:", "%");
                    tempHtm = tempStr.substring(0, tempStr.indexOf(":")).replace("%", ":");
                    tempVal = tempStr.substring(tempStr.indexOf(":") + 1).replace("%", ":");
                } else {
                    tempHtm = tempStr;
                    tempVal = tempStr;
                }
                if (value.equals(tempVal)) {
                    sel = "selected";
                }
                sBuilder.append("<option value='" + tempVal + "' " + sel + ">" + tempHtm + "</option>");
                sel = "";
                ++i;
            }
        }
        sBuilder.append("</select>");
        return sBuilder.toString();
    }

    private String getHtmlDesc(AppContextProperty appContextProperty, String appId) {
        StringBuilder htmlEditor = new StringBuilder();
        String disabled = "";
        String descDisabled = "";
        if (appContextProperty != null) {
            if (appContextProperty.getAction().equals("disabled")) {
                disabled = "disabled";
            }
            htmlEditor.append("<textarea " + disabled + " class='paramInfoDesc' " + descDisabled + "  id=\"htmlEditorDesc\">" + (appContextProperty.getDesc() == null ? "" : appContextProperty.getDesc().replaceAll("<br>", "\n")) + "</textarea>");
        }
        return htmlEditor.toString();
    }

    private boolean getGroupIsHidden(String groupName, List<AppContextProperty> appContextPropertyList) {
        boolean isHidden = true;
        int groupNamePropertyCount = 0;
        int count = 0;
        for (AppContextProperty appContextProperty : appContextPropertyList) {
            if (!appContextProperty.getGroup().equals(groupName)) continue;
            ++groupNamePropertyCount;
            if (!appContextProperty.getAction().equals("hidden")) continue;
            ++count;
        }
        if (groupNamePropertyCount - count > 0) {
            isHidden = false;
        }
        return isHidden;
    }

    public String getAppManagerMessageByPage(String appId, int page, boolean isPage, String mesLevel) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        StringBuilder html = new StringBuilder();
        int totalPage = 0;
        if (app != null) {
            List<AppLogMsg> messageList = AMCUtil.getMessageListByApp(appId, mesLevel);
            Collections.sort(messageList, new AppComparator.MessageDateComparatorDESC());
            int total = messageList.size();
            int start = 0;
            int end = total;
            if (isPage) {
                start = (page - 1) * 50;
                end = page * 50;
                end = end > total ? total : end;
            }
            int i = start;
            while (i < end) {
                AppLogMsg appLogBean = messageList.get(i);
                html.append("<tr>");
                html.append(this.getLiDiv(appLogBean));
                html.append("</tr>");
                ++i;
            }
            totalPage = messageList.size() % 50 > 0 ? messageList.size() / 50 + 1 : messageList.size() / 50;
        }
        JSONObject json = new JSONObject();
        json.put("html", (Object)html.toString());
        json.put("totalPage", (Object)totalPage);
        ro.setData(json);
        return ro.toString();
    }

    private String getLiDiv(AppLogMsg appLogBean) {
        SimpleDateFormat smp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder html = new StringBuilder();
        String css1 = "info1";
        String css2 = "unread";
        String level = appLogBean.getLevel();
        boolean isRead = appLogBean.isRead();
        isRead = true;
        appLogBean.setRead(isRead);
        if (level.equals("err")) {
            css1 = "error1";
        } else if (level.equals("warn")) {
            css1 = "warn1";
        }
        if (isRead) {
            css2 = "read";
        }
        html.append("<td align='center' style='width:5%;'><div  class='icon " + css1 + "'></div></td>");
        html.append("<td style='width:80%;'><div  class='ellipsis " + css2 + "' style='margin:5px;line-height:25px;' title='" + I18nRes.findValue("_bpm.platform", appLogBean.getMsg()) + "' >" + I18nRes.findValue("_bpm.platform", appLogBean.getMsg()) + "</div></td>");
        html.append("<td style='white-space: nowrap;' >" + smp.format(appLogBean.getTime()) + "</td>");
        return html.toString().replaceAll("\n", "<br>").replaceAll("\t", "&nbsp;&nbsp;");
    }

    private String getReverseDepend(String appId) {
        StringBuilder reverseDepend = new StringBuilder();
        List<AppContext> reverseDepandList = AMCUtil.getReverseDependApps(appId);
        if (reverseDepandList.size() > 0) {
            for (AppContext tApp : reverseDepandList) {
                String css = "normal";
                if (!tApp.getRuntimeState().equals("ACTIVE")) {
                    css = "error";
                }
                reverseDepend.append("<tr>");
                reverseDepend.append("<td width='5px'><div class='bar " + css + "' style='margin-top:0px;'></div></td><td class='list'>" + tApp.getName() + "</td>");
                reverseDepend.append("</tr>");
            }
        } else {
            reverseDepend.append("<tr>");
            reverseDepend.append("<td width='5px'</td><td class='list'>" + I18nRes.findValue("_bpm.platform", "\u65e0") + "</td>");
            reverseDepend.append("</tr>");
        }
        return reverseDepend.toString();
    }

    private String getAppDepend(AppContext app) {
        StringBuilder appDepand = new StringBuilder();
        AppContext dependApp = null;
        AppContextDepend appDependContext = app.getDepend();
        if (appDependContext != null) {
            dependApp = AppsAPIManager.getInstance().getAppContext(appDependContext.getAppId());
            String css = "normal";
            if (dependApp != null) {
                if (!dependApp.getRuntimeState().equals("ACTIVE")) {
                    css = "error";
                }
                if (dependApp != null) {
                    appDepand.append("<tr>");
                    appDepand.append("<td width='5px'><div class='bar " + css + "' style='margin-top:0px;'></div></td><td class='list'>" + dependApp.getName() + "(" + dependApp.getVersion() + ")" + "</td>");
                    appDepand.append("</tr>");
                }
            } else {
                appDepand.append("<tr>");
                appDepand.append("<td width='5px'</td><td class='list'>" + I18nRes.findValue("_bpm.platform", "\u65e0") + "</td>");
                appDepand.append("</tr>");
            }
        } else {
            appDepand.append("<tr>");
            appDepand.append("<td width='5px'</td><td class='list'>" + I18nRes.findValue("_bpm.platform", "\u65e0") + "</td>");
            appDepand.append("</tr>");
        }
        return appDepand.toString();
    }

    public String getApplicationManagementList() {
        return this.getApplicationManagementListBySort("");
    }

    public String getAppSortOrFilter(String opeType, String str) {
        if (opeType.equals("filter")) {
            return this.getApplicationManagementListFilterByFiled(str);
        }
        if (opeType.equals("sort")) {
            return this.getApplicationManagementListBySort(str);
        }
        return "";
    }

    public String getApplicationManagementListBySort(String sortStr) {
        StringBuilder html = new StringBuilder();
        List<AppContext> appContexts = null;
        try {
            appContexts = AMCUtil.queryAllAppsList();
            if (sortStr.equals("1")) {
                Collections.sort(appContexts, new AppComparator.AppDateComparatorASC());
            } else if (sortStr.equals("2")) {
                ArrayList<AppContext> startApps = new ArrayList<AppContext>();
                ArrayList<AppContext> stopApps = new ArrayList<AppContext>();
                ArrayList<AppContext> failedApps = new ArrayList<AppContext>();
                ArrayList<AppContext> readyApps = new ArrayList<AppContext>();
                ArrayList<AppContext> offlineApps = new ArrayList<AppContext>();
                for (AppContext appContext : appContexts) {
                    if (appContext.getRuntimeState().equals("ACTIVE")) {
                        startApps.add(appContext);
                        continue;
                    }
                    if (appContext.getRuntimeState().equals("STOPPED")) {
                        stopApps.add(appContext);
                        continue;
                    }
                    if (appContext.getRuntimeState().equals("FAILED")) {
                        failedApps.add(appContext);
                        continue;
                    }
                    if (appContext.getRuntimeState().equals("READY")) {
                        readyApps.add(appContext);
                        continue;
                    }
                    if (!appContext.getRuntimeState().equals("OFFLINE")) continue;
                    offlineApps.add(appContext);
                }
                Collections.sort(startApps, new AppComparator.AppDateComparatorASC());
                for (AppContext appContext : startApps) {
                    html.append(this.getSingleAppHtml(appContext));
                }
                Collections.sort(stopApps, new AppComparator.AppDateComparatorASC());
                for (AppContext appContext : stopApps) {
                    html.append(this.getSingleAppHtml(appContext));
                }
                Collections.sort(failedApps, new AppComparator.AppDateComparatorASC());
                for (AppContext appContext : failedApps) {
                    html.append(this.getSingleAppHtml(appContext));
                }
                Collections.sort(readyApps, new AppComparator.AppDateComparatorASC());
                for (AppContext appContext : readyApps) {
                    html.append(this.getSingleAppHtml(appContext));
                }
                Collections.sort(offlineApps, new AppComparator.AppDateComparatorASC());
                for (AppContext appContext : offlineApps) {
                    html.append(this.getSingleAppHtml(appContext));
                }
                return html.toString();
            }
            for (AppContext appContext : appContexts) {
                html.append(this.getSingleAppHtml(appContext));
            }
        }
        catch (AppContainerException e) {
            e.printStackTrace();
        }
        return html.toString();
    }

    public String getApplicationManagementListFilterByFiled(String filter) {
        List<AppContext> appContexts;
        StringBuilder html = new StringBuilder();
        List<AppContext> filterApps = appContexts = AMCUtil.queryAllAppsList();
        if (!filter.equals("0")) {
            filterApps = this.getFileterApp(appContexts, filter);
        }
        for (AppContext appContext : filterApps) {
            html.append(this.getSingleAppHtml(appContext));
        }
        return html.toString();
    }

    private List<AppContext> getFileterApp(List<AppContext> appContexts, String type) {
        ArrayList<AppContext> filterApps = new ArrayList<AppContext>();
        ArrayList<AppContext> startApps = new ArrayList<AppContext>();
        for (AppContext appContext : appContexts) {
            if (!appContext.getRuntimeState().equals(type)) continue;
            startApps.add(appContext);
        }
        List offlineList = new ArrayList();
        if (type.equals("OFFLINE")) {
            offlineList = AppDependencyHelper.queryOfflineApps();
        }
        filterApps.addAll(startApps);
        for (AppContext appContext : offlineList) {
            if (startApps.contains(appContext)) continue;
            filterApps.add(appContext);
        }
        return filterApps;
    }

    public String getApplicationManagementTree() {
        StringBuilder html = new StringBuilder();
        List appContexts = AppsAPIManager.getInstance().getInstalledApps();
        for (AppContext appContext : appContexts) {
            html.append(this.getSingleAppHtml(appContext));
        }
        return html.toString();
    }

    public String getSingleAppHtml(AppContext appContext) {
        StringBuilder html = new StringBuilder();
        if (GradeSecurityUtil.isSuperMaster(this.getContext().getUID()) || GradeSecurityUtil.isSystemMaster(this.getContext().getUID()) || AMCAPIManager.isDevelopApp(appContext.getId(), this.getContext().getUID()) || AMCAPIManager.isManagementApp(appContext.getId(), this.getContext().getUID())) {
            html.append("<tr id='" + appContext.getId() + "'>");
            html.append(this.getSingleAppNoTrHtml(appContext));
            html.append("</tr>");
        }
        return html.toString();
    }

    public String getSingleAppNoTrHtml(AppContext appContext) {
        boolean isShow = false;
        StringBuilder html = new StringBuilder();
        String runTimeStatus = appContext.getRuntimeState();
        boolean isDepend = true;
        AppContextDepend appDependContext = appContext.getDepend();
        AppContext dependApp = null;
        if (appDependContext != null && (dependApp = AppsAPIManager.getInstance().getAppContext(appDependContext.getAppId())) != null) {
            isDepend = appDependContext.isDependVersion(dependApp.getVersion());
        }
        runTimeStatus = runTimeStatus.equals("STOPPED") || runTimeStatus.equals("FAILED") ? "<font color='red'><b>" + I18nRes.findValue("_bpm.platform", AMCUtil.getAppRunTimeStatus(runTimeStatus)) + "</b></font>" : I18nRes.findValue("_bpm.platform", AMCUtil.getAppRunTimeStatus(runTimeStatus));
        String img = AMCUtil.getListAppIcon(appContext.getId());
        if (AppPlatformConfig.isAppStoreService() || !appContext.getProductId().equals("")) {
            isShow = true;
        }
        html.append("<td  class='list name'>" + img);
        html.append("<input type='hidden' value='" + appContext.getId() + "' name='appId'>");
        html.append("<div style='float:left;height: 41px;line-height: 41px;' >");
        if (isDepend) {
            String noUse = "use";
            if (!appContext.getRuntimeState().equals("ACTIVE")) {
                noUse = "nouse";
            }
            String appNameI18N = I18nMetadataUtil.findValue(appContext.getId(), "APP_NAME_", appContext.getId(), this.getContext().getLanguage(), appContext.getName());
            html.append("<a class='app_name' name='" + noUse + "' href='#' style='text-decoration: none;' index='" + appContext.getId().replaceAll("\\.", "-") + "' title='" + appNameI18N + "(" + appContext.getId() + ")' onclick='ApplicationManagement.showDetail(\"" + appContext.getId() + "\",\"" + appNameI18N + "\",true," + isShow + ");return false;'>" + AMCUtil.getAppNewName(appNameI18N, 22) + "</a>");
        } else {
            html.append("<span name='nouse' index='" + appContext.getId().replaceAll("\\.", "-") + "' title='" + I18nRes.findValue("_bpm.platform", "\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u7684\u7236\u5e94\u7528") + "[" + I18nMetadataUtil.findValue(dependApp.getId(), "APP_NAME_", dependApp.getId(), this.getContext().getLanguage(), dependApp.getName()) + "]" + I18nRes.findValue("_bpm.platform", "\u5df2\u7ecf\u5347\u7ea7\u81f3") + "[" + dependApp.getVersion() + "]" + I18nRes.findValue("_bpm.platform", "\u800c\u5f53\u524d\u5e94\u7528\u4f9d\u8d56") + "[" + I18nMetadataUtil.findValue(dependApp.getId(), "APP_NAME_", dependApp.getId(), this.getContext().getLanguage(), dependApp.getName()) + "]" + I18nRes.findValue("_bpm.platform", "\u7684") + "[" + appDependContext.getVersions() + "]," + I18nRes.findValue("_bpm.platform", "\u8bf7\u5347\u7ea7\u5f53\u524d\u5e94\u7528\u4ee5\u7ee7\u7eed\u64cd\u4f5c") + "'>" + I18nRes.findValue("_bpm.platform", AMCUtil.getAppNewName(appContext.getName())) + "</span>");
        }
        html.append("</div>");
        html.append("</td>");
        html.append("<td  class='list state'>");
        if (isDepend) {
            html.append(AMCUtil.getAppNotificationCountHtml(appContext, "apppManager", isDepend));
        } else {
            html.append("<span title='" + I18nRes.findValue("_bpm.platform", "\u5f53\u524d\u5e94\u7528\u4f9d\u8d56\u7684\u7236\u5e94\u7528") + "[" + I18nMetadataUtil.findValue(dependApp.getId(), "APP_NAME_", dependApp.getId(), this.getContext().getLanguage(), dependApp.getName()) + "]" + I18nRes.findValue("_bpm.platform", "\u5df2\u7ecf\u5347\u7ea7\u81f3") + "[" + dependApp.getVersion() + "]" + I18nRes.findValue("_bpm.platform", "\u800c\u5f53\u524d\u5e94\u7528\u4f9d\u8d56") + "[" + I18nMetadataUtil.findValue(dependApp.getId(), "APP_NAME_", dependApp.getId(), this.getContext().getLanguage(), dependApp.getName()) + "]" + I18nRes.findValue("_bpm.platform", "\u7684") + "[" + appDependContext.getVersions() + "]," + I18nRes.findValue("_bpm.platform", "\u8bf7\u5347\u7ea7\u5f53\u524d\u5e94\u7528\u4ee5\u7ee7\u7eed\u64cd\u4f5c") + "'>" + I18nRes.findValue("_bpm.platform", "\u4f9d\u8d56\u5e94\u7528\u7248\u672c\u5b58\u5728\u95ee\u9898") + "</span>");
        }
        html.append("</td>");
        html.append("<td  class='list runtime'>");
        if (appContext.getStartTime() == null) {
            html.append("");
        } else {
            html.append(String.valueOf(I18nRes.findValue("_bpm.platform", "\u5df2\u8fd0\u884c")) + AMCUtil.getAppRunTime(appContext.getStartTime()));
        }
        html.append("</td>");
        html.append("<td  class='list runstate running'>");
        html.append(runTimeStatus);
        html.append("</td>");
        boolean isRepeat = AMCUtil.checkRepeat(appContext);
        if (isDepend) {
            html.append(AMCUtil.getOptButtonStatusByAppRumtimeStatus(appContext, true, this.getContext(), isRepeat));
        } else {
            html.append("<td>");
            if (!appContext.getId().equals("_bpm.platform")) {
                html.append("<input type='button' class='button blue small' onclick='ApplicationManagement.openAppRestoreDialog(\"" + appContext.getId() + "\");'  value='" + I18nRes.findValue("_bpm.platform", "\u8fd8\u539f") + "'/>");
            }
            html.append(AMCUtil.getUninstallButton(appContext, true, this.getContext(), isRepeat));
            html.append("</td>");
        }
        return html.toString();
    }

    public String modifyLogToRead(String appId, boolean isRead, int page) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        List logs = app.getNotification();
        StringBuilder html = new StringBuilder();
        html.append("<tr> <th width='5%'style='text-align: center;'>" + I18nRes.findValue("_bpm.platform", "\u7c7b\u578b") + "</th><th width='80%'>" + I18nRes.findValue("_bpm.platform", "\u6d88\u606f\u5185\u5bb9") + "</th><th  width='15%'>" + I18nRes.findValue("_bpm.platform", "\u8bb0\u5f55\u65f6\u95f4") + "</th></tr>");
        Collections.sort(logs, new AppComparator.MessageDateComparatorDESC());
        int total = logs.size();
        int start = 0;
        int end = total;
        int totalPage = 0;
        start = (page - 1) * 50;
        end = page * 50;
        end = end > total ? total : end;
        int i = start;
        while (i < end) {
            AppLogMsg appLogBean = (AppLogMsg)logs.get(i);
            html.append("<tr>");
            appLogBean.setRead(isRead);
            html.append(this.getLiDiv(appLogBean));
            html.append("</tr>");
            ++i;
        }
        totalPage = logs.size() % 50 > 0 ? logs.size() / 50 + 1 : logs.size() / 50;
        JSONObject json = new JSONObject();
        json.put("html", (Object)html.toString());
        json.put("totalPage", (Object)totalPage);
        ro.setData(json);
        return html.toString();
    }

    public String modifyParam(String appId, String param, String value, String group, String desc) {
        desc = desc.replaceAll("\n", "<br>");
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject info = new JSONObject();
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        if (app != null) {
            Map propertys = app.getProperty();
            for (AppContextProperty property : propertys.values()) {
                if (!property.getGroup().equals(group) || !property.getName().equals(param)) continue;
                AppContextWrapper appPropertyWra = AppContextWrapper.createAppContextProperty((AppContextProperty)property);
                if (property.getType().equals("password") && !UtilString.isEmpty(value)) {
                    try {
                        value = new String(Base64.encode(AES.encrypt((byte[])value.getBytes(Charset.forName("UTF-8")), (String)new MD5().toDigest(appId))), Charset.forName("UTF-8"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                appPropertyWra.setValue(value);
                appPropertyWra.setPropertyDesc(desc);
            }
            ArrayList<AppContextProperty> properties = new ArrayList<AppContextProperty>();
            for (AppContextProperty property : app.getProperty().values()) {
                properties.add(property);
            }
            try {
                AppsAPIManager.getInstance().saveProperties(appConfigFile, properties);
                info.put("status", (Object)"ok");
                ro.ok();
            }
            catch (Exception e) {
                info.put("status", (Object)"error");
                ro.err();
                ro.msg(e.getMessage());
                e.printStackTrace();
            }
            AppContextWrapper appWarp = AppContextWrapper.createWrapper((AppContext)app);
            appWarp.setLastModified(Long.valueOf(appConfigFile.lastModified()));
        }
        ro.setData(info);
        return ro.toString();
    }

    public String removeParam(String appId, String group, String name) {
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject info = new JSONObject();
        try {
            AppsAPIManager.getInstance().delProperties(appConfigFile, group, name);
            AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
            if (app != null) {
                AppContextWrapper wapp = AppContextWrapper.createWrapper((AppContext)app);
                Map properties = app.getProperty();
                if (!group.equals("")) {
                    for (AppContextProperty property : properties.values()) {
                        if (property == null || !property.getGroup().equals(group)) continue;
                        properties.remove(property.getName());
                    }
                } else if (!name.equals("")) {
                    properties.remove(name);
                }
                wapp.setProperty(properties);
            }
            info.put("status", (Object)"ok");
            ro.ok();
        }
        catch (Exception e) {
            info.put("status", (Object)"error");
            ro.msg(e.getMessage());
            ro.err();
            e.printStackTrace();
        }
        ro.setData(info);
        return ro.toString();
    }

    public String addParamPage(String appId, String paramName, String paramGroup) {
        HashMap<String, Object> macroLibraries = new HashMap<String, Object>();
        macroLibraries.put("sid", super.getContext().getSessionId());
        String name = "";
        String title = "";
        String group = "";
        String actionoption = "";
        String typeoption = "";
        String desc = "";
        String value = "";
        String referenceVal = "";
        boolean isSysem = false;
        String nameInput = "<span class='required'><input type=\"text\" class=\"awsui-textbox\" id=\"name\" value=\"\" name=\"name\"></span>";
        AppContextProperty pro = AppsAPIManager.getInstance().getAppContext(appId).getPropertyObj(paramName);
        if (pro != null && pro.getName().length() > 0) {
            name = pro.getName();
            title = pro.getTitle();
            group = pro.getGroup();
            actionoption = pro.getAction();
            typeoption = pro.getType();
            desc = pro.getDesc() == null ? "" : pro.getDesc();
            value = pro.getValue();
            isSysem = pro.isSystem();
            referenceVal = pro.getRef();
            nameInput = "<label >" + name + "</label><input type=\"hidden\" class=\"awsui-textbox\" id=\"name\" value=\"" + name + "\" name=\"name\">";
        }
        macroLibraries.put("name", name);
        macroLibraries.put("nameInput", nameInput);
        macroLibraries.put("title", title);
        macroLibraries.put("group", group);
        macroLibraries.put("actionoption", this.getActionOptionHtml(actionoption));
        macroLibraries.put("typeoption", this.getTypeOptionHtml(typeoption));
        macroLibraries.put("desc", desc);
        macroLibraries.put("value", value);
        macroLibraries.put("isSystem", isSysem);
        macroLibraries.put("referenceVal", referenceVal);
        return HtmlPageTemplate.merge("_bpm.platform", "console.admin.amc.appdevelop.addparam.htm", macroLibraries);
    }

    private String getTypeOptionHtml(String typeoption) {
        StringBuilder html = new StringBuilder();
        html.append("<option value='0'>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9") + "...</option>");
        if (typeoption.equals("input")) {
            html.append("<option selected value='input'>" + I18nRes.findValue("_bpm.platform", "\u5355\u884c\u8f93\u5165\u6846") + "</option>");
        } else {
            html.append("<option  value='input'>" + I18nRes.findValue("_bpm.platform", "\u5355\u884c\u8f93\u5165\u6846") + "</option>");
        }
        if (typeoption.equals("textarea")) {
            html.append("<option selected value='textarea'>" + I18nRes.findValue("_bpm.platform", "\u591a\u884c\u8f93\u5165\u6846") + "</option>");
        } else {
            html.append("<option  value='textarea'>" + I18nRes.findValue("_bpm.platform", "\u591a\u884c\u8f93\u5165\u6846") + "</option>");
        }
        if (typeoption.equals("combox")) {
            html.append("<option selected value='combox'>" + I18nRes.findValue("_bpm.platform", "\u4e0b\u62c9\u5217\u8868\u6846") + "</option>");
        } else {
            html.append("<option value='combox'>" + I18nRes.findValue("_bpm.platform", "\u4e0b\u62c9\u5217\u8868\u6846") + "</option>");
        }
        if (typeoption.equals("password")) {
            html.append("<option selected value='password'>" + I18nRes.findValue("_bpm.platform", "\u5bc6\u7801\u8f93\u5165\u6846") + "</option>");
        } else {
            html.append("<option value='password'>" + I18nRes.findValue("_bpm.platform", "\u5bc6\u7801\u8f93\u5165\u6846") + "</option>");
        }
        if (typeoption.equals("address")) {
            html.append("<option selected value='address'>" + I18nRes.findValue("_bpm.platform", "\u5730\u5740\u7c3f") + "</option>");
        } else {
            html.append("<option value='address'>" + I18nRes.findValue("_bpm.platform", "\u5730\u5740\u7c3f") + "</option>");
        }
        return html.toString();
    }

    private String getActionOptionHtml(String actionoption) {
        StringBuilder html = new StringBuilder();
        html.append("<option value='0'>" + I18nRes.findValue("_bpm.platform", "\u8bf7\u9009\u62e9") + "...</option>");
        if (actionoption.equals("disabled")) {
            html.append("<option selected value='disabled'>" + I18nRes.findValue("_bpm.platform", "\u53ea\u8bfb") + "</option>");
        } else {
            html.append("<option  value='disabled'>" + I18nRes.findValue("_bpm.platform", "\u53ea\u8bfb") + "</option>");
        }
        if (actionoption.equals("edit")) {
            html.append("<option selected value='edit'>" + I18nRes.findValue("_bpm.platform", "\u7f16\u8f91") + "</option>");
        } else {
            html.append("<option  value='edit'>" + I18nRes.findValue("_bpm.platform", "\u7f16\u8f91") + "</option>");
        }
        if (actionoption.equals("hidden")) {
            html.append("<option  selected value='hidden'>" + I18nRes.findValue("_bpm.platform", "\u9690\u85cf") + "</option>");
        } else {
            html.append("<option   value='hidden'>" + I18nRes.findValue("_bpm.platform", "\u9690\u85cf") + "</option>");
        }
        return html.toString();
    }

    public String addParam(String appId, String propertyJson) {
        ResponseObject ro = ResponseObject.newOkResponse();
        AppContext app = AppsAPIManager.getInstance().getAppContext(appId);
        JSONObject info = new JSONObject();
        if (!(propertyJson = propertyJson.replaceAll("\n", "<br>")).equals("")) {
            String action = "";
            String group = "";
            String name = "";
            String title = "";
            String type = "";
            String desc = "";
            String value = "";
            String referenceValue = "";
            boolean isSystem = false;
            if (propertyJson.equals("")) {
                propertyJson = "{}";
            }
            JSONObject json = JSONObject.parseObject((String)propertyJson);
            action = json.getString("action");
            name = json.getString("name");
            group = json.getString("group");
            title = json.getString("title");
            type = json.getString("type");
            desc = json.getString("desc");
            referenceValue = json.getString("referenceValue");
            value = json.getString("value");
            isSystem = json.getBoolean("system");
            AppContextPropertyImpl property = new AppContextPropertyImpl();
            AppContextWrapper wproperty = AppContextWrapper.createAppContextProperty((AppContextProperty)property);
            wproperty.setAction(action);
            wproperty.setPropertyName(name);
            wproperty.setPropertyGroup(group);
            wproperty.setPropertyTitle(title);
            wproperty.setPropertyType(type);
            wproperty.setPropertyDesc(desc);
            wproperty.setValue(value);
            wproperty.setPropertySystem(isSystem);
            wproperty.setPropertyRef(referenceValue);
            File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
            try {
                if (app != null) {
                    AppContextWrapper wapp = AppContextWrapper.createWrapper((AppContext)app);
                    Map properties = app.getProperty();
                    properties.put(name, property);
                    wapp.setProperty(properties);
                }
                ArrayList<AppContextProperty> properties = new ArrayList<AppContextProperty>();
                for (AppContextProperty myproperty : app.getProperty().values()) {
                    properties.add(myproperty);
                }
                AppsAPIManager.getInstance().saveProperties(appConfigFile, properties);
                info.put("status", (Object)"ok");
                ro.ok();
            }
            catch (Exception e) {
                info.put("status", (Object)"fail");
                e.printStackTrace();
                ro.msg(e.getMessage());
                ro.warn();
            }
        } else {
            info.put("status", (Object)"fail");
            ro.msg(I18nRes.findValue("_bpm.platform", "\u83b7\u53d6\u53c2\u6570\u4fe1\u606f\u5931\u8d25"));
            ro.warn();
        }
        ro.setData(info);
        return ro.toString();
    }

    public String delNavDeploy(String navId, String type) {
        JSONObject info;
        ResponseObject ro;
        block29: {
            ro = ResponseObject.newOkResponse();
            info = new JSONObject();
            if (type.equals("system")) {
                List<NavigationDirectoryModel> list = NavigationDirectoryCache.getListOfSystem(navId);
                if (list.size() > 0) {
                    info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u8be5\u5b50\u7cfb\u7edf\u4e0b\u542b\u6709\u76ee\u5f55\u4e0d\u53ef\u5220\u9664"));
                    info.put("state", (Object)"fail");
                    ro.warn();
                    ro.msg(I18nRes.findValue("_bpm.platform", "\u8be5\u5b50\u7cfb\u7edf\u4e0b\u542b\u6709\u76ee\u5f55\u4e0d\u53ef\u5220\u9664"));
                } else {
                    try {
                        int r = NavigationDaoFactory.createNavigationSystem().delete(navId);
                        if (r > 0) {
                            info.put("state", (Object)"ok");
                            ro.ok();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                            break block29;
                        }
                        info.put("state", (Object)"fail");
                        ro.warn();
                        ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        info.put("state", (Object)"fail");
                        ro.warn();
                        ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                    }
                }
            } else if (type.equals("directory")) {
                List<NavigationFunctionModel> list = NavigationFunctionCache.getListOfDirectory(navId);
                if (list.size() > 0) {
                    info.put("state", (Object)"fail");
                    ro.warn();
                    ro.msg(I18nRes.findValue("_bpm.platform", "\u8be5\u76ee\u5f55\u4e0b\u542b\u6709\u529f\u80fd\u4e0d\u53ef\u5220\u9664"));
                } else {
                    try {
                        int r = NavigationDaoFactory.createNavigationDirectory().delete(navId);
                        if (r > 0) {
                            info.put("state", (Object)"ok");
                            ro.ok();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                            break block29;
                        }
                        info.put("state", (Object)"fail");
                        ro.warn();
                        ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                NavigationSystemModel model = NavigationSystemCache.getModel(navId);
                if (model != null) {
                    try {
                        int r = NavigationDaoFactory.createNavigationSystem().delete(navId);
                        if (r > 0) {
                            info.put("state", (Object)"ok");
                            ro.ok();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                        } else {
                            info.put("state", (Object)"fail");
                            ro.warn();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        info.put("state", (Object)"fail");
                        ro.err();
                        ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                    }
                    ro.setData(info);
                    return ro.toString();
                }
                NavigationDirectoryModel directoryModel = NavigationDirectoryCache.getModel(navId);
                if (directoryModel != null) {
                    try {
                        int r = NavigationDaoFactory.createNavigationDirectory().delete(navId);
                        if (r > 0) {
                            info.put("state", (Object)"ok");
                            info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                            ro.ok();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                        } else {
                            info.put("state", (Object)"fail");
                            info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                            ro.warn();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        info.put("state", (Object)"fail");
                        info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                        ro.err();
                        ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                    }
                    ro.setData(info);
                    return ro.toString();
                }
                NavigationFunctionModel functionModel = NavigationFunctionCache.getModel(navId);
                if (functionModel != null) {
                    int r = 0;
                    try {
                        r = NavigationDaoFactory.createNavigationFunction().delete(navId);
                        if (r > 0) {
                            info.put("state", (Object)"ok");
                            info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                            ro.ok();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u6210\u529f"));
                        } else {
                            info.put("state", (Object)"fail");
                            info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                            ro.warn();
                            ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        info.put("state", (Object)"fail");
                        info.put("info", (Object)I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                        ro.err();
                        ro.msg(I18nRes.findValue("_bpm.platform", "\u5220\u9664\u5931\u8d25"));
                    }
                    ro.setData(info);
                    return ro.toString();
                }
            }
        }
        ro.setData(info);
        return ro.toString();
    }

    public String deployNav(String appId, String appDeployId, String deployType, String pid, String functionType) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONObject json = new JSONObject();
        File appConfigFile = new File("../apps/install/" + appId + "/" + "manifest.xml");
        boolean isSuccess = true;
        if (deployType.equals("system")) {
            DeploymentFunction nav = null;
            if (functionType.equals("function")) {
                nav = DeployUtil.getDeploymentFunctionById(appConfigFile, appDeployId);
            }
            if (functionType.equals("system")) {
                nav = DeployUtil.getDeploymentSystemById(appConfigFile, appDeployId);
            }
            if (nav != null) {
                isSuccess = !DeployUtil.createNavSystem((NavTpl)nav, appId).equals("");
            }
        } else if (deployType.equals("directory")) {
            DeploymentFunction nav = null;
            if (functionType.equals("function")) {
                nav = DeployUtil.getDeploymentFunctionById(appConfigFile, appDeployId);
            }
            if (functionType.equals("directory")) {
                nav = DeployUtil.getDeploymentDirectoryById(appConfigFile, appDeployId);
            }
            if (!pid.equals("") && nav != null) {
                isSuccess = !DeployUtil.createNavDirectory((NavTpl)nav, appId, pid).equals("");
            }
        } else {
            DeploymentFunction deploymentFunction = DeployUtil.getDeploymentFunctionById(appConfigFile, appDeployId);
            isSuccess = DeployUtil.createNavFucntion(deploymentFunction, appId, pid);
            if (isSuccess) {
                NavigationDirectoryModelImpl model;
                String systemId;
                PermissionListModel permissionListModel = new PermissionListModel();
                permissionListModel.setPermissionId("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31");
                permissionListModel.setResourceId(appDeployId);
                permissionListModel.setResourceType("FunctionObject");
                if (!PermAPIManager.getInstance().isAccessMenuPermission("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31", appDeployId)) {
                    PermissionDaoFactory.createPermissionList().insert(permissionListModel);
                }
                String string = systemId = (model = (NavigationDirectoryModelImpl)NavigationDirectoryCache.getModel(pid)) == null ? "" : model.getSystemId();
                if (!UtilString.isEmpty(pid)) {
                    permissionListModel = new PermissionListModel();
                    permissionListModel.setPermissionId("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31");
                    permissionListModel.setResourceId(pid);
                    permissionListModel.setResourceType("FunctionObject");
                    if (!PermAPIManager.getInstance().isAccessMenuPermission("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31", pid)) {
                        PermissionDaoFactory.createPermissionList().insert(permissionListModel);
                    }
                }
                if (!UtilString.isEmpty(systemId)) {
                    permissionListModel = new PermissionListModel();
                    permissionListModel.setPermissionId("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31");
                    permissionListModel.setResourceId(systemId);
                    permissionListModel.setResourceType("FunctionObject");
                    if (!PermAPIManager.getInstance().isAccessMenuPermission("ff6a0ce9-1a01-4091-b8c2-7eb3547b0c31", systemId)) {
                        PermissionDaoFactory.createPermissionList().insert(permissionListModel);
                    }
                }
            }
        }
        if (isSuccess) {
            json.put("state", (Object)"ok");
            ro.ok();
        } else {
            json.put("state", (Object)"fail");
            ro.warn();
        }
        ro.setData(json);
        return ro.toString();
    }

    public String setAppSuspendVal(String appId, boolean suspend) {
        File appConfigFile = AppsAPIManager.getInstance().getAppManifestXMLFile(appId);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("suspend", String.valueOf(suspend));
        ResponseObject ro = ResponseObject.newOkResponse(I18nRes.findValue("_bpm.platform", "\u64cd\u4f5c\u6210\u529f"));
        try {
            AppsAPIManager.getInstance().saveKeyValue(appConfigFile, values);
            return ro.toString();
        }
        catch (Exception e) {
            ro.err(ExceptionUtil.getMessage(e));
            return ro.toString();
        }
    }

    public String deployAllNav(String deployDatas, String appId) {
        ResponseObject ro = ResponseObject.newOkResponse();
        JSONArray arr = JSONArray.parseArray((String)deployDatas);
        if (arr.size() > 0) {
            int i = 0;
            while (i < arr.size()) {
                JSONObject obj = arr.getJSONObject(i);
                String id = obj.getString("id");
                String deployType = obj.getString("type");
                String pid = obj.getString("pid");
                String functionType = deployType;
                this.deployNav(appId, id, deployType, pid, functionType);
                ++i;
            }
        }
        return ro.toString();
    }
}

