/*
 * Decompiled with CFR 0.152.
 */
package com.actionsoft.bpms.commons.amc.web;

import com.actionsoft.apps.lifecycle.AppRestorer;
import com.actionsoft.apps.lifecycle.log.AppLogMsg;
import com.actionsoft.apps.lifecycle.log.AppsLogger;
import com.actionsoft.bpms.commons.amc.web.AMCWeb;
import com.actionsoft.bpms.commons.mvc.view.ResponseObject;
import com.actionsoft.bpms.server.UserContext;
import com.actionsoft.bpms.util.Base64;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ApplicationRestoreWeb
extends AMCWeb {
    public ApplicationRestoreWeb(UserContext me) {
        super(me);
    }

    public String getRestoreList(String appId) {
        Stream<File> fileStream = null;
        try {
            fileStream = Files.walk(Paths.get("../apps//history", new String[0]), 2, new FileVisitOption[0]).map(Path::toFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u5386\u53f2\u76ee\u5f55\u8def\u5f84\u9519\u8bef", e);
        }
        Pattern filenameRegex = Pattern.compile("^(" + appId.replace(".", "\\.") + "\\.v)\\d+\\.\\d+_\\d+(\\$\\d+)?(_bak)?(\\.zip)$");
        fileStream = fileStream.filter(file -> {
            String fileName = file.getName();
            String parent = file.getParent();
            if (parent.endsWith("history" + File.separator + "install") || parent.endsWith("history" + File.separator + "uninstall") || parent.endsWith("history" + File.separator + "upgrade") || parent.endsWith("history" + File.separator + "restore")) {
                return filenameRegex.matcher(fileName).find();
            }
            return false;
        });
        String install = "install";
        String uninstall = "uninstall";
        String upgrade = "upgrade";
        String restore = "restore";
        class FileExt {
            private File file;
            private boolean isValid;
            private String warehouse;

            FileExt(File file, boolean isValid, String warehouse) {
                this.file = file;
                this.isValid = isValid;
                this.warehouse = warehouse;
            }
        }
        Stream<FileExt> fileExtStream = fileStream.map(file -> {
            String parent = file.getParent();
            String filename = file.getName();
            if (parent.endsWith("history" + File.separator + "install")) {
                return new FileExt((File)file, true, install);
            }
            if (parent.endsWith("history" + File.separator + "uninstall")) {
                return new FileExt((File)file, true, uninstall);
            }
            if (parent.endsWith("history" + File.separator + "upgrade")) {
                if (filename.endsWith("_bak.zip")) {
                    return new FileExt((File)file, true, upgrade);
                }
                return new FileExt((File)file, false, upgrade);
            }
            if (parent.endsWith("history" + File.separator + "restore")) {
                if (filename.endsWith("_bak.zip")) {
                    return new FileExt((File)file, true, restore);
                }
                return new FileExt((File)file, false, restore);
            }
            throw new RuntimeException("\u4e0d\u7b26\u5408\u6807\u51c6\u7684\u4ed3\u5e93");
        });
        fileExtStream = fileExtStream.sorted((file1, file2) -> {
            int compare = Long.compare(((FileExt)file1).file.lastModified(), ((FileExt)file2).file.lastModified());
            if (compare == 0 && (upgrade.equals(((FileExt)file1).warehouse) && upgrade.equals(((FileExt)file2).warehouse) || restore.equals(((FileExt)file1).warehouse) && restore.equals(((FileExt)file2).warehouse))) {
                if (((FileExt)file1).isValid && !((FileExt)file2).isValid) {
                    return 1;
                }
                if (!((FileExt)file1).isValid && ((FileExt)file2).isValid) {
                    return -1;
                }
            }
            return compare;
        });
        JSONArray ja = new JSONArray();
        SimpleDateFormat yMd = new SimpleDateFormat("yyyy.MM.dd");
        SimpleDateFormat yMdHm = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        List fileExtList = fileExtStream.collect(Collectors.toList());
        List reversedFileExtList = Lists.reverse(fileExtList);
        int i = 0;
        while (i < fileExtList.size()) {
            FileExt fileExt = (FileExt)fileExtList.get(i);
            if (fileExt.isValid) {
                String substring;
                JSONObject jo = new JSONObject();
                String warehouse = fileExt.warehouse;
                jo.put("warehouse", (Object)warehouse);
                Date date = new Date(fileExt.file.lastModified());
                jo.put("yMd", (Object)yMd.format(date));
                jo.put("yMdHm", (Object)yMdHm.format(date));
                String filename = fileExt.file.getName();
                jo.put("filename", (Object)Base64.encodeBase64String(filename.getBytes(StandardCharsets.UTF_8)));
                if (install.equals(warehouse)) {
                    substring = filename.substring(filename.indexOf(String.valueOf(appId) + ".v") + (String.valueOf(appId) + ".v").length());
                    substring = substring.contains("$") ? substring.substring(0, substring.indexOf("$")) : substring.substring(0, substring.indexOf(".zip"));
                    jo.put("srcVersion", (Object)substring);
                    jo.put("version", (Object)substring.replace("_", "."));
                } else if (uninstall.equals(warehouse)) {
                    substring = filename.substring(filename.indexOf(String.valueOf(appId) + ".v") + (String.valueOf(appId) + ".v").length());
                    substring = substring.contains("$") ? substring.substring(0, substring.indexOf("$")) : substring.substring(0, substring.indexOf("_bak.zip"));
                    jo.put("srcVersion", (Object)substring);
                    jo.put("version", (Object)substring.replace("_", "."));
                } else if (upgrade.equals(warehouse) || restore.equals(warehouse)) {
                    substring = filename.substring(filename.indexOf(String.valueOf(appId) + ".v") + (String.valueOf(appId) + ".v").length());
                    substring = substring.contains("$") ? substring.substring(0, substring.indexOf("$")) : substring.substring(0, substring.indexOf("_bak.zip"));
                    jo.put("versionFile", (Object)substring);
                    jo.put("version", (Object)substring.replace("_", "."));
                    Optional<FileExt> first = reversedFileExtList.stream().skip(fileExtList.size() - i - 1 + 1).filter(fileExt1 -> warehouse.equals(((FileExt)fileExt1).warehouse)).filter(fileExt1 -> !((FileExt)fileExt1).isValid).findFirst();
                    first.map(fileExt1 -> {
                        File file1 = ((FileExt)fileExt1).file;
                        Date date1 = new Date(file1.lastModified());
                        jo.put("yMd-newerVersion", (Object)yMd.format(date1));
                        jo.put("yMdHm-newerVersion", (Object)yMdHm.format(date1));
                        String firstFilename = file1.getName();
                        String firstSubstring = firstFilename.substring(firstFilename.indexOf(String.valueOf(appId) + ".v") + (String.valueOf(appId) + ".v").length());
                        firstSubstring = firstSubstring.contains("$") ? firstSubstring.substring(0, firstSubstring.indexOf("$")) : firstSubstring.substring(0, firstSubstring.indexOf(".zip"));
                        jo.put("toVersion", (Object)firstSubstring.replace("_", "."));
                        jo.put("toVersionFile", (Object)firstSubstring);
                        jo.put("toFilename", (Object)Base64.encodeBase64String(firstFilename.getBytes(StandardCharsets.UTF_8)));
                        return "";
                    }).orElseGet(() -> {
                        jo.put("toVersion", (Object)"\u672a\u77e5\u7248\u672c");
                        jo.put("toVersionFile", (Object)"\u672a\u77e5\u7248\u672c");
                        return "";
                    });
                }
                ja.add((Object)jo);
            }
            ++i;
        }
        Collections.reverse(ja);
        return ja.toString();
    }

    public String restoreApp(String appId, String version, String warehouse, boolean isNewerVersion, String filename) {
        File srcFile;
        String appFilePath;
        filename = new String(Base64.decodeBase64(filename), StandardCharsets.UTF_8);
        ArrayList<String> restoreApps = new ArrayList<String>();
        if ("install".equals(warehouse) || "uninstall".equals(warehouse)) {
            appFilePath = String.valueOf(warehouse) + "/" + filename;
            srcFile = new File("../apps/history/" + appFilePath);
            restoreApps.add(appFilePath);
        } else if ("upgrade".equals(warehouse) || "restore".equals(warehouse)) {
            appFilePath = String.valueOf(warehouse) + "/" + filename;
            srcFile = new File("../apps/history/" + appFilePath);
            restoreApps.add(appFilePath);
        } else {
            return ResponseObject.newErrResponse("\u4ed3\u5e93\u540d\u79f0\u9519\u8bef").toString();
        }
        if (!srcFile.exists()) {
            return ResponseObject.newErrResponse("\u8fd8\u539f\u7684\u5907\u4efd\u6587\u4ef6\u4e0d\u5b58\u5728").toString();
        }
        try {
            AppsLogger.clearLogs((String)appId);
            if (AppRestorer.isRestore((String)appId)) {
                AppRestorer.restore(restoreApps);
            }
        }
        catch (Exception e) {
            return ResponseObject.newErrResponse(e.getMessage()).toString();
        }
        return ResponseObject.newOkResponse("\u8fd8\u539f\u5b8c\u6bd5").toString();
    }

    public String restoreProcessInfo(String appId) {
        String newLog;
        ResponseObject ro = ResponseObject.newOkResponse();
        StringBuilder log = new StringBuilder();
        JSONObject info = new JSONObject();
        List logs = AppsLogger.getLogs((String)appId);
        try {
            for (AppLogMsg appLogBean : logs) {
                String msg = appLogBean.getMsg();
                if (msg == null) continue;
                log.append(this.getLogInfo(appLogBean));
                if (!msg.equals("\u5b8c\u6210\u8fd8\u539f")) {
                    continue;
                }
                break;
            }
        }
        catch (Exception appLogBean) {
            // empty catch block
        }
        if ((newLog = log.toString()).equals("")) {
            newLog = "\u6570\u636e\u52a0\u8f7d\u4e2d...";
        }
        info.put("log", (Object)newLog);
        int percent = 0;
        if (AppRestorer.percentMap.get(appId) != null && (percent = ((Integer)AppRestorer.percentMap.get(appId)).intValue()) == 100) {
            AppRestorer.percentMap.put(appId, 0);
        }
        info.put("percent", (Object)percent);
        ro.setData(info);
        return ro.toDataString();
    }

    private String getLogInfo(AppLogMsg appLogBean) {
        SimpleDateFormat smp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder log = new StringBuilder();
        if (appLogBean.getLevel().equals("err")) {
            log.append("<font style='color:red'>\u9519\u8bef:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "</font><br>");
        }
        if (appLogBean.getLevel().equals("warn")) {
            log.append("<font style='color:yellow'>\u8b66\u544a:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "</font><br>");
        } else {
            log.append("\u4fe1\u606f:[" + smp.format(appLogBean.getTime()) + "]" + appLogBean.getMsg() + "<br>");
        }
        return log.toString();
    }
}

